/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration.formatters;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.I_CmsFormatterBean;

public class CmsFormatterIndex {
    private HashMultimap<CmsUUID, String> m_keysById = HashMultimap.create();
    private HashMultimap<String, CmsUUID> m_idsByKey = HashMultimap.create();
    private Map<CmsUUID, I_CmsFormatterBean> m_formattersById = new HashMap<CmsUUID, I_CmsFormatterBean>();

    public void addFormatter(I_CmsFormatterBean formatter) {
        String id = formatter.getId();
        if (CmsUUID.isValidUUID(id)) {
            CmsUUID uuid = new CmsUUID(id);
            this.m_formattersById.put(uuid, formatter);
            HashSet<String> relatedKeys = new HashSet<String>();
            HashSet<CmsUUID> relatedIds = new HashSet<CmsUUID>();
            this.collectRelatedKeysAndIds(formatter.getAllKeys(), relatedKeys, relatedIds);
            for (CmsUUID relatedId : relatedIds) {
                this.m_keysById.removeAll((Object)relatedId);
                this.m_formattersById.remove(relatedId);
            }
            for (String relatedKey : relatedKeys) {
                this.m_idsByKey.removeAll((Object)relatedKey);
            }
            for (String relatedKey : relatedKeys) {
                this.m_idsByKey.put((Object)relatedKey, (Object)uuid);
            }
            this.m_keysById.putAll((Object)uuid, relatedKeys);
        }
    }

    public Map<CmsUUID, I_CmsFormatterBean> getFormattersWithAdditionalKeys() {
        HashMap<CmsUUID, I_CmsFormatterBean> result = new HashMap<CmsUUID, I_CmsFormatterBean>();
        for (Map.Entry<CmsUUID, I_CmsFormatterBean> entry : this.m_formattersById.entrySet()) {
            CmsUUID id = entry.getKey();
            Set keys = this.m_keysById.get((Object)id);
            I_CmsFormatterBean formatter = entry.getValue();
            Optional<I_CmsFormatterBean> formatterWithKeys = formatter.withKeys(keys);
            if (!formatterWithKeys.isPresent()) continue;
            result.put(id, formatterWithKeys.orElse(null));
        }
        return result;
    }

    public void remove(CmsUUID id) {
        Set keys = this.m_keysById.removeAll((Object)id);
        for (String key : keys) {
            this.m_idsByKey.remove((Object)key, (Object)id);
        }
        this.m_formattersById.remove(id);
    }

    public void removeIf(Predicate<I_CmsFormatterBean> condition) {
        HashSet<CmsUUID> toRemove = new HashSet<CmsUUID>();
        for (Map.Entry<CmsUUID, I_CmsFormatterBean> entry : this.m_formattersById.entrySet()) {
            if (!condition.test(entry.getValue())) continue;
            toRemove.add(entry.getKey());
        }
        toRemove.forEach(id -> this.remove((CmsUUID)id));
    }

    private void collectRelatedKeysAndIds(Collection<String> initialKeys, Set<String> visitedKeys, Set<CmsUUID> visitedIds) {
        visitedKeys.clear();
        visitedIds.clear();
        ArrayList<String> todo = new ArrayList<String>(initialKeys);
        while (todo.size() > 0) {
            String key = (String)todo.remove(todo.size() - 1);
            if (visitedKeys.contains(key)) continue;
            visitedKeys.add(key);
            for (CmsUUID id : this.m_idsByKey.get((Object)key)) {
                visitedIds.add(id);
                for (String relatedKey : this.m_keysById.get((Object)id)) {
                    todo.add(relatedKey);
                }
            }
        }
    }
}

