/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.containerpage;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.ade.containerpage.CmsContainerpageService;
import org.opencms.ade.containerpage.Messages;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeFolder;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.i18n.CmsSingleTreeLocaleHandler;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.lock.CmsLockActionRecord;
import org.opencms.lock.CmsLockUtil;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationType;
import org.opencms.site.CmsSite;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.templatemapper.CmsTemplateMapper;

public final class CmsDetailOnlyContainerUtil {
    public static final String DETAIL_CONTAINERS_FOLDER_NAME = ".detailContainers";
    public static final String LOCALE_ALL = "ALL";
    private static final Log LOG = CmsLog.getLog(CmsDetailOnlyContainerUtil.class);

    private CmsDetailOnlyContainerUtil() {
    }

    public static String getDetailContainerLocale(CmsObject cms, String contentLocale, CmsResource resource) {
        boolean singleLocale = CmsDetailOnlyContainerUtil.useSingleLocaleDetailContainers(cms.getRequestContext().getSiteRoot());
        if (!singleLocale) {
            try {
                CmsProperty prop = cms.readPropertyObject(resource, "locale.independent-details", true);
                singleLocale = Boolean.parseBoolean(prop.getValue());
            }
            catch (Exception e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        return singleLocale ? LOCALE_ALL : contentLocale;
    }

    public static String getDetailContentPath(String detailContainersPage) {
        String detailName = CmsResource.getName(detailContainersPage);
        String parentFolder = CmsResource.getParentFolder(CmsResource.getParentFolder(detailContainersPage));
        if (parentFolder.endsWith("/.detailContainers/")) {
            parentFolder = CmsResource.getParentFolder(parentFolder);
        }
        detailName = CmsStringUtil.joinPaths(parentFolder, detailName);
        return detailName;
    }

    public static Optional<CmsResource> getDetailOnlyPage(CmsObject cms, CmsResource detailContent, String contentLocale) {
        try {
            CmsObject rootCms = OpenCms.initCmsObject(cms);
            rootCms.getRequestContext().setSiteRoot("");
            String path = CmsDetailOnlyContainerUtil.getDetailOnlyPageNameWithoutLocaleCheck(detailContent.getRootPath(), contentLocale);
            if (rootCms.existsResource(path, CmsResourceFilter.ALL)) {
                CmsResource detailOnlyRes = rootCms.readResource(path, CmsResourceFilter.ALL);
                return Optional.of((Object)detailOnlyRes);
            }
            return Optional.absent();
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            return Optional.absent();
        }
    }

    public static CmsContainerPageBean getDetailOnlyPage(CmsObject cms, ServletRequest req, String pageRootPath) {
        return CmsDetailOnlyContainerUtil.getDetailOnlyPage(cms, req, pageRootPath, true);
    }

    public static CmsContainerPageBean getDetailOnlyPage(CmsObject cms, ServletRequest req, String pageRootPath, boolean lookupContextFirst) {
        CmsContainerPageBean detailOnlyPage;
        CmsJspStandardContextBean standardContext = CmsJspStandardContextBean.getInstance(req);
        CmsContainerPageBean cmsContainerPageBean = detailOnlyPage = lookupContextFirst ? standardContext.getDetailOnlyPage() : null;
        if (standardContext.isDetailRequest() && detailOnlyPage == null) {
            try {
                CmsObject rootCms = OpenCms.initCmsObject(cms);
                rootCms.getRequestContext().setSiteRoot("");
                String locale = CmsDetailOnlyContainerUtil.getDetailContainerLocale(cms, cms.getRequestContext().getLocale().toString(), cms.readResource(cms.getRequestContext().getUri()));
                String resourceName = CmsDetailOnlyContainerUtil.getDetailOnlyPageNameWithoutLocaleCheck(standardContext.getDetailContent().getRootPath(), locale);
                CmsResource resource = null;
                if (rootCms.existsResource(resourceName)) {
                    resource = rootCms.readResource(resourceName);
                } else {
                    resourceName = CmsDetailOnlyContainerUtil.getDetailOnlyPageNameWithoutLocaleCheck(standardContext.getDetailContent().getRootPath(), null);
                    if (rootCms.existsResource(resourceName)) {
                        resource = rootCms.readResource(resourceName);
                    }
                }
                CmsXmlContainerPage xmlContainerPage = null;
                if (resource != null) {
                    xmlContainerPage = CmsXmlContainerPageFactory.unmarshal(rootCms, resource, req);
                }
                if (xmlContainerPage != null) {
                    detailOnlyPage = xmlContainerPage.getContainerPage(rootCms);
                    detailOnlyPage = CmsTemplateMapper.get(req).transformContainerpageBean(rootCms, detailOnlyPage, pageRootPath);
                    standardContext.setDetailOnlyPage(detailOnlyPage);
                }
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return detailOnlyPage;
    }

    public static String getDetailOnlyPageName(CmsObject cms, CmsResource pageResource, String detailPath, String locale) {
        return CmsDetailOnlyContainerUtil.getDetailOnlyPageNameWithoutLocaleCheck(detailPath, CmsDetailOnlyContainerUtil.getDetailContainerLocale(cms, locale, pageResource));
    }

    public static Optional<CmsResource> getDetailOnlyResource(CmsObject cms, String contentLocale, CmsResource detailContentRes, CmsResource pageRes) {
        Optional<CmsResource> detailOnlyRes = CmsDetailOnlyContainerUtil.getDetailOnlyPage(cms, detailContentRes, CmsDetailOnlyContainerUtil.getDetailContainerLocale(cms, contentLocale, pageRes));
        return detailOnlyRes;
    }

    public static List<CmsResource> getDetailOnlyResources(CmsObject cms, CmsResource resource) {
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        HashSet<String> resourcePaths = new HashSet<String>();
        String sitePath = cms.getSitePath(resource);
        for (Locale locale : OpenCms.getLocaleManager().getAvailableLocales()) {
            resourcePaths.add(CmsDetailOnlyContainerUtil.getDetailOnlyPageNameWithoutLocaleCheck(sitePath, locale.toString()));
        }
        resourcePaths.add(CmsDetailOnlyContainerUtil.getDetailOnlyPageNameWithoutLocaleCheck(sitePath, null));
        resourcePaths.add(CmsDetailOnlyContainerUtil.getDetailOnlyPageNameWithoutLocaleCheck(sitePath, LOCALE_ALL));
        for (String path : resourcePaths) {
            try {
                CmsResource detailContainers = cms.readResource(path, CmsResourceFilter.IGNORE_EXPIRATION);
                result.add(detailContainers);
            }
            catch (CmsException cmsException) {}
        }
        return result;
    }

    public static boolean isDetailContainersPage(CmsObject cms, String detailContainersPage) {
        boolean result = false;
        try {
            String detailName = CmsResource.getName(detailContainersPage);
            String parentFolder = CmsResource.getParentFolder(detailContainersPage);
            if (!parentFolder.endsWith("/.detailContainers/")) {
                parentFolder = CmsResource.getParentFolder(parentFolder);
            }
            detailName = CmsStringUtil.joinPaths(CmsResource.getParentFolder(parentFolder), detailName);
            result = parentFolder.endsWith("/.detailContainers/") && cms.existsResource(detailName, CmsResourceFilter.IGNORE_EXPIRATION);
        }
        catch (Throwable t) {
            LOG.debug((Object)t.getLocalizedMessage(), t);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CmsResource readOrCreateDetailOnlyPage(CmsObject cms, CmsUUID detailId, String detailOnlyRootPath) throws CmsException {
        CmsResource containerpage;
        block12: {
            CmsObject rootCms = OpenCms.initCmsObject(cms);
            rootCms.getRequestContext().setSiteRoot("");
            if (rootCms.existsResource(detailOnlyRootPath)) {
                containerpage = rootCms.readResource(detailOnlyRootPath);
            } else {
                String parentFolder = CmsResource.getFolderPath(detailOnlyRootPath);
                ArrayList<String> foldersToCreate = new ArrayList<String>();
                while (!rootCms.existsResource(parentFolder)) {
                    foldersToCreate.add(0, parentFolder);
                    parentFolder = CmsResource.getParentFolder(parentFolder);
                }
                for (String folderName : foldersToCreate) {
                    CmsResource parentRes = rootCms.createResource(folderName, OpenCms.getResourceManager().getResourceType(CmsResourceTypeFolder.getStaticTypeName()));
                    rootCms.writePropertyObject(folderName, new CmsProperty("search.exclude", "all", null));
                    CmsLockUtil.tryUnlock(rootCms, parentRes);
                }
                containerpage = rootCms.createResource(detailOnlyRootPath, OpenCms.getResourceManager().getResourceType(CmsResourceTypeXmlContainerPage.getStaticTypeName()));
            }
            CmsLockUtil.ensureLock(rootCms, containerpage);
            try {
                CmsResource detailResource = cms.readResource(detailId, CmsResourceFilter.IGNORE_EXPIRATION);
                String title = cms.readPropertyObject(detailResource, "Title", true).getValue();
                if (title != null) {
                    title = Messages.get().getBundle(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms)).key("GUI_DETAIL_CONTENT_PAGE_TITLE_1", title);
                    CmsProperty titleProp = new CmsProperty("Title", title, null);
                    cms.writePropertyObjects(containerpage, Arrays.asList(titleProp));
                }
                List<CmsRelation> relations = cms.readRelations(CmsRelationFilter.relationsFromStructureId(detailId).filterType(CmsRelationType.DETAIL_ONLY));
                boolean hasRelation = false;
                for (CmsRelation relation : relations) {
                    if (!relation.getTargetId().equals(containerpage.getStructureId())) continue;
                    hasRelation = true;
                    break;
                }
                if (hasRelation) break block12;
                CmsLockActionRecord lockRecord = null;
                try {
                    lockRecord = CmsLockUtil.ensureLock(cms, detailResource);
                    cms.addRelationToResource(detailResource, containerpage, CmsRelationType.DETAIL_ONLY.getName());
                }
                finally {
                    if (lockRecord != null && lockRecord.getChange() == CmsLockActionRecord.LockChange.locked) {
                        cms.unlockResource(detailResource);
                    }
                }
            }
            catch (CmsException e) {
                CmsContainerpageService.LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return containerpage;
    }

    public static CmsXmlContainerPage saveDetailOnlyPage(CmsObject cms, CmsResource content, String locale, CmsContainerPageBean page) throws CmsException {
        String detailOnlyPath = CmsDetailOnlyContainerUtil.getDetailOnlyPageNameWithoutLocaleCheck(content.getRootPath(), locale);
        CmsResource resource = CmsDetailOnlyContainerUtil.readOrCreateDetailOnlyPage(cms, content.getStructureId(), detailOnlyPath);
        CmsXmlContainerPage xmlCntPage = CmsXmlContainerPageFactory.unmarshal(cms, cms.readFile(resource));
        xmlCntPage.save(cms, page);
        return xmlCntPage;
    }

    public static boolean useSingleLocaleDetailContainers(String siteRoot) {
        boolean result = false;
        if (siteRoot != null && OpenCms.getLocaleManager().getLocaleHandler() instanceof CmsSingleTreeLocaleHandler) {
            CmsSite site = OpenCms.getSiteManager().getSiteForSiteRoot(siteRoot);
            result = site != null && CmsSite.LocalizationMode.singleTree.equals((Object)site.getLocalizationMode());
        }
        return result;
    }

    static String getDetailOnlyPageNameWithoutLocaleCheck(String detailContentSitePath, String contentLocale) {
        String result = CmsResource.getFolderPath(detailContentSitePath);
        result = contentLocale != null ? CmsStringUtil.joinPaths(result, DETAIL_CONTAINERS_FOLDER_NAME, contentLocale.toString(), CmsResource.getName(detailContentSitePath)) : CmsStringUtil.joinPaths(result, DETAIL_CONTAINERS_FOLDER_NAME, CmsResource.getName(detailContentSitePath));
        return result;
    }
}

