/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.containerpage;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsElementView;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.ade.containerpage.CmsModelGroupHelper;
import org.opencms.ade.containerpage.Messages;
import org.opencms.ade.containerpage.inherited.CmsInheritanceReference;
import org.opencms.ade.containerpage.inherited.CmsInheritanceReferenceParser;
import org.opencms.ade.containerpage.inherited.CmsInheritedContainerState;
import org.opencms.ade.containerpage.shared.CmsContainer;
import org.opencms.ade.containerpage.shared.CmsContainerElement;
import org.opencms.ade.containerpage.shared.CmsContainerElementData;
import org.opencms.ade.containerpage.shared.CmsElementLockInfo;
import org.opencms.ade.containerpage.shared.CmsElementSettingsConfig;
import org.opencms.ade.containerpage.shared.CmsFormatterConfig;
import org.opencms.ade.containerpage.shared.CmsFormatterConfigCollection;
import org.opencms.ade.containerpage.shared.CmsInheritanceInfo;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.gwt.CmsDefaultResourceStatusProvider;
import org.opencms.gwt.CmsIconUtil;
import org.opencms.gwt.shared.CmsAdditionalInfoBean;
import org.opencms.gwt.shared.CmsPermissionInfo;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationType;
import org.opencms.search.galleries.CmsGallerySearch;
import org.opencms.search.galleries.CmsGallerySearchResult;
import org.opencms.util.CmsDateUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.workplace.editors.CmsWorkplaceEditorManager;
import org.opencms.workplace.editors.directedit.CmsAdvancedDirectEditProvider;
import org.opencms.workplace.editors.directedit.CmsDirectEditMode;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.xml.containerpage.CmsADESessionCache;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.containerpage.CmsGroupContainerBean;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.containerpage.CmsXmlGroupContainer;
import org.opencms.xml.containerpage.CmsXmlGroupContainerFactory;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentPropertyHelper;

public class CmsElementUtil {
    public static final int MAX_NESTING_LEVEL = 7;
    private static final Log LOG = CmsLog.getLog(CmsElementUtil.class);
    private CmsADEConfigData m_adeConfig;
    private CmsObject m_cms;
    private String m_currentPageUri;
    private Locale m_locale;
    private CmsResource m_page;
    private Map<String, Object> m_parameterMap;
    private HttpServletRequest m_req;
    private HttpServletResponse m_res;
    private CmsJspStandardContextBean m_standardContext;

    public CmsElementUtil(CmsObject cms, String currentPageUri, CmsContainerPageBean containerPage, CmsUUID detailContentId, HttpServletRequest req, HttpServletResponse res, boolean isDragMode, Locale locale) throws CmsException {
        this.m_cms = OpenCms.initCmsObject(cms);
        String contextPath = (String)cms.getRequestContext().getAttribute(CmsRequestContext.ATTRIBUTE_ADE_CONTEXT_PATH);
        if (contextPath != null) {
            this.m_cms.getRequestContext().setAttribute(CmsRequestContext.ATTRIBUTE_ADE_CONTEXT_PATH, contextPath);
        }
        this.m_req = req;
        this.m_res = res;
        this.m_currentPageUri = currentPageUri;
        this.m_locale = locale;
        req.setAttribute("__cmsObject", (Object)this.m_cms);
        if (detailContentId != null) {
            CmsResource detailRes = this.m_cms.readResource(detailContentId, CmsResourceFilter.ignoreExpirationOffline(this.m_cms));
            req.setAttribute("__opencms_detail_content_resource", (Object)detailRes);
        }
        this.m_standardContext = CmsJspStandardContextBean.getInstance((ServletRequest)req);
        this.m_page = this.m_cms.readResource(currentPageUri, CmsResourceFilter.ignoreExpirationOffline(cms));
        this.m_standardContext.setPage(containerPage);
        this.m_standardContext.setDragMode(isDragMode);
    }

    public CmsElementUtil(CmsObject cms, String currentPageUri, CmsUUID detailContentId, HttpServletRequest req, HttpServletResponse res, Locale locale) throws CmsException {
        this.m_cms = OpenCms.initCmsObject(cms);
        this.m_req = req;
        this.m_res = res;
        this.m_currentPageUri = currentPageUri;
        this.m_locale = locale;
        req.setAttribute("__cmsObject", (Object)this.m_cms);
        if (detailContentId != null) {
            CmsResource detailRes = this.m_cms.readResource(detailContentId, CmsResourceFilter.ignoreExpirationOffline(cms));
            req.setAttribute("__opencms_detail_content_resource", (Object)detailRes);
        }
        this.m_standardContext = CmsJspStandardContextBean.getInstance((ServletRequest)req);
        this.m_page = this.m_cms.readResource(currentPageUri);
        CmsXmlContainerPage xmlContainerPage = CmsXmlContainerPageFactory.unmarshal(cms, this.m_page, (ServletRequest)req);
        CmsContainerPageBean containerPage = xmlContainerPage.getContainerPage(cms);
        this.m_standardContext.setPage(containerPage);
    }

    public CmsElementUtil(CmsObject cms, String currentPageUri, CmsUUID detailContentId, String requestParameters, HttpServletRequest req, HttpServletResponse res, Locale locale) throws CmsException {
        this(cms, currentPageUri, detailContentId, req, res, locale);
        this.m_parameterMap = this.parseRequestParameters(requestParameters);
    }

    public static boolean checkGroupAllowed(String containerType, CmsGroupContainerBean groupContainer) {
        return !Sets.intersection(CmsContainer.splitType(containerType), groupContainer.getTypes()).isEmpty();
    }

    public static CmsContainerBean clientToServerContainer(CmsContainer container, List<CmsContainerElementBean> elements) {
        return new CmsContainerBean(container.getName(), container.getType(), container.getParentInstanceId(), container.isRootContainer(), container.getMaxElements(), elements);
    }

    public static Function<String, String> createStringTemplateSource(I_CmsFormatterBean formatter, Supplier<CmsXmlContent> contentSupplier) {
        return key -> {
            CmsXmlContent content;
            String result = null;
            if (formatter != null) {
                result = formatter.getAttributes().get(key);
            }
            if (result == null && (content = (CmsXmlContent)contentSupplier.get()) != null) {
                result = content.getHandler().getParameter((String)key);
            }
            return result;
        };
    }

    public static I_CmsFormatterBean getFormatterForContainer(CmsObject cms, CmsContainerElementBean element, CmsContainer container, CmsADEConfigData config, CmsADESessionCache cache) {
        I_CmsFormatterBean formatter = null;
        CmsFormatterConfiguration formatterSet = config.getFormatters(cms, element.getResource());
        Map<String, I_CmsFormatterBean> formatters = formatterSet.getFormatterSelectionByKeyOrId(container.getType(), container.getWidth());
        String formatterId = element.getIndividualSettings().get(CmsFormatterConfig.getSettingsKeyForContainer(container.getName()));
        if (formatterId != null) {
            I_CmsFormatterBean dynamicFmt = config.findFormatter(formatterId);
            formatter = dynamicFmt != null ? dynamicFmt : formatters.get(formatterId);
        }
        if (formatter == null && (formatterId = element.getIndividualSettings().get("formatterSettings#")) != null) {
            formatter = CmsElementUtil.lookupFormatter(config, formatterId, formatters);
        }
        if (formatter == null) {
            for (Map.Entry<String, String> settingsEntry : element.getIndividualSettings().entrySet()) {
                if (settingsEntry.getKey().startsWith("formatterSettings#") && (formatter = CmsElementUtil.lookupFormatter(config, settingsEntry.getValue(), formatters)) != null) break;
            }
        }
        if (formatter == null && element.getFormatterId() != null) {
            for (I_CmsFormatterBean currentFormatter : formatters.values()) {
                if (currentFormatter.getJspStructureId() == null || !currentFormatter.getJspStructureId().equals(element.getFormatterId())) continue;
                formatter = currentFormatter;
                break;
            }
        }
        if (formatter == null) {
            formatter = CmsElementUtil.getStartFormatter(cms, container, config, element, cache);
        }
        return formatter;
    }

    public static final boolean isSystemSetting(String name) {
        return CmsXmlContainerPage.LEGACY_SYSTEM_SETTING_NAMES.contains(name) || "element_instance_id".equals(name) || name.startsWith("SYSTEM::") || name.startsWith("formatterSettings#");
    }

    private static I_CmsFormatterBean getStartFormatter(CmsObject cms, CmsContainer cnt, CmsADEConfigData configData, CmsContainerElementBean element, CmsADESessionCache cache) {
        I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(element.getResource());
        I_CmsFormatterBean formatter = cache.getRecentFormatter(type.getTypeName(), cnt, configData);
        if (formatter == null) {
            formatter = configData.getFormatters(cms, element.getResource()).getDefaultFormatter(cnt.getType(), cnt.getWidth());
        }
        return formatter;
    }

    private static I_CmsFormatterBean lookupFormatter(CmsADEConfigData config, String keyOrId, Map<String, I_CmsFormatterBean> active) {
        I_CmsFormatterBean dynamicFmt = config.findFormatter(keyOrId);
        if (dynamicFmt != null) {
            for (String key : new String[]{dynamicFmt.getKey(), dynamicFmt.getId(), keyOrId}) {
                if (key == null || active.get(key) == null) continue;
                return active.get(key);
            }
            return null;
        }
        return active.get(keyOrId);
    }

    public String getContentByContainer(CmsFile elementFile, String elementId, CmsContainer container) {
        CmsContainerElementBean element = CmsADESessionCache.getCache(this.m_req, this.m_cms).getCacheContainerElement(elementId);
        element = element.clone();
        element.setTemporaryFile(elementFile);
        CmsFormatterConfiguration configs = this.getFormatterConfiguration(element.getResource());
        return this.getContentByContainer(element, container, configs);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CmsContainerElementData getElementData(CmsResource page, CmsContainerElementBean element, Collection<CmsContainer> containers) throws CmsException {
        Locale requestLocale = this.m_cms.getRequestContext().getLocale();
        this.m_cms.getRequestContext().setLocale(this.m_locale);
        element.initResource(this.m_cms);
        if (element.getResource().isFolder()) {
            return null;
        }
        boolean typeDisabled = false;
        if (page != null) {
            CmsADEConfigData config = OpenCms.getADEManager().lookupConfigurationWithCache(this.m_cms, page.getRootPath());
            String typeName = OpenCms.getResourceManager().getResourceType(element.getResource()).getTypeName();
            if (!config.getActiveTypeNames().contains(typeName)) {
                typeDisabled = true;
            }
        }
        CmsContainerElementData elementData = this.getBaseElementData(page, element);
        elementData.setTypeDisabled(typeDisabled);
        CmsFormatterConfiguration formatterConfiguraton = this.getFormatterConfiguration(element.getResource());
        HashMap<String, String> contents = new HashMap();
        if (element.isGroupContainer(this.m_cms)) {
            HashMap<String, CmsContainer> containersByName = new HashMap<String, CmsContainer>();
            for (CmsContainer container : containers) {
                containersByName.put(container.getName(), container);
            }
            CmsXmlGroupContainer xmlGroupContainer = CmsXmlGroupContainerFactory.unmarshal(this.m_cms, element.getResource(), (ServletRequest)this.m_req);
            CmsGroupContainerBean groupContainer = xmlGroupContainer.getGroupContainer(this.m_cms);
            elementData.setTitle(groupContainer.getTitle());
            elementData.setTypes(groupContainer.getTypes());
            elementData.setDescription(groupContainer.getDescription());
            if (groupContainer.getTypes().isEmpty()) {
                if (!groupContainer.getElements().isEmpty()) return null;
                String emptySub = "<div>NEW AND EMPTY</div>";
                for (CmsContainer cont : containersByName.values()) {
                    if (!formatterConfiguraton.hasFormatter(cont.getType(), cont.getWidth())) continue;
                    contents.put(cont.getName(), emptySub);
                }
            } else {
                for (Object cnt : containersByName.values()) {
                    String type = ((CmsContainer)cnt).getType();
                    if (!CmsElementUtil.checkGroupAllowed(type, groupContainer)) continue;
                    contents.put(((CmsContainer)cnt).getName(), "<div>should not be used</div>");
                }
            }
            ArrayList<String> subItems = new ArrayList<String>();
            for (CmsContainerElementBean subElement : groupContainer.getElements()) {
                subItems.add(subElement.editorHash());
            }
            elementData.setSubItems(subItems);
        } else if (element.isInheritedContainer(this.m_cms)) {
            CmsInheritanceReferenceParser parser = new CmsInheritanceReferenceParser(this.m_cms);
            parser.parse(element.getResource());
            CmsInheritanceReference ref = parser.getReference(this.m_locale);
            String name = null;
            if (ref != null) {
                name = ref.getName();
                elementData.setDescription(ref.getDescription());
                elementData.setTitle(ref.getTitle());
            }
            for (CmsContainer container : containers) {
                if (!formatterConfiguraton.hasFormatter(container.getType(), container.getWidth())) continue;
                contents.put(container.getName(), "<div>should not be used</div>");
            }
            ArrayList<CmsInheritanceInfo> inheritanceInfos = new ArrayList<CmsInheritanceInfo>();
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(name)) {
                CmsInheritedContainerState result = OpenCms.getADEManager().getInheritedContainerState(this.m_cms, this.m_cms.addSiteRoot(this.m_currentPageUri), name);
                for (CmsContainerElementBean subElement : result.getElements(true)) {
                    CmsInheritanceInfo inheritanceInfo = subElement.getInheritanceInfo();
                    inheritanceInfo.setClientId(subElement.editorHash());
                    inheritanceInfos.add(inheritanceInfo);
                }
            } else {
                name = element.getResource().getStructureId().toString();
            }
            elementData.setInheritanceInfos(inheritanceInfos);
            elementData.setInheritanceName(name);
        } else {
            block6: for (CmsContainer cnt : containers) {
                boolean missesFormatterSetting = !elementData.getSettings().containsKey(CmsFormatterConfig.getSettingsKeyForContainer(cnt.getName()));
                if (!missesFormatterSetting) continue;
                if (element.getFormatterId() == null) {
                    I_CmsFormatterBean formatter = CmsElementUtil.getStartFormatter(this.m_cms, cnt, this.m_adeConfig, element, CmsADESessionCache.getCache(this.m_req, this.m_cms));
                    if (formatter == null) continue;
                    elementData.getSettings().put(CmsFormatterConfig.getSettingsKeyForContainer(cnt.getName()), formatter.getId());
                    element.addFormatterSetting(cnt.getName(), formatter.getKeyOrId());
                    continue;
                }
                Map<String, I_CmsFormatterBean> formatterSelection = formatterConfiguraton.getFormatterSelection(cnt.getType(), cnt.getWidth());
                for (Map.Entry<String, I_CmsFormatterBean> formatterEntry : formatterSelection.entrySet()) {
                    I_CmsFormatterBean formatter = formatterEntry.getValue();
                    String id = formatterEntry.getKey();
                    if (!element.getFormatterId().equals(formatter.getJspStructureId())) continue;
                    elementData.getSettings().put(CmsFormatterConfig.getSettingsKeyForContainer(cnt.getName()), formatter.getKeyOrId());
                    continue block6;
                }
            }
            Map<String, String> contentsByName = this.getContentsByContainerName(element, containers);
            contents = contentsByName;
        }
        elementData.setContents(contents);
        this.m_cms.getRequestContext().setLocale(requestLocale);
        return elementData;
    }

    public CmsElementSettingsConfig getElementSettingsConfig(CmsResource page, CmsContainerElementBean element, String containerId, Collection<CmsContainer> containers) throws CmsException {
        String label;
        Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms);
        CmsADEConfigData adeConfig = OpenCms.getADEManager().lookupConfigurationWithCache(this.m_cms, page.getRootPath());
        Locale requestLocale = this.m_cms.getRequestContext().getLocale();
        this.m_cms.getRequestContext().setLocale(this.m_locale);
        element.initResource(this.m_cms);
        if (element.getResource().isFolder()) {
            return null;
        }
        String schema = null;
        try {
            I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(element.getResource());
            schema = type.getConfiguration().getString("schema", null);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        CmsContainerElementData elementData = this.getBaseElementData(page, element);
        HashMap<String, String> settingUpdates = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : elementData.getSettings().entrySet()) {
            String value;
            Object dynamicFmt;
            int underscorePos = entry.getKey().indexOf("_");
            if (underscorePos >= 0 && !CmsElementUtil.isSystemSetting(entry.getKey())) {
                String prefix = entry.getKey().substring(0, underscorePos);
                dynamicFmt = adeConfig.findFormatter(prefix);
                if (CmsUUID.isValidUUID(prefix) && dynamicFmt != null && dynamicFmt.getKey() != null) {
                    String newSettingName = dynamicFmt.getKey() + entry.getKey().substring(underscorePos);
                    settingUpdates.put(newSettingName, entry.getValue());
                    settingUpdates.put(entry.getKey(), null);
                }
            }
            if (!entry.getKey().startsWith("formatterSettings#") || !CmsUUID.isValidUUID(value = entry.getValue()) || (dynamicFmt = adeConfig.findFormatter(value)) == null || dynamicFmt.getKey() == null) continue;
            settingUpdates.put(entry.getKey(), dynamicFmt.getKey());
        }
        for (String key : settingUpdates.keySet()) {
            String value = (String)settingUpdates.get(key);
            if (value == null) {
                elementData.getSettings().remove(key);
                continue;
            }
            elementData.getSettings().put(key, value);
        }
        Supplier contentSupplier = Suppliers.memoize(() -> {
            try {
                return CmsXmlContentFactory.unmarshal(this.m_cms, this.m_cms.readFile(element.getResource()));
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return null;
            }
        });
        I_CmsFormatterBean foundFormatter = null;
        if (!element.isGroupContainer(this.m_cms) && !element.isInheritedContainer(this.m_cms)) {
            CmsFormatterConfiguration formatterConfiguraton = this.getFormatterConfiguration(element.getResource());
            HashMap<String, CmsFormatterConfigCollection> formatters = new HashMap<String, CmsFormatterConfigCollection>();
            for (CmsContainer cnt : containers) {
                boolean missesFormatterSetting;
                if (!cnt.getName().equals(containerId)) continue;
                CmsFormatterConfigCollection containerFormatters = new CmsFormatterConfigCollection();
                String foundFormatterKey = null;
                for (String containerName : new String[]{cnt.getName(), ""}) {
                    foundFormatterKey = elementData.getSettings().get(CmsFormatterConfig.getSettingsKeyForContainer(containerName));
                    if (foundFormatterKey != null) break;
                }
                boolean bl = missesFormatterSetting = foundFormatterKey == null;
                if (!missesFormatterSetting) {
                    foundFormatter = adeConfig.findFormatter(foundFormatterKey);
                }
                Map<String, I_CmsFormatterBean> formatterSelection = formatterConfiguraton.getFormatterSelection(cnt.getType(), cnt.getWidth());
                for (Map.Entry<String, I_CmsFormatterBean> formatterEntry : formatterSelection.entrySet()) {
                    I_CmsFormatterBean i_CmsFormatterBean = formatterEntry.getValue();
                    String id = formatterEntry.getValue().getId();
                    if (missesFormatterSetting && (element.getFormatterId() == null || element.getFormatterId().equals(i_CmsFormatterBean.getJspStructureId()))) {
                        elementData.getSettings().put(CmsFormatterConfig.getSettingsKeyForContainer(cnt.getName()), id);
                        missesFormatterSetting = false;
                    }
                    label = i_CmsFormatterBean.getNiceName(OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms));
                    if (formatterEntry.getKey().startsWith("schema_formatter")) {
                        label = Messages.get().getBundle().key("GUI_SCHEMA_FORMATTER_LABEL_0") + " [" + CmsResource.getName(i_CmsFormatterBean.getJspRootPath()) + "]";
                    }
                    if (CmsStringUtil.isEmptyOrWhitespaceOnly(label)) {
                        label = id;
                    }
                    CmsFormatterConfig config = new CmsFormatterConfig(id);
                    LinkedHashSet<String> cssResources = new LinkedHashSet<String>();
                    for (String cssSitePath : i_CmsFormatterBean.getCssHeadIncludes()) {
                        cssResources.add(OpenCms.getLinkManager().getOnlineLink(this.m_cms, cssSitePath));
                    }
                    config.setCssResources(cssResources);
                    config.setInlineCss(i_CmsFormatterBean.getInlineCss());
                    config.setKey(i_CmsFormatterBean.getKey());
                    config.setLabel(label);
                    config.setDescription(i_CmsFormatterBean.getDescription(OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms)));
                    Map<String, CmsXmlContentProperty> settingsConfig = OpenCms.getADEManager().getFormatterSettings(this.m_cms, adeConfig, i_CmsFormatterBean, element.getResource(), this.m_locale, (ServletRequest)this.m_req);
                    Function<String, String> templateSource = CmsElementUtil.createStringTemplateSource(i_CmsFormatterBean, (Supplier<CmsXmlContent>)contentSupplier);
                    settingsConfig = CmsXmlContentPropertyHelper.resolveMacrosForPropertyInfo(this.m_cms, page, element.getResource(), (Supplier<CmsXmlContent>)contentSupplier, templateSource, settingsConfig);
                    config.setSettingConfig(settingsConfig);
                    List<I_CmsFormatterBean> nestedFormatters = OpenCms.getADEManager().getNestedFormatters(this.m_cms, adeConfig, element.getResource(), this.m_locale, (ServletRequest)this.m_req);
                    if (nestedFormatters != null && !nestedFormatters.isEmpty()) {
                        LinkedHashMap<String, String> settingPrefixes = new LinkedHashMap<String, String>();
                        for (I_CmsFormatterBean nested : nestedFormatters) {
                            String sectionLabel = nested.getNiceName(OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms));
                            settingPrefixes.put(nested.getId(), sectionLabel);
                            if (nested.getKey() == null) continue;
                            settingPrefixes.put(nested.getKey() + "_", sectionLabel);
                        }
                        config.setNestedFormatterPrefixes(settingPrefixes);
                    }
                    config.setJspRootPath(i_CmsFormatterBean.getJspRootPath());
                    containerFormatters.add(config);
                }
                formatters.put(cnt.getName(), containerFormatters);
            }
            elementData.setFormatters(formatters);
        }
        this.m_cms.getRequestContext().setLocale(requestLocale);
        ArrayList<CmsAdditionalInfoBean> infos = new ArrayList<CmsAdditionalInfoBean>();
        CmsResource resource = element.getResource();
        String resTypeName = OpenCms.getResourceManager().getResourceType(resource).getTypeName();
        CmsExplorerTypeSettings cmsExplorerTypeSettings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(resTypeName);
        if (null == cmsExplorerTypeSettings) {
            CmsMessageContainer errMsg = org.opencms.gwt.Messages.get().container("ERR_EXPLORER_TYPE_SETTINGS_FOR_RESOURCE_TYPE_NOT_FOUND_3", resource.getRootPath(), resTypeName, resource.getTypeId());
            throw new CmsConfigurationException(errMsg);
        }
        String key = cmsExplorerTypeSettings.getKey();
        Locale currentLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms);
        CmsWorkplaceMessages messages = OpenCms.getWorkplaceManager().getMessages(currentLocale);
        String resTypeNiceName = messages.key(key);
        infos.add(new CmsAdditionalInfoBean(messages.key("GUI_LABEL_TYPE_0"), resTypeNiceName, null));
        try {
            CmsRelationFilter filter = CmsRelationFilter.relationsFromStructureId(element.getResource().getStructureId()).filterType(CmsRelationType.XSD);
            Iterator<Object> iterator = this.m_cms.readRelations(filter).iterator();
            if (iterator.hasNext()) {
                CmsRelation cmsRelation = iterator.next();
                CmsResource target = cmsRelation.getTarget(this.m_cms, CmsResourceFilter.IGNORE_EXPIRATION);
                label = Messages.get().getBundle(wpLocale).key("GUI_ADDINFO_SCHEMA_0");
                infos.add(new CmsAdditionalInfoBean(label, target.getRootPath(), null));
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        if (foundFormatter != null) {
            Map<String, String> formatterInfo = CmsDefaultResourceStatusProvider.getFormatterInfo(this.m_cms, foundFormatter);
            for (Map.Entry entry : formatterInfo.entrySet()) {
                infos.add(new CmsAdditionalInfoBean((String)entry.getKey(), (String)entry.getValue(), null));
            }
        }
        CmsResourceState state = element.getResource().getState();
        return new CmsElementSettingsConfig(elementData, state, infos, schema);
    }

    public CmsResource getPage() {
        return this.m_page;
    }

    public CmsContainerElement setElementInfo(CmsContainerElementBean elementBean, CmsContainerElement result) throws CmsException {
        String subTitle;
        String title;
        CmsPermissionInfo permissionInfo;
        Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms);
        elementBean.initResource(this.m_cms);
        CmsResource resource = elementBean.getResource();
        boolean isModelGroup = elementBean.getIndividualSettings().containsKey("model_group_id");
        if (isModelGroup) {
            CmsUUID groupId = new CmsUUID(elementBean.getIndividualSettings().get("model_group_id"));
            resource = this.m_cms.readResource(groupId, CmsResourceFilter.IGNORE_EXPIRATION);
        }
        boolean newEditorDisabled = !CmsWorkplaceEditorManager.checkAcaciaEditorAvailable(this.m_cms, elementBean.getResource());
        result.setNewEditorDisabled(newEditorDisabled);
        I_CmsResourceType resourceType = OpenCms.getResourceManager().getResourceType(resource);
        String typeName = resourceType.getTypeName();
        result.setHasEditHandler(resourceType instanceof CmsResourceTypeXmlContent && ((CmsResourceTypeXmlContent)resourceType).getEditHandler(this.m_cms) != null);
        result.setResourceType(typeName);
        result.setIconClasses(CmsIconUtil.getIconClasses(CmsIconUtil.getDisplayType(this.m_cms, resource), elementBean.getResource().getName(), false));
        if (!elementBean.isInMemoryOnly()) {
            CmsGallerySearchResult searchResult;
            CmsElementLockInfo lockInfo = this.getLockInfo(this.m_cms, resource);
            result.setLockInfo(lockInfo);
            permissionInfo = OpenCms.getADEManager().getPermissionInfo(this.m_cms, resource, this.m_page.getRootPath());
            if (CmsResourceTypeXmlContent.isXmlContent(resource)) {
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(permissionInfo.getNoEditReason()) && elementBean.isInheritedContainer(this.m_cms)) {
                    String requestUri = this.m_cms.getRequestContext().getUri();
                    String folderPath = CmsResource.getFolderPath(requestUri);
                    String configPath = CmsStringUtil.joinPaths(folderPath, ".inherited");
                    if (this.m_cms.existsResource(configPath)) {
                        permissionInfo.setNoEditReason(new CmsResourceUtil(this.m_cms, this.m_cms.readResource(configPath)).getNoEditReason(wpLocale, true));
                    } else if (!this.m_cms.getLock(folderPath).isLockableBy(this.m_cms.getRequestContext().getCurrentUser())) {
                        permissionInfo.setNoEditReason(org.opencms.workplace.explorer.Messages.get().getBundle(wpLocale).key("GUI_NO_EDIT_REASON_LOCK_1", new CmsResourceUtil(this.m_cms, this.m_cms.readResource(folderPath)).getLockedByName()));
                    }
                }
            } else {
                permissionInfo.setNoEditReason(Messages.get().getBundle(wpLocale).key("GUI_ELEMENT_RESOURCE_CAN_NOT_BE_EDITED_0"));
            }
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(title = (searchResult = CmsGallerySearch.searchById(this.m_cms, resource.getStructureId(), this.m_locale)).getTitle())) {
                resource.getName();
            }
            subTitle = searchResult.getUserLastModified();
            Date lastModDate = searchResult.getDateLastModified();
            if (lastModDate != null) {
                subTitle = subTitle + " / " + CmsDateUtil.getDateTime(lastModDate, 2, wpLocale);
            }
        } else {
            permissionInfo = new CmsPermissionInfo(true, true, "");
            title = CmsWorkplaceMessages.getResourceTypeName(wpLocale, typeName);
            subTitle = CmsWorkplaceMessages.getResourceTypeDescription(wpLocale, typeName);
        }
        result.setTitle(title);
        result.setSubTitle(subTitle);
        result.setClientId(elementBean.editorHash());
        result.setSitePath(this.m_cms.getSitePath(resource));
        result.setCreateNew(elementBean.isCreateNew());
        CmsResourceTypeConfig typeConfig = this.getConfigData().getResourceType(typeName);
        if (typeConfig != null) {
            result.setCopyInModels(typeConfig.isCopyInModels());
        }
        Map<CmsUUID, CmsElementView> viewMap = OpenCms.getADEManager().getElementViews(this.m_cms);
        boolean isModelGroupEditing = CmsModelGroupHelper.isModelGroupResource(this.m_page);
        if (!isModelGroup && isModelGroupEditing && elementBean.getIndividualSettings().containsKey("model_group_state") && CmsContainerElement.ModelGroupState.isModelGroup == CmsContainerElement.ModelGroupState.evaluate(elementBean.getIndividualSettings().get("model_group_state"))) {
            isModelGroup = true;
        }
        if (!isModelGroupEditing && isModelGroup) {
            CmsResourceTypeConfig modelGroupConfig = this.getConfigData().getResourceType("modelgroup");
            if (modelGroupConfig != null) {
                CmsUUID elementView = modelGroupConfig.getElementView();
                CmsElementView viewObject = viewMap.get(elementView);
                if (viewObject != null && viewObject.getParentViewId() != null) {
                    elementView = viewObject.getParentViewId();
                }
                result.setElementView(elementView);
            }
        } else if (typeConfig != null) {
            CmsUUID elementView = typeConfig.getElementView();
            CmsElementView viewObject = viewMap.get(elementView);
            if (viewObject != null && viewObject.getParentViewId() != null) {
                elementView = viewObject.getParentViewId();
            }
            result.setElementView(elementView);
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(permissionInfo.getNoEditReason()) && typeConfig == null) {
            String message = Messages.get().getBundle(wpLocale).key("GUI_CONTAINERPAGE_EDIT_DISABLED_BY_SITEMAP_CONFIG_0");
            permissionInfo.setNoEditReason(message);
        }
        result.setHasSettings(this.hasSettings(this.m_cms, elementBean.getResource()));
        result.setPermissionInfo(permissionInfo);
        result.setReleasedAndNotExpired(elementBean.isReleasedAndNotExpired());
        if (elementBean.isModelGroup()) {
            String modelId = elementBean.getIndividualSettings().get("model_group_id");
            result.setModelGroupId(modelId != null ? new CmsUUID(modelId) : CmsUUID.getNullUUID());
        }
        result.setWasModelGroup(elementBean.getIndividualSettings().containsKey("model_group_state") && CmsContainerElement.ModelGroupState.evaluate(elementBean.getIndividualSettings().get("model_group_state")) == CmsContainerElement.ModelGroupState.wasModelGroup);
        return result;
    }

    CmsFormatterConfiguration getFormatterConfiguration(CmsResource resource) {
        return this.getConfigData().getFormatters(this.m_cms, resource);
    }

    private CmsContainerElementData getBaseElementData(CmsResource page, CmsContainerElementBean element) throws CmsException {
        CmsResourceUtil resUtil = new CmsResourceUtil(this.m_cms, element.getResource());
        CmsContainerElementData elementData = new CmsContainerElementData();
        this.setElementInfo(element, elementData);
        elementData.setLoadTime(System.currentTimeMillis());
        elementData.setLastModifiedDate(element.getResource().getDateLastModified());
        String userName = null;
        try {
            CmsUser user = this.m_cms.readUser(element.getResource().getUserLastModified());
            userName = user.getName();
        }
        catch (CmsException e) {
            userName = "" + element.getResource().getUserLastModified();
            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        elementData.setLastModifiedByUser(userName);
        elementData.setNavText(resUtil.getNavText());
        Map<String, CmsXmlContentProperty> settingConfig = CmsXmlContentPropertyHelper.getPropertyInfo(this.m_cms, page, element.getResource());
        elementData.setSettings(CmsXmlContentPropertyHelper.convertPropertiesToClientFormat(this.m_cms, element.getIndividualSettings(), settingConfig));
        return elementData;
    }

    private CmsADEConfigData getConfigData() {
        if (this.m_adeConfig == null) {
            this.m_adeConfig = OpenCms.getADEManager().lookupConfigurationWithCache(this.m_cms, this.m_cms.addSiteRoot(this.m_currentPageUri));
        }
        return this.m_adeConfig;
    }

    private String getContentByContainer(CmsContainerElementBean element, CmsContainer container, CmsFormatterConfiguration configs) {
        String content = null;
        I_CmsFormatterBean formatter = CmsElementUtil.getFormatterForContainer(this.m_cms, element, container, this.m_adeConfig, CmsADESessionCache.getCache(this.m_req, this.m_cms));
        if (formatter != null) {
            element = element.clone();
            element.initSettings(this.m_cms, this.m_adeConfig, formatter, this.m_locale, (ServletRequest)this.m_req, container.getSettingPresets());
            try {
                content = this.getElementContent(element, this.m_cms.readResource(formatter.getJspStructureId()), container);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            if (content != null) {
                content = this.removeScriptTags(content);
            }
        }
        return content;
    }

    private Map<String, String> getContentsByContainerName(CmsContainerElementBean element, Collection<CmsContainer> containers) {
        CmsFormatterConfiguration configs = this.getFormatterConfiguration(element.getResource());
        HashMap<String, String> result = new HashMap<String, String>();
        for (CmsContainer container : containers) {
            String content = this.getContentByContainer(element, container, configs);
            if (content != null) {
                content = this.removeScriptTags(content);
            }
            result.put(container.getName(), content);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getElementContent(CmsContainerElementBean element, CmsResource formatter, CmsContainer container) throws CmsException, ServletException, IOException {
        element.initResource(this.m_cms);
        CmsJspStandardContextBean.TemplateBean templateBean = CmsADESessionCache.getCache(this.m_req, this.m_cms).getTemplateBean(this.m_cms.addSiteRoot(this.m_currentPageUri), true);
        String oldUri = this.m_cms.getRequestContext().getUri();
        try {
            this.m_cms.getRequestContext().setUri(this.m_currentPageUri);
            CmsContainerBean containerBean = null;
            containerBean = this.m_standardContext.getPage() != null && this.m_standardContext.getPage().getContainers().containsKey(container.getName()) ? this.m_standardContext.getPage().getContainers().get(container.getName()) : CmsElementUtil.clientToServerContainer(container, Collections.emptyList());
            if (containerBean.getWidth() == null) {
                containerBean.setWidth(String.valueOf(container.getWidth()));
            }
            containerBean.setDetailOnly(container.isDetailOnly());
            this.m_standardContext.setContainer(containerBean);
            this.m_standardContext.setElement(element);
            this.m_standardContext.setEdited(true);
            CmsAdvancedDirectEditProvider eb = new CmsAdvancedDirectEditProvider();
            eb.init(this.m_cms, CmsDirectEditMode.TRUE, element.getSitePath());
            this.m_req.setAttribute("org.opencms.workplace.editors.directedit.__directEditProvider", (Object)eb);
            this.m_req.setAttribute("ATTR_TEMPLATE_BEAN", (Object)templateBean);
            String encoding = this.m_res.getCharacterEncoding();
            String string = new String(OpenCms.getResourceManager().getLoader(formatter).dump(this.m_cms, formatter, null, this.m_locale, this.m_req, this.m_res), encoding).trim();
            return string;
        }
        finally {
            this.m_cms.getRequestContext().setUri(oldUri);
        }
    }

    private CmsElementLockInfo getLockInfo(CmsObject cms, CmsResource resource) {
        try {
            CmsLock lock = cms.getLock(resource);
            CmsUUID owner = lock.getUserId();
            boolean isPublish = lock.isPublish();
            return new CmsElementLockInfo(owner, isPublish);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return new CmsElementLockInfo(null, false);
        }
    }

    private boolean hasSettings(CmsObject cms, CmsResource resource) throws CmsException {
        boolean result;
        if (!CmsResourceTypeXmlContent.isXmlContent(resource)) {
            return false;
        }
        CmsADEConfigData config = this.getConfigData();
        CmsFormatterConfiguration formatters = config.getFormatters(this.m_cms, resource);
        boolean bl = result = formatters.getAllFormatters().size() > 1 || !CmsXmlContentPropertyHelper.getPropertyInfo(this.m_cms, null, resource).isEmpty();
        if (!result && formatters.getAllFormatters().size() == 1) {
            result = formatters.getAllFormatters().get(0).getSettings(config).size() > 0;
        }
        return result;
    }

    private Map<String, Object> parseRequestParameters(String requestParameters) {
        Map<String, Object> parameterMap;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(requestParameters)) {
            parameterMap = new HashMap();
            String[] params = requestParameters.split("&");
            for (int i = 0; i < params.length; ++i) {
                int position = params[i].indexOf("=");
                if (position < 0) continue;
                String key = params[i].substring(0, position);
                String value = params[i].substring(position + 1);
                if (value.contains(",")) {
                    parameterMap.put(key, value.split(","));
                    continue;
                }
                parameterMap.put(key, value);
            }
        } else {
            parameterMap = Collections.emptyMap();
        }
        return parameterMap;
    }

    private String removeScriptTags(String input) {
        Pattern removePattern = Pattern.compile("<script[^>]*?>[\\s\\S]*?<\\/script>");
        Matcher match = removePattern.matcher(input);
        return match.replaceAll("");
    }
}

