/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.containerpage.inherited;

import java.util.Locale;
import java.util.Map;
import org.opencms.ade.containerpage.inherited.CmsContainerConfiguration;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.util.CmsUUID;

public class CmsContainerConfigurationGroup {
    private Map<Locale, Map<String, CmsContainerConfiguration>> m_configurations;
    private String m_rootPath;
    private CmsUUID m_structureId;

    public CmsContainerConfigurationGroup(Map<Locale, Map<String, CmsContainerConfiguration>> configurations) {
        this.m_configurations = configurations;
    }

    public CmsContainerConfiguration getConfiguration(String name) {
        Map<String, CmsContainerConfiguration> configurationsForLocale = null;
        if (this.m_configurations.containsKey(CmsLocaleManager.MASTER_LOCALE)) {
            configurationsForLocale = this.m_configurations.get(CmsLocaleManager.MASTER_LOCALE);
        } else if (!this.m_configurations.isEmpty()) {
            configurationsForLocale = this.m_configurations.values().iterator().next();
        } else {
            return null;
        }
        return configurationsForLocale.get(name);
    }

    public String getRootPath() {
        return this.m_rootPath;
    }

    public CmsUUID getStructureId() {
        return this.m_structureId;
    }

    public void setResource(CmsResource configResource) {
        this.m_structureId = configResource.getStructureId();
        this.m_rootPath = configResource.getRootPath();
    }
}

