/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.contenteditor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.acacia.shared.CmsAttributeConfiguration;
import org.opencms.acacia.shared.CmsTabInfo;
import org.opencms.acacia.shared.CmsType;
import org.opencms.ade.contenteditor.CmsContentService;
import org.opencms.ade.contenteditor.CmsDynamicCategoryFieldList;
import org.opencms.ade.contenteditor.CmsWidgetUtil;
import org.opencms.ade.contenteditor.Messages;
import org.opencms.ade.contenteditor.shared.CmsComplexWidgetData;
import org.opencms.ade.contenteditor.shared.CmsExternalWidgetConfiguration;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsRequestContext;
import org.opencms.i18n.CmsMessages;
import org.opencms.i18n.CmsMultiMessages;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.I_CmsADEWidget;
import org.opencms.widgets.I_CmsComplexWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.content.CmsDefaultXmlContentHandler;
import org.opencms.xml.content.CmsXmlContentTab;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.types.A_CmsXmlContentValue;
import org.opencms.xml.types.CmsXmlDynamicCategoryValue;
import org.opencms.xml.types.CmsXmlNestedContentDefinition;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsContentTypeVisitor {
    private static final Log LOG = CmsLog.getLog(CmsContentTypeVisitor.class);
    private static final String MESSAGE_MACRO_START = "%(key.";
    private static final String MESSAGE_MACRO_START_OLD = "${key.";
    private Map<String, CmsAttributeConfiguration> m_attributeConfigurations;
    private CmsObject m_cms;
    private Map<String, CmsComplexWidgetData> m_complexWidgets = new HashMap<String, CmsComplexWidgetData>();
    private I_CmsXmlContentHandler m_contentHandler;
    private List<String> m_dynamicallyLoaded;
    private CmsDynamicCategoryFieldList m_dynamicCategoryFields = new CmsDynamicCategoryFieldList();
    private CmsFile m_file;
    private boolean m_hasInvisible;
    private Locale m_locale;
    private List<String> m_localeSynchronizations;
    private CmsMultiMessages m_messages;
    private Map<String, CmsType> m_registeredTypes;
    private CmsXmlContentDefinition m_rootContentDefinition;
    private List<CmsTabInfo> m_tabInfos;
    private Map<String, CmsExternalWidgetConfiguration> m_widgetConfigurations;
    private List<I_CmsWidget> m_widgets = new ArrayList<I_CmsWidget>();

    public CmsContentTypeVisitor(CmsObject cms, CmsFile file, Locale locale) {
        this.m_file = file;
        this.m_cms = cms;
        this.m_locale = locale;
    }

    public CmsObject getCmsObject() {
        return this.m_cms;
    }

    public List<I_CmsWidget> getCollectedWidgets() {
        return Collections.unmodifiableList(this.m_widgets);
    }

    public Map<String, CmsComplexWidgetData> getComplexWidgetData() {
        return this.m_complexWidgets;
    }

    public CmsDynamicCategoryFieldList getOptionalDynamicCategoryFields() {
        return this.m_dynamicCategoryFields;
    }

    public List<CmsTabInfo> getTabInfos() {
        return this.m_tabInfos;
    }

    public boolean hasInvisibleFields() {
        return this.m_hasInvisible;
    }

    public boolean isDynamicallyLoaded(String attributeName) {
        return this.m_dynamicallyLoaded.contains(attributeName);
    }

    public boolean isEditorCompatible(CmsXmlContentDefinition xmlContentDefinition) throws CmsXmlException {
        boolean result = true;
        for (I_CmsXmlSchemaType subType : xmlContentDefinition.getTypeSequence()) {
            if (subType.isSimpleType()) {
                result = this.isEditorCompatible((A_CmsXmlContentValue)subType);
            } else {
                CmsXmlContentDefinition subTypeDefinition = ((CmsXmlNestedContentDefinition)subType).getNestedContentDefinition();
                result = this.isEditorCompatible(subTypeDefinition);
            }
            if (result) continue;
            break;
        }
        return result;
    }

    public void visitTypes(CmsXmlContentDefinition xmlContentDefinition, Locale messageLocale) {
        this.m_rootContentDefinition = xmlContentDefinition;
        this.m_contentHandler = xmlContentDefinition.getContentHandler();
        CmsMessages messages = null;
        this.m_messages = new CmsMultiMessages(messageLocale);
        this.m_messages.setFallbackHandler(xmlContentDefinition.getContentHandler().getMessageKeyHandler());
        try {
            messages = OpenCms.getWorkplaceManager().getMessages(messageLocale);
            if (messages != null) {
                this.m_messages.addMessages(messages);
            }
            if ((messages = this.m_contentHandler.getMessages(messageLocale)) != null) {
                this.m_messages.addMessages(messages);
            }
        }
        catch (Exception e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
        this.m_attributeConfigurations = new HashMap<String, CmsAttributeConfiguration>();
        this.m_widgetConfigurations = new HashMap<String, CmsExternalWidgetConfiguration>();
        this.m_registeredTypes = new HashMap<String, CmsType>();
        this.m_localeSynchronizations = new ArrayList<String>();
        this.m_dynamicallyLoaded = new ArrayList<String>();
        this.m_tabInfos = this.collectTabInfos(xmlContentDefinition);
        this.readTypes(xmlContentDefinition, "");
    }

    protected Map<String, CmsAttributeConfiguration> getAttributeConfigurations() {
        return this.m_attributeConfigurations;
    }

    protected List<String> getLocaleSynchronizations() {
        return this.m_localeSynchronizations;
    }

    protected Map<String, CmsType> getTypes() {
        return this.m_registeredTypes;
    }

    protected Collection<CmsExternalWidgetConfiguration> getWidgetConfigurations() {
        return this.m_widgetConfigurations.values();
    }

    private List<CmsTabInfo> collectTabInfos(CmsXmlContentDefinition definition) {
        ArrayList<CmsTabInfo> result = new ArrayList<CmsTabInfo>();
        CmsMacroResolver resolver = new CmsMacroResolver();
        resolver.setCmsObject(this.m_cms);
        resolver.setMessages(this.m_messages);
        if (definition.getContentHandler().getTabs() != null) {
            for (CmsXmlContentTab xmlTab : definition.getContentHandler().getTabs()) {
                String tabName = xmlTab.getTabName().contains(MESSAGE_MACRO_START) || xmlTab.getTabName().contains(MESSAGE_MACRO_START_OLD) ? resolver.resolveMacros(xmlTab.getTabName()) : this.m_messages.keyDefault("label." + definition.getInnerName() + "." + xmlTab.getTabName(), xmlTab.getTabName());
                result.add(new CmsTabInfo(tabName, xmlTab.getIdName(), xmlTab.getStartName(), xmlTab.isCollapsed(), resolver.resolveMacros(xmlTab.getDescription())));
            }
        }
        return result;
    }

    private String getHelp(I_CmsXmlSchemaType value) {
        CmsDefaultXmlContentHandler defaultHandler;
        String help;
        StringBuffer result = new StringBuffer(64);
        I_CmsXmlContentHandler handler = value.getContentDefinition().getContentHandler();
        if (handler instanceof CmsDefaultXmlContentHandler && (help = (defaultHandler = (CmsDefaultXmlContentHandler)handler).getFieldHelp().get(value.getName())) != null) {
            CmsMacroResolver resolver = new CmsMacroResolver();
            resolver.setCmsObject(this.m_cms);
            resolver.setKeepEmptyMacros(true);
            resolver.setMessages(this.m_messages);
            return resolver.resolveMacros(help);
        }
        result.append("label.");
        result.append(this.getTypeKey(value));
        result.append(".help");
        return this.m_messages.keyDefault(result.toString(), null);
    }

    private String getLabel(I_CmsXmlSchemaType value) {
        CmsDefaultXmlContentHandler defaultHandler;
        String label;
        I_CmsXmlContentHandler handler = value.getContentDefinition().getContentHandler();
        if (handler instanceof CmsDefaultXmlContentHandler && (label = (defaultHandler = (CmsDefaultXmlContentHandler)handler).getFieldLabels().get(value.getName())) != null) {
            CmsMacroResolver resolver = new CmsMacroResolver();
            resolver.setCmsObject(this.m_cms);
            resolver.setKeepEmptyMacros(true);
            resolver.setMessages(this.m_messages);
            return resolver.resolveMacros(label);
        }
        StringBuffer result = new StringBuffer(64);
        result.append("label.");
        result.append(this.getTypeKey(value));
        return this.m_messages.keyDefault(result.toString(), value.getName());
    }

    private String getTypeKey(I_CmsXmlSchemaType value) {
        StringBuffer result = new StringBuffer(64);
        result.append(value.getContentDefinition().getInnerName());
        result.append('.');
        result.append(value.getName());
        return result.toString();
    }

    private boolean isEditorCompatible(A_CmsXmlContentValue schemaType) throws CmsXmlException {
        boolean result = false;
        I_CmsXmlContentHandler contentHandler = schemaType.getContentDefinition().getContentHandler();
        I_CmsWidget widget = contentHandler.getWidget(schemaType);
        result = widget == null || widget instanceof I_CmsADEWidget;
        return result;
    }

    private boolean isTabRootLevel(String path) {
        if (!(path = path.substring(1)).contains("/")) {
            return true;
        }
        if (this.m_tabInfos != null) {
            for (CmsTabInfo info : this.m_tabInfos) {
                if (!info.isCollapsed() || !path.startsWith(info.getStartName()) || path.substring(info.getStartName().length() + 1).contains("/")) continue;
                return true;
            }
        }
        return false;
    }

    private DisplayTypeEvaluator readConfiguration(A_CmsXmlContentValue schemaType, String path) {
        boolean visible;
        String widgetName = null;
        String widgetConfig = null;
        CmsObject cms = this.getCmsObject();
        String label = this.getLabel(schemaType);
        I_CmsXmlContentHandler.DisplayType configuredType = I_CmsXmlContentHandler.DisplayType.none;
        I_CmsXmlContentHandler.DisplayType defaultType = I_CmsXmlContentHandler.DisplayType.none;
        EvaluationRule rule = EvaluationRule.none;
        try {
            CmsWidgetUtil.WidgetInfo widgetInfo = CmsWidgetUtil.collectWidgetInfo(cms, this.m_rootContentDefinition, path);
            I_CmsWidget widget = widgetInfo.getWidget();
            I_CmsComplexWidget complexWidget = widgetInfo.getComplexWidget();
            configuredType = widgetInfo.getDisplayType();
            if (configuredType.equals((Object)I_CmsXmlContentHandler.DisplayType.none) && schemaType.isSimpleType()) {
                if (this.isTabRootLevel(path)) {
                    rule = EvaluationRule.rootLevel;
                } else if (label.length() > 15) {
                    rule = EvaluationRule.labelLength;
                } else if (schemaType.getMinOccurs() == 0) {
                    rule = EvaluationRule.optional;
                }
            }
            if (widget != null) {
                widgetName = widget.getClass().getName();
                if (!(configuredType != I_CmsXmlContentHandler.DisplayType.column || schemaType.isSimpleType() && schemaType.getMaxOccurs() == 1 && widget.isCompactViewEnabled())) {
                    configuredType = I_CmsXmlContentHandler.DisplayType.singleline;
                }
                long timer = 0L;
                if (widget instanceof I_CmsADEWidget) {
                    if (CmsContentService.LOG.isDebugEnabled()) {
                        timer = System.currentTimeMillis();
                    }
                    I_CmsADEWidget adeWidget = (I_CmsADEWidget)widget;
                    defaultType = adeWidget.getDefaultDisplayType();
                    widgetName = adeWidget.getWidgetName();
                    if (cms.getRequestContext().getAttribute(CmsRequestContext.ATTRIBUTE_ADE_CONTEXT_PATH) == null && this.m_file != null) {
                        cms.getRequestContext().setAttribute(CmsRequestContext.ATTRIBUTE_ADE_CONTEXT_PATH, this.m_file.getRootPath());
                    }
                    widgetConfig = adeWidget.getConfiguration(cms, schemaType, this.m_messages, this.m_file, this.m_locale);
                    if (!adeWidget.isInternal() && !this.m_widgetConfigurations.containsKey(widgetName)) {
                        CmsExternalWidgetConfiguration externalConfiguration = new CmsExternalWidgetConfiguration(widgetName, adeWidget.getInitCall(), adeWidget.getJavaScriptResourceLinks(cms), adeWidget.getCssResourceLinks(cms));
                        this.m_widgetConfigurations.put(widgetName, externalConfiguration);
                    }
                    if (CmsContentService.LOG.isDebugEnabled()) {
                        CmsContentService.LOG.debug((Object)Messages.get().getBundle().key("LOG_TAKE_READING_WIDGET_CONFIGURATION_TIME_2", widgetName, "" + (System.currentTimeMillis() - timer)));
                    }
                }
                this.m_widgets.add(widget);
            }
            if (complexWidget != null) {
                CmsComplexWidgetData widgetData = complexWidget.getWidgetData(this.m_cms);
                CmsExternalWidgetConfiguration externalConfig = widgetData.getExternalWidgetConfiguration();
                if (externalConfig != null) {
                    this.m_widgetConfigurations.put(complexWidget.getName(), externalConfig);
                }
                this.m_complexWidgets.put(CmsContentService.getAttributeName(schemaType), widgetData);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        boolean bl = visible = !this.m_contentHandler.hasVisibilityHandlers() || this.m_contentHandler.isVisible(cms, schemaType, path.substring(1), this.m_file, this.m_locale);
        if (!visible) {
            this.m_hasInvisible = true;
        }
        boolean localeSynchronized = this.m_contentHandler.hasSynchronizedElements() && this.m_contentHandler.getSynchronizations().contains(path.substring(1)) || schemaType.getTypeName().equals("OpenCmsDynamicCategory");
        boolean dynamicallyLoaded = schemaType instanceof CmsXmlDynamicCategoryValue;
        CmsAttributeConfiguration result = new CmsAttributeConfiguration(label, this.getHelp(schemaType), widgetName, widgetConfig, this.readDefaultValue(schemaType, path), configuredType.name(), visible, localeSynchronized, dynamicallyLoaded);
        return new DisplayTypeEvaluator(result, configuredType, defaultType, rule);
    }

    private String readDefaultValue(I_CmsXmlSchemaType schemaType, String path) {
        return this.m_contentHandler.getDefault(this.getCmsObject(), this.m_file, schemaType, path, this.m_locale);
    }

    private CmsType readTypes(CmsXmlContentDefinition xmlContentDefinition, String path) {
        String typeName = (CmsStringUtil.isEmptyOrWhitespaceOnly(path) ? "" : path + ":") + CmsContentService.getTypeUri(xmlContentDefinition);
        if (this.m_registeredTypes.containsKey(typeName)) {
            return this.m_registeredTypes.get(typeName);
        }
        CmsType type = new CmsType(typeName);
        type.setChoiceMaxOccurrence(xmlContentDefinition.getChoiceMaxOccurs());
        this.m_registeredTypes.put(typeName, type);
        CmsType choiceType = null;
        if (type.isChoice()) {
            choiceType = new CmsType(typeName + "/" + "ATTRIBUTE_CHOICE");
            this.m_registeredTypes.put(choiceType.getId(), choiceType);
            type.addAttribute("ATTRIBUTE_CHOICE", choiceType, 1, xmlContentDefinition.getChoiceMaxOccurs());
        }
        ArrayList<DisplayTypeEvaluator> evaluators = new ArrayList<DisplayTypeEvaluator>();
        for (I_CmsXmlSchemaType subType : xmlContentDefinition.getTypeSequence()) {
            CmsType subEntityType;
            String subTypeName = null;
            String childPath = path + "/" + subType.getName();
            String subAttributeName = CmsContentService.getAttributeName(subType.getName(), typeName);
            DisplayTypeEvaluator ev = this.readConfiguration((A_CmsXmlContentValue)subType, childPath);
            ev.setAttributeName(subAttributeName);
            evaluators.add(ev);
            if (subType.isSimpleType()) {
                subTypeName = "http://opencms.org/types/" + subType.getTypeName();
                if (!this.m_registeredTypes.containsKey(subTypeName)) {
                    subEntityType = new CmsType(subTypeName);
                    this.m_registeredTypes.put(subTypeName, subEntityType);
                } else {
                    subEntityType = this.m_registeredTypes.get(subTypeName);
                }
            } else {
                CmsXmlContentDefinition subTypeDefinition = ((CmsXmlNestedContentDefinition)subType).getNestedContentDefinition();
                subTypeName = CmsContentService.getTypeUri(subTypeDefinition);
                subEntityType = this.readTypes(subTypeDefinition, childPath);
            }
            if (choiceType != null) {
                choiceType.addAttribute(subAttributeName, subEntityType, subType.getMinOccurs(), subType.getMaxOccurs());
                continue;
            }
            int minOccurs = subType.getMinOccurs();
            if (subType instanceof CmsXmlDynamicCategoryValue && subType.getMinOccurs() == 0) {
                String dynamicCategoryPath = "".equals(path) ? subType.getName() : path + "/" + subType.getName();
                this.m_dynamicCategoryFields.add(dynamicCategoryPath);
                minOccurs = 1;
            }
            type.addAttribute(subAttributeName, subEntityType, minOccurs, subType.getMaxOccurs());
        }
        I_CmsXmlContentHandler.DisplayType predecessor = null;
        for (int i = 0; i < evaluators.size(); ++i) {
            DisplayTypeEvaluator ev = (DisplayTypeEvaluator)evaluators.get(i);
            I_CmsXmlContentHandler.DisplayType successor = i + 1 < evaluators.size() ? ((DisplayTypeEvaluator)evaluators.get(i + 1)).getProposedType() : null;
            CmsAttributeConfiguration evaluated = ev.getEvaluatedConfiguration(predecessor, successor);
            this.m_attributeConfigurations.put(ev.getAttributeName(), evaluated);
            if (evaluated.isLocaleSynchronized()) {
                this.m_localeSynchronizations.add(ev.getAttributeName());
            }
            if (evaluated.isDynamicallyLoaded()) {
                this.m_dynamicallyLoaded.add(ev.getAttributeName());
            }
            predecessor = I_CmsXmlContentHandler.DisplayType.valueOf(evaluated.getDisplayType());
        }
        return type;
    }

    protected static enum EvaluationRule {
        labelLength,
        none,
        optional,
        rootLevel;

    }

    protected class DisplayTypeEvaluator {
        private String m_attributeName;
        private CmsAttributeConfiguration m_config;
        private I_CmsXmlContentHandler.DisplayType m_configuredType;
        private I_CmsXmlContentHandler.DisplayType m_default;
        private EvaluationRule m_rule;

        protected DisplayTypeEvaluator(CmsAttributeConfiguration config, I_CmsXmlContentHandler.DisplayType configuredType, I_CmsXmlContentHandler.DisplayType defaultType, EvaluationRule rule) {
            this.m_config = config;
            this.m_configuredType = configuredType;
            this.m_default = defaultType;
            this.m_rule = rule;
        }

        protected String getAttributeName() {
            return this.m_attributeName;
        }

        protected CmsAttributeConfiguration getEvaluatedConfiguration(I_CmsXmlContentHandler.DisplayType predecessor, I_CmsXmlContentHandler.DisplayType successor) {
            I_CmsXmlContentHandler.DisplayType resultingType = this.m_configuredType;
            if (resultingType.equals((Object)I_CmsXmlContentHandler.DisplayType.none)) {
                if (this.m_rule.equals((Object)EvaluationRule.rootLevel)) {
                    resultingType = I_CmsXmlContentHandler.DisplayType.wide;
                } else {
                    boolean strong;
                    resultingType = this.getProposedType();
                    if (predecessor != null && predecessor.equals((Object)I_CmsXmlContentHandler.DisplayType.none)) {
                        predecessor = null;
                    }
                    if (successor != null && successor.equals((Object)I_CmsXmlContentHandler.DisplayType.none)) {
                        successor = null;
                    }
                    if (predecessor != null && predecessor.equals((Object)I_CmsXmlContentHandler.DisplayType.column)) {
                        predecessor = I_CmsXmlContentHandler.DisplayType.singleline;
                    }
                    if (successor != null && successor.equals((Object)I_CmsXmlContentHandler.DisplayType.column)) {
                        successor = I_CmsXmlContentHandler.DisplayType.singleline;
                    }
                    boolean bl = strong = this.m_rule.equals((Object)EvaluationRule.none) || this.m_rule.equals((Object)EvaluationRule.optional) && this.m_default.equals((Object)I_CmsXmlContentHandler.DisplayType.singleline) || this.m_rule.equals((Object)EvaluationRule.labelLength) && this.m_default.equals((Object)I_CmsXmlContentHandler.DisplayType.wide);
                    if ((predecessor == null || successor == null) && strong) {
                        resultingType = this.m_default;
                    } else if (!(predecessor == null && successor == null || predecessor != null && resultingType.equals((Object)predecessor) || successor != null && resultingType.equals((Object)successor))) {
                        I_CmsXmlContentHandler.DisplayType match = predecessor != null && (predecessor.equals((Object)I_CmsXmlContentHandler.DisplayType.wide) || predecessor.equals((Object)I_CmsXmlContentHandler.DisplayType.singleline)) ? predecessor : (successor != null && (successor.equals((Object)I_CmsXmlContentHandler.DisplayType.wide) || successor.equals((Object)I_CmsXmlContentHandler.DisplayType.singleline)) ? successor : null);
                        resultingType = match != null ? match : resultingType;
                    }
                }
            }
            this.m_config.setDisplayType(resultingType.name());
            return this.m_config;
        }

        protected I_CmsXmlContentHandler.DisplayType getProposedType() {
            I_CmsXmlContentHandler.DisplayType resultingType = this.m_configuredType;
            if (resultingType.equals((Object)I_CmsXmlContentHandler.DisplayType.none)) {
                switch (this.m_rule) {
                    case rootLevel: 
                    case labelLength: {
                        resultingType = I_CmsXmlContentHandler.DisplayType.wide;
                        break;
                    }
                    case optional: {
                        resultingType = I_CmsXmlContentHandler.DisplayType.singleline;
                        break;
                    }
                    default: {
                        resultingType = this.m_default;
                    }
                }
            }
            return resultingType;
        }

        protected void setAttributeName(String attributeName) {
            this.m_attributeName = attributeName;
        }
    }
}

