/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.contenteditor;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.opencms.file.CmsObject;
import org.opencms.main.OpenCms;
import org.opencms.widgets.I_CmsComplexWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public final class CmsWidgetUtil {
    private CmsWidgetUtil() {
    }

    public static WidgetInfo collectWidgetInfo(CmsObject cms, CmsXmlContentDefinition rootContentDefinition, String path) {
        String widgetConfig = null;
        I_CmsXmlContentHandler.DisplayType configuredType = I_CmsXmlContentHandler.DisplayType.none;
        I_CmsXmlSchemaType schemaType = rootContentDefinition.getSchemaType(path);
        I_CmsWidget widget = null;
        I_CmsComplexWidget complexWidget = null;
        I_CmsXmlContentHandler contentHandler = schemaType.getContentDefinition().getContentHandler();
        ArrayList configuredWidgets = new ArrayList();
        ArrayList configuredWidgetConfigs = new ArrayList();
        ArrayList configuredDisplayTypes = new ArrayList();
        ArrayList configuredComplexWidgets = new ArrayList();
        rootContentDefinition.findSchemaTypesForPath(path, (nestedType, remainingPath) -> {
            remainingPath = CmsXmlUtils.concatXpath(nestedType.getName(), remainingPath);
            I_CmsXmlContentHandler handler = nestedType.getContentDefinition().getContentHandler();
            I_CmsWidget widgetForPath = handler.getWidget(cms, (String)remainingPath);
            CollectionUtils.addIgnoreNull((Collection)configuredWidgets, (Object)widgetForPath);
            CollectionUtils.addIgnoreNull((Collection)configuredWidgetConfigs, (Object)handler.getConfiguration((String)remainingPath));
            CollectionUtils.addIgnoreNull((Collection)configuredDisplayTypes, (Object)((Object)handler.getConfiguredDisplayType((String)remainingPath, null)));
            if (widgetForPath == null) {
                CollectionUtils.addIgnoreNull((Collection)configuredComplexWidgets, (Object)handler.getComplexWidget(cms, (String)remainingPath));
            }
        });
        widget = !configuredWidgets.isEmpty() ? ((I_CmsWidget)configuredWidgets.get(0)).newInstance() : OpenCms.getXmlContentTypeManager().getWidgetDefault(schemaType.getTypeName());
        if (!configuredDisplayTypes.isEmpty()) {
            configuredType = (I_CmsXmlContentHandler.DisplayType)((Object)configuredDisplayTypes.get(0));
        }
        if (!configuredWidgetConfigs.isEmpty()) {
            widgetConfig = (String)configuredWidgetConfigs.get(0);
        } else if (widget != null) {
            widgetConfig = OpenCms.getXmlContentTypeManager().getWidgetDefaultConfiguration(widget);
        }
        if (widget != null) {
            widget.setConfiguration(widgetConfig);
        }
        CollectionUtils.addIgnoreNull(configuredComplexWidgets, (Object)contentHandler.getDefaultComplexWidget());
        ArrayList complexWidgetConfigs = new ArrayList(configuredWidgetConfigs);
        CollectionUtils.addIgnoreNull(complexWidgetConfigs, (Object)contentHandler.getDefaultComplexWidgetConfiguration());
        if (!configuredComplexWidgets.isEmpty()) {
            String config = "";
            if (!complexWidgetConfigs.isEmpty()) {
                config = (String)complexWidgetConfigs.get(0);
            }
            complexWidget = ((I_CmsComplexWidget)configuredComplexWidgets.get(0)).configure(config);
        }
        WidgetInfo result = new WidgetInfo();
        result.setComplexWidget(complexWidget);
        result.setDisplayType(configuredType);
        result.setWidget(widget);
        return result;
    }

    public static WidgetInfo collectWidgetInfo(CmsObject cms, I_CmsXmlContentValue value) {
        CmsXmlContentDefinition contentDef = value.getDocument().getContentDefinition();
        String path = value.getPath();
        return CmsWidgetUtil.collectWidgetInfo(cms, contentDef, path);
    }

    public static class WidgetInfo {
        private I_CmsXmlContentHandler.DisplayType m_displayType;
        private I_CmsWidget m_widget;
        private I_CmsComplexWidget m_complexWidget;

        public I_CmsComplexWidget getComplexWidget() {
            return this.m_complexWidget;
        }

        public I_CmsXmlContentHandler.DisplayType getDisplayType() {
            return this.m_displayType;
        }

        public I_CmsWidget getWidget() {
            return this.m_widget;
        }

        public void setComplexWidget(I_CmsComplexWidget complexWidget) {
            this.m_complexWidget = complexWidget;
        }

        public void setDisplayType(I_CmsXmlContentHandler.DisplayType displayType) {
            this.m_displayType = displayType;
        }

        public void setWidget(I_CmsWidget widget) {
            this.m_widget = widget;
        }
    }
}

