/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.detailpage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsADEManager;
import org.opencms.ade.detailpage.CmsDetailPageInfo;
import org.opencms.ade.detailpage.I_CmsDetailPageHandler;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSite;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;

public class CmsDefaultDetailPageHandler
implements I_CmsDetailPageHandler {
    private static final Log LOG = CmsLog.getLog(CmsDefaultDetailPageHandler.class);
    private CmsParameterConfiguration m_config = new CmsParameterConfiguration();

    public CmsDefaultDetailPageHandler() {
        LOG.debug((Object)"Created default detail page handler.");
    }

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
        this.m_config.add(paramName, paramValue);
    }

    @Override
    public Collection<String> getAllDetailPages(CmsObject cms, int resType) throws CmsException {
        if (!OpenCms.getADEManager().isInitialized()) {
            return new ArrayList<String>();
        }
        String typeName = OpenCms.getResourceManager().getResourceType(resType).getTypeName();
        return OpenCms.getADEManager().getDetailPages(cms, typeName);
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        return this.m_config;
    }

    public String getDetailPage(CmsADEManager manager, CmsObject cms, String contentRootPath, String originPath, String targetDetailPage) {
        boolean online = cms.getRequestContext().getCurrentProject().isOnlineProject();
        String resType = manager.getParentFolderType(online, contentRootPath);
        if (resType == null) {
            return null;
        }
        if (targetDetailPage != null && manager.getDetailPages(cms, resType).contains(targetDetailPage)) {
            return targetDetailPage;
        }
        DetailPageConfigData context = this.lookupDetailPageConfigData(manager, cms, contentRootPath, originPath, resType);
        List<CmsDetailPageInfo> relevantPages = context.getDetailPages();
        if (context.getConfigForDetailPages() == null) {
            return null;
        }
        if (!CmsStringUtil.isPrefixPath(context.getConfigForDetailPages().getExternalDetailContentExclusionFolder(), contentRootPath)) {
            return null;
        }
        if (relevantPages.size() > 0) {
            return relevantPages.get(0).getUri();
        }
        return null;
    }

    @Override
    public String getDetailPage(CmsObject cms, String rootPath, String linkSource, String targetDetailPage) {
        CmsADEManager manager = OpenCms.getADEManager();
        if (!manager.isInitialized()) {
            return null;
        }
        if (rootPath.endsWith(".jsp") || rootPath.startsWith("/system/workplace/")) {
            return null;
        }
        String result = this.getDetailPage(manager, cms, rootPath, linkSource, targetDetailPage);
        if (result == null) {
            return null;
        }
        if (!CmsResource.isFolder(result)) {
            result = CmsResource.getFolderPath(result);
        }
        return result;
    }

    @Override
    public void initConfiguration() {
        this.m_config = CmsParameterConfiguration.unmodifiableVersion(this.m_config);
    }

    @Override
    public void initialize(CmsObject offlineCms, CmsObject onlineCms) {
    }

    @Override
    public boolean isValidDetailPage(CmsObject cms, CmsResource page, CmsResource detailRes) {
        String p = "[" + RandomStringUtils.randomAlphanumeric((int)6) + "] ";
        LOG.debug((Object)(p + "isValidDetailPage(" + page.getRootPath() + "," + detailRes.getRootPath() + ")"));
        if (OpenCms.getSystemInfo().isRestrictDetailContents()) {
            CmsSite pageSite = OpenCms.getSiteManager().getSiteForRootPath(page.getRootPath());
            CmsSite detailSite = OpenCms.getSiteManager().getSiteForRootPath(detailRes.getRootPath());
            if (pageSite != null && detailSite != null && !pageSite.getSiteRoot().equals(detailSite.getSiteRoot())) {
                LOG.debug((Object)(p + "returned false because of restrict-detail-contents option"));
                return false;
            }
        }
        if (!OpenCms.getADEManager().isDetailPage(cms, page)) {
            LOG.debug((Object)(p + "returned false because the page is not a detail page."));
            return false;
        }
        String typeName = OpenCms.getResourceManager().getResourceType(detailRes).getTypeName();
        DetailPageConfigData context = this.lookupDetailPageConfigData(OpenCms.getADEManager(), cms, detailRes.getRootPath(), cms.getSitePath(page), typeName);
        String pageFolder = CmsFileUtil.removeTrailingSeparator(CmsResource.getParentFolder(page.getRootPath()));
        boolean foundDetailPage = context.getDetailPages().stream().anyMatch(info -> pageFolder.equals(CmsFileUtil.removeTrailingSeparator(info.getUri())));
        CmsADEConfigData configForPage = context.getConfigForDetailPages();
        if (configForPage == null) {
            LOG.debug((Object)(p + "Returned false because no valid sitemap configuration found"));
            return false;
        }
        if (!foundDetailPage) {
            LOG.debug((Object)(p + "Returned false because detail page is not in context " + configForPage.getBasePath()));
            return false;
        }
        if (!CmsStringUtil.isPrefixPath(configForPage.getExternalDetailContentExclusionFolder(), detailRes.getRootPath())) {
            LOG.debug((Object)(p + "returned false because of external detail content exclusion folder " + configForPage.getExternalDetailContentExclusionFolder()));
            return false;
        }
        return true;
    }

    private DetailPageConfigData lookupDetailPageConfigData(CmsADEManager manager, CmsObject cms, String contentPath, String originPath, String resType) {
        DetailPageConfigData context = new DetailPageConfigData();
        CmsADEConfigData configData = manager.lookupConfigurationWithCache(cms, cms.getRequestContext().addSiteRoot(originPath));
        context.setSourceConfig(configData);
        CmsADEConfigData targetConfigData = manager.lookupConfigurationWithCache(cms, contentPath);
        context.setTargetConfig(targetConfigData);
        boolean targetFirst = targetConfigData.isPreferDetailPagesForLocalContents();
        List<CmsADEConfigData> configs = targetFirst ? Arrays.asList(targetConfigData, configData) : Arrays.asList(configData, targetConfigData);
        for (CmsADEConfigData config : configs) {
            List<CmsDetailPageInfo> pageInfo = config.getDetailPagesForType(resType);
            if (pageInfo == null || pageInfo.isEmpty()) continue;
            context.setConfigForDetailPages(config);
            context.setDetailPages(pageInfo);
            break;
        }
        return context;
    }

    private static class DetailPageConfigData {
        private CmsADEConfigData m_sourceConfig;
        private CmsADEConfigData m_configForDetailPages;
        private CmsADEConfigData m_targetConfig;
        private List<CmsDetailPageInfo> m_detailPages = new ArrayList<CmsDetailPageInfo>();

        private DetailPageConfigData() {
        }

        public CmsADEConfigData getConfigForDetailPages() {
            return this.m_configForDetailPages;
        }

        public List<CmsDetailPageInfo> getDetailPages() {
            return this.m_detailPages;
        }

        public CmsADEConfigData getSourceConfig() {
            return this.m_sourceConfig;
        }

        public CmsADEConfigData getTargetConfig() {
            return this.m_targetConfig;
        }

        public void setConfigForDetailPages(CmsADEConfigData configForDetailPages) {
            this.m_configForDetailPages = configForDetailPages;
        }

        public void setDetailPages(List<CmsDetailPageInfo> detailPages) {
            this.m_detailPages = detailPages;
        }

        public void setSourceConfig(CmsADEConfigData sourceConfig) {
            this.m_sourceConfig = sourceConfig;
        }

        public void setTargetConfig(CmsADEConfigData targetConfig) {
            this.m_targetConfig = targetConfig;
        }
    }
}

