/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.postupload;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.postupload.Messages;
import org.opencms.ade.postupload.shared.CmsPostUploadDialogBean;
import org.opencms.ade.postupload.shared.CmsPostUploadDialogPanelBean;
import org.opencms.ade.postupload.shared.rpc.I_CmsPostUploadDialogService;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.flex.CmsFlexController;
import org.opencms.gwt.CmsGwtService;
import org.opencms.gwt.CmsPropertyEditorHelper;
import org.opencms.gwt.CmsRpcException;
import org.opencms.gwt.CmsVfsService;
import org.opencms.gwt.shared.CmsListInfoBean;
import org.opencms.gwt.shared.property.CmsClientProperty;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentPropertyHelper;

public class CmsPostUploadDialogService
extends CmsGwtService
implements I_CmsPostUploadDialogService {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = CmsLog.getLog(CmsPostUploadDialogService.class);

    public static CmsPostUploadDialogBean prefetch(HttpServletRequest request) throws CmsRpcException {
        CmsPostUploadDialogService srv = new CmsPostUploadDialogService();
        srv.setCms(CmsFlexController.getCmsObject((ServletRequest)request));
        srv.setRequest(request);
        CmsPostUploadDialogBean result = null;
        try {
            result = srv.prefetch();
        }
        finally {
            srv.clearThreadStorage();
        }
        return result;
    }

    @Override
    public CmsPostUploadDialogPanelBean load(CmsUUID id, boolean useConfiguration, boolean addBasicProperties) throws CmsRpcException {
        try {
            String description;
            CmsResource res = this.getCmsObject().readResource(id);
            List<CmsProperty> properties = this.getCmsObject().readPropertyObjects(res, false);
            String title = CmsProperty.get("Title", properties).getValue();
            if (title == null) {
                title = res.getName();
            }
            if ((description = CmsProperty.get("Description", properties).getValue()) == null) {
                description = this.getCmsObject().getSitePath(res);
            }
            CmsListInfoBean listInfo = CmsVfsService.getPageInfo(this.getCmsObject(), res);
            CmsPostUploadDialogPanelBean result = new CmsPostUploadDialogPanelBean(id, listInfo);
            I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(res.getTypeId());
            String typeName = type.getTypeName();
            listInfo.setResourceType(typeName);
            CmsExplorerTypeSettings settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(typeName);
            List<String> defaultProperties = settings.getProperties();
            while (properties.isEmpty() && !CmsStringUtil.isEmptyOrWhitespaceOnly(settings.getReference())) {
                settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(settings.getReference());
                defaultProperties = settings.getProperties();
            }
            Map<String, CmsXmlContentProperty> propertyDefinitions = new LinkedHashMap<String, CmsXmlContentProperty>();
            LinkedHashMap<String, CmsClientProperty> clientProperties = new LinkedHashMap<String, CmsClientProperty>();
            CmsXmlContentProperty fileNamePropDef = new CmsXmlContentProperty("~~~file_name_property~~~", "string", "string", "", "", "", "", Messages.get().getBundle(OpenCms.getWorkplaceManager().getWorkplaceLocale(this.getCmsObject())).key("GUI_UPLOAD_FILE_NAME_0"), "", "", "false");
            propertyDefinitions.put("~~~file_name_property~~~", fileNamePropDef);
            clientProperties.put("~~~file_name_property~~~", new CmsClientProperty("~~~file_name_property~~~", res.getName(), res.getName()));
            CmsADEConfigData configData = OpenCms.getADEManager().lookupConfiguration(this.getCmsObject(), res.getRootPath());
            Map<String, CmsXmlContentProperty> propertyConfiguration = configData.getPropertyConfigurationAsMap();
            LinkedHashSet<String> propertiesToShow = new LinkedHashSet<String>();
            propertiesToShow.addAll(defaultProperties);
            if (addBasicProperties) {
                propertiesToShow.addAll(propertyConfiguration.keySet());
            }
            Set<String> requiredProperties = this.getRequiredProperties(this.getCmsObject(), res);
            for (String propertyName : propertiesToShow) {
                CmsXmlContentProperty propDef = null;
                if (useConfiguration) {
                    propDef = propertyConfiguration.get(propertyName);
                }
                if (propDef == null) {
                    propDef = new CmsXmlContentProperty(propertyName, "string", "string", "", "", "", "", null, "", "", "false");
                }
                if (requiredProperties.contains(propertyName)) {
                    String validationErrorMessage = Messages.get().getBundle(OpenCms.getWorkplaceManager().getWorkplaceLocale(this.getCmsObject())).key("GUI_POSTUPLOAD_REQUIRED_PROPERTY_1", propertyName);
                    propDef = propDef.withValidation(".*?[^ ].*", "error", validationErrorMessage);
                }
                propertyDefinitions.put(propertyName, propDef);
                CmsProperty property = CmsProperty.get(propertyName, properties);
                if (property == null) continue;
                CmsClientProperty clientProperty = new CmsClientProperty(propertyName, property.getStructureValue(), property.getResourceValue());
                clientProperties.put(clientProperty.getName(), clientProperty);
            }
            propertyDefinitions = CmsXmlContentPropertyHelper.resolveMacrosInProperties(propertyDefinitions, CmsMacroResolver.newWorkplaceLocaleResolver(this.getCmsObject()));
            CmsPropertyEditorHelper.updateWysiwygConfig(propertyDefinitions, this.getCmsObject(), res);
            result.setPropertyDefinitions(propertyDefinitions);
            result.setProperties(clientProperties);
            return result;
        }
        catch (CmsException e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsPostUploadDialogBean prefetch() throws CmsRpcException {
        try {
            String resourceParam;
            ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getRequest().getParameter("resources"))) {
                String resourcesParam = this.getRequest().getParameter("resources");
                List<String> resourceUUIDs = CmsStringUtil.splitAsList(resourcesParam, ",");
                for (String uuidAsString : resourceUUIDs) {
                    CmsUUID uuid = new CmsUUID(uuidAsString);
                    CmsResource res = this.getCmsObject().readResource(uuid);
                    resources.add(res);
                }
            } else if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getRequest().getParameter("resource")) && CmsStringUtil.isNotEmptyOrWhitespaceOnly(resourceParam = this.getRequest().getParameter("resource"))) {
                CmsResource res = this.getCmsObject().readResource(resourceParam);
                resources.add(res);
            }
            return this.createUploadDialogBean(resources);
        }
        catch (CmsException e) {
            this.error(e);
            return null;
        }
    }

    private CmsPostUploadDialogBean createUploadDialogBean(List<CmsResource> resources) {
        LinkedHashMap<CmsUUID, String> result = new LinkedHashMap<CmsUUID, String>();
        CmsObject cms = this.getCmsObject();
        Map<Boolean, List<CmsResource>> parts = resources.stream().collect(Collectors.partitioningBy(res -> this.getRequiredProperties(cms, (CmsResource)res).size() > 0));
        for (CmsResource res2 : Iterables.concat((Iterable)parts.get(Boolean.TRUE), (Iterable)parts.get(Boolean.FALSE))) {
            result.put(res2.getStructureId(), cms.getRequestContext().removeSiteRoot(res2.getRootPath()));
        }
        Set<CmsUUID> reqValIds = parts.get(Boolean.TRUE).stream().map(res -> res.getStructureId()).collect(Collectors.toSet());
        return new CmsPostUploadDialogBean(result, reqValIds);
    }

    private Set<String> getRequiredProperties(CmsObject cms, CmsResource res) {
        HashSet<String> requiredProps = new HashSet<String>();
        try {
            String typeName = OpenCms.getResourceManager().getResourceType(res).getTypeName();
            CmsExplorerTypeSettings explorerType = OpenCms.getWorkplaceManager().getExplorerTypeSetting(typeName);
            if (explorerType != null) {
                for (String prop : explorerType.getProperties()) {
                    if (!explorerType.isPropertyRequiredOnUpload(prop)) continue;
                    requiredProps.add(prop);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return requiredProps;
        }
        return requiredProps;
    }
}

