/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration;

import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.Rule;
import org.dom4j.Element;
import org.opencms.configuration.I_CmsConfigurationParameterHandler;
import org.xml.sax.Attributes;

public class CmsElementWithSubElementsParamConfigHelper {
    private String m_basePath;
    private Class<?> m_class;
    private String m_name;
    private String[] m_subElements;

    public CmsElementWithSubElementsParamConfigHelper(String parentPath, String name, Class<?> cls, String ... subElements) {
        this.m_basePath = parentPath + "/" + name;
        this.m_name = name;
        this.m_class = cls;
        this.m_subElements = subElements;
    }

    public void addRules(Digester digester) {
        digester.addRule(this.m_basePath, new Rule(){

            public void begin(String namespace, String name, Attributes attributes) throws Exception {
                I_CmsConfigurationParameterHandler config = (I_CmsConfigurationParameterHandler)CmsElementWithSubElementsParamConfigHelper.this.m_class.newInstance();
                config.initConfiguration();
                this.getDigester().push((Object)config);
            }

            public void end(String namespace, String name) throws Exception {
                this.getDigester().pop();
            }
        });
        for (String elem : this.m_subElements) {
            digester.addRule(this.m_basePath + "/" + elem, new Rule(){

                public void body(String namespace, String name, String text) throws Exception {
                    I_CmsConfigurationParameterHandler handler = (I_CmsConfigurationParameterHandler)this.getDigester().peek();
                    handler.addConfigurationParameter(name, text);
                }
            });
        }
    }

    public void generateXml(Element parent, I_CmsConfigurationParameterHandler config) {
        if (config != null) {
            Element elem = parent.addElement(this.m_name);
            for (String subElemName : this.m_subElements) {
                for (String value : config.getConfiguration().getList(subElemName)) {
                    elem.addElement(subElemName).addText(value);
                }
            }
        }
    }

    public String getBasePath() {
        return this.m_basePath;
    }
}

