/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration.test;

import java.util.function.Consumer;
import javax.xml.bind.JAXBContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.digester3.NodeCreateRule;
import org.apache.commons.digester3.Rule;
import org.dom4j.Element;
import org.dom4j.io.DOMReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CmsJaxbConfigHelper<T> {
    private static DocumentBuilderFactory DBF = DocumentBuilderFactory.newInstance();
    private JAXBContext m_jaxb;
    private DocumentBuilder m_docBuilder;

    public CmsJaxbConfigHelper(Class<T> cls) {
        try {
            this.m_jaxb = JAXBContext.newInstance((Class[])new Class[]{cls});
            this.m_docBuilder = DBF.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void appendToXml(Element parent, T bean) {
        if (bean != null) {
            try {
                Document doc = this.m_docBuilder.newDocument();
                this.m_jaxb.createMarshaller().marshal(bean, (Node)doc);
                DOMReader rd = new DOMReader();
                Element result = rd.read(doc).getRootElement();
                result.detach();
                parent.add(result);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Rule getDigesterRule(final Consumer<T> beanCallback) {
        try {
            return new NodeCreateRule(){

                public void end(String namespace, String name) throws Exception {
                    Node root = (Node)this.getDigester().pop();
                    Object bean = CmsJaxbConfigHelper.this.m_jaxb.createUnmarshaller().unmarshal(root);
                    beanCallback.accept(bean);
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

