/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.crypto;

import com.google.common.io.BaseEncoding;
import java.nio.charset.StandardCharsets;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.crypto.CmsEncryptionException;
import org.opencms.crypto.I_CmsTextEncryption;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsLog;

public class CmsAESTextEncryption
implements I_CmsTextEncryption {
    public static final String AES = "AES";
    public static final BaseEncoding BASE64 = BaseEncoding.base64Url().withPadChar('.');
    public static final String PARAM_SECRET = "secret";
    private static final Log LOG = CmsLog.getLog(CmsAESTextEncryption.class);
    private CmsParameterConfiguration m_config = new CmsParameterConfiguration();
    private SecretKey m_key;
    private String m_name;

    public static SecretKey generateAESKey(String secret) {
        HKDFParameters params = HKDFParameters.defaultParameters((byte[])secret.getBytes(StandardCharsets.UTF_8));
        HKDFBytesGenerator keyGenerator = new HKDFBytesGenerator((Digest)new SHA256Digest());
        keyGenerator.init((DerivationParameters)params);
        byte[] keyBytes = new byte[16];
        keyGenerator.generateBytes(keyBytes, 0, 16);
        SecretKeySpec keySpec = new SecretKeySpec(keyBytes, AES);
        return keySpec;
    }

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
        this.m_config.add(paramName, paramValue);
    }

    @Override
    public String decrypt(String input) throws CmsEncryptionException {
        byte[] encryptedBytes = BASE64.decode((CharSequence)input);
        try {
            Cipher cipher = Cipher.getInstance(AES);
            cipher.init(2, this.m_key);
            byte[] decData = cipher.doFinal(encryptedBytes);
            String result = new String(decData, StandardCharsets.UTF_8);
            return result;
        }
        catch (Exception e) {
            throw new CmsEncryptionException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public String encrypt(String input) throws CmsEncryptionException {
        try {
            Cipher cipher = Cipher.getInstance(AES);
            cipher.init(1, this.m_key);
            byte[] encData = cipher.doFinal(input.getBytes(StandardCharsets.UTF_8));
            String lit = BASE64.encode(encData);
            return lit;
        }
        catch (Exception e) {
            throw new CmsEncryptionException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        return this.m_config;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public void initConfiguration() {
    }

    @Override
    public void initialize(CmsObject cms) {
        String secret = this.m_config.get(PARAM_SECRET);
        if (secret == null) {
            throw new IllegalArgumentException("Parameter 'secret' must be set for CmsAESTextEncryption!");
        }
        this.m_key = CmsAESTextEncryption.generateAESKey(secret);
    }

    @Override
    public void setName(String name) {
        if (this.m_name != null) {
            throw new IllegalStateException("Can't call setName twice!");
        }
        this.m_name = name;
    }
}

