/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsDbSqlException;
import org.opencms.db.Messages;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsException;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsSecurityException;
import org.opencms.util.CmsFileUtil;

public class CmsImportFolder {
    private static final Log LOG = CmsLog.getLog(CmsImportFolder.class);
    private CmsObject m_cms;
    private List<CmsResource> m_importedResources = new ArrayList<CmsResource>();
    private String m_importFolderName;
    private String m_importPath;
    private File m_importResource;
    private boolean m_validZipFile;
    private ZipInputStream m_zipStreamIn;

    public CmsImportFolder() {
    }

    public CmsImportFolder(byte[] content, String importPath, CmsObject cms, boolean noSubFolder) throws CmsException {
        this.importZip(content, importPath, cms, noSubFolder);
    }

    public CmsImportFolder(String importFolderName, String importPath, CmsObject cms) throws CmsException {
        this.importFolder(importFolderName, importPath, cms);
    }

    public List<CmsResource> getImportedResources() {
        return this.m_importedResources;
    }

    public void importFolder(String importFolderName, String importPath, CmsObject cms) throws CmsException {
        try {
            this.m_importedResources = new ArrayList<CmsResource>();
            this.m_importFolderName = importFolderName;
            this.m_importPath = importPath;
            this.m_cms = cms;
            this.getImportResource();
            this.m_cms.lockResource(this.m_importPath);
            if (this.m_zipStreamIn == null) {
                this.importResources(this.m_importResource, this.m_importPath);
            } else {
                this.importZipResource(this.m_zipStreamIn, this.m_importPath, false);
            }
            this.m_cms.unlockResource(this.m_importPath);
        }
        catch (Exception e) {
            throw new CmsVfsException(Messages.get().container("ERR_IMPORT_FOLDER_2", importFolderName, importPath), (Throwable)e);
        }
        finally {
            if (this.m_zipStreamIn != null) {
                try {
                    this.m_zipStreamIn.close();
                }
                catch (Exception e) {
                    LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    public void importZip(byte[] content, String importPath, CmsObject cms, boolean noSubFolder) throws CmsException {
        this.m_importPath = importPath;
        this.m_cms = cms;
        try {
            this.m_zipStreamIn = new ZipInputStream(new ByteArrayInputStream(content));
            this.m_cms.readFolder(importPath, CmsResourceFilter.IGNORE_EXPIRATION);
            this.importZipResource(this.m_zipStreamIn, this.m_importPath, noSubFolder);
        }
        catch (Exception e) {
            throw new CmsVfsException(Messages.get().container("ERR_IMPORT_FOLDER_1", importPath), (Throwable)e);
        }
        finally {
            if (this.m_zipStreamIn != null) {
                try {
                    this.m_zipStreamIn.close();
                }
                catch (Exception e) {
                    LOG.info((Object)e.getLocalizedMessage());
                }
            }
        }
    }

    public boolean isValidZipFile() {
        return this.m_validZipFile;
    }

    private void getImportResource() throws CmsVfsException {
        this.m_importResource = new File(this.m_importFolderName);
        if (this.m_importResource.isFile()) {
            try {
                this.m_zipStreamIn = new ZipInputStream(new FileInputStream(this.m_importResource));
            }
            catch (IOException e) {
                throw new CmsVfsException(Messages.get().container("ERR_NO_ZIPFILE_1", this.m_importResource.getName()), (Throwable)e);
            }
        }
    }

    private void importResources(File folder, String importPath) throws Exception {
        String[] diskFiles = folder.list();
        for (int i = 0; i < diskFiles.length; ++i) {
            File currentFile = new File(folder, diskFiles[i]);
            if (currentFile.isDirectory()) {
                this.m_importedResources.add(this.m_cms.createResource(importPath + currentFile.getName(), 0));
                this.importResources(currentFile, importPath + currentFile.getName() + "/");
                continue;
            }
            int type = OpenCms.getResourceManager().getDefaultTypeForName(currentFile.getName()).getTypeId();
            byte[] content = CmsFileUtil.readFile(currentFile);
            try {
                this.m_importedResources.add(this.m_cms.createResource(importPath + currentFile.getName(), type, content, null));
            }
            catch (CmsSecurityException e) {
                int plainId = OpenCms.getResourceManager().getResourceType(CmsResourceTypePlain.getStaticTypeName()).getTypeId();
                this.m_importedResources.add(this.m_cms.createResource(importPath + currentFile.getName(), plainId, content, null));
            }
            content = null;
        }
    }

    private void importZipResource(ZipInputStream zipStreamIn, String importPath, boolean noSubFolder) throws Exception {
        boolean isFolder = false;
        int entries = 0;
        byte[] buffer = null;
        while (true) {
            int j = 0;
            int stop = 0;
            ZipEntry entry = zipStreamIn.getNextEntry();
            if (entry == null) break;
            ++entries;
            String actImportPath = importPath;
            String title = CmsResource.getName(entry.getName());
            String filename = this.m_cms.getRequestContext().getFileTranslator().translateResource(entry.getName());
            StringTokenizer st = new StringTokenizer(filename, "/\\");
            int count = st.countTokens();
            String[] path = new String[count];
            isFolder = filename.endsWith("\\") || filename.endsWith("/");
            while (st.hasMoreTokens()) {
                path[j] = st.nextToken();
                ++j;
            }
            int n = stop = isFolder ? path.length : path.length - 1;
            if (noSubFolder) {
                stop = 0;
            }
            for (int r = 0; r < stop; ++r) {
                try {
                    CmsResource createdFolder = this.m_cms.createResource(actImportPath + path[r], 0);
                    this.m_importedResources.add(createdFolder);
                }
                catch (CmsException createdFolder) {
                    // empty catch block
                }
                actImportPath = actImportPath + path[r];
                actImportPath = actImportPath + "/";
            }
            if (!isFolder) {
                boolean resourceExists;
                int type = OpenCms.getResourceManager().getDefaultTypeForName(path[path.length - 1]).getTypeId();
                int size = new Long(entry.getSize()).intValue();
                buffer = size == -1 ? CmsFileUtil.readFully((InputStream)zipStreamIn, false) : CmsFileUtil.readFully(zipStreamIn, size, false);
                filename = actImportPath + path[path.length - 1];
                try {
                    this.m_cms.lockResource(filename);
                    this.m_cms.readResource(filename);
                    resourceExists = true;
                }
                catch (CmsException e) {
                    resourceExists = false;
                }
                int plainId = OpenCms.getResourceManager().getResourceType(CmsResourceTypePlain.getStaticTypeName()).getTypeId();
                if (resourceExists) {
                    CmsResource res = this.m_cms.readResource(filename, CmsResourceFilter.ALL);
                    CmsFile file = this.m_cms.readFile(res);
                    byte[] contents = file.getContents();
                    try {
                        this.m_cms.replaceResource(filename, res.getTypeId(), buffer, new ArrayList<CmsProperty>(0));
                        this.m_importedResources.add(res);
                    }
                    catch (CmsSecurityException e) {
                        this.m_cms.replaceResource(filename, plainId, buffer, new ArrayList<CmsProperty>(0));
                        this.m_importedResources.add(res);
                    }
                    catch (CmsDbSqlException sqlExc) {
                        file.setContents(contents);
                        this.m_cms.writeFile(file);
                        throw sqlExc;
                    }
                } else {
                    String newResName = actImportPath + path[path.length - 1];
                    if (title.lastIndexOf(46) != -1) {
                        title = title.substring(0, title.lastIndexOf(46));
                    }
                    ArrayList<CmsProperty> properties = new ArrayList<CmsProperty>(1);
                    CmsProperty titleProp = new CmsProperty();
                    titleProp.setName("Title");
                    if (OpenCms.getWorkplaceManager().isDefaultPropertiesOnStructure()) {
                        titleProp.setStructureValue(title);
                    } else {
                        titleProp.setResourceValue(title);
                    }
                    properties.add(titleProp);
                    try {
                        this.m_importedResources.add(this.m_cms.createResource(newResName, type, buffer, properties));
                    }
                    catch (CmsSecurityException e) {
                        this.m_importedResources.add(this.m_cms.createResource(newResName, plainId, buffer, properties));
                    }
                    catch (CmsDbSqlException sqlExc) {
                        this.m_cms.lockResource(newResName);
                        this.m_cms.deleteResource(newResName, CmsResource.DELETE_PRESERVE_SIBLINGS);
                        throw sqlExc;
                    }
                }
            }
            zipStreamIn.closeEntry();
        }
        zipStreamIn.close();
        if (entries > 0) {
            this.m_validZipFile = true;
        }
    }
}

