/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opencms.db.CmsCompositeQueryFragment;
import org.opencms.db.CmsSimpleQueryFragment;
import org.opencms.db.CmsStatementBuilder;
import org.opencms.db.I_CmsQueryFragment;

public class CmsSelectQuery
implements I_CmsQueryFragment {
    private CmsCompositeQueryFragment m_columns = new CmsCompositeQueryFragment();
    private CmsCompositeQueryFragment m_conditions = new CmsCompositeQueryFragment();
    private I_CmsQueryFragment m_ordering;
    private CmsCompositeQueryFragment m_otherClauses = new CmsCompositeQueryFragment();
    private List<String> m_tables = Lists.newArrayList();
    private Set<String> m_usedAliases = new HashSet<String>();

    public CmsSelectQuery() {
        this.m_conditions.add(new CmsSimpleQueryFragment("1 = 1", Collections.emptyList()));
        this.m_conditions.setSeparator(" AND ");
        this.m_otherClauses.setSeparator("\n");
        this.m_columns.setSeparator(", ");
    }

    public void addClause(I_CmsQueryFragment clause) {
        this.m_otherClauses.add(clause);
    }

    public void addColumn(I_CmsQueryFragment node) {
        this.m_columns.add(node);
    }

    public void addColumn(String column) {
        this.m_columns.add(new CmsSimpleQueryFragment(column, Collections.emptyList()));
    }

    public void addCondition(I_CmsQueryFragment node) {
        this.m_conditions.add(node);
    }

    public void addCondition(String fragment, Object ... params) {
        this.m_conditions.add(new CmsSimpleQueryFragment(fragment, params));
    }

    public void addTable(String table) {
        this.m_tables.add(table);
    }

    public TableAlias addTable(String table, String aliasPrefix) {
        String alias = this.makeAlias(aliasPrefix);
        this.m_tables.add(table + " " + alias);
        return new TableAlias(alias);
    }

    public I_CmsQueryFragment getOrdering() {
        return this.m_ordering;
    }

    public void setOrdering(String ordering) {
        this.m_ordering = ordering != null ? new CmsSimpleQueryFragment(ordering, Collections.emptyList()) : null;
    }

    @Override
    public void visit(CmsStatementBuilder builder) {
        builder.add("SELECT ", new Object[0]);
        Joiner commaJoin = Joiner.on((String)", ");
        this.m_columns.visit(builder);
        builder.add("\nFROM ", new Object[0]);
        builder.add(commaJoin.join(this.m_tables), new Object[0]);
        builder.add("\nWHERE ", new Object[0]);
        this.m_conditions.visit(builder);
        if (this.m_ordering != null) {
            builder.add("\nORDER BY ", new Object[0]);
            this.m_ordering.visit(builder);
        }
        this.m_otherClauses.visit(builder);
    }

    private String makeAlias(String prefix) {
        String result;
        int i = 0;
        while (this.m_usedAliases.contains(result = i == 0 ? prefix : prefix + i)) {
        }
        this.m_usedAliases.add(result);
        return result;
    }

    public class TableAlias {
        String m_name;

        public TableAlias(String name) {
            this.m_name = name;
        }

        public String column(String colName) {
            return this.m_name + "." + colName;
        }

        public String getName() {
            return this.m_name;
        }
    }
}

