/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import java.util.Date;
import org.opencms.db.CmsDbContext;
import org.opencms.util.CmsUUID;

public class CmsVisitEntry {
    private final long m_date;
    private final CmsUUID m_structureId;
    private final CmsUUID m_userId;

    public CmsVisitEntry(CmsDbContext dbc, CmsUUID structureId) {
        this.m_userId = dbc.currentUser().getId();
        this.m_date = System.currentTimeMillis();
        this.m_structureId = structureId;
    }

    public CmsVisitEntry(CmsUUID userId, long date, CmsUUID structureId) {
        this.m_userId = userId;
        this.m_date = date;
        this.m_structureId = structureId;
    }

    public long getDate() {
        return this.m_date;
    }

    public CmsUUID getStructureId() {
        return this.m_structureId;
    }

    public CmsUUID getUserId() {
        return this.m_userId;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[").append(this.getClass().getName()).append(":");
        sb.append("user=").append(this.m_userId).append(",");
        sb.append("date=").append(new Date(this.m_date)).append(",");
        sb.append("structure=").append(this.m_structureId);
        return sb.append("]").toString();
    }
}

