/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.generic;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsConfigurationManager;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.db.CmsDbConsistencyException;
import org.opencms.db.CmsDbContext;
import org.opencms.db.CmsDbSqlException;
import org.opencms.db.CmsDriverManager;
import org.opencms.db.CmsPreparedStatementLongParameter;
import org.opencms.db.CmsPreparedStatementStringParameter;
import org.opencms.db.CmsSubscriptionFilter;
import org.opencms.db.CmsSubscriptionReadMode;
import org.opencms.db.CmsVisitEntry;
import org.opencms.db.CmsVisitEntryFilter;
import org.opencms.db.CmsVisitedByFilter;
import org.opencms.db.I_CmsDriver;
import org.opencms.db.I_CmsPreparedStatementParameter;
import org.opencms.db.I_CmsSubscriptionDriver;
import org.opencms.db.generic.CmsSqlManager;
import org.opencms.db.generic.CmsVfsDriver;
import org.opencms.db.generic.Messages;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.file.history.I_CmsHistoryResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPrincipal;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsPair;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsSubscriptionDriver
implements I_CmsDriver,
I_CmsSubscriptionDriver {
    private static final Log LOG = CmsLog.getLog(CmsSubscriptionDriver.class);
    protected CmsDriverManager m_driverManager;
    protected CmsSqlManager m_sqlManager;

    @Override
    public void deleteVisits(CmsDbContext dbc, String poolName, CmsVisitEntryFilter filter) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = CmsStringUtil.isNotEmpty(poolName) ? this.m_sqlManager.getConnection(poolName) : this.m_sqlManager.getConnection(dbc);
            StringBuffer queryBuf = new StringBuffer(256);
            queryBuf.append(this.m_sqlManager.readQuery("C_VISIT_DELETE_ENTRIES"));
            CmsPair<String, List<I_CmsPreparedStatementParameter>> conditionsAndParams = this.prepareVisitConditions(filter);
            queryBuf.append(conditionsAndParams.getFirst());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)queryBuf.toString());
            }
            stmt = this.m_sqlManager.getPreparedStatementForSql(conn, queryBuf.toString());
            List<I_CmsPreparedStatementParameter> params = conditionsAndParams.getSecond();
            for (int i = 0; i < params.size(); ++i) {
                I_CmsPreparedStatementParameter param = conditionsAndParams.getSecond().get(i);
                param.insertIntoStatement(stmt, i + 1);
            }
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    @Override
    public long getDateLastVisitedBy(CmsDbContext dbc, String poolName, CmsUser user, CmsResource resource) throws CmsException {
        CmsVisitEntryFilter filter = CmsVisitEntryFilter.ALL.filterResource(resource.getStructureId()).filterUser(user.getId());
        List<CmsVisitEntry> entries = this.readVisits(dbc, poolName, filter);
        if (!entries.isEmpty()) {
            return entries.get(0).getDate();
        }
        return 0L;
    }

    @Override
    public CmsSqlManager getSqlManager() {
        return this.m_sqlManager;
    }

    @Override
    public void init(CmsDbContext dbc, CmsConfigurationManager configurationManager, List<String> successiveDrivers, CmsDriverManager driverManager) {
        CmsParameterConfiguration config = configurationManager.getConfiguration();
        String poolUrl = config.get("db.subscription.pool");
        String classname = config.get("db.subscription.sqlmanager");
        this.m_sqlManager = this.initSqlManager(classname);
        this.m_sqlManager.init(4, poolUrl);
        this.m_driverManager = driverManager;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ASSIGNED_POOL_1", poolUrl));
        }
        if (successiveDrivers != null && !successiveDrivers.isEmpty() && LOG.isWarnEnabled()) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_SUCCESSIVE_DRIVERS_UNSUPPORTED_1", this.getClass().getName()));
        }
    }

    @Override
    public CmsSqlManager initSqlManager(String classname) {
        return CmsSqlManager.getInstance(classname);
    }

    @Override
    public void markResourceAsVisitedBy(CmsDbContext dbc, String poolName, CmsResource resource, CmsUser user) throws CmsDataAccessException {
        boolean entryExists = false;
        CmsVisitEntryFilter filter = CmsVisitEntryFilter.ALL.filterResource(resource.getStructureId()).filterUser(user.getId());
        if (this.readVisits(dbc, OpenCms.getSubscriptionManager().getPoolName(), filter).size() > 0) {
            entryExists = true;
            this.deleteVisits(dbc, OpenCms.getSubscriptionManager().getPoolName(), filter);
        }
        CmsVisitEntry entry = new CmsVisitEntry(user.getId(), System.currentTimeMillis(), resource.getStructureId());
        this.addVisit(dbc, poolName, entry);
        if (!entryExists) {
            PreparedStatement stmt = null;
            Connection conn = null;
            ResultSet res = null;
            int count = 0;
            ArrayList<Long> dates = new ArrayList<Long>();
            try {
                conn = this.m_sqlManager.getConnection(poolName);
                stmt = this.m_sqlManager.getPreparedStatement(conn, dbc.currentProject(), "C_VISITED_USER_COUNT_1");
                stmt.setString(1, user.getId().toString());
                res = stmt.executeQuery();
                if (res.next()) {
                    count = res.getInt(1);
                    while (res.next()) {
                    }
                } else {
                    throw new CmsDbConsistencyException(Messages.get().container("ERR_COUNTING_VISITED_RESOURCES_1", user.getName()));
                }
                int maxCount = OpenCms.getSubscriptionManager().getMaxVisitedCount();
                if (count > maxCount) {
                    this.m_sqlManager.closeAll(dbc, null, stmt, res);
                    stmt = this.m_sqlManager.getPreparedStatement(conn, dbc.currentProject(), "C_VISITED_USER_DELETE_GETDATE_2");
                    stmt.setString(1, user.getId().toString());
                    stmt.setInt(2, count - maxCount);
                    res = stmt.executeQuery();
                    while (res.next()) {
                        dates.add(res.getLong(1));
                    }
                }
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
            }
            catch (SQLException e) {
                try {
                    throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
                }
                catch (Throwable throwable) {
                    this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                    throw throwable;
                }
            }
            long deleteDate = 0L;
            for (Long date : dates) {
                deleteDate = date;
                if (deleteDate <= 0L) continue;
                filter = CmsVisitEntryFilter.ALL.filterUser(user.getId()).filterTo(deleteDate);
                this.deleteVisits(dbc, OpenCms.getSubscriptionManager().getPoolName(), filter);
            }
        }
    }

    @Override
    public List<CmsResource> readAllSubscribedResources(CmsDbContext dbc, String poolName, CmsPrincipal principal) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        Connection conn = null;
        ResultSet res = null;
        CmsFile currentResource = null;
        ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
        try {
            conn = this.m_sqlManager.getConnection(poolName);
            stmt = this.m_sqlManager.getPreparedStatement(conn, dbc.currentProject(), "C_SUBSCRIPTION_READ_ALL_1");
            stmt.setString(1, principal.getId().toString());
            res = stmt.executeQuery();
            while (res.next()) {
                currentResource = this.m_driverManager.getVfsDriver(dbc).createFile(res, dbc.currentProject().getUuid(), false);
                resources.add(currentResource);
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return resources;
    }

    @Override
    public List<CmsResource> readResourcesVisitedBy(CmsDbContext dbc, String poolName, CmsVisitedByFilter filter) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        Connection conn = null;
        ResultSet res = null;
        CmsFile currentResource = null;
        StringBuffer conditions = new StringBuffer(256);
        ArrayList<String> params = new ArrayList<String>(1);
        ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
        try {
            if (CmsStringUtil.isNotEmpty(filter.getParentPath())) {
                CmsResource parent = this.m_driverManager.getVfsDriver(dbc).readResource(dbc, dbc.currentProject().getUuid(), filter.getParentPath(), false);
                conditions.append(" AND (");
                if (filter.isIncludeSubFolders()) {
                    conditions.append(this.m_sqlManager.readQuery(dbc.currentProject(), "C_RESOURCES_SELECT_BY_PATH_PREFIX"));
                    params.add(CmsFileUtil.addTrailingSeparator(CmsVfsDriver.escapeDbWildcard(filter.getParentPath())) + "%");
                } else {
                    conditions.append(this.m_sqlManager.readQuery(dbc.currentProject(), "C_RESOURCES_SELECT_BY_PARENT_UUID"));
                    params.add(parent.getStructureId().toString());
                }
                conditions.append(") ");
            }
            conn = this.m_sqlManager.getConnection(poolName);
            String query = this.m_sqlManager.readQuery(dbc.currentProject(), "C_VISITED_USER_READ_4");
            query = CmsStringUtil.substitute(query, "%(CONDITIONS)", conditions.toString());
            stmt = this.m_sqlManager.getPreparedStatementForSql(conn, query);
            stmt.setString(1, filter.getUser().getId().toString());
            stmt.setLong(2, filter.getFromDate());
            stmt.setLong(3, filter.getToDate());
            for (int i = 0; i < params.size(); ++i) {
                stmt.setString(i + 4, (String)params.get(i));
            }
            res = stmt.executeQuery();
            while (res.next()) {
                currentResource = this.m_driverManager.getVfsDriver(dbc).createFile(res, dbc.currentProject().getUuid(), false);
                resources.add(currentResource);
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return resources;
    }

    @Override
    public List<I_CmsHistoryResource> readSubscribedDeletedResources(CmsDbContext dbc, String poolName, CmsUser user, List<CmsGroup> groups, CmsResource parent, boolean includeSubFolders, long deletedFrom) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        Connection conn = null;
        ResultSet res = null;
        ArrayList<I_CmsHistoryResource> resources = new ArrayList<I_CmsHistoryResource>();
        HashSet<CmsUUID> historyIDs = new HashSet<CmsUUID>();
        ArrayList<String> principalIds = new ArrayList<String>();
        principalIds.add(user.getId().toString());
        if (groups != null && !groups.isEmpty()) {
            Iterator<CmsGroup> it = groups.iterator();
            while (it.hasNext()) {
                principalIds.add(it.next().getId().toString());
            }
        }
        StringBuffer conditions = new StringBuffer(256);
        ArrayList<String> params = new ArrayList<String>();
        conditions.append(this.m_sqlManager.readQuery("C_SUBSCRIPTION_DELETED"));
        if (principalIds.size() == 1) {
            conditions.append(" AND (");
            conditions.append(this.m_sqlManager.readQuery("C_SUBSCRIPTION_DELETED_FILTER_PRINCIPAL_SINGLE"));
            params.add((String)principalIds.get(0));
            conditions.append(") ");
        } else {
            conditions.append(" AND (");
            conditions.append(this.m_sqlManager.readQuery("C_SUBSCRIPTION_DELETED_FILTER_PRINCIPALS"));
            conditions.append(" (");
            Iterator it = principalIds.iterator();
            while (it.hasNext()) {
                params.add((String)it.next());
                conditions.append("?");
                if (!it.hasNext()) continue;
                conditions.append(", ");
            }
            conditions.append(") ");
            conditions.append(") ");
        }
        try {
            conn = this.m_sqlManager.getConnection(poolName);
            stmt = this.m_sqlManager.getPreparedStatementForSql(conn, conditions.toString());
            stmt.setLong(1, deletedFrom);
            for (int i = 0; i < params.size(); ++i) {
                stmt.setString(i + 2, (String)params.get(i));
            }
            res = stmt.executeQuery();
            while (res.next()) {
                historyIDs.add(new CmsUUID(res.getString(1)));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        String parentFolderPath = "";
        if (parent != null) {
            parentFolderPath = CmsResource.getFolderPath(parent.getRootPath());
        }
        for (CmsUUID id : historyIDs) {
            int version = this.m_driverManager.getHistoryDriver(dbc).readLastVersion(dbc, id);
            if (version <= 0) continue;
            I_CmsHistoryResource histRes = this.m_driverManager.getHistoryDriver(dbc).readResource(dbc, id, version);
            if (parent != null && (!includeSubFolders && !parentFolderPath.equals(CmsResource.getFolderPath(histRes.getRootPath())) || includeSubFolders && !histRes.getRootPath().startsWith(parentFolderPath))) continue;
            resources.add(histRes);
        }
        return resources;
    }

    @Override
    public List<CmsResource> readSubscribedResources(CmsDbContext dbc, String poolName, CmsSubscriptionFilter filter) throws CmsDataAccessException {
        Iterator<CmsGroup> it;
        boolean groupsDefined;
        PreparedStatement stmt = null;
        Connection conn = null;
        ResultSet res = null;
        CmsFile currentResource = null;
        ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
        String queryBuf = this.m_sqlManager.readQuery(dbc.currentProject(), "C_SUBSCRIPTION_FILTER_READ");
        StringBuffer conditions = new StringBuffer(256);
        ArrayList<I_CmsPreparedStatementParameter> params = new ArrayList<I_CmsPreparedStatementParameter>();
        boolean userDefined = filter.getUser() != null;
        boolean bl = groupsDefined = !filter.getGroups().isEmpty();
        if (!groupsDefined && !userDefined) {
            filter.setUser(dbc.currentUser());
            userDefined = true;
        }
        if (!filter.getMode().isAll() && filter.getUser() == null) {
            filter.setMode(CmsSubscriptionReadMode.ALL);
        }
        ArrayList<String> principalIds = new ArrayList<String>();
        if (userDefined) {
            principalIds.add(filter.getUser().getId().toString());
        }
        if (groupsDefined) {
            it = filter.getGroups().iterator();
            while (it.hasNext()) {
                principalIds.add(it.next().getId().toString());
            }
        }
        if (principalIds.size() == 1) {
            conditions.append(" (");
            conditions.append(this.m_sqlManager.readQuery(dbc.currentProject(), "C_SUBSCRIPTION_FILTER_PRINCIPAL_SINGLE"));
            params.add(new CmsPreparedStatementStringParameter((String)principalIds.get(0)));
            conditions.append(") ");
        } else {
            conditions.append(" (");
            conditions.append(this.m_sqlManager.readQuery("C_SUBSCRIPTION_FILTER_PRINCIPALS"));
            conditions.append(" (");
            it = principalIds.iterator();
            while (it.hasNext()) {
                params.add(new CmsPreparedStatementStringParameter((String)((Object)it.next())));
                conditions.append("?");
                if (!it.hasNext()) continue;
                conditions.append(", ");
            }
            conditions.append(") ");
            conditions.append(this.m_sqlManager.readQuery(dbc.currentProject(), "C_SUBSCRIPTION_FILTER_PRINCIPALS_END"));
            conditions.append(") ");
        }
        if (CmsStringUtil.isNotEmpty(filter.getParentPath())) {
            CmsResource parent = this.m_driverManager.getVfsDriver(dbc).readResource(dbc, dbc.currentProject().getUuid(), filter.getParentPath(), false);
            conditions.append(" AND (");
            if (filter.isIncludeSubFolders()) {
                conditions.append(this.m_sqlManager.readQuery(dbc.currentProject(), "C_RESOURCES_SELECT_BY_PATH_PREFIX"));
                params.add(new CmsPreparedStatementStringParameter(CmsFileUtil.addTrailingSeparator(CmsVfsDriver.escapeDbWildcard(filter.getParentPath())) + "%"));
            } else {
                conditions.append(this.m_sqlManager.readQuery(dbc.currentProject(), "C_RESOURCES_SELECT_BY_PARENT_UUID"));
                params.add(new CmsPreparedStatementStringParameter(parent.getStructureId().toString()));
            }
            conditions.append(") ");
        }
        if (filter.getFromDate() > 0L || filter.getToDate() < Long.MAX_VALUE) {
            conditions.append(" AND (");
            conditions.append(this.m_sqlManager.readQuery(dbc.currentProject(), "C_SUBSCRIPTION_FILTER_RESOURCES_DATE_MODIFIED"));
            params.add(new CmsPreparedStatementLongParameter(filter.getFromDate()));
            params.add(new CmsPreparedStatementLongParameter(filter.getToDate()));
            conditions.append(") ");
        }
        try {
            conn = this.m_sqlManager.getConnection(poolName);
            queryBuf = CmsStringUtil.substitute(queryBuf, "%(CONDITIONS)", conditions.toString());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)queryBuf.toString());
            }
            stmt = this.m_sqlManager.getPreparedStatementForSql(conn, queryBuf);
            for (int i = 0; i < params.size(); ++i) {
                I_CmsPreparedStatementParameter param = (I_CmsPreparedStatementParameter)params.get(i);
                param.insertIntoStatement(stmt, i + 1);
            }
            res = stmt.executeQuery();
            while (res.next()) {
                currentResource = this.m_driverManager.getVfsDriver(dbc).createFile(res, dbc.currentProject().getUuid(), false);
                resources.add(currentResource);
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        if (!filter.getMode().isAll()) {
            ArrayList<CmsResource> result = new ArrayList<CmsResource>(resources.size());
            for (CmsResource resource : resources) {
                long visitedDate = 0L;
                try {
                    visitedDate = this.m_driverManager.getDateLastVisitedBy(dbc, poolName, filter.getUser(), resource);
                }
                catch (CmsException e) {
                    throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_0"), (Throwable)e);
                }
                if (filter.getMode().isUnVisited() && visitedDate >= resource.getDateLastModified() || filter.getMode().isVisited() && resource.getDateLastModified() > visitedDate) continue;
                result.add(resource);
            }
            resources = result;
        }
        return resources;
    }

    public List<CmsVisitEntry> readVisits(CmsDbContext dbc, String poolName, CmsVisitEntryFilter filter) throws CmsDataAccessException {
        ArrayList<CmsVisitEntry> entries = new ArrayList<CmsVisitEntry>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            conn = CmsStringUtil.isNotEmpty(poolName) ? this.m_sqlManager.getConnection(poolName) : this.m_sqlManager.getConnection(dbc);
            StringBuffer queryBuf = new StringBuffer(256);
            queryBuf.append(this.m_sqlManager.readQuery("C_VISIT_READ_ENTRIES"));
            CmsPair<String, List<I_CmsPreparedStatementParameter>> conditionsAndParameters = this.prepareVisitConditions(filter);
            List<I_CmsPreparedStatementParameter> params = conditionsAndParameters.getSecond();
            queryBuf.append(conditionsAndParameters.getFirst());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)queryBuf.toString());
            }
            stmt = this.m_sqlManager.getPreparedStatementForSql(conn, queryBuf.toString());
            for (int i = 0; i < params.size(); ++i) {
                I_CmsPreparedStatementParameter param = params.get(i);
                param.insertIntoStatement(stmt, i + 1);
            }
            res = stmt.executeQuery();
            while (res.next()) {
                entries.add(this.internalReadVisitEntry(res));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return entries;
    }

    @Override
    public void setSubscribedResourceAsDeleted(CmsDbContext dbc, String poolName, CmsResource resource) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        Connection conn = null;
        long deletedTime = System.currentTimeMillis();
        try {
            conn = this.getSqlManager().getConnection(poolName);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_SUBSCRIPTION_UPDATE_DATE_2");
            stmt.setLong(1, deletedTime);
            stmt.setString(2, resource.getStructureId().toString());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    @Override
    public void subscribeResourceFor(CmsDbContext dbc, String poolName, CmsPrincipal principal, CmsResource resource) throws CmsDataAccessException {
        ResultSet res = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = this.getSqlManager().getConnection(poolName);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_SUBSCRIPTION_CHECK_2");
            stmt.setString(1, principal.getId().toString());
            stmt.setString(2, resource.getStructureId().toString());
            res = stmt.executeQuery();
            if (res.next()) {
                while (res.next()) {
                }
            } else {
                this.m_sqlManager.closeAll(dbc, null, stmt, null);
                stmt = this.m_sqlManager.getPreparedStatement(conn, "C_SUBSCRIPTION_CREATE_2");
                stmt.setString(1, principal.getId().toString());
                stmt.setString(2, resource.getStructureId().toString());
                stmt.executeUpdate();
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
    }

    @Override
    public void unsubscribeAllDeletedResources(CmsDbContext dbc, String poolName, long deletedTo) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = this.getSqlManager().getConnection(poolName);
            StringBuffer conditions = new StringBuffer(256);
            conditions.append(this.m_sqlManager.readQuery("C_SUBSCRIPTION_DELETE"));
            conditions.append(" (");
            conditions.append(this.m_sqlManager.readQuery("C_SUBSCRIPTION_DELETE_FILTER_DATE"));
            conditions.append(") ");
            stmt = this.m_sqlManager.getPreparedStatementForSql(conn, conditions.toString());
            stmt.setLong(1, deletedTo);
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    @Override
    public void unsubscribeAllResourcesFor(CmsDbContext dbc, String poolName, CmsPrincipal principal) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            if (principal != null) {
                conn = this.getSqlManager().getConnection(poolName);
                StringBuffer conditions = new StringBuffer(256);
                conditions.append(this.m_sqlManager.readQuery("C_SUBSCRIPTION_DELETE"));
                conditions.append(" (");
                conditions.append(this.m_sqlManager.readQuery("C_SUBSCRIPTION_DELETE_FILTER_PRINCIPAL"));
                conditions.append(") ");
                stmt = this.m_sqlManager.getPreparedStatementForSql(conn, conditions.toString());
                stmt.setString(1, principal.getId().toString());
                stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
        }
        finally {
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
    }

    @Override
    public void unsubscribeResourceFor(CmsDbContext dbc, String poolName, CmsPrincipal principal, CmsResource resource) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = this.getSqlManager().getConnection(poolName);
            StringBuffer conditions = new StringBuffer(256);
            conditions.append(this.m_sqlManager.readQuery("C_SUBSCRIPTION_DELETE"));
            conditions.append(" (");
            conditions.append(this.m_sqlManager.readQuery("C_SUBSCRIPTION_DELETE_FILTER_PRINCIPAL"));
            conditions.append(") ");
            conditions.append(" AND (");
            conditions.append(this.m_sqlManager.readQuery("C_SUBSCRIPTION_DELETE_FILTER_STRUCTURE"));
            conditions.append(") ");
            stmt = this.m_sqlManager.getPreparedStatementForSql(conn, conditions.toString());
            stmt.setString(1, principal.getId().toString());
            stmt.setString(2, resource.getStructureId().toString());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    @Override
    public void unsubscribeResourceForAll(CmsDbContext dbc, String poolName, CmsResource resource) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = this.getSqlManager().getConnection(poolName);
            StringBuffer conditions = new StringBuffer(256);
            conditions.append(this.m_sqlManager.readQuery("C_SUBSCRIPTION_DELETE"));
            conditions.append(" (");
            conditions.append(this.m_sqlManager.readQuery("C_SUBSCRIPTION_DELETE_FILTER_STRUCTURE"));
            conditions.append(") ");
            stmt = this.m_sqlManager.getPreparedStatementForSql(conn, conditions.toString());
            stmt.setString(1, resource.getStructureId().toString());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addVisit(CmsDbContext dbc, String poolName, CmsVisitEntry visit) throws CmsDbSqlException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = CmsStringUtil.isNotEmpty(poolName) ? this.m_sqlManager.getConnection(poolName) : this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_VISIT_CREATE_3");
            stmt.setString(1, visit.getUserId().toString());
            stmt.setLong(2, visit.getDate());
            stmt.setString(3, visit.getStructureId() == null ? null : visit.getStructureId().toString());
            try {
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                LOG.debug((Object)Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)).key(), (Throwable)e);
            }
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                    throw throwable;
                }
                catch (Throwable t) {
                    LOG.debug((Object)t.getLocalizedMessage(), t);
                }
                throw throwable;
            }
        }
        try {
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
            return;
        }
        catch (Throwable t) {
            LOG.debug((Object)t.getLocalizedMessage(), t);
            return;
        }
    }

    protected CmsVisitEntry internalReadVisitEntry(ResultSet res) throws SQLException {
        CmsUUID userId = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_VISIT_USER_ID")));
        long date = res.getLong(this.m_sqlManager.readQuery("C_VISIT_DATE"));
        CmsUUID structureId = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_VISIT_STRUCTURE_ID")));
        return new CmsVisitEntry(userId, date, structureId);
    }

    protected CmsPair<String, List<I_CmsPreparedStatementParameter>> prepareVisitConditions(CmsVisitEntryFilter filter) {
        ArrayList<I_CmsPreparedStatementParameter> params = new ArrayList<I_CmsPreparedStatementParameter>();
        StringBuffer conditions = new StringBuffer();
        if (filter.getUserId() != null) {
            if (conditions.length() == 0) {
                conditions.append(" (");
            } else {
                conditions.append(" AND (");
            }
            conditions.append(this.m_sqlManager.readQuery("C_VISIT_FILTER_USER_ID"));
            params.add(new CmsPreparedStatementStringParameter(filter.getUserId().toString()));
            conditions.append(") ");
        }
        if (filter.getStructureId() != null) {
            if (conditions.length() == 0) {
                conditions.append(" (");
            } else {
                conditions.append(" AND (");
            }
            conditions.append(this.m_sqlManager.readQuery("C_VISIT_FILTER_STRUCTURE_ID"));
            params.add(new CmsPreparedStatementStringParameter(filter.getStructureId().toString()));
            conditions.append(") ");
        }
        if (filter.getDateFrom() != 0L) {
            if (conditions.length() == 0) {
                conditions.append(" (");
            } else {
                conditions.append(" AND (");
            }
            conditions.append(this.m_sqlManager.readQuery("C_VISIT_FILTER_DATE_FROM"));
            params.add(new CmsPreparedStatementLongParameter(filter.getDateFrom()));
            conditions.append(") ");
        }
        if (filter.getDateTo() != 0L) {
            if (conditions.length() == 0) {
                conditions.append(" (");
            } else {
                conditions.append(" AND (");
            }
            conditions.append(this.m_sqlManager.readQuery("C_VISIT_FILTER_DATE_TO"));
            params.add(new CmsPreparedStatementLongParameter(filter.getDateTo()));
            conditions.append(") ");
        }
        return CmsPair.create(conditions.toString(), params);
    }
}

