/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.timing;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.opencms.db.timing.I_CmsProfilingHandler;

public class CmsThreadStatsTreeProfilingHandler
implements I_CmsProfilingHandler {
    private Node m_root = new Node("ROOT");
    private boolean m_hasData;

    public String dump() {
        try {
            Document doc = Node.dumpTree(this.m_root);
            OutputFormat outformat = OutputFormat.createPrettyPrint();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            outformat.setEncoding("UTF-8");
            XMLWriter writer = new XMLWriter((OutputStream)buffer, outformat);
            writer.write(doc);
            writer.flush();
            return new String(buffer.toByteArray(), "UTF-8");
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean hasData() {
        return this.m_hasData;
    }

    @Override
    public synchronized void putTime(String key, long nanos) {
        this.m_hasData = true;
        StackTraceElement[] traceElems = new Throwable().getStackTrace();
        List<StackTraceElement> trace = Arrays.asList(traceElems);
        List<String> keys = new ArrayList<String>();
        keys.add("THREAD " + Thread.currentThread().getId());
        keys.addAll(Lists.reverse(trace));
        keys = keys.subList(0, keys.size() - 3);
        Node child = this.m_root.addOrGetDescendant(keys);
        child.addCall(nanos);
    }

    public static class Node {
        private Object m_key;
        private long m_nanos;
        private int m_count;
        private long m_cumulativeNanos;
        private int m_cumulativeCount;
        private Map<Object, Node> m_children = new HashMap<Object, Node>();

        public Node(Object key) {
            this.m_key = key;
        }

        public static Document dumpTree(Node node) {
            node.computeCumulativeData();
            Document doc = DocumentHelper.createDocument();
            Element root = doc.addElement("root");
            node.dump(root);
            return doc;
        }

        public void addCall(long nanos) {
            ++this.m_count;
            this.m_nanos += nanos;
        }

        public Node addOrGetChild(Object key) {
            Node child = this.m_children.get(key);
            if (child == null) {
                child = new Node(key);
                this.m_children.put(key, child);
            }
            return child;
        }

        public Node addOrGetDescendant(List<?> path) {
            Node current = this;
            for (Object key : path) {
                current = current.addOrGetChild(key);
            }
            return current;
        }

        public void computeCumulativeData() {
            this.m_cumulativeCount = this.m_count;
            this.m_cumulativeNanos = this.m_nanos;
            for (Node child : this.m_children.values()) {
                child.computeCumulativeData();
                this.m_cumulativeNanos += child.getCumulativeNanos();
                this.m_cumulativeCount += child.getCumulativeCount();
            }
        }

        public void dump(Element parent) {
            Element elem = parent.addElement("location").addAttribute("key", "" + this.m_key).addAttribute("count", "" + this.m_cumulativeCount).addAttribute("millis", "" + this.m_cumulativeNanos / 1000000L);
            ArrayList<Node> children = new ArrayList<Node>(this.m_children.values());
            children.sort(new Comparator<Node>(){

                @Override
                public int compare(Node o1, Node o2) {
                    return -Long.compare(o1.getCumulativeNanos(), o2.getCumulativeNanos());
                }
            });
            for (Node child : children) {
                child.dump(elem);
            }
        }

        public Object getKey() {
            return this.m_key;
        }

        private int getCumulativeCount() {
            return this.m_cumulativeCount;
        }

        private long getCumulativeNanos() {
            return this.m_cumulativeNanos;
        }
    }
}

