/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file;

import org.apache.commons.logging.Log;
import org.opencms.db.CmsResourceState;
import org.opencms.db.CmsSecurityManager;
import org.opencms.file.CmsResource;
import org.opencms.file.Messages;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;

public class CmsFolder
extends CmsResource {
    private static final Log LOG = CmsLog.getLog(CmsSecurityManager.class);
    private static final long serialVersionUID = 5527163725725725452L;

    public CmsFolder(CmsResource resource) {
        this(resource.getStructureId(), resource.getResourceId(), resource.getRootPath(), resource.getTypeId(), resource.getFlags(), resource.getProjectLastModified(), resource.getState(), resource.getDateCreated(), resource.getUserCreated(), resource.getDateLastModified(), resource.getUserLastModified(), resource.getDateReleased(), resource.getDateExpired(), resource.getVersion());
    }

    public CmsFolder(CmsUUID structureId, CmsUUID resourceId, String path, int type, int flags, CmsUUID projectId, CmsResourceState state, long dateCreated, CmsUUID userCreated, long dateLastModified, CmsUUID userLastModified, long dateReleased, long dateExpired, int version) {
        super(structureId, resourceId, path, type, true, flags, projectId, state, dateCreated, userCreated, dateLastModified, userLastModified, dateReleased, dateExpired, 1, -1, -1L, version);
    }

    public static final boolean isFolderSize(long size) {
        return size < 0L;
    }

    public static final boolean isFolderType(int typeId) {
        try {
            return OpenCms.getResourceManager().getResourceType(typeId).isFolder();
        }
        catch (CmsLoaderException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("ERR_UNKNOWN_RESOURCE_TYPE_1", new Integer(typeId)), (Throwable)e);
            }
            return false;
        }
    }

    public static final boolean isFolderType(String typeName) {
        try {
            return OpenCms.getResourceManager().getResourceType(typeName).isFolder();
        }
        catch (CmsLoaderException e) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_UNKNOWN_RESOURCE_TYPE_1", typeName), (Throwable)e);
        }
    }

    @Override
    public Object clone() {
        CmsFolder clone = new CmsFolder(this.getStructureId(), this.getResourceId(), this.getRootPath(), this.getTypeId(), this.getFlags(), this.getProjectLastModified(), this.getState(), this.getDateCreated(), this.getUserCreated(), this.getDateLastModified(), this.getUserLastModified(), this.getDateReleased(), this.getDateExpired(), this.getVersion());
        if (this.isTouched()) {
            clone.setDateLastModified(this.getDateLastModified());
        }
        return clone;
    }

    @Override
    public long getDateContent() {
        return -1L;
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public boolean isTemporaryFile() {
        return false;
    }
}

