/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.flex;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.AbstractLinkedMap;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.opencms.cache.CmsLruCache;
import org.opencms.cache.I_CmsLruCacheObject;
import org.opencms.db.CmsPublishedResource;
import org.opencms.file.CmsObject;
import org.opencms.flex.CmsFlexBucketConfiguration;
import org.opencms.flex.CmsFlexCacheConfiguration;
import org.opencms.flex.CmsFlexCacheEntry;
import org.opencms.flex.CmsFlexCacheKey;
import org.opencms.flex.CmsFlexRequestKey;
import org.opencms.flex.Messages;
import org.opencms.loader.CmsJspLoader;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.I_CmsEventListener;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsFlexCache
implements I_CmsEventListener {
    public static final String CACHE_ACTION = "action";
    public static final String CACHE_OFFLINESUFFIX = " [offline]";
    public static final String CACHE_ONLINESUFFIX = " [online]";
    public static final int CLEAR_ALL = 0;
    public static final int CLEAR_ENTRIES = 1;
    public static final int CLEAR_OFFLINE_ALL = 4;
    public static final int CLEAR_OFFLINE_ENTRIES = 5;
    public static final int CLEAR_ONLINE_ALL = 2;
    public static final int CLEAR_ONLINE_ENTRIES = 3;
    public static final String CONFIG_PATH = "/system/config/flexconfig.properties";
    public static final int INITIAL_CAPACITY_CACHE = 512;
    public static final int INITIAL_CAPACITY_VARIATIONS = 8;
    public static final String REPOSITORY_OFFLINE = "offline";
    public static final String REPOSITORY_ONLINE = "online";
    private static final Log LOG = CmsLog.getLog(CmsFlexCache.class);
    protected CmsLruCache m_variationCache;
    private CmsFlexBucketConfiguration m_bucketConfiguration;
    private boolean m_cacheOffline;
    private CmsObject m_cmsObject;
    private boolean m_enabled;
    private Map<String, CmsFlexCacheVariation> m_keyCache;
    private int m_size;

    public CmsFlexCache(CmsFlexCacheConfiguration configuration) {
        this.m_enabled = configuration.isCacheEnabled();
        this.m_cacheOffline = configuration.isCacheOffline();
        long maxCacheBytes = configuration.getMaxCacheBytes();
        long avgCacheBytes = configuration.getAvgCacheBytes();
        int maxEntryBytes = configuration.getMaxEntryBytes();
        int maxKeys = configuration.getMaxKeys();
        this.m_variationCache = new CmsLruCache(maxCacheBytes, avgCacheBytes, maxEntryBytes);
        OpenCms.getMemoryMonitor().register(this.getClass().getName() + ".m_entryLruCache", this.m_variationCache);
        if (this.m_enabled) {
            CmsFlexKeyMap flexKeyMap = new CmsFlexKeyMap(maxKeys);
            this.m_keyCache = Collections.synchronizedMap(CmsCollectionsGenericWrapper.map((Object)flexKeyMap));
            OpenCms.getMemoryMonitor().register(this.getClass().getName() + ".m_resourceMap", (Object)flexKeyMap);
            OpenCms.addCmsEventListener(this, new int[]{2, 5, 8, 9});
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("INIT_FLEXCACHE_CREATED_2", this.m_enabled, this.m_cacheOffline));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <K, V> Set<K> synchronizedCopyKeys(Map<K, V> map) {
        if (map == null) {
            return new HashSet();
        }
        Map<K, V> map2 = map;
        synchronized (map2) {
            return new HashSet<K>(map.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <K, V> Map<K, V> synchronizedCopyMap(Map<K, V> map) {
        if (map == null) {
            return new HashMap();
        }
        Map<K, V> map2 = map;
        synchronized (map2) {
            return new HashMap<K, V>(map);
        }
    }

    public boolean cacheOffline() {
        return this.m_cacheOffline;
    }

    @Override
    public void cmsEvent(CmsEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        block3 : switch (event.getType()) {
            case 2: {
                String publishIdStr;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"FlexCache: Received event PUBLISH_PROJECT");
                }
                if (!CmsUUID.isValidUUID(publishIdStr = (String)event.getData().get("publishHistoryId"))) {
                    this.clear();
                    break;
                }
                try {
                    CmsUUID publishId = new CmsUUID(publishIdStr);
                    List<CmsPublishedResource> publishedResources = this.m_cmsObject.readPublishedResources(publishId);
                    boolean updateConfiguration = false;
                    for (CmsPublishedResource res : publishedResources) {
                        if (!res.getRootPath().equals(CONFIG_PATH)) continue;
                        updateConfiguration = true;
                        break;
                    }
                    CmsFlexBucketConfiguration bucketConfig = this.m_bucketConfiguration;
                    if (updateConfiguration) {
                        LOG.info((Object)"Flex bucket configuration was updated, re-initializing configuration...");
                        try {
                            this.m_bucketConfiguration = CmsFlexBucketConfiguration.loadFromVfsFile(this.m_cmsObject, CONFIG_PATH);
                        }
                        catch (CmsException e) {
                            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                        this.clear();
                        break;
                    }
                    if (bucketConfig != null) {
                        boolean bucketClearOk = this.clearBucketsForPublishList(bucketConfig, publishId, publishedResources);
                        if (bucketClearOk) break;
                        this.clear();
                        break;
                    }
                    this.clear();
                }
                catch (CmsException e1) {
                    LOG.error((Object)e1.getLocalizedMessage(), (Throwable)e1);
                    this.clear();
                }
                break;
            }
            case 5: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_RECEIVED_EVENT_CLEAR_CACHE_0"));
                }
                this.clear();
                break;
            }
            case 8: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_RECEIVED_EVENT_PURGE_REPOSITORY_0"));
                }
                this.purgeJspRepository();
                break;
            }
            case 9: {
                Map<String, Object> m;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_RECEIVED_EVENT_CLEAR_CACHE_PARTIALLY_0"));
                }
                if ((m = event.getData()) == null) break;
                Integer it = null;
                try {
                    it = (Integer)m.get(CACHE_ACTION);
                }
                catch (Exception updateConfiguration) {
                    // empty catch block
                }
                if (it == null) {
                    LOG.error((Object)"Flex cache clear event with no action parameter received");
                    break;
                }
                int i = it;
                switch (i) {
                    case 0: {
                        this.clear();
                        break block3;
                    }
                    case 1: {
                        this.clearEntries();
                        break block3;
                    }
                    case 2: {
                        this.clearOnline();
                        break block3;
                    }
                    case 3: {
                        this.clearOnlineEntries();
                        break block3;
                    }
                    case 4: {
                        this.clearOffline();
                        break block3;
                    }
                    case 5: {
                        this.clearOfflineEntries();
                        break block3;
                    }
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpKeys(StringBuffer buffer) {
        CmsFlexCache cmsFlexCache = this;
        synchronized (cmsFlexCache) {
            for (Map.Entry<String, CmsFlexCacheVariation> entry : CmsFlexCache.synchronizedCopyMap(this.m_keyCache).entrySet()) {
                String key = entry.getKey();
                CmsFlexCacheVariation variations = entry.getValue();
                Map<String, I_CmsLruCacheObject> variationMap = variations.m_map;
                for (Map.Entry<String, I_CmsLruCacheObject> varEntry : variationMap.entrySet()) {
                    CmsFlexCacheEntry singleCacheEntry;
                    CmsFlexBucketConfiguration.BucketSet buckets;
                    String varKey = varEntry.getKey();
                    I_CmsLruCacheObject value = varEntry.getValue();
                    buffer.append(key + " VAR " + varKey + "\n");
                    if (!(value instanceof CmsFlexCacheEntry) || (buckets = (singleCacheEntry = (CmsFlexCacheEntry)value).getBucketSet()) == null) continue;
                    buffer.append("buckets = " + buckets.toString() + "\n");
                }
            }
        }
    }

    public CmsFlexCacheKey getCachedKey(String key, CmsObject cms) {
        if (!this.isEnabled() || !OpenCms.getRoleManager().hasRole(cms, CmsRole.WORKPLACE_MANAGER)) {
            return null;
        }
        CmsFlexCacheVariation o = this.m_keyCache.get(key);
        if (o != null) {
            return o.m_key;
        }
        return null;
    }

    public Set<String> getCachedResources(CmsObject cms) {
        if (!this.isEnabled() || !OpenCms.getRoleManager().hasRole(cms, CmsRole.WORKPLACE_MANAGER)) {
            return null;
        }
        return CmsFlexCache.synchronizedCopyKeys(this.m_keyCache);
    }

    public Set<String> getCachedVariations(String key, CmsObject cms) {
        if (!this.isEnabled() || !OpenCms.getRoleManager().hasRole(cms, CmsRole.WORKPLACE_MANAGER)) {
            return null;
        }
        CmsFlexCacheVariation o = this.m_keyCache.get(key);
        if (o != null) {
            return CmsFlexCache.synchronizedCopyKeys(o.m_map);
        }
        return null;
    }

    public CmsLruCache getEntryLruCache() {
        return this.m_variationCache;
    }

    public void initializeCms(CmsObject adminCms) {
        try {
            this.m_cmsObject = adminCms;
            try {
                String path = CONFIG_PATH;
                if (this.m_cmsObject.existsResource(path)) {
                    LOG.info((Object)"Flex configuration found at /system/config/flexconfig.properties, initializing...");
                    this.m_bucketConfiguration = CmsFlexBucketConfiguration.loadFromVfsFile(this.m_cmsObject, path);
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public int keySize() {
        if (!this.isEnabled()) {
            return 0;
        }
        return this.m_keyCache.size();
    }

    public int size() {
        return this.m_variationCache.size();
    }

    CmsFlexCacheEntry get(CmsFlexRequestKey key) {
        if (!this.isEnabled()) {
            return null;
        }
        CmsFlexCacheVariation o = this.m_keyCache.get(key.getResource());
        if (o != null) {
            CmsFlexCacheVariation v = o;
            String variation = v.m_key.matchRequestKey(key);
            if (CmsStringUtil.isEmpty(variation)) {
                return null;
            }
            CmsFlexCacheEntry entry = (CmsFlexCacheEntry)v.m_map.get(variation);
            if (entry == null) {
                return null;
            }
            if (entry.getDateExpires() < System.currentTimeMillis()) {
                this.m_variationCache.remove(entry);
                return null;
            }
            return entry;
        }
        return null;
    }

    CmsFlexCacheKey getKey(String resource) {
        if (!this.isEnabled()) {
            return null;
        }
        CmsFlexCacheVariation o = this.m_keyCache.get(resource);
        if (o != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHEKEY_FOUND_1", resource));
            }
            return o.m_key;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHEKEY_NOT_FOUND_1", resource));
        }
        return null;
    }

    boolean isEmpty() {
        if (!this.isEnabled()) {
            return true;
        }
        return this.m_keyCache.isEmpty();
    }

    boolean put(CmsFlexCacheKey key, CmsFlexCacheEntry entry, String variation, CmsFlexRequestKey requestKey) {
        if (!this.isEnabled()) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_ADD_ENTRY_1", key.getResource()));
        }
        if (variation != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_ADD_ENTRY_WITH_VARIATION_2", key.getResource(), variation));
            }
            this.put(key, entry, variation);
            if (this.m_bucketConfiguration != null) {
                try {
                    List<String> paths = key.getPathsForBuckets(requestKey);
                    if (paths.size() > 0) {
                        CmsFlexBucketConfiguration.BucketSet buckets = this.m_bucketConfiguration.getBucketSet(paths);
                        entry.setBucketSet(buckets);
                    } else {
                        entry.setBucketSet(null);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_RESOURCE_NOT_CACHEABLE_0"));
        }
        return false;
    }

    void putKey(CmsFlexCacheKey key) {
        if (!this.isEnabled()) {
            return;
        }
        CmsFlexCacheVariation o = this.m_keyCache.get(key.getResource());
        if (o == null) {
            CmsFlexCacheVariation variationMap = new CmsFlexCacheVariation(key);
            this.m_keyCache.put(key.getResource(), variationMap);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_ADD_KEY_1", key.getResource()));
            }
        }
    }

    private synchronized void clear() {
        if (!this.isEnabled()) {
            return;
        }
        this.m_keyCache.clear();
        this.m_size = 0;
        this.m_variationCache.clear();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_CLEAR_0"));
        }
    }

    private synchronized void clearAccordingToSuffix(String suffix, boolean entriesOnly) {
        Set<String> keys = CmsFlexCache.synchronizedCopyKeys(this.m_keyCache);
        for (String s : keys) {
            I_CmsLruCacheObject nextObject;
            Iterator<I_CmsLruCacheObject> allEntries;
            if (!s.endsWith(suffix)) continue;
            CmsFlexCacheVariation v = this.m_keyCache.get(s);
            if (entriesOnly) {
                this.m_size -= v.m_map.size();
                allEntries = v.m_map.values().iterator();
                while (allEntries.hasNext()) {
                    nextObject = allEntries.next();
                    allEntries.remove();
                    this.m_variationCache.remove(nextObject);
                }
                v.m_map = new Hashtable<String, I_CmsLruCacheObject>(8);
                continue;
            }
            this.m_size -= v.m_map.size();
            allEntries = v.m_map.values().iterator();
            while (allEntries.hasNext()) {
                nextObject = allEntries.next();
                allEntries.remove();
                this.m_variationCache.remove(nextObject);
            }
            v.m_map = null;
            v.m_key = null;
            this.m_keyCache.remove(s);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_CLEAR_HALF_2", suffix, entriesOnly));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean clearBucketsForPublishList(CmsFlexBucketConfiguration bucketConfig, CmsUUID publishId, List<CmsPublishedResource> publishedResources) {
        long startTime = System.currentTimeMillis();
        String p = "[" + publishId + "] ";
        try {
            LOG.debug((Object)(p + "Trying bucket-based flex entry cleanup"));
            if (bucketConfig.shouldClearAll(publishedResources)) {
                LOG.info((Object)(p + "Clearing Flex cache completely based on Flex bucket configuration."));
                return false;
            }
            long totalEntries = 0L;
            long removedEntries = 0L;
            ArrayList paths = Lists.newArrayList();
            for (CmsPublishedResource pubRes : publishedResources) {
                paths.add(pubRes.getRootPath());
                LOG.info((Object)(p + "Published resource: " + pubRes.getRootPath()));
            }
            CmsFlexBucketConfiguration.BucketSet publishListBucketSet = bucketConfig.getBucketSet(paths);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)(p + "Flex cache buckets for publish list: " + publishListBucketSet.toString()));
            }
            CmsFlexCache cmsFlexCache = this;
            synchronized (cmsFlexCache) {
                ArrayList entriesToDelete = Lists.newArrayList();
                for (Map.Entry<String, CmsFlexCacheVariation> entry : CmsFlexCache.synchronizedCopyMap(this.m_keyCache).entrySet()) {
                    CmsFlexCacheVariation variation = entry.getValue();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(p + "Processing entries for " + entry.getKey()));
                    }
                    entriesToDelete.clear();
                    for (Map.Entry<String, I_CmsLruCacheObject> variationEntry : CmsFlexCache.synchronizedCopyMap(variation.m_map).entrySet()) {
                        CmsFlexCacheEntry flexEntry = (CmsFlexCacheEntry)variationEntry.getValue();
                        ++totalEntries;
                        CmsFlexBucketConfiguration.BucketSet entryBucketSet = flexEntry.getBucketSet();
                        if (publishListBucketSet.matchForDeletion(entryBucketSet)) {
                            entriesToDelete.add(flexEntry);
                            if (!LOG.isInfoEnabled()) continue;
                            LOG.info((Object)(p + "Match: " + variationEntry.getKey()));
                            continue;
                        }
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)(p + "No match: " + variationEntry.getKey()));
                    }
                    for (CmsFlexCacheEntry entryToDelete : entriesToDelete) {
                        this.m_variationCache.remove(entryToDelete);
                        ++removedEntries;
                    }
                }
                long endTime = System.currentTimeMillis();
                LOG.info((Object)(p + "Removed " + removedEntries + " of " + totalEntries + " Flex cache entries, took " + (endTime - startTime) + " milliseconds"));
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)(p + "Exception while trying to selectively purge flex cache: " + e.getLocalizedMessage()), (Throwable)e);
            return false;
        }
    }

    private synchronized void clearEntries() {
        if (!this.isEnabled()) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_CLEAR_ALL_0"));
        }
        Set<String> cacheKeys = CmsFlexCache.synchronizedCopyKeys(this.m_keyCache);
        Iterator<String> i = cacheKeys.iterator();
        while (i.hasNext()) {
            CmsFlexCacheVariation v = this.m_keyCache.get(i.next());
            Iterator<I_CmsLruCacheObject> allEntries = v.m_map.values().iterator();
            while (allEntries.hasNext()) {
                I_CmsLruCacheObject nextObject = allEntries.next();
                allEntries.remove();
                this.m_variationCache.remove(nextObject);
            }
            v.m_map = new Hashtable<String, I_CmsLruCacheObject>(8);
        }
        this.m_size = 0;
    }

    private void clearOffline() {
        if (!this.isEnabled()) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_CLEAR_KEYS_AND_ENTRIES_0"));
        }
        this.clearAccordingToSuffix(CACHE_OFFLINESUFFIX, false);
    }

    private void clearOfflineEntries() {
        if (!this.isEnabled()) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_CLEAR_OFFLINE_ENTRIES_0"));
        }
        this.clearAccordingToSuffix(CACHE_OFFLINESUFFIX, true);
    }

    private void clearOnline() {
        if (!this.isEnabled()) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_CLEAR_ONLINE_KEYS_AND_ENTRIES_0"));
        }
        this.clearAccordingToSuffix(CACHE_ONLINESUFFIX, false);
    }

    private void clearOnlineEntries() {
        if (!this.isEnabled()) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_CLEAR_ONLINE_ENTRIES_0"));
        }
        this.clearAccordingToSuffix(CACHE_ONLINESUFFIX, true);
    }

    private synchronized void purgeJspRepository() {
        CmsJspLoader cmsJspLoader = (CmsJspLoader)OpenCms.getResourceManager().getLoader(6);
        cmsJspLoader.triggerPurge(new Runnable(){

            @Override
            public void run() {
                CmsFlexCache.this.clear();
            }
        });
    }

    private void put(CmsFlexCacheKey key, CmsFlexCacheEntry theCacheEntry, String variation) {
        CmsFlexCacheVariation o = this.m_keyCache.get(key.getResource());
        if (key.getTimeout() > 0L) {
            theCacheEntry.setDateExpiresToNextTimeout(key.getTimeout());
        }
        if (o != null) {
            Map<String, I_CmsLruCacheObject> m = o.m_map;
            boolean wasAdded = true;
            wasAdded = !m.containsKey(variation) ? this.m_variationCache.add(theCacheEntry) : this.m_variationCache.touch(theCacheEntry);
            if (wasAdded) {
                theCacheEntry.setVariationData(variation, m);
                m.put(variation, theCacheEntry);
            }
        } else {
            CmsFlexCacheVariation list = new CmsFlexCacheVariation(key);
            boolean wasAdded = this.m_variationCache.add(theCacheEntry);
            if (wasAdded) {
                theCacheEntry.setVariationData(variation, list.m_map);
                list.m_map.put(variation, theCacheEntry);
                this.m_keyCache.put(key.getResource(), list);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_ADDED_ENTRY_FOR_RESOURCE_WITH_VARIATION_3", new Integer(this.m_size), key.getResource(), variation));
            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_ADDED_ENTRY_1", theCacheEntry.toString()));
        }
    }

    class CmsFlexKeyMap
    extends LRUMap {
        private static final long serialVersionUID = 6931995916013396902L;

        public CmsFlexKeyMap(int maxSize) {
            super(maxSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean removeLRU(AbstractLinkedMap.LinkEntry entry) {
            CmsFlexCacheVariation v = (CmsFlexCacheVariation)entry.getValue();
            if (v == null) {
                return true;
            }
            Map<String, I_CmsLruCacheObject> m = v.m_map;
            if (m == null || m.size() == 0) {
                return true;
            }
            ArrayList<I_CmsLruCacheObject> entries = new ArrayList<I_CmsLruCacheObject>(m.values());
            CmsLruCache cmsLruCache = CmsFlexCache.this.m_variationCache;
            synchronized (cmsLruCache) {
                for (I_CmsLruCacheObject e : entries) {
                    CmsFlexCache.this.m_variationCache.remove(e);
                }
                v.m_map.clear();
                v.m_map = null;
                v.m_key = null;
            }
            return true;
        }
    }

    public static class CmsFlexCacheVariation {
        public CmsFlexCacheKey m_key;
        public Map<String, I_CmsLruCacheObject> m_map;

        public CmsFlexCacheVariation(CmsFlexCacheKey theKey) {
            this.m_key = theKey;
            this.m_map = new Hashtable<String, I_CmsLruCacheObject>(8);
        }
    }
}

