/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.flex.CmsFlexController;
import org.opencms.gwt.CmsGwtActionElement;
import org.opencms.gwt.I_CmsClientMessageBundle;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsResourceBundleLoader;
import org.opencms.i18n.I_CmsMessageBundle;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;

public abstract class A_CmsClientMessageBundle
implements I_CmsClientMessageBundle {
    public static final String IMPORT_PREFIX = "@@import:";
    private static final Log LOG = CmsLog.getLog(A_CmsClientMessageBundle.class);

    protected A_CmsClientMessageBundle() {
    }

    @Override
    public String export(HttpServletRequest request) {
        CmsObject cms = CmsFlexController.getCmsObject((ServletRequest)request);
        return this.export(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
    }

    @Override
    public String export(Locale locale) {
        return this.export(locale, true);
    }

    @Override
    public String export(Locale locale, boolean wrapScript) {
        JSONObject keys = new JSONObject();
        try {
            ResourceBundle resourceBundle = CmsResourceBundleLoader.getBundle(this.getBundleName(), locale);
            Enumeration<String> bundleKeys = resourceBundle.getKeys();
            while (bundleKeys.hasMoreElements()) {
                String importKey;
                String importedValue;
                String bundleKey = bundleKeys.nextElement();
                String value = resourceBundle.getString(bundleKey);
                if (value.startsWith(IMPORT_PREFIX) && (importedValue = this.importMessage(importKey = value.replace(IMPORT_PREFIX, ""), locale)) != null) {
                    value = importedValue;
                }
                keys.put(bundleKey, value);
            }
        }
        catch (Throwable e) {
            LOG.error((Object)e.getLocalizedMessage(), e);
            try {
                keys.put("error", e.getLocalizedMessage());
            }
            catch (JSONException e1) {
                LOG.error((Object)e1.getLocalizedMessage(), (Throwable)e1);
            }
        }
        StringBuffer sb = new StringBuffer();
        String script = this.getBundleName().replace('.', '_') + "=" + keys.toString() + ";";
        if (wrapScript) {
            script = CmsGwtActionElement.wrapScript(script);
        }
        sb.append(script);
        return sb.toString();
    }

    @Override
    public String export(String localeName) {
        return this.export(CmsLocaleManager.getLocale(localeName));
    }

    @Override
    public String getBundleName() {
        return this.getClass().getPackage().getName() + ".clientmessages";
    }

    @Override
    public Class<?> getClientImpl() throws Exception {
        return Class.forName(this.getClass().getPackage().getName() + ".client.Messages");
    }

    public String importMessage(String key, Locale locale) {
        String[] tokens = (key = key.trim()).split("#");
        if (tokens.length != 2) {
            return null;
        }
        String className = tokens[0];
        String messageName = tokens[1];
        try {
            Method messagesGet = Class.forName(className).getMethod("get", new Class[0]);
            I_CmsMessageBundle bundle = (I_CmsMessageBundle)messagesGet.invoke(null, new Object[0]);
            return bundle.getBundle(locale).key(messageName);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }
}

