/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt;

import com.google.common.collect.Lists;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.FontIcon;
import com.vaadin.server.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.gwt.CmsCoreService;
import org.opencms.gwt.Messages;
import org.opencms.gwt.shared.CmsQuickLaunchData;
import org.opencms.gwt.shared.CmsQuickLaunchParams;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.CmsAppVisibilityStatus;
import org.opencms.ui.apps.CmsLegacyAppConfiguration;
import org.opencms.ui.apps.CmsQuickLaunchLocationCache;
import org.opencms.ui.apps.I_CmsWorkplaceAppConfiguration;

public final class CmsQuickLaunchProvider {
    private static final String FONT_ICON_PREFIX = "fonticon:";
    private static final Log LOG = CmsLog.getLog(CmsQuickLaunchProvider.class);

    private CmsQuickLaunchProvider() {
    }

    public static List<CmsQuickLaunchData> getQuickLaunchData(CmsObject cms, HttpSession session, CmsQuickLaunchParams params) {
        ArrayList result = Lists.newArrayList();
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        ArrayList<I_CmsWorkplaceAppConfiguration> appConfigs = new ArrayList<I_CmsWorkplaceAppConfiguration>(OpenCms.getWorkplaceAppManager().getQuickLaunchConfigurations(cms));
        CmsResource currentPage = null;
        if (params.getPageId() != null) {
            try {
                currentPage = cms.readResource(params.getPageId(), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        CmsQuickLaunchLocationCache locationCache = CmsQuickLaunchLocationCache.getLocationCache(session);
        for (I_CmsWorkplaceAppConfiguration config : appConfigs) {
            try {
                String page;
                boolean reload = false;
                String link = null;
                String errorTitle = null;
                String errorMessage = null;
                boolean useLegacyButtonStyle = config instanceof CmsLegacyAppConfiguration;
                if ("explorer".equals(config.getId())) {
                    page = locationCache.getFileExplorerLocation(cms.getRequestContext().getSiteRoot());
                    if (page != null) {
                        link = CmsCoreService.getVaadinWorkplaceLink(cms, cms.getRequestContext().addSiteRoot(page));
                    } else if (cms.existsResource("/", CmsResourceFilter.ONLY_VISIBLE_NO_DELETED)) {
                        link = CmsCoreService.getVaadinWorkplaceLink(cms, cms.getRequestContext().getSiteRoot());
                    } else if (currentPage != null) {
                        link = CmsCoreService.getVaadinWorkplaceLink(cms, params.getPageId());
                    } else {
                        errorTitle = config.getName(locale);
                        errorMessage = Messages.get().getBundle(locale).key("GUI_QUICKLAUNCH_EXPLORER_NOT_ALLOWED_0");
                    }
                } else if ("pageeditor".equals(config.getId())) {
                    if (params.isPageContext()) {
                        if (currentPage != null && "modelgroup".equals(OpenCms.getResourceManager().getResourceType(currentPage).getTypeName())) {
                            page = locationCache.getPageEditorLocation(cms, cms.getRequestContext().getSiteRoot());
                            if (page != null) {
                                link = OpenCms.getLinkManager().substituteLink(cms, page);
                            } else {
                                reload = true;
                            }
                        } else {
                            reload = true;
                        }
                    } else if (params.isSitemapContext()) {
                        page = locationCache.getPageEditorLocation(cms, cms.getRequestContext().getSiteRoot());
                        if (page == null) {
                            page = locationCache.getSitemapEditorLocation(cms.getRequestContext().getSiteRoot());
                        }
                        if (page != null) {
                            link = OpenCms.getLinkManager().substituteLink(cms, page);
                        }
                    }
                } else if ("sitemapeditor".equals(config.getId())) {
                    if (params.isSitemapContext()) {
                        reload = true;
                    } else if (params.isPageContext()) {
                        String sitemapLink = OpenCms.getLinkManager().substituteLinkForUnknownTarget(cms, "/system/workplace/commons/sitemap.jsp");
                        String page2 = locationCache.getPageEditorLocation(cms, cms.getRequestContext().getSiteRoot());
                        link = sitemapLink + "?path=" + page2;
                    }
                } else {
                    link = CmsVaadinUtils.getWorkplaceLink(config.getId());
                }
                Resource icon = config.getIcon();
                String imageLink = "";
                if (icon instanceof ExternalResource) {
                    imageLink = ((ExternalResource)icon).getURL();
                } else if (icon instanceof FontIcon) {
                    imageLink = FONT_ICON_PREFIX + ((FontIcon)icon).getHtml();
                }
                String name = config.getName(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
                CmsAppVisibilityStatus visibility = config.getVisibility(cms);
                if (!visibility.isActive()) {
                    errorTitle = name;
                    errorMessage = visibility.getHelpText();
                }
                CmsQuickLaunchData data = new CmsQuickLaunchData(link, name, imageLink, config.getButtonStyle(), errorTitle, errorMessage, useLegacyButtonStyle, reload);
                result.add(data);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }
}

