/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.importexport;

import com.google.common.base.Objects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.ZipFile;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.Rule;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.db.CmsDbEntryNotFoundException;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceBuilder;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.file.types.CmsResourceTypeXmlAdeConfiguration;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.importexport.CmsImportExportException;
import org.opencms.importexport.CmsImportExportManager;
import org.opencms.importexport.CmsImportHelper;
import org.opencms.importexport.CmsImportParameters;
import org.opencms.importexport.I_CmsImport;
import org.opencms.importexport.Messages;
import org.opencms.loader.CmsLoaderException;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelationType;
import org.opencms.relations.I_CmsLinkParseable;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsDataTypeUtil;
import org.opencms.util.CmsDateUtil;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.CmsXmlErrorHandler;
import org.opencms.xml.content.CmsXmlContent;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class CmsImportVersion10
implements I_CmsImport {
    public static final String A_NAME = "name";
    public static final String A_TYPE = "type";
    public static final String DTD_FILENAME = "opencms-import10.dtd";
    public static final String DTD_LOCATION = "org/opencms/importexport/";
    public static final int IMPORT_VERSION10 = 10;
    public static final String N_ACCESSCONTROL_ALLOWEDPERMISSIONS = "allowed";
    public static final String N_ACCESSCONTROL_DENIEDPERMISSIONS = "denied";
    public static final String N_ACCESSCONTROL_ENTRIES = "accesscontrol";
    public static final String N_ACCESSCONTROL_ENTRY = "accessentry";
    public static final String N_ACCESSCONTROL_PERMISSIONSET = "permissionset";
    public static final String N_ACCESSCONTROL_PRINCIPAL = "uuidprincipal";
    public static final String N_ACCOUNTS = "accounts";
    public static final String N_DATECREATED = "datecreated";
    public static final String N_DATEEXPIRED = "dateexpired";
    public static final String N_DATELASTMODIFIED = "datelastmodified";
    public static final String N_DATERELEASED = "datereleased";
    public static final String N_DESCRIPTION = "description";
    public static final String N_DESTINATION = "destination";
    public static final String N_EMAIL = "email";
    public static final String N_FILE = "file";
    public static final String N_FILES = "files";
    public static final String N_FIRSTNAME = "firstname";
    public static final String N_FLAGS = "flags";
    public static final String N_GROUP = "group";
    public static final String N_GROUPS = "groups";
    public static final String N_ID = "id";
    public static final String N_LASTNAME = "lastname";
    public static final String N_MANAGERSGROUP = "managersgroup";
    public static final String N_NAME = "name";
    public static final String N_ORGUNIT = "orgunit";
    public static final String N_ORGUNITS = "orgunits";
    public static final String N_PARENTGROUP = "parentgroup";
    public static final String N_PASSWORD = "password";
    public static final String N_PATH = "path";
    public static final String N_PROJECT = "project";
    public static final String N_PROJECTS = "projects";
    public static final String N_PROPERTIES = "properties";
    public static final String N_PROPERTY = "property";
    public static final String N_RELATION = "relation";
    public static final String N_RELATIONS = "relations";
    public static final String N_RESOURCE = "resource";
    public static final String N_RESOURCES = "resources";
    public static final String N_SOURCE = "source";
    public static final String N_TYPE = "type";
    public static final String N_USER = "user";
    public static final String N_USERCREATED = "usercreated";
    public static final String N_USERGROUP = "usergroup";
    public static final String N_USERGROUPS = "usergroups";
    public static final String N_USERINFO = "userinfo";
    public static final String N_USERINFO_ENTRY = "entry";
    public static final String N_USERLASTMODIFIED = "userlastmodified";
    public static final String N_USERROLE = "userrole";
    public static final String N_USERROLES = "userroles";
    public static final String N_USERS = "users";
    public static final String N_USERSGROUP = "usersgroup";
    public static final String N_UUIDRESOURCE = "uuidresource";
    public static final String N_UUIDSTRUCTURE = "uuidstructure";
    public static final String N_VALUE = "value";
    public static final String PROPERTY_ATTRIB_TYPE_SHARED = "shared";
    protected static final long DATE_CREATED_UNSPECIFIED = -1L;
    protected static final long DATE_LAST_MODIFICATION_FILETIME = -1L;
    protected static final long DATE_LAST_MODIFICATION_UNSPECIFIED = -2L;
    private static final Log LOG = CmsLog.getLog(CmsImportVersion10.class);
    private static final AtomicLong cumulativeConfigWaitTime = new AtomicLong(0L);
    protected int m_aceFlags;
    protected int m_acePermissionsAllowed;
    protected int m_acePermissionsDenied;
    protected CmsUUID m_acePrincipalId;
    protected List<CmsAccessControlEntry> m_aces;
    protected CmsObject m_cms;
    protected Set<CmsUUID> m_contentFiles = new HashSet<CmsUUID>();
    protected String m_destination;
    protected int m_fileCounter;
    protected String m_groupDescription;
    protected int m_groupFlags;
    protected String m_groupName;
    protected String m_groupParent;
    protected Map<String, List<String>> m_groupParents;
    protected boolean m_hasDateLastModified;
    protected boolean m_hasStructureId;
    protected CmsImportHelper m_helper;
    protected List<String> m_ignoredProperties;
    protected List<String> m_immutables;
    protected boolean m_importACEs;
    protected Map<String, Map<String, Map<String, String>>> m_membership;
    protected CmsOrganizationalUnit m_orgUnit;
    protected String m_orgUnitDescription;
    protected int m_orgUnitFlags;
    protected String m_orgUnitName;
    protected Map<String, List<String>> m_orgUnitResources;
    protected CmsImportParameters m_parameters;
    protected List<CmsResource> m_parseables;
    protected String m_projectDescription;
    protected String m_projectManagers;
    protected String m_projectName;
    protected List<String> m_projectResources;
    protected String m_projectUsers;
    protected Map<String, CmsProperty> m_properties;
    protected String m_propertyName;
    protected String m_propertyValue;
    protected CmsUUID m_relationId;
    protected String m_relationPath;
    protected List<RelationData> m_relationsForResource;
    protected CmsRelationType m_relationType;
    protected I_CmsReport m_report;
    protected CmsResource m_resource;
    protected CmsResourceBuilder m_resourceBuilder;
    protected String m_source;
    protected Throwable m_throwable;
    protected int m_totalFiles;
    protected String m_typeName;
    protected CmsUser m_user;
    protected long m_userDateCreated;
    protected String m_userEmail;
    protected String m_userFirstname;
    protected int m_userFlags;
    protected Map<String, Object> m_userInfos;
    protected String m_userLastname;
    protected String m_userName;
    protected String m_userPassword;
    protected int m_version;
    private Map<Integer, CmsUUID> m_indexToStructureId;
    private Multimap<Integer, RelationData> m_relationData;
    private boolean m_resourceIdWasNull;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseLinks(CmsObject cms, List<CmsResource> parseables, I_CmsReport report) {
        int i = 0;
        ArrayListMultimap resourcesByCategory = ArrayListMultimap.create();
        for (CmsResource resource : parseables) {
            LinkParsableCategory category = LinkParsableCategory.other;
            if (CmsResourceTypeXmlContainerPage.isContainerPage(resource)) {
                category = LinkParsableCategory.page;
            } else {
                I_CmsResourceType resType = OpenCms.getResourceManager().getResourceType(resource);
                if (resType instanceof CmsResourceTypeXmlAdeConfiguration && !OpenCms.getResourceManager().matchResourceType("listconfig", resource.getTypeId())) {
                    category = LinkParsableCategory.config;
                }
            }
            resourcesByCategory.put((Object)category, (Object)resource);
        }
        for (LinkParsableCategory category : Arrays.asList(LinkParsableCategory.config, LinkParsableCategory.page, LinkParsableCategory.other)) {
            List resourcesInCurrentCategory = resourcesByCategory.get((Object)category);
            resourcesInCurrentCategory.sort((a, b) -> a.getRootPath().compareTo(b.getRootPath()));
            for (CmsResource parsableRes : resourcesInCurrentCategory) {
                block16: {
                    String resName = cms.getSitePath(parsableRes);
                    report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", String.valueOf(i + 1), String.valueOf(parseables.size())), 3);
                    LOG.info((Object)("Rewriting parsable resource: " + resName));
                    report.print(Messages.get().container("RPT_PARSE_LINKS_FOR_1", resName), 3);
                    report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                    try {
                        CmsFile file = cms.readFile(resName);
                        file.setDateLastModified(file.getDateLastModified());
                        CmsLock lock = cms.getLock(file);
                        if (lock.isUnlocked()) {
                            cms.lockResource(resName);
                        } else if (!lock.isDirectlyOwnedInProjectBy(cms)) {
                            cms.changeLock(resName);
                        }
                        cms.getRequestContext().setAttribute(CmsXmlContent.AUTO_CORRECTION_ATTRIBUTE, Boolean.TRUE);
                        try {
                            cms.writeFile(file);
                        }
                        finally {
                            cms.getRequestContext().removeAttribute(CmsXmlContent.AUTO_CORRECTION_ATTRIBUTE);
                        }
                        report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                    }
                    catch (Throwable e) {
                        report.addWarning(e);
                        report.println(org.opencms.report.Messages.get().container("RPT_FAILED_0"), 5);
                        if (LOG.isWarnEnabled()) {
                            LOG.warn((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_REWRITING_1", resName));
                            LOG.warn((Object)e.getMessage(), e);
                        }
                        if (!LOG.isDebugEnabled()) break block16;
                        LOG.debug((Object)e.getLocalizedMessage(), e);
                    }
                }
                ++i;
            }
            if (category != LinkParsableCategory.config || resourcesInCurrentCategory.size() <= 0) continue;
            long start = System.currentTimeMillis();
            OpenCms.getADEManager().waitForFormatterCache(false);
            OpenCms.getADEManager().waitForCacheUpdate(false);
            long end = System.currentTimeMillis();
            long waitTime = end - start;
            long cumulative = cumulativeConfigWaitTime.addAndGet(waitTime);
            LOG.debug((Object)("Waited " + (double)waitTime / 1000.0 + "s for configuration in parseLinks, total = " + cumulative));
        }
        cms.getRequestContext().removeAttribute("ATTR_LOG_ENTRY");
    }

    public void addAccessControlEntry() {
        try {
            if (this.m_throwable != null) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_ERROR_IMPORTING_ACE_1", this.getRequestContext().removeSiteRoot(this.m_resource.getRootPath())), this.m_throwable);
                }
                this.getReport().println(this.m_throwable);
                this.getReport().addError(this.m_throwable);
                this.m_throwable = null;
                return;
            }
            if (this.m_aces == null) {
                this.m_aces = new ArrayList<CmsAccessControlEntry>();
            }
            this.m_aces.add(new CmsAccessControlEntry(null, this.m_acePrincipalId, this.m_acePermissionsAllowed, this.m_acePermissionsDenied, this.m_aceFlags));
        }
        finally {
            this.m_acePrincipalId = null;
            this.m_acePermissionsAllowed = 0;
            this.m_acePermissionsDenied = 0;
            this.m_aceFlags = 0;
        }
    }

    public void addContentFile(String source, String resourceId) {
        if (source != null && resourceId != null) {
            try {
                this.m_helper.getFileBytes(source);
                this.m_contentFiles.add(new CmsUUID(resourceId));
            }
            catch (CmsImportExportException e) {
                LOG.info((Object)("File not found in import: " + source));
            }
        }
    }

    public void addOrgUnitResource(String resourceName) {
        List<String> resources;
        if (this.m_throwable != null || this.m_orgUnitName == null) {
            return;
        }
        if (this.m_orgUnitResources == null) {
            this.m_orgUnitResources = new HashMap<String, List<String>>();
        }
        if ((resources = this.m_orgUnitResources.get(this.m_orgUnitName)) == null) {
            resources = new ArrayList<String>();
            this.m_orgUnitResources.put(this.m_orgUnitName, resources);
        }
        resources.add(resourceName);
    }

    public void addProjectResource(String resourceName) {
        if (this.m_throwable != null || this.m_projectName == null) {
            return;
        }
        if (this.m_projectResources == null) {
            this.m_projectResources = new ArrayList<String>();
        }
        this.m_projectResources.add(resourceName);
    }

    public void addProperty() {
        this.addProperty("individual");
    }

    public void addProperty(String propertyType) {
        if (this.m_properties == null) {
            this.m_properties = new HashMap<String, CmsProperty>();
        }
        try {
            if (this.m_propertyName == null || this.getIgnoredProperties().contains(this.m_propertyName)) {
                return;
            }
            CmsProperty property = this.m_properties.get(this.m_propertyName);
            if (property == null) {
                property = new CmsProperty();
                property.setName(this.m_propertyName);
                property.setAutoCreatePropertyDefinition(true);
                this.m_properties.put(this.m_propertyName, property);
            }
            if (this.m_propertyValue == null) {
                this.m_propertyValue = "";
            }
            if (propertyType != null && propertyType.equals(PROPERTY_ATTRIB_TYPE_SHARED)) {
                property.setResourceValue(this.m_propertyValue);
            } else {
                property.setStructureValue(this.m_propertyValue);
            }
        }
        finally {
            this.m_propertyName = null;
            this.m_propertyValue = null;
        }
    }

    public void addRelation() {
        try {
            if (this.m_throwable != null) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_ERROR_IMPORTING_RELATION_1", this.m_destination), this.m_throwable);
                }
                this.getReport().println(this.m_throwable);
                this.getReport().addError(this.m_throwable);
                this.m_throwable = null;
                return;
            }
            RelationData relData = new RelationData(this.m_relationPath, this.m_relationId, this.m_relationType);
            this.m_relationsForResource.add(relData);
            this.m_relationData.put((Object)this.m_fileCounter, (Object)relData);
        }
        finally {
            this.m_relationId = null;
            this.m_relationPath = null;
            this.m_relationType = null;
        }
    }

    public void addXmlDigesterRules(Digester digester) {
        String xpath = "export/accounts/orgunits/orgunit/";
        this.addAccountsOrgunitRules(digester, xpath);
        this.addAccountsGroupRules(digester, xpath);
        this.addAccountsUserRules(digester, xpath);
        digester.addCallMethod("export/accounts/orgunits/orgunit", "setMembership");
        digester.addRule("export/files", new Rule(){

            public void begin(String namespace, String name, Attributes attributes) throws Exception {
                CmsImportVersion10.this.m_indexToStructureId = new HashMap();
                CmsImportVersion10.this.m_relationData = (Multimap)ArrayListMultimap.create();
            }
        });
        digester.addRule("export/files/file", new Rule(){

            public void begin(String namespace, String name, Attributes attributes) throws Exception {
                CmsImportVersion10.this.m_importACEs = true;
                CmsImportVersion10.this.m_resourceBuilder = new CmsResourceBuilder();
                CmsImportVersion10.this.m_resourceBuilder.setDateLastModified(-2L);
                CmsImportVersion10.this.m_resourceBuilder.setDateReleased(0L);
                CmsImportVersion10.this.m_resourceBuilder.setDateExpired(Long.MAX_VALUE);
                CmsImportVersion10.this.m_resourceBuilder.setDateCreated(-1L);
                CmsImportVersion10.this.m_resourceBuilder.setUserCreated(CmsUUID.getNullUUID());
                CmsImportVersion10.this.m_relationsForResource = new ArrayList<RelationData>();
                CmsImportVersion10.this.m_hasStructureId = false;
                CmsImportVersion10.this.m_hasDateLastModified = false;
            }
        });
        xpath = "export/files/file/";
        this.addResourceAttributesRules(digester, xpath);
        digester.addCallMethod(xpath, "importResourceAll");
        this.addResourcePropertyRules(digester, xpath);
        this.addResourceRelationRules(digester, xpath);
        this.addResourceAceRules(digester, xpath);
        digester.addCallMethod("export/files", "importRelations");
        digester.addCallMethod("export/files", "rewriteParseables");
        digester.addCallMethod("export/files", "associateOrgUnitResources");
        xpath = "export/projects/project/";
        this.addProjectRules(digester, xpath);
    }

    public void addXmlPreprocessingDigesterRules(Digester digester) {
        digester.addCallMethod("export/files/file", "increaseTotalFiles");
        digester.addCallMethod("export/info/export_version", "setVersion", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateOrgUnitResources() {
        if (this.m_orgUnitResources == null || this.m_orgUnitResources.isEmpty()) {
            return;
        }
        String site = this.getRequestContext().getSiteRoot();
        try {
            this.getRequestContext().setSiteRoot("");
            ArrayList<String> orgUnits = new ArrayList<String>(this.m_orgUnitResources.keySet());
            Collections.sort(orgUnits);
            for (String orgUnitName : orgUnits) {
                List<String> resources = this.m_orgUnitResources.get(orgUnitName);
                if (orgUnitName.equals("")) continue;
                for (String resourceName : resources) {
                    try {
                        OpenCms.getOrgUnitManager().addResourceToOrgUnit(this.getCms(), orgUnitName, resourceName);
                    }
                    catch (CmsException e) {
                        this.getReport().addWarning(e);
                        if (LOG.isWarnEnabled()) {
                            LOG.warn((Object)e.getLocalizedMessage());
                        }
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                try {
                    String resName = OpenCms.getOrgUnitManager().getResourcesForOrganizationalUnit(this.getCms(), CmsOrganizationalUnit.getParentFqn(orgUnitName)).get(0).getRootPath();
                    if (resources.contains(resName)) continue;
                    OpenCms.getOrgUnitManager().removeResourceFromOrgUnit(this.getCms(), orgUnitName, resName);
                }
                catch (CmsException e) {
                    this.getReport().addWarning(e);
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)e.getLocalizedMessage());
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        finally {
            this.getRequestContext().setSiteRoot(site);
        }
        this.m_orgUnitResources = null;
    }

    public int getAceFlags() {
        return this.m_aceFlags;
    }

    public int getAcePermissionsAllowed() {
        return this.m_acePermissionsAllowed;
    }

    public int getAcePermissionsDenied() {
        return this.m_acePermissionsDenied;
    }

    public CmsUUID getAcePrincipalId() {
        return this.m_acePrincipalId;
    }

    public CmsObject getCms() {
        return this.m_cms;
    }

    public long getDateCreated() {
        return this.m_resourceBuilder.getDateCreated();
    }

    public long getDateExpired() {
        return this.m_resourceBuilder.getDateExpired();
    }

    public long getDateLastModified() {
        return this.m_resourceBuilder.getDateLastModified();
    }

    public long getDateReleased() {
        return this.m_resourceBuilder.getDateReleased();
    }

    public String getDestination() {
        return this.m_destination;
    }

    public int getFlags() {
        return this.m_resourceBuilder.getFlags();
    }

    public String getGroupDescription() {
        return this.m_groupDescription;
    }

    public int getGroupFlags() {
        return this.m_groupFlags;
    }

    public String getGroupName() {
        return this.m_groupName;
    }

    public String getGroupParent() {
        return this.m_groupParent;
    }

    public String getOrgUnitDescription() {
        return this.m_orgUnitDescription;
    }

    public int getOrgUnitFlags() {
        return this.m_orgUnitFlags;
    }

    public String getOrgUnitName() {
        return this.m_orgUnitName;
    }

    public String getProjectDescription() {
        return this.m_projectDescription;
    }

    public String getProjectManagers() {
        return this.m_projectManagers;
    }

    public String getProjectName() {
        return this.m_projectName;
    }

    public String getProjectUsers() {
        return this.m_projectUsers;
    }

    public String getPropertyName() {
        return this.m_propertyName;
    }

    public String getPropertyValue() {
        return this.m_propertyValue;
    }

    public CmsUUID getRelationId() {
        return this.m_relationId;
    }

    public String getRelationPath() {
        return this.m_relationPath;
    }

    public CmsRelationType getRelationType() {
        return this.m_relationType;
    }

    public I_CmsReport getReport() {
        return this.m_report;
    }

    public CmsRequestContext getRequestContext() {
        return this.getCms().getRequestContext();
    }

    public CmsUUID getResourceId() {
        return this.m_resourceBuilder.getResourceId();
    }

    public String getSource() {
        return this.m_source;
    }

    public CmsUUID getStructureId() {
        return this.m_resourceBuilder.getStructureId();
    }

    public Throwable getThrowable() {
        return this.m_throwable;
    }

    public I_CmsResourceType getType() {
        return null;
    }

    public CmsUUID getUserCreated() {
        return this.m_resourceBuilder.getUserCreated();
    }

    public long getUserDateCreated() {
        return this.m_userDateCreated;
    }

    public String getUserEmail() {
        return this.m_userEmail;
    }

    public String getUserFirstname() {
        return this.m_userFirstname;
    }

    public int getUserFlags() {
        return this.m_userFlags;
    }

    public CmsUUID getUserLastModified() {
        return this.m_resourceBuilder.getUserLastModified();
    }

    public String getUserLastname() {
        return this.m_userLastname;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public String getUserPassword() {
        return this.m_userPassword;
    }

    @Override
    public int getVersion() {
        return 10;
    }

    public void importAccessControlEntries() {
        if (this.m_resource == null || !this.m_importACEs) {
            return;
        }
        if (this.m_aces == null || this.m_aces.size() == 0) {
            return;
        }
        try {
            this.getCms().importAccessControlEntries(this.m_resource, this.m_aces);
        }
        catch (CmsException exc) {
            this.getReport().println(Messages.get().container("RPT_IMPORT_ACL_DATA_FAILED_0"), 1);
        }
        finally {
            this.m_aces = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importData(CmsObject cms, I_CmsReport report, CmsImportParameters parameters) {
        this.m_cms = cms;
        this.m_report = report;
        this.m_parameters = parameters;
        Digester digester = new Digester();
        digester.setUseContextClassLoader(true);
        digester.setValidating(this.m_parameters.isXmlValidation());
        digester.setEntityResolver((EntityResolver)new CmsXmlEntityResolver(null));
        digester.setRuleNamespaceURI(null);
        digester.setErrorHandler((ErrorHandler)new CmsXmlErrorHandler("manifest.xml"));
        digester.push((Object)this);
        this.addXmlDigesterRules(digester);
        InputStream stream = null;
        this.m_helper = new CmsImportHelper(this.m_parameters);
        try {
            this.m_helper.openFile();
            this.m_helper.cacheDtdSystemId(DTD_LOCATION, DTD_FILENAME, "http://www.opencms.org/dtd/6.0/");
            this.findContentFiles();
            stream = this.m_helper.getFileStream("manifest.xml");
            digester.parse(stream);
        }
        catch (Exception ioe) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_IMPORTEXPORT_ERROR_READING_FILE_1", "manifest.xml"), (Throwable)ioe);
            }
            this.getReport().println(ioe);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception exception) {}
            this.m_helper.closeFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importGroup() {
        if (this.m_orgUnit == null) {
            return;
        }
        if (this.m_groupDescription == null) {
            this.m_groupDescription = "";
        }
        if (this.m_groupParents == null) {
            this.m_groupParents = new HashMap<String, List<String>>();
        }
        String groupName = this.m_orgUnit.getName() + this.m_groupName;
        try {
            if (this.m_throwable != null) {
                this.getReport().println(this.m_throwable);
                CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_GROUP_1", groupName);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)message.key(), this.m_throwable);
                }
                this.m_throwable = null;
                return;
            }
            this.getReport().print(Messages.get().container("RPT_IMPORT_GROUP_0"), 3);
            this.getReport().print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", groupName));
            this.getReport().print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            try {
                this.getCms().readGroup(groupName);
                this.getReport().println(Messages.get().container("RPT_NOT_CREATED_0"), 4);
            }
            catch (CmsDbEntryNotFoundException e) {
                CmsUUID parentGroupId = null;
                if (CmsStringUtil.isNotEmpty(this.m_groupParent)) {
                    try {
                        parentGroupId = this.getCms().readGroup(this.m_groupParent).getId();
                    }
                    catch (CmsDbEntryNotFoundException exc) {
                        List<String> childs = this.m_groupParents.get(this.m_groupParent);
                        if (childs == null) {
                            childs = new ArrayList<String>();
                            this.m_groupParents.put(this.m_groupParent, childs);
                        }
                        childs.add(groupName);
                    }
                }
                this.getCms().createGroup(groupName, this.m_groupDescription, this.m_groupFlags, parentGroupId == null ? null : this.m_groupParent);
                this.getReport().println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                List<String> childs = this.m_groupParents.remove(groupName);
                if (childs != null) {
                    for (String childGroup : childs) {
                        this.getCms().setParentGroup(childGroup, groupName);
                    }
                }
            }
        }
        catch (Exception e) {
            this.getReport().println(e);
            CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_GROUP_1", groupName);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key(), (Throwable)e);
            }
        }
        finally {
            this.m_groupDescription = null;
            this.m_groupFlags = 0;
            this.m_groupName = null;
            this.m_groupParent = null;
            this.m_throwable = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importOrgUnit() {
        try {
            if (this.m_throwable != null) {
                this.getReport().println(this.m_throwable);
                this.getReport().addError(this.m_throwable);
                CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_ORGUNITS_0");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)message.key(), this.m_throwable);
                }
                this.m_throwable = null;
                this.m_orgUnit = null;
                return;
            }
            this.getReport().print(Messages.get().container("RPT_IMPORT_ORGUNIT_0"), 3);
            this.getReport().print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", this.m_orgUnitName));
            this.getReport().print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            try {
                this.m_orgUnit = OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), this.m_orgUnitName);
                this.getReport().println(Messages.get().container("RPT_NOT_CREATED_0"), 4);
                this.m_orgUnitResources.remove(this.m_orgUnitName);
                return;
            }
            catch (CmsDataAccessException message) {
                try {
                    ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
                    String site = this.getRequestContext().getSiteRoot();
                    try {
                        this.getRequestContext().setSiteRoot("");
                        boolean remove = true;
                        List ouResources = CmsCollectionsGenericWrapper.list(this.m_orgUnitResources.get(this.m_orgUnitName));
                        if (ouResources != null) {
                            Iterator itResNames = ouResources.iterator();
                            while (itResNames.hasNext()) {
                                String resName = (String)itResNames.next();
                                try {
                                    resources.add(this.getCms().readResource(resName, CmsResourceFilter.ALL));
                                    itResNames.remove();
                                }
                                catch (CmsVfsResourceNotFoundException e) {
                                    remove = false;
                                }
                            }
                        }
                        if (remove) {
                            this.m_orgUnitResources.remove(this.m_orgUnitName);
                        }
                    }
                    finally {
                        this.getRequestContext().setSiteRoot(site);
                    }
                    if (resources.isEmpty()) {
                        resources.add(OpenCms.getOrgUnitManager().getResourcesForOrganizationalUnit(this.getCms(), CmsOrganizationalUnit.getParentFqn(this.m_orgUnitName)).get(0));
                    }
                    this.m_orgUnit = OpenCms.getOrgUnitManager().createOrganizationalUnit(this.getCms(), this.m_orgUnitName, this.m_orgUnitDescription, this.m_orgUnitFlags, ((CmsResource)resources.get(0)).getRootPath());
                    for (int i = 1; i < resources.size(); ++i) {
                        OpenCms.getOrgUnitManager().addResourceToOrgUnit(this.getCms(), this.m_orgUnitName, ((CmsResource)resources.get(i)).getRootPath());
                    }
                    this.getReport().println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                    this.m_orgUnitName = null;
                    this.m_orgUnitDescription = null;
                    this.m_orgUnitFlags = 0;
                }
                catch (CmsException e) {
                    this.getReport().println(e);
                    this.getReport().addError(e);
                    CmsMessageContainer message2 = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_ORGUNITS_0");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)message2.key(), (Throwable)e);
                    }
                    this.m_throwable = null;
                    this.m_orgUnit = null;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.m_orgUnitName = null;
            this.m_orgUnitDescription = null;
            this.m_orgUnitFlags = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importProject() {
        try {
            if (this.m_throwable != null) {
                this.getReport().println(this.m_throwable);
                this.getReport().addError(this.m_throwable);
                CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_PROJECTS_0");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)message.key(), this.m_throwable);
                }
                this.m_throwable = null;
                return;
            }
            this.getReport().print(Messages.get().container("RPT_IMPORT_PROJECT_0"), 3);
            this.getReport().print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", this.m_projectName));
            this.getReport().print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            try {
                this.getCms().readProject(this.m_projectName);
                this.getReport().println(Messages.get().container("RPT_NOT_CREATED_0"), 4);
                return;
            }
            catch (CmsDataAccessException message) {
                try {
                    CmsProject project = this.getCms().createProject(this.m_projectName, this.m_projectDescription, this.m_projectUsers, this.m_projectManagers, CmsProject.PROJECT_TYPE_NORMAL);
                    if (this.m_projectResources != null) {
                        String site = this.getRequestContext().getSiteRoot();
                        CmsProject currentProject = this.getRequestContext().getCurrentProject();
                        try {
                            this.getRequestContext().setSiteRoot("");
                            this.getRequestContext().setCurrentProject(project);
                            for (String resName : this.m_projectResources) {
                                try {
                                    this.getCms().copyResourceToProject(resName);
                                }
                                catch (CmsVfsResourceNotFoundException cmsVfsResourceNotFoundException) {}
                            }
                        }
                        finally {
                            this.getRequestContext().setSiteRoot(site);
                            this.getRequestContext().setCurrentProject(currentProject);
                        }
                    }
                    this.getReport().println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                    this.m_projectName = null;
                    this.m_projectDescription = null;
                    this.m_projectManagers = null;
                    this.m_projectUsers = null;
                    this.m_projectResources = null;
                }
                catch (CmsException e) {
                    this.getReport().println(e);
                    this.getReport().addError(e);
                    CmsMessageContainer message2 = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_PROJECTS_0");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)message2.key(), (Throwable)e);
                    }
                    this.m_throwable = null;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.m_projectName = null;
            this.m_projectDescription = null;
            this.m_projectManagers = null;
            this.m_projectUsers = null;
            this.m_projectResources = null;
        }
    }

    public void importRelations() {
        if (this.m_relationData == null || this.m_relationData.isEmpty()) {
            return;
        }
        this.getReport().println(Messages.get().container("RPT_START_IMPORT_RELATIONS_0"), 2);
        int i = 0;
        CmsResourceFilter filter = CmsResourceFilter.ALL;
        for (Integer importIndex : this.m_relationData.keySet()) {
            CmsUUID structureId = this.m_indexToStructureId.get(importIndex);
            if (structureId == null) continue;
            Collection relationDataList = this.m_relationData.get((Object)importIndex);
            try {
                CmsResource src = this.m_cms.readResource(structureId, filter);
                if (this.checkImmutable(src.getRootPath())) continue;
                this.getReport().print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", String.valueOf(i + 1), String.valueOf(this.m_relationData.keySet().size())), 3);
                this.getReport().print(Messages.get().container("RPT_IMPORTING_RELATIONS_FOR_2", src.getRootPath(), new Integer(this.m_relationData.keySet().size())), 3);
                this.getReport().print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                boolean withErrors = false;
                for (RelationData relationData : relationDataList) {
                    CmsResource target = null;
                    if (relationData.getTargetId() != null) {
                        try {
                            target = this.m_cms.readResource(relationData.getTargetId(), filter);
                        }
                        catch (CmsVfsResourceNotFoundException cmsVfsResourceNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (target == null) {
                        try {
                            target = this.m_cms.readResource(relationData.getTarget(), filter);
                        }
                        catch (CmsVfsResourceNotFoundException cmsVfsResourceNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (target == null) continue;
                    try {
                        this.getCms().importRelation(this.m_cms.getSitePath(src), this.m_cms.getSitePath(target), relationData.getType().toString());
                    }
                    catch (CmsException e) {
                        this.getReport().addWarning(e);
                        withErrors = true;
                        if (LOG.isWarnEnabled()) {
                            LOG.warn((Object)e.getLocalizedMessage());
                        }
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                if (!withErrors) {
                    this.getReport().println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                } else {
                    this.getReport().println(org.opencms.report.Messages.get().container("RPT_FAILED_0"), 5);
                }
                ++i;
            }
            catch (CmsException e) {
                this.getReport().addError(e);
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public void importResource() {
        this.m_resourceIdWasNull = false;
        try {
            if (this.m_throwable != null) {
                this.getReport().println(this.m_throwable);
                this.getReport().addError(this.m_throwable);
                CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_RESOURCES_0");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)message.key(), this.m_throwable);
                }
                this.m_throwable = null;
                this.m_importACEs = false;
                this.m_resource = null;
                return;
            }
            String translatedName = this.getRequestContext().addSiteRoot(CmsStringUtil.joinPaths(this.m_parameters.getDestinationPath(), this.m_destination));
            boolean resourceImmutable = this.checkImmutable(translatedName);
            translatedName = this.getRequestContext().removeSiteRoot(translatedName);
            if (!resourceImmutable) {
                this.getReport().print(Messages.get().container("RPT_IMPORTING_0"), 3);
                this.getReport().print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", translatedName));
                this.getReport().print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                boolean exists = this.getCms().existsResource(translatedName, CmsResourceFilter.ALL);
                byte[] content = null;
                if (this.m_source != null) {
                    content = this.m_helper.getFileBytes(this.m_source);
                }
                int size = 0;
                if (content != null) {
                    size = content.length;
                }
                this.setDefaultsForEmptyResourceFields();
                CmsResource resource = this.createResourceObjectFromFields(translatedName, size);
                if (!OpenCms.getResourceManager().hasResourceType(this.m_typeName)) {
                    this.m_properties.put("export.type", new CmsProperty("export.type", null, this.m_typeName, true));
                }
                if (this.m_resourceBuilder.getType().isFolder() || this.m_resourceIdWasNull || this.hasContentInVfsOrImport(resource)) {
                    this.m_resource = this.getCms().importResource(translatedName, resource, content, new ArrayList<CmsProperty>(this.m_properties.values()));
                }
                if (this.m_resource != null) {
                    this.m_indexToStructureId.put(this.m_fileCounter, this.m_resource.getStructureId());
                }
                boolean bl = this.m_importACEs = this.m_resource != null && (!exists || !this.m_parameters.isKeepPermissions());
                if (this.m_resource != null) {
                    this.getReport().println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                    if (OpenCms.getResourceManager().getResourceType(this.m_resource.getTypeId()) instanceof I_CmsLinkParseable) {
                        this.m_parseables.add(this.m_resource);
                    }
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)Messages.get().getBundle().key("LOG_IMPORTING_4", new Object[]{String.valueOf(this.m_fileCounter), String.valueOf(this.m_totalFiles), translatedName, this.m_destination}));
                    }
                } else {
                    this.getReport().print(Messages.get().container("RPT_SKIPPING_0"), 3);
                    this.getReport().println(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", translatedName));
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)Messages.get().getBundle().key("LOG_SKIPPING_3", String.valueOf(this.m_fileCounter), String.valueOf(this.m_totalFiles), translatedName));
                    }
                }
            } else {
                this.m_resource = null;
                this.getReport().print(Messages.get().container("RPT_SKIPPING_0"), 3);
                this.getReport().println(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", translatedName));
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)Messages.get().getBundle().key("LOG_SKIPPING_3", String.valueOf(this.m_fileCounter), String.valueOf(this.m_totalFiles), translatedName));
                }
                this.m_importACEs = false;
            }
        }
        catch (Exception e) {
            this.m_resource = null;
            this.m_importACEs = false;
            this.getReport().println(e);
            this.getReport().addError(e);
            CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_RESOURCES_0");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key(), (Throwable)e);
            }
            return;
        }
    }

    public void importResourceAll() {
        try {
            this.importResource();
            this.importAccessControlEntries();
            this.increaseCounter();
        }
        finally {
            this.m_destination = null;
            this.m_source = null;
            this.m_throwable = null;
            this.m_properties = null;
            this.m_aces = null;
        }
    }

    @Override
    @Deprecated
    public void importResources(CmsObject cms, String importPath, I_CmsReport report, File importResource, ZipFile importZip, Document docXml) {
        CmsImportParameters params = new CmsImportParameters(importResource.getAbsolutePath(), importPath, true);
        this.importData(cms, report, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importUser() {
        String userName = this.m_orgUnit.getName() + this.m_userName;
        try {
            if (this.m_throwable != null) {
                this.m_user = null;
                this.getReport().println(this.m_throwable);
                CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_USER_1", userName);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)message.key(), this.m_throwable);
                }
                this.m_throwable = null;
                return;
            }
            this.getReport().print(Messages.get().container("RPT_IMPORT_USER_0"), 3);
            this.getReport().print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", userName));
            this.getReport().print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            try {
                this.getCms().readUser(userName);
                this.getReport().println(Messages.get().container("RPT_NOT_CREATED_0"), 4);
                this.m_user = null;
                return;
            }
            catch (CmsDbEntryNotFoundException message) {
                try {
                    CmsParameterConfiguration config = OpenCms.getPasswordHandler().getConfiguration();
                    if (config != null && config.containsKey("compatibility.convert.digestencoding") && config.getBoolean("compatibility.convert.digestencoding", false)) {
                        this.m_userPassword = this.convertDigestEncoding(this.m_userPassword);
                    }
                    this.m_user = this.getCms().importUser(new CmsUUID().toString(), userName, this.m_userPassword, this.m_userFirstname, this.m_userLastname, this.m_userEmail, this.m_userFlags, this.m_userDateCreated, this.m_userInfos);
                    this.getReport().println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                    this.m_userName = null;
                    this.m_userPassword = null;
                    this.m_userFirstname = null;
                    this.m_userLastname = null;
                    this.m_userEmail = null;
                    this.m_userFlags = 0;
                    this.m_userDateCreated = 0L;
                    this.m_userInfos = null;
                }
                catch (Throwable e) {
                    this.m_user = null;
                    this.getReport().println(e);
                    CmsMessageContainer message2 = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_USER_1", userName);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)message2.key(), e);
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.m_userName = null;
            this.m_userPassword = null;
            this.m_userFirstname = null;
            this.m_userLastname = null;
            this.m_userEmail = null;
            this.m_userFlags = 0;
            this.m_userDateCreated = 0L;
            this.m_userInfos = null;
        }
    }

    public void importUserGroup(String groupName) {
        block7: {
            if (this.m_throwable != null || this.m_user == null) {
                return;
            }
            groupName = OpenCms.getImportExportManager().translateGroup(groupName);
            try {
                String ouName = CmsOrganizationalUnit.getParentFqn(groupName);
                try {
                    OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), ouName);
                    this.getCms().addUserToGroup(this.m_user.getName(), groupName);
                    return;
                }
                catch (CmsDbEntryNotFoundException cmsDbEntryNotFoundException) {
                    Map<String, String> groups;
                    Map<String, Map<String, String>> membership = this.m_membership.get(ouName);
                    if (membership == null) {
                        membership = new HashMap<String, Map<String, String>>();
                        this.m_membership.put(ouName, membership);
                    }
                    if ((groups = membership.get("GROUP")) == null) {
                        groups = new HashMap<String, String>();
                        membership.put("GROUP", groups);
                    }
                    groups.put(this.m_user.getName(), groupName);
                }
            }
            catch (Throwable e) {
                this.getReport().println(Messages.get().container("RPT_USER_COULDNT_BE_ADDED_TO_GROUP_2", this.m_user.getName(), groupName), 1);
                if (!LOG.isDebugEnabled()) break block7;
                LOG.debug((Object)e.getLocalizedMessage(), e);
            }
        }
    }

    public void importUserInfo(String infoName, String infoType, String infoValue) {
        block3: {
            if (this.m_userInfos == null) {
                this.m_userInfos = new HashMap<String, Object>();
            }
            try {
                this.m_userInfos.put(infoName, CmsDataTypeUtil.dataImport(infoValue, infoType));
            }
            catch (Throwable e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)e.getLocalizedMessage(), e);
            }
        }
    }

    public void importUserRole(String roleName) {
        block7: {
            if (this.m_throwable != null || this.m_user == null) {
                return;
            }
            try {
                CmsRole role = CmsRole.valueOfRoleName(roleName);
                try {
                    OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), role.getOuFqn());
                    OpenCms.getRoleManager().addUserToRole(this.getCms(), role, this.m_user.getName());
                    return;
                }
                catch (CmsDbEntryNotFoundException cmsDbEntryNotFoundException) {
                    Map<String, String> roles;
                    Map<String, Map<String, String>> membership = this.m_membership.get(role.getOuFqn());
                    if (membership == null) {
                        membership = new HashMap<String, Map<String, String>>();
                        this.m_membership.put(role.getOuFqn(), membership);
                    }
                    if ((roles = membership.get("USER")) == null) {
                        roles = new HashMap<String, String>();
                        membership.put("USER", roles);
                    }
                    roles.put(this.m_user.getName(), role.getFqn());
                }
            }
            catch (Throwable e) {
                this.getReport().println(Messages.get().container("RPT_USER_COULDNT_BE_ADDED_TO_ROLE_2", this.m_user.getName(), roleName), 1);
                if (!LOG.isDebugEnabled()) break block7;
                LOG.debug((Object)e.getLocalizedMessage(), e);
            }
        }
    }

    public void increaseCounter() {
        ++this.m_fileCounter;
    }

    public void increaseTotalFiles() {
        ++this.m_totalFiles;
    }

    @Override
    public boolean matches(CmsImportParameters parameters) throws CmsImportExportException {
        this.m_fileCounter = 1;
        this.m_totalFiles = 0;
        this.m_parseables = new ArrayList<CmsResource>();
        this.m_parameters = parameters;
        Digester digester = new Digester();
        digester.setUseContextClassLoader(true);
        digester.setValidating(this.m_parameters.isXmlValidation());
        digester.setEntityResolver((EntityResolver)new CmsXmlEntityResolver(null));
        digester.setRuleNamespaceURI(null);
        digester.setErrorHandler((ErrorHandler)new CmsXmlErrorHandler("manifest.xml"));
        digester.push((Object)this);
        this.addXmlPreprocessingDigesterRules(digester);
        InputStream stream = null;
        this.m_helper = new CmsImportHelper(this.m_parameters);
        this.m_helper.cacheDtdSystemId(DTD_LOCATION, DTD_FILENAME, "http://www.opencms.org/dtd/6.0/");
        try {
            this.m_helper.openFile();
            stream = this.m_helper.getFileStream("manifest.xml");
            digester.parse(stream);
        }
        catch (Exception ioe) {
            CmsMessageContainer msg = Messages.get().container("ERR_IMPORTEXPORT_ERROR_READING_FILE_1", "manifest.xml");
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)msg.key(), (Throwable)ioe);
            }
            throw new CmsImportExportException(msg, (Throwable)ioe);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception exception) {}
            this.m_helper.closeFile();
        }
        return this.m_version == this.getVersion();
    }

    public void rewriteParseables() {
        if (this.m_parseables.isEmpty()) {
            return;
        }
        I_CmsReport report = this.getReport();
        CmsObject cms = this.getCms();
        cms.getRequestContext().setAttribute("ATTR_LOG_ENTRY", Boolean.FALSE);
        report.println(Messages.get().container("RPT_START_PARSE_LINKS_0"), 2);
        CmsImportVersion10.parseLinks(cms, this.m_parseables, report);
        report.println(Messages.get().container("RPT_END_PARSE_LINKS_0"), 2);
        this.m_parseables = null;
    }

    public void setAceFlags(String aceFlags) {
        try {
            this.m_aceFlags = Integer.parseInt(aceFlags);
        }
        catch (Throwable e) {
            this.m_throwable = e;
        }
    }

    public void setAcePermissionsAllowed(String acePermissionsAllowed) {
        try {
            this.m_acePermissionsAllowed = Integer.parseInt(acePermissionsAllowed);
        }
        catch (Throwable e) {
            this.m_throwable = e;
        }
    }

    public void setAcePermissionsDenied(String acePermissionsDenied) {
        try {
            this.m_acePermissionsDenied = Integer.parseInt(acePermissionsDenied);
        }
        catch (Throwable e) {
            this.m_throwable = e;
        }
    }

    public void setAcePrincipalId(String acePrincipalId) {
        try {
            CmsUUID principalId = null;
            String principal = acePrincipalId.substring(acePrincipalId.indexOf(46) + 1, acePrincipalId.length());
            if (acePrincipalId.startsWith("GROUP")) {
                principal = OpenCms.getImportExportManager().translateGroup(principal);
                principalId = this.getCms().readGroup(principal).getId();
            } else if (acePrincipalId.startsWith("USER")) {
                principal = OpenCms.getImportExportManager().translateUser(principal);
                principalId = this.getCms().readUser(principal).getId();
            } else if (acePrincipalId.startsWith("ROLE")) {
                principalId = CmsRole.valueOfRoleName(principal).getId();
            } else if (acePrincipalId.equalsIgnoreCase("ALL_OTHERS")) {
                principalId = CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID;
            } else if (acePrincipalId.equalsIgnoreCase("OVERWRITE_ALL")) {
                principalId = CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID;
            } else {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_ERROR_IMPORTING_ACE_1", acePrincipalId));
                }
                throw new CmsIllegalStateException(Messages.get().container("LOG_IMPORTEXPORT_ERROR_IMPORTING_ACE_1", acePrincipalId));
            }
            this.m_acePrincipalId = principalId;
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setDateCreated(String dateCreated) {
        try {
            if (dateCreated != null) {
                this.m_resourceBuilder.setDateCreated(this.convertTimestamp(dateCreated));
            } else {
                this.m_resourceBuilder.setDateCreated(System.currentTimeMillis());
            }
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setDateExpired(String dateExpired) {
        try {
            if (dateExpired != null) {
                this.m_resourceBuilder.setDateExpired(this.convertTimestamp(dateExpired));
            } else {
                this.m_resourceBuilder.setDateExpired(Long.MAX_VALUE);
            }
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setDateLastModified(String dateLastModified) {
        this.m_hasDateLastModified = true;
        try {
            if (dateLastModified != null) {
                CmsImportExportManager.TimestampMode timeMode = CmsImportExportManager.TimestampMode.getEnum(CmsMacroResolver.stripMacro(dateLastModified));
                switch (timeMode) {
                    case FILETIME: {
                        this.m_resourceBuilder.setDateLastModified(-1L);
                        break;
                    }
                    case IMPORTTIME: {
                        this.m_resourceBuilder.setDateLastModified(System.currentTimeMillis());
                        break;
                    }
                    default: {
                        this.m_resourceBuilder.setDateLastModified(this.convertTimestamp(dateLastModified));
                        break;
                    }
                }
            } else {
                this.m_resourceBuilder.setDateLastModified(System.currentTimeMillis());
            }
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setDateReleased(String dateReleased) {
        try {
            if (dateReleased != null) {
                this.m_resourceBuilder.setDateReleased(this.convertTimestamp(dateReleased));
            } else {
                this.m_resourceBuilder.setDateReleased(0L);
            }
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setDestination(String destination) {
        this.m_destination = destination;
    }

    public void setFlags(String flags) {
        try {
            this.m_resourceBuilder.setFlags(Integer.parseInt(flags));
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setGroupDescription(String groupDescription) {
        this.m_groupDescription = groupDescription;
    }

    public void setGroupFlags(String groupFlags) {
        try {
            this.m_groupFlags = Integer.parseInt(groupFlags);
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setGroupName(String groupName) {
        this.m_groupName = OpenCms.getImportExportManager().translateGroup(groupName);
    }

    public void setGroupParent(String groupParent) {
        this.m_groupParent = OpenCms.getImportExportManager().translateGroup(groupParent);
    }

    public void setMembership() {
        Map<String, String> roles;
        if (this.m_orgUnit == null || this.m_membership == null) {
            return;
        }
        Map<String, Map<String, String>> membership = this.m_membership.get(this.m_orgUnit.getName());
        if (membership == null) {
            return;
        }
        Map<String, String> groups = membership.get("GROUP");
        if (groups != null) {
            for (Map.Entry<String, String> entry : groups.entrySet()) {
                String userName = entry.getKey();
                String groupName = entry.getValue();
                try {
                    this.getCms().addUserToGroup(userName, groupName);
                }
                catch (Throwable e) {
                    this.getReport().println(Messages.get().container("RPT_USER_COULDNT_BE_ADDED_TO_GROUP_2", userName, groupName), 1);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)e.getLocalizedMessage(), e);
                }
            }
        }
        if ((roles = membership.get("USER")) != null) {
            for (Map.Entry<String, String> entry : roles.entrySet()) {
                String userName = entry.getKey();
                String roleName = entry.getValue();
                CmsRole role = CmsRole.valueOfRoleName(roleName);
                try {
                    OpenCms.getRoleManager().addUserToRole(this.getCms(), role, userName);
                    return;
                }
                catch (Throwable e) {
                    this.getReport().println(Messages.get().container("RPT_USER_COULDNT_BE_ADDED_TO_ROLE_2", userName, roleName), 1);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)e.getLocalizedMessage(), e);
                }
            }
        }
    }

    public void setOrgUnitDescription(String orgUnitDescription) {
        this.m_orgUnitDescription = orgUnitDescription;
    }

    public void setOrgUnitFlags(String orgUnitFlags) {
        try {
            this.m_orgUnitFlags = Integer.parseInt(orgUnitFlags);
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setOrgUnitName(String orgUnitName) {
        this.m_orgUnitName = orgUnitName;
    }

    public void setProjectDescription(String projectDescription) {
        this.m_projectDescription = projectDescription;
    }

    public void setProjectManagers(String projectManagers) {
        this.m_projectManagers = projectManagers;
    }

    public void setProjectName(String projectName) {
        this.m_projectName = projectName;
    }

    public void setProjectUsers(String projectUsers) {
        this.m_projectUsers = projectUsers;
    }

    public void setPropertyName(String propertyName) {
        this.m_propertyName = propertyName;
    }

    public void setPropertyValue(String propertyValue) {
        this.m_propertyValue = propertyValue;
    }

    public void setRelationId(String relationId) {
        try {
            this.m_relationId = new CmsUUID(relationId);
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setRelationPath(String relationPath) {
        this.m_relationPath = relationPath;
    }

    public void setRelationType(String relationType) {
        try {
            this.m_relationType = CmsRelationType.valueOf(relationType);
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setResourceId(String resourceId) {
        try {
            if (!this.m_resourceBuilder.isFolder()) {
                this.m_resourceBuilder.setResourceId(new CmsUUID(resourceId));
            } else {
                this.m_resourceBuilder.setResourceId(new CmsUUID());
            }
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setSource(String source) {
        this.m_source = source;
    }

    public void setStructureId(String structureId) {
        try {
            this.m_resourceBuilder.setStructureId(new CmsUUID(structureId));
            this.m_hasStructureId = true;
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setThrowable(Throwable throwable) {
        this.m_throwable = throwable;
    }

    public void setType(String typeName) {
        this.m_typeName = typeName;
        try {
            try {
                this.m_resourceBuilder.setType(OpenCms.getResourceManager().getResourceType(typeName));
            }
            catch (CmsLoaderException e) {
                try {
                    this.m_resourceBuilder.setType(OpenCms.getResourceManager().getResourceType(CmsResourceTypePlain.getStaticTypeName()));
                }
                catch (CmsLoaderException e1) {
                    this.m_resourceBuilder.setType(OpenCms.getResourceManager().getResourceType(CmsResourceTypePlain.getStaticTypeName()));
                }
            }
            if (this.m_resourceBuilder.getType().isFolder() && !CmsResource.isFolder(this.m_destination)) {
                this.m_destination = this.m_destination + "/";
            }
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setUserCreated(CmsUUID userCreated) {
        this.m_resourceBuilder.setUserCreated(userCreated);
    }

    public void setUserCreated(String userCreated) {
        try {
            String userCreatedName = OpenCms.getImportExportManager().translateUser(userCreated);
            try {
                this.m_resourceBuilder.setUserCreated(this.getCms().readUser(userCreatedName).getId());
            }
            catch (CmsDbEntryNotFoundException e) {
                this.m_resourceBuilder.setUserCreated(this.getRequestContext().getCurrentUser().getId());
            }
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setUserDateCreated(String userDateCreated) {
        try {
            this.m_userDateCreated = this.convertTimestamp(userDateCreated);
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setUserEmail(String userEmail) {
        this.m_userEmail = userEmail;
    }

    public void setUserFirstname(String userFirstname) {
        this.m_userFirstname = userFirstname;
    }

    public void setUserFlags(String userFlags) {
        try {
            this.m_userFlags = Integer.parseInt(userFlags);
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setUserLastModified(CmsUUID userLastModified) {
        this.m_resourceBuilder.setUserLastModified(userLastModified);
    }

    public void setUserLastModified(String userLastModified) {
        if (null == userLastModified) {
            this.m_resourceBuilder.setUserLastModified(this.getRequestContext().getCurrentUser().getId());
        } else {
            try {
                String userLastModifiedName = OpenCms.getImportExportManager().translateUser(userLastModified);
                try {
                    this.m_resourceBuilder.setUserLastModified(this.getCms().readUser(userLastModifiedName).getId());
                }
                catch (CmsDbEntryNotFoundException e) {
                    this.m_resourceBuilder.setUserLastModified(this.getRequestContext().getCurrentUser().getId());
                }
            }
            catch (Throwable e) {
                this.setThrowable(e);
            }
        }
    }

    public void setUserLastname(String userLastname) {
        this.m_userLastname = userLastname;
    }

    public void setUserName(String userName) {
        this.m_userName = OpenCms.getImportExportManager().translateUser(userName);
    }

    public void setUserPassword(String userPassword) {
        this.m_userPassword = new String(Base64.decodeBase64((byte[])userPassword.trim().getBytes()));
    }

    public void setVersion(String version) {
        this.m_version = Integer.parseInt(version);
    }

    protected void addAccountsGroupRules(Digester digester, String xpath) {
        String xp_group = xpath + N_GROUPS + "/" + N_GROUP;
        digester.addCallMethod(xp_group, "importGroup");
        xp_group = xp_group + "/";
        digester.addCallMethod(xp_group + "name", "setGroupName", 0);
        digester.addCallMethod(xp_group + N_DESCRIPTION, "setGroupDescription", 0);
        digester.addCallMethod(xp_group + N_FLAGS, "setGroupFlags", 0);
        digester.addCallMethod(xp_group + N_PARENTGROUP, "setGroupParent", 0);
    }

    protected void addAccountsOrgunitRules(Digester digester, String xpath) {
        digester.addCallMethod(xpath + "name", "setOrgUnitName", 0);
        digester.addCallMethod(xpath + N_DESCRIPTION, "setOrgUnitDescription", 0);
        digester.addCallMethod(xpath + N_FLAGS, "setOrgUnitFlags", 0);
        digester.addCallMethod(xpath + N_RESOURCES + "/" + N_RESOURCE, "addOrgUnitResource", 0);
        digester.addCallMethod(xpath + N_RESOURCES, "importOrgUnit");
    }

    protected void addAccountsUserRules(Digester digester, String xpath) {
        String xp_user = xpath + N_USERS + "/" + N_USER + "/";
        digester.addCallMethod(xp_user + "name", "setUserName", 0);
        digester.addCallMethod(xp_user + N_PASSWORD, "setUserPassword", 0);
        digester.addCallMethod(xp_user + N_FIRSTNAME, "setUserFirstname", 0);
        digester.addCallMethod(xp_user + N_LASTNAME, "setUserLastname", 0);
        digester.addCallMethod(xp_user + N_EMAIL, "setUserEmail", 0);
        digester.addCallMethod(xp_user + N_FLAGS, "setUserFlags", 0);
        digester.addCallMethod(xp_user + N_DATECREATED, "setUserDateCreated", 0);
        digester.addCallMethod(xp_user + N_USERINFO, "importUser");
        String xp_info = xp_user + N_USERINFO + "/" + N_USERINFO_ENTRY;
        digester.addCallMethod(xp_info, "importUserInfo", 3);
        digester.addCallParam(xp_info, 0, "name");
        digester.addCallParam(xp_info, 1, "type");
        digester.addCallParam(xp_info, 2);
        digester.addCallMethod(xp_user + N_USERROLES + "/" + N_USERROLE, "importUserRole", 0);
        digester.addCallMethod(xp_user + N_USERGROUPS + "/" + N_USERGROUP, "importUserGroup", 0);
    }

    protected void addProjectRules(Digester digester, String xpath) {
        digester.addCallMethod(xpath + "name", "setProjectName", 0);
        digester.addCallMethod(xpath + N_DESCRIPTION, "setProjectDescription", 0);
        digester.addCallMethod(xpath + N_MANAGERSGROUP, "setProjectManagers", 0);
        digester.addCallMethod(xpath + N_USERSGROUP, "setProjectUsers", 0);
        digester.addCallMethod(xpath + N_RESOURCES + "/" + N_RESOURCE, "addProjectResource", 0);
        digester.addCallMethod(xpath + N_RESOURCES, "importProject");
    }

    protected void addResourceAceRules(Digester digester, String xpath) {
        String xp_ace = xpath + N_ACCESSCONTROL_ENTRIES + "/" + N_ACCESSCONTROL_ENTRY;
        digester.addCallMethod(xp_ace, "addAccessControlEntry");
        digester.addCallMethod(xp_ace + "/" + N_ACCESSCONTROL_PRINCIPAL, "setAcePrincipalId", 0);
        digester.addCallMethod(xp_ace + "/" + N_FLAGS, "setAceFlags", 0);
        String xp_perms = xp_ace + "/" + N_ACCESSCONTROL_PERMISSIONSET + "/";
        digester.addCallMethod(xp_perms + N_ACCESSCONTROL_ALLOWEDPERMISSIONS, "setAcePermissionsAllowed", 0);
        digester.addCallMethod(xp_perms + N_ACCESSCONTROL_DENIEDPERMISSIONS, "setAcePermissionsDenied", 0);
    }

    protected void addResourceAttributesRules(Digester digester, String xpath) {
        digester.addCallMethod(xpath + N_SOURCE, "setSource", 0);
        digester.addCallMethod(xpath + N_DESTINATION, "setDestination", 0);
        digester.addCallMethod(xpath + "type", "setType", 0);
        digester.addCallMethod(xpath + N_UUIDSTRUCTURE, "setStructureId", 0);
        digester.addCallMethod(xpath + N_UUIDRESOURCE, "setResourceId", 0);
        digester.addCallMethod(xpath + N_DATELASTMODIFIED, "setDateLastModified", 0);
        digester.addCallMethod(xpath + N_USERLASTMODIFIED, "setUserLastModified", 0);
        digester.addCallMethod(xpath + N_DATECREATED, "setDateCreated", 0);
        digester.addCallMethod(xpath + N_USERCREATED, "setUserCreated", 0);
        digester.addCallMethod(xpath + N_DATERELEASED, "setDateReleased", 0);
        digester.addCallMethod(xpath + N_DATEEXPIRED, "setDateExpired", 0);
        digester.addCallMethod(xpath + N_FLAGS, "setFlags", 0);
    }

    protected void addResourcePropertyRules(Digester digester, String xpath) {
        String xp_props = xpath + N_PROPERTIES + "/" + N_PROPERTY;
        digester.addCallMethod(xp_props, "addProperty");
        digester.addCallMethod(xp_props, "addProperty", 1);
        digester.addCallParam(xp_props, 0, "type");
        digester.addCallMethod(xp_props + "/" + "name", "setPropertyName", 0);
        digester.addCallMethod(xp_props + "/" + N_VALUE, "setPropertyValue", 0);
    }

    protected void addResourceRelationRules(Digester digester, String xpath) {
        String xp_rels = xpath + N_RELATIONS + "/" + N_RELATION;
        digester.addCallMethod(xp_rels, "addRelation");
        digester.addCallMethod(xp_rels + "/" + N_ID, "setRelationId", 0);
        digester.addCallMethod(xp_rels + "/" + N_PATH, "setRelationPath", 0);
        digester.addCallMethod(xp_rels + "/" + "type", "setRelationType", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkImmutable(String resourceName) {
        boolean resourceImmutable = false;
        if (this.getImmutableResources().contains(resourceName)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_RESOURCENAME_IMMUTABLE_1", resourceName));
            }
            String storedSiteRoot = this.getRequestContext().getSiteRoot();
            try {
                this.getRequestContext().setSiteRoot("/");
                this.getCms().readResource(resourceName);
                resourceImmutable = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_IMMUTABLE_FLAG_SET_1", resourceName));
                }
            }
            catch (CmsException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_ERROR_ON_TEST_IMMUTABLE_1", resourceName), (Throwable)e);
                }
            }
            finally {
                this.getRequestContext().setSiteRoot(storedSiteRoot);
            }
        }
        return resourceImmutable;
    }

    protected String convertDigestEncoding(String value) {
        byte[] data = new byte[value.length() / 2];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(Integer.parseInt(value.substring(i * 2, i * 2 + 2), 16) - 128);
        }
        return new String(Base64.encodeBase64((byte[])data));
    }

    protected long convertTimestamp(String timestamp) {
        long value = 0L;
        try {
            value = Long.parseLong(timestamp);
        }
        catch (NumberFormatException e) {
            try {
                value = CmsDateUtil.parseHeaderDate(timestamp);
            }
            catch (ParseException pe) {
                value = System.currentTimeMillis();
            }
        }
        return value;
    }

    protected CmsResource createResourceObjectFromFields(String translatedName, int size) {
        this.m_resourceBuilder.setRootPath(translatedName);
        this.m_resourceBuilder.setState(CmsResource.STATE_NEW);
        this.m_resourceBuilder.setProjectLastModified(this.getRequestContext().getCurrentProject().getUuid());
        this.m_resourceBuilder.setLength(size);
        this.m_resourceBuilder.setSiblingCount(1);
        this.m_resourceBuilder.setVersion(0);
        this.m_resourceBuilder.setDateContent(System.currentTimeMillis());
        return this.m_resourceBuilder.buildResource();
    }

    protected void findContentFiles() throws CmsImportExportException, IOException, SAXException {
        Digester digester = new Digester();
        digester.setUseContextClassLoader(true);
        digester.setValidating(false);
        digester.setEntityResolver((EntityResolver)new CmsXmlEntityResolver(null));
        digester.setRuleNamespaceURI(null);
        digester.setErrorHandler((ErrorHandler)new CmsXmlErrorHandler("manifest.xml"));
        digester.addCallMethod("export/files/file", "addContentFile", 2);
        digester.addCallParam("export/files/file/source", 0);
        digester.addCallParam("export/files/file/uuidresource", 1);
        this.m_contentFiles.clear();
        digester.push((Object)this);
        try (InputStream stream = null;){
            stream = this.m_helper.getFileStream("manifest.xml");
            digester.parse(stream);
        }
    }

    protected CmsImportHelper getHelper() {
        return this.m_helper;
    }

    protected List<String> getIgnoredProperties() {
        if (this.m_ignoredProperties == null) {
            this.m_ignoredProperties = OpenCms.getImportExportManager().getIgnoredProperties();
            if (this.m_ignoredProperties == null) {
                this.m_ignoredProperties = Collections.emptyList();
            }
        }
        return this.m_ignoredProperties;
    }

    protected List<String> getImmutableResources() {
        if (this.m_immutables == null) {
            this.m_immutables = OpenCms.getImportExportManager().getImmutableResources();
            if (this.m_immutables == null) {
                this.m_immutables = Collections.emptyList();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_IMMUTABLE_RESOURCES_SIZE_1", Integer.toString(this.m_immutables.size())));
            }
        }
        return this.m_immutables;
    }

    protected void setDefaultsForEmptyResourceFields() throws CmsImportExportException {
        if (this.m_resourceBuilder.getStructureId() == null) {
            this.m_resourceBuilder.setStructureId(new CmsUUID());
        }
        if (this.m_resourceBuilder.getResourceId() == null || this.m_resourceBuilder.getType().isFolder()) {
            this.m_resourceBuilder.setResourceId(new CmsUUID());
            this.m_resourceIdWasNull = true;
        }
        if (this.m_resourceBuilder.getDateLastModified() == -1L) {
            if (null != this.m_source) {
                this.m_resourceBuilder.setDateLastModified(this.m_helper.getFileModification(this.m_source));
            } else {
                this.m_resourceBuilder.setDateLastModified(System.currentTimeMillis());
            }
        }
        if (this.m_resourceBuilder.getDateLastModified() == -2L) {
            this.m_resourceBuilder.setDateLastModified(System.currentTimeMillis());
        }
        if (null == this.m_resourceBuilder.getUserLastModified()) {
            this.m_resourceBuilder.setUserLastModified(this.m_cms.getRequestContext().getCurrentUser().getId());
        }
        if (this.m_resourceBuilder.getDateCreated() == -1L) {
            this.m_resourceBuilder.setDateCreated(System.currentTimeMillis());
        }
        if (this.m_resourceBuilder.getUserCreated().isNullUUID()) {
            this.m_resourceBuilder.setUserCreated(this.getRequestContext().getCurrentUser().getId());
        }
        if (this.m_properties == null) {
            this.m_properties = new HashMap<String, CmsProperty>();
        }
    }

    private boolean hasContentInVfsOrImport(CmsResource resource) {
        if (this.m_contentFiles.contains(resource.getResourceId())) {
            return true;
        }
        try {
            List<CmsResource> resources = this.getCms().readSiblings(resource, CmsResourceFilter.ALL);
            if (!resources.isEmpty()) {
                return true;
            }
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return false;
    }

    public static class RelationData {
        private String m_target;
        private CmsUUID m_targetId;
        private CmsRelationType m_type;

        public RelationData(String target, CmsUUID targetId, CmsRelationType type) {
            this.m_target = target;
            this.m_type = type;
            this.m_targetId = targetId;
        }

        public boolean equals(Object otherObj) {
            if (!(otherObj instanceof RelationData)) {
                return false;
            }
            RelationData other = (RelationData)otherObj;
            return Objects.equal((Object)this.m_target, (Object)other.m_target) && Objects.equal((Object)this.m_type, (Object)other.m_type) && Objects.equal((Object)this.m_targetId, (Object)other.m_targetId);
        }

        public String getTarget() {
            return this.m_target;
        }

        public CmsUUID getTargetId() {
            return this.m_targetId;
        }

        public CmsRelationType getType() {
            return this.m_type;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.m_target, this.m_type.getName(), this.m_targetId});
        }
    }

    public static enum LinkParsableCategory {
        config,
        page,
        other;

    }
}

