/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jlan;

import org.opencms.jlan.CmsByteBuffer;

public class CmsFileBuffer {
    CmsByteBuffer m_buffer = new CmsByteBuffer(8192);
    long m_position;

    public byte[] getContents() {
        byte[] contents = new byte[this.m_buffer.size()];
        this.m_buffer.readBytes(contents, 0, 0, this.m_buffer.size());
        return contents;
    }

    public long getLength() {
        return this.m_buffer.size();
    }

    public long getPosition() {
        return this.m_position;
    }

    public void init(byte[] data) {
        this.m_position = 0L;
        this.m_buffer.writeBytes(data, 0, 0, data.length);
    }

    public int read(byte[] dest, int length, int bufferOffset, int fileOffset) {
        if (fileOffset >= this.m_buffer.size()) {
            return -1;
        }
        int readEnd = fileOffset + length;
        if (readEnd > this.m_buffer.size()) {
            length -= readEnd - this.m_buffer.size();
        }
        this.m_buffer.readBytes(dest, fileOffset, bufferOffset, length);
        return length;
    }

    public void seek(long newPos) {
        this.m_position = newPos;
    }

    public void truncate(int size) {
        this.m_buffer.truncate(size);
        this.m_position = Math.min((long)size, this.m_position);
    }

    public void write(byte[] data) {
        this.m_buffer.writeBytes(data, 0, (int)this.m_position, data.length);
    }
}

