/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.i18n.CmsLocaleGroup;
import org.opencms.jsp.CmsJspNavBuilder;
import org.opencms.jsp.CmsJspNavElement;
import org.opencms.jsp.util.CmsJspCategoryAccessBean;
import org.opencms.jsp.util.CmsJspContentAccessBean;
import org.opencms.jsp.util.CmsJspImageBean;
import org.opencms.jsp.util.CmsJspValueTransformers;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.security.CmsSecurityException;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsUUID;

public class CmsJspResourceWrapper
extends CmsResource {
    private static final Log LOG = CmsLog.getLog(CmsJspResourceWrapper.class);
    private static final long serialVersionUID = 1L;
    public static final boolean RELATIONS_OUT = true;
    public static final boolean RELATIONS_IN = false;
    public List<CmsJspResourceWrapper> m_incomingRelations;
    public List<CmsJspResourceWrapper> m_outgoingRelations;
    public List<CmsJspResourceWrapper> m_parentFolders;
    private CmsJspCategoryAccessBean m_categories;
    private CmsObject m_cms;
    private String m_content;
    private CmsFile m_file;
    private CmsJspImageBean m_imageBean;
    private Boolean m_isXml;
    private Map<String, CmsJspResourceWrapper> m_localeResources;
    private Locale m_mainLocale;
    private CmsJspNavBuilder m_navBuilder;
    private CmsJspNavElement m_navigation;
    private CmsJspResourceWrapper m_navigationDefaultFile;
    private List<CmsJspNavElement> m_navigationForFolder;
    private CmsJspResourceWrapper m_parentFolder;
    private Map<String, String> m_properties;
    private Map<String, Map<String, String>> m_propertiesLocale;
    private Map<String, Map<String, String>> m_propertiesLocaleSearch;
    private Map<String, String> m_propertiesSearch;
    private String m_sitePath;
    private String m_typeName;
    private CmsJspContentAccessBean m_xml;

    private CmsJspResourceWrapper(CmsObject cms, CmsResource res) {
        super(res.getStructureId(), res.getResourceId(), res.getRootPath(), res.getTypeId(), res.isFolder(), res.getFlags(), res.getProjectLastModified(), res.getState(), res.getDateCreated(), res.getUserCreated(), res.getDateLastModified(), res.getUserLastModified(), res.getDateReleased(), res.getDateExpired(), res.getSiblingCount(), res.getLength(), res.getDateContent(), res.getVersion());
        this.m_cms = cms;
        this.m_file = null;
        this.m_content = "";
    }

    public static CmsJspResourceWrapper wrap(CmsObject cms, CmsResource res) {
        CmsJspResourceWrapper result = null;
        if (cms != null && res != null) {
            if (res instanceof CmsJspResourceWrapper) {
                CmsJspResourceWrapper wrapper = (CmsJspResourceWrapper)res;
                result = cms.getRequestContext().getSiteRoot().equals(wrapper.getRequestContext().getSiteRoot()) ? wrapper : new CmsJspResourceWrapper(cms, res);
            } else {
                result = new CmsJspResourceWrapper(cms, res);
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsResource) {
            return ((CmsResource)obj).getStructureId().equals(this.getStructureId());
        }
        return false;
    }

    public CmsJspCategoryAccessBean getCategories() {
        if (this.m_categories == null) {
            this.m_categories = new CmsJspCategoryAccessBean(this.m_cms, this);
        }
        return this.m_categories;
    }

    public CmsObject getCmsObject() {
        return this.m_cms;
    }

    public String getContent() {
        if (this.m_content.length() == 0 && this.getFile() != null) {
            this.m_content = new String(this.getFile().getContents());
        }
        return this.m_content;
    }

    public String getExtension() {
        return CmsJspResourceWrapper.getExtension(this.getRootPath());
    }

    public CmsFile getFile() {
        if (this.m_file == null && !this.isFolder()) {
            try {
                this.m_file = this.m_cms.readFile(this);
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
        }
        return this.m_file;
    }

    public CmsJspResourceWrapper getFolder() {
        CmsJspResourceWrapper result = this.isFolder() ? this : this.readResource(this.getSitePathFolder());
        return result;
    }

    public List<CmsJspResourceWrapper> getIncomingRelations() {
        if (this.m_incomingRelations == null) {
            this.m_incomingRelations = this.getRelatedResources(false);
        }
        return this.m_incomingRelations;
    }

    public List<CmsJspResourceWrapper> getIncomingRelations(String typeName) {
        return this.getIncomingRelations().stream().filter(res -> res.getTypeName().equals(typeName)).collect(Collectors.toList());
    }

    public boolean getIsImage() {
        return this.getToImage().isImage();
    }

    public boolean getIsXml() {
        if (this.m_isXml == null) {
            this.m_isXml = CmsResourceTypeXmlPage.isXmlPage(this) || CmsResourceTypeXmlContent.isXmlContent(this);
        }
        return this.m_isXml;
    }

    public String getLink() {
        return OpenCms.getLinkManager().substituteLinkForUnknownTarget(this.m_cms, this.m_cms.getRequestContext().getSitePath(this));
    }

    public Map<String, CmsJspResourceWrapper> getLocaleResource() {
        if (this.m_localeResources != null) {
            return this.m_localeResources;
        }
        try {
            CmsLocaleGroup localeGroup = this.m_cms.getLocaleGroupService().readLocaleGroup(this);
            Map<Locale, CmsResource> resourcesByLocale = localeGroup.getResourcesByLocale();
            HashMap<String, CmsJspResourceWrapper> result = new HashMap<String, CmsJspResourceWrapper>();
            for (Map.Entry<Locale, CmsResource> entry : resourcesByLocale.entrySet()) {
                result.put(entry.getKey().toString(), CmsJspResourceWrapper.wrap(this.m_cms, entry.getValue()));
            }
            this.m_localeResources = result;
            return result;
        }
        catch (CmsException e) {
            return new HashMap<String, CmsJspResourceWrapper>();
        }
    }

    public Locale getMainLocale() {
        if (this.m_mainLocale != null) {
            return this.m_mainLocale;
        }
        try {
            CmsLocaleGroup localeGroup = this.m_cms.getLocaleGroupService().readLocaleGroup(this);
            this.m_mainLocale = localeGroup.getMainLocale();
            return this.m_mainLocale;
        }
        catch (CmsException e) {
            return null;
        }
    }

    public String getMimeType() {
        return OpenCms.getResourceManager().getMimeType(this.getRootPath(), null, "text/plain");
    }

    public CmsJspNavBuilder getNavBuilder() {
        if (this.m_navBuilder == null) {
            this.m_navBuilder = new CmsJspNavBuilder();
            this.m_navBuilder.init(this.m_cms, null, this.getSitePath());
        }
        return this.m_navBuilder;
    }

    public CmsJspNavElement getNavigation() {
        if (this.m_navigation == null) {
            this.m_navigation = this.getNavBuilder().getNavigationForResource();
        }
        return this.m_navigation;
    }

    public CmsJspResourceWrapper getNavigationDefaultFile() {
        if (this.m_navigationDefaultFile == null) {
            if (this.isFolder()) {
                try {
                    this.m_navigationDefaultFile = CmsJspResourceWrapper.wrap(this.m_cms, this.m_cms.readDefaultFile(this, CmsResourceFilter.DEFAULT));
                }
                catch (CmsSecurityException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        } else {
            this.m_navigationDefaultFile = this;
        }
        return this.m_navigationDefaultFile;
    }

    public List<CmsJspNavElement> getNavigationForFolder() {
        if (this.m_navigationForFolder == null) {
            this.m_navigationForFolder = this.getNavBuilder().getNavigationForFolder();
        }
        return this.m_navigationForFolder;
    }

    public List<CmsJspResourceWrapper> getOutgoingRelations() {
        if (this.m_outgoingRelations == null) {
            this.m_outgoingRelations = this.getRelatedResources(true);
        }
        return this.m_outgoingRelations;
    }

    public List<CmsJspResourceWrapper> getOutgoingRelations(String typeName) {
        return this.getOutgoingRelations().stream().filter(res -> res.getTypeName().equals(typeName)).collect(Collectors.toList());
    }

    public CmsJspResourceWrapper getParentFolder() {
        String parentFolder;
        if (this.m_parentFolder == null && (parentFolder = this.getSitePathParentFolder()) != null) {
            this.m_parentFolder = this.readResource(this.getSitePathParentFolder());
        }
        return this.m_parentFolder;
    }

    public List<CmsJspResourceWrapper> getParentFolders() {
        if (this.m_parentFolders == null) {
            this.m_parentFolders = new ArrayList<CmsJspResourceWrapper>();
            for (CmsJspResourceWrapper parentFolder = this.getParentFolder(); parentFolder != null; parentFolder = parentFolder.getParentFolder()) {
                this.m_parentFolders.add(parentFolder);
            }
        }
        return this.m_parentFolders;
    }

    public Map<String, String> getProperty() {
        block3: {
            if (this.m_properties == null) {
                try {
                    List<CmsProperty> properties = this.m_cms.readPropertyObjects(this, false);
                    this.m_properties = CmsProperty.toMap(properties);
                }
                catch (CmsException e) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return this.m_properties;
    }

    public Map<String, Map<String, String>> getPropertyLocale() {
        if (this.m_propertiesLocale == null) {
            this.m_propertiesLocale = CmsCollectionsGenericWrapper.createLazyMap(new CmsJspValueTransformers.CmsLocalePropertyLoaderTransformer(this.getCmsObject(), this, false));
            return this.m_propertiesLocale == null ? Collections.EMPTY_MAP : this.m_propertiesLocale;
        }
        return this.m_propertiesLocale;
    }

    public Map<String, Map<String, String>> getPropertyLocaleSearch() {
        if (this.m_propertiesLocaleSearch == null) {
            this.m_propertiesLocaleSearch = CmsCollectionsGenericWrapper.createLazyMap(new CmsJspValueTransformers.CmsLocalePropertyLoaderTransformer(this.getCmsObject(), this, true));
            return this.m_propertiesLocaleSearch == null ? Collections.EMPTY_MAP : this.m_propertiesLocaleSearch;
        }
        return this.m_propertiesLocaleSearch;
    }

    public Map<String, String> getPropertySearch() {
        block3: {
            if (this.m_propertiesSearch == null) {
                try {
                    List<CmsProperty> properties = this.m_cms.readPropertyObjects(this, true);
                    this.m_propertiesSearch = CmsProperty.toMap(properties);
                }
                catch (CmsException e) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return this.m_propertiesSearch;
    }

    public CmsRequestContext getRequestContext() {
        return this.m_cms.getRequestContext();
    }

    public String getResourceExtension() {
        return this.getExtension();
    }

    public String getResourceName() {
        return this.getName();
    }

    public String getRootPathFolder() {
        String result = this.isFile() ? this.getRootPathParentFolder() : this.getRootPath();
        return result;
    }

    public int getRootPathLevel() {
        return CmsJspResourceWrapper.getPathLevel(this.getRootPath());
    }

    public String getRootPathParentFolder() {
        return CmsJspResourceWrapper.getParentFolder(this.getRootPath());
    }

    public String getSitePath() {
        if (this.m_sitePath == null) {
            this.m_sitePath = this.m_cms.getRequestContext().getSitePath(this);
        }
        return this.m_sitePath;
    }

    public String getSitePathFolder() {
        String result = this.isFile() ? this.getSitePathParentFolder() : this.getSitePath();
        return result;
    }

    public int getSitePathLevel() {
        return CmsJspResourceWrapper.getPathLevel(this.getSitePath());
    }

    public String getSitePathParentFolder() {
        return CmsJspResourceWrapper.getParentFolder(this.getSitePath());
    }

    public CmsJspImageBean getToImage() {
        if (this.m_imageBean == null) {
            this.m_imageBean = new CmsJspImageBean(this.getCmsObject(), this, null);
        }
        return this.m_imageBean;
    }

    public CmsJspResourceWrapper getToResource() {
        return this;
    }

    public CmsJspContentAccessBean getToXml() {
        if (this.m_xml == null && this.getIsXml()) {
            this.m_xml = new CmsJspContentAccessBean(this.m_cms, this);
        }
        return this.m_xml;
    }

    public String getTypeName() {
        if (this.m_typeName == null) {
            try {
                this.m_typeName = OpenCms.getResourceManager().getResourceType(this.getTypeId()).getTypeName();
            }
            catch (CmsLoaderException cmsLoaderException) {
                // empty catch block
            }
        }
        return this.m_typeName;
    }

    public CmsJspContentAccessBean getXml() {
        return this.getToXml();
    }

    @Override
    public int hashCode() {
        if (this.getStructureId() != null) {
            return this.getStructureId().hashCode();
        }
        return CmsUUID.getNullUUID().hashCode();
    }

    public boolean isChildResourceOf(CmsResource resource) {
        return resource != null && resource.isFolder() && !this.getStructureId().equals(resource.getStructureId()) && this.getRootPath().indexOf(resource.getRootPath()) == 0;
    }

    public boolean isChildResourceOf(String sitePath) {
        return sitePath != null && this.getSitePath().indexOf(sitePath) == 0 && sitePath.length() < this.getSitePath().length();
    }

    public boolean isParentFolderOf(CmsResource resource) {
        return resource != null && this.isFolder() && !this.getStructureId().equals(resource.getStructureId()) && resource.getRootPath().indexOf(this.getRootPath()) == 0;
    }

    public boolean isParentFolderOf(String sitePath) {
        return sitePath != null && this.isFolder() && sitePath.indexOf(this.getSitePath()) == 0 && sitePath.length() > this.getSitePath().length();
    }

    private List<CmsJspResourceWrapper> getRelatedResources(boolean out) {
        CmsObject cms = this.getCmsObject();
        ArrayList<CmsJspResourceWrapper> result = new ArrayList<CmsJspResourceWrapper>();
        try {
            CmsRelationFilter filter = out ? CmsRelationFilter.relationsFromStructureId(this.getStructureId()) : CmsRelationFilter.relationsToStructureId(this.getStructureId());
            List<CmsRelation> relations = cms.readRelations(filter);
            for (CmsRelation rel : relations) {
                try {
                    CmsResource other = out ? rel.getTarget(cms, CmsResourceFilter.DEFAULT) : rel.getSource(cms, CmsResourceFilter.DEFAULT);
                    result.add(CmsJspResourceWrapper.wrap(cms, other));
                }
                catch (CmsException e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    private CmsJspResourceWrapper readResource(String sitePath) {
        CmsJspResourceWrapper result;
        block2: {
            result = null;
            try {
                result = new CmsJspResourceWrapper(this.m_cms, this.m_cms.readResource(sitePath));
            }
            catch (CmsException e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }
}

