/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsProperty;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.CmsJspTagEditable;
import org.opencms.jsp.Messages;
import org.opencms.jsp.decorator.CmsHtmlDecorator;
import org.opencms.jsp.decorator.I_CmsDecoratorConfiguration;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;

public class CmsJspTagDecorate
extends BodyTagSupport {
    public static final String DEFAULT_DECORATOR_CONFIGURATION = "org.opencms.jsp.decorator.CmsDecoratorConfiguration";
    public static final String PROPERTY_CATEGORY = "category";
    private static final Log LOG = CmsLog.getLog(CmsJspTagDecorate.class);
    private static final long serialVersionUID = 3072561342127379294L;
    private boolean m_allowInlineEdit;
    private String m_file;
    private String m_locale;
    private List<String> m_noAutoCloseTags;

    public String decorateTagAction(String content, String configFile, String locale, ServletRequest req) {
        try {
            Locale loc = null;
            CmsFlexController controller = CmsFlexController.getController(req);
            loc = CmsStringUtil.isEmpty(locale) ? controller.getCmsObject().getRequestContext().getLocale() : CmsLocaleManager.getLocale(locale);
            CmsProperty decoratorClass = controller.getCmsObject().readPropertyObject(configFile, PROPERTY_CATEGORY, false);
            String decoratorClassName = decoratorClass.getValue();
            if (CmsStringUtil.isEmpty(decoratorClassName)) {
                decoratorClassName = DEFAULT_DECORATOR_CONFIGURATION;
            }
            String encoding = controller.getCmsObject().getRequestContext().getEncoding();
            I_CmsDecoratorConfiguration config = (I_CmsDecoratorConfiguration)Class.forName(decoratorClassName).newInstance();
            config.init(controller.getCmsObject(), configFile, loc);
            CmsHtmlDecorator decorator = new CmsHtmlDecorator(controller.getCmsObject(), config);
            decorator.setNoAutoCloseTags(this.m_noAutoCloseTags);
            return decorator.doDecoration(content, encoding);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_PROCESS_TAG_1", "decoration"), (Throwable)e);
            }
            return content;
        }
    }

    public int doEndTag() throws JspException {
        ServletRequest req = this.pageContext.getRequest();
        if (this.m_allowInlineEdit && CmsJspTagEditable.isEditableRequest(req)) {
            try {
                this.getBodyContent().writeOut((Writer)this.pageContext.getOut());
                this.release();
            }
            catch (Exception ex) {
                this.release();
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_PROCESS_TAG_1", "decoration"), (Throwable)ex);
                }
                throw new JspException((Throwable)ex);
            }
        }
        if (CmsFlexController.isCmsRequest(req)) {
            try {
                String content = this.decorateTagAction(this.getBodyContent().getString(), this.getFile(), this.getLocale(), req);
                this.getBodyContent().clear();
                this.getBodyContent().print(content);
                this.getBodyContent().writeOut((Writer)this.pageContext.getOut());
            }
            catch (Exception ex) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_PROCESS_TAG_1", "decoration"), (Throwable)ex);
                }
                throw new JspException((Throwable)ex);
            }
        }
        return 6;
    }

    public String getFile() {
        return this.m_file;
    }

    public String getLocale() {
        return this.m_locale;
    }

    public String getNoAutoCloseTags() {
        StringBuffer result = new StringBuffer();
        if (this.m_noAutoCloseTags != null && this.m_noAutoCloseTags.size() > 0) {
            Iterator<String> it = this.m_noAutoCloseTags.iterator();
            while (it.hasNext()) {
                result.append(it.next()).append(',');
            }
        }
        return result.toString();
    }

    public boolean isAllowInlineEdit() {
        return this.m_allowInlineEdit;
    }

    public void setAllowInlineEdit(boolean allowInlineEdit) {
        this.m_allowInlineEdit = allowInlineEdit;
    }

    public void setFile(String file) {
        this.m_file = file != null ? file.toLowerCase() : null;
    }

    public void setLocale(String locale) {
        this.m_locale = locale;
    }

    public void setNoAutoCloseTags(String noAutoCloseTagList) {
        this.m_noAutoCloseTags = CmsStringUtil.splitAsList(noAutoCloseTagList, ',');
    }
}

