/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.logging.Log;
import org.opencms.flex.CmsFlexController;
import org.opencms.jsp.Messages;
import org.opencms.jsp.util.I_CmsJspDeviceSelector;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public class CmsJspTagDevice
extends BodyTagSupport {
    private static final Log LOG = CmsLog.getLog(CmsJspTagDevice.class);
    private static final long serialVersionUID = 9175484824140856283L;
    protected String m_type;

    public int doEndTag() {
        if (OpenCms.getSystemInfo().getServletContainerSettings().isReleaseTagsAfterEnd()) {
            this.release();
        }
        return 6;
    }

    public int doStartTag() {
        CmsFlexController controller = CmsFlexController.getController(this.pageContext.getRequest());
        I_CmsJspDeviceSelector selector = OpenCms.getSystemInfo().getDeviceSelector();
        List<String> supportedDevices = selector.getDeviceTypes();
        List<String> selectedDevices = CmsStringUtil.splitAsList(this.m_type, ",", true);
        for (String selectedDevice : selectedDevices) {
            if (supportedDevices.contains(selectedDevice)) {
                HttpServletRequest req = controller.getTopRequest();
                String device = (String)req.getAttribute("__device");
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(device) && CmsStringUtil.isNotEmpty(device = selector.getDeviceType(req))) {
                    req.setAttribute("__device", (Object)device);
                }
                if (selectedDevices.contains(device)) {
                    return 1;
                }
                return 0;
            }
            LOG.error((Object)Messages.get().getBundle().key("LOG_WRONG_DEVICE_TYPE_2", selectedDevice, controller.getCurrentRequest().getElementUri()));
        }
        return 0;
    }

    public String getType() {
        return this.m_type != null ? this.m_type : "";
    }

    public void release() {
        super.release();
        this.m_type = null;
    }

    public void setType(String type) {
        if (type != null) {
            this.m_type = type;
        }
    }
}

