/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacet;

public class CmsSearchConfigurationFacet
implements I_CmsSearchConfigurationFacet {
    protected Integer m_minCount;
    protected String m_name;
    protected String m_label;
    protected List<String> m_preselection;
    protected boolean m_isAndFacet;
    protected boolean m_ignoreFacetFilters;
    protected Set<String> m_ignoreTags;
    protected Set<String> m_explicitExcludeTags;

    public CmsSearchConfigurationFacet(Integer minCount, String label, String name, Boolean isAndFacet, List<String> preselection, Boolean ignoreFiltersFromFacets, Collection<String> excludeTags) {
        this.m_minCount = minCount;
        String string = this.m_label = label == null ? name : label;
        if (isAndFacet != null) {
            this.m_isAndFacet = isAndFacet;
        }
        this.m_name = name;
        this.m_preselection = preselection == null ? new ArrayList() : preselection;
        this.m_ignoreFacetFilters = ignoreFiltersFromFacets == null ? false : ignoreFiltersFromFacets;
        this.m_ignoreTags = new HashSet<String>();
        if (!this.m_isAndFacet) {
            this.m_ignoreTags.add(this.getName());
        }
        if (null != excludeTags) {
            this.m_ignoreTags.addAll(excludeTags);
        }
    }

    @Override
    public boolean getIgnoreAllFacetFilters() {
        return this.m_ignoreFacetFilters;
    }

    @Override
    public String getIgnoreMaxParamKey() {
        return this.getParamKey() + "_ignoremax";
    }

    @Override
    public String getIgnoreTags() {
        return String.join((CharSequence)",", this.m_ignoreTags);
    }

    @Override
    public boolean getIsAndFacet() {
        return this.m_isAndFacet;
    }

    @Override
    public String getLabel() {
        return this.m_label;
    }

    @Override
    public Integer getMinCount() {
        return this.m_minCount;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getParamKey() {
        return "facet_" + this.getName();
    }

    @Override
    public List<String> getPreSelection() {
        return this.m_preselection;
    }

    @Override
    public void propagateAllFacetNames(Collection<String> names) {
        if (this.m_ignoreFacetFilters) {
            this.m_ignoreTags.addAll(names);
            this.m_ignoreTags.add("q");
        }
    }
}

