/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.config.parser;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsEncoder;
import org.opencms.json.JSONException;
import org.opencms.jsp.search.config.CmsSearchConfigurationFacetField;
import org.opencms.jsp.search.config.CmsSearchConfigurationFacetRange;
import org.opencms.jsp.search.config.CmsSearchConfigurationSortOption;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacet;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacetField;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacetRange;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationPagination;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationSortOption;
import org.opencms.jsp.search.config.parser.CmsJSONSearchConfigurationParser;
import org.opencms.main.CmsException;
import org.opencms.relations.CmsCategoryService;
import org.opencms.search.solr.CmsSolrQuery;
import org.opencms.search.solr.CmsSolrQueryUtil;
import org.opencms.ui.apps.lists.CmsListManager;
import org.opencms.ui.apps.lists.daterestrictions.I_CmsListDateRestriction;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsSimpleSearchConfigurationParser
extends CmsJSONSearchConfigurationParser {
    private I_CmsSearchConfigurationPagination m_pagination;
    private CmsObject m_cms;
    private CmsListManager.ListConfigurationBean m_config;
    private Locale m_searchLocale;
    private SortOption m_sortOrder;
    private boolean m_ignoreBlacklist;

    public CmsSimpleSearchConfigurationParser(CmsObject cms, CmsListManager.ListConfigurationBean config, String additionalParamJSON) throws JSONException {
        super(CmsStringUtil.isEmptyOrWhitespaceOnly(additionalParamJSON) ? "{}" : additionalParamJSON);
        this.m_cms = cms;
        this.m_config = config;
    }

    public static CmsSimpleSearchConfigurationParser createInstanceWithNoJsonConfig(CmsObject cms, CmsListManager.ListConfigurationBean config) {
        try {
            return new CmsSimpleSearchConfigurationParser(cms, config, null);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public CmsSolrQuery getInitialQuery() {
        HashMap<String, String[]> queryParams = new HashMap<String, String[]>();
        if (!this.m_cms.getRequestContext().getCurrentProject().isOnlineProject() && this.m_config.isShowExpired()) {
            queryParams.put("fq", new String[]{"released:[* TO *]", "expired:[* TO *]"});
        }
        return new CmsSolrQuery(null, queryParams);
    }

    public Locale getSearchLocale() {
        if (this.m_searchLocale != null) {
            return this.m_searchLocale;
        }
        return this.m_cms.getRequestContext().getLocale();
    }

    @Override
    public Map<String, I_CmsSearchConfigurationFacetField> parseFieldFacets() {
        if (this.m_configObject.has("fieldfacets")) {
            return super.parseFieldFacets();
        }
        return this.getDefaultFieldFacets(true);
    }

    @Override
    public I_CmsSearchConfigurationPagination parsePagination() {
        if (this.m_pagination != null) {
            return this.m_pagination;
        }
        return super.parsePagination();
    }

    @Override
    public Map<String, I_CmsSearchConfigurationFacetRange> parseRangeFacets() {
        if (this.m_configObject.has("rangefacets")) {
            return super.parseRangeFacets();
        }
        HashMap<String, I_CmsSearchConfigurationFacetRange> rangeFacets = new HashMap<String, I_CmsSearchConfigurationFacetRange>();
        String indexField = "instancedate_%s_dt";
        if (Boolean.parseBoolean(this.m_config.getParameterValue("FilterMultiDay"))) {
            indexField = "instancedaterange_%s_dr";
        }
        CmsSearchConfigurationFacetRange rangeFacet = new CmsSearchConfigurationFacetRange(String.format(indexField, this.getSearchLocale().toString()), "NOW/YEAR-20YEARS", "NOW/MONTH+5YEARS", "+1MONTHS", null, Boolean.FALSE, "instancedate", 1, "Date", Boolean.FALSE, null, Boolean.TRUE, null);
        rangeFacets.put(rangeFacet.getName(), rangeFacet);
        return rangeFacets;
    }

    public void setIgnoreBlacklist(boolean ignoreBlacklist) {
        this.m_ignoreBlacklist = ignoreBlacklist;
    }

    public void setPagination(I_CmsSearchConfigurationPagination pagination) {
        this.m_pagination = pagination;
    }

    public void setSearchLocale(Locale locale) {
        this.m_searchLocale = locale;
    }

    public void setSortOption(String sortOption) {
        if (null != sortOption) {
            try {
                this.m_sortOrder = SortOption.valueOf(sortOption);
            }
            catch (IllegalArgumentException e) {
                this.m_sortOrder = null;
                LOG.warn((Object)("Setting illegal default sort option " + sortOption + " failed. Using Solr's default sort option."));
            }
        } else {
            this.m_sortOrder = null;
        }
    }

    @Override
    protected Boolean getEscapeQueryChars() {
        if (this.m_configObject.has("escapequerychars")) {
            return super.getEscapeQueryChars();
        }
        return Boolean.TRUE;
    }

    @Override
    protected String getExtraSolrParams() {
        String params = super.getExtraSolrParams();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(params)) {
            params = this.getCategoryFolderFilter() + this.getResourceTypeFilter() + this.getFilterQuery() + this.getBlacklistFilter() + this.getGeoFilterQuery();
        }
        return params;
    }

    @Override
    protected Boolean getIgnoreExpirationDate() {
        return this.getIgnoreReleaseAndExpiration();
    }

    @Override
    protected Boolean getIgnoreReleaseDate() {
        return this.getIgnoreReleaseAndExpiration();
    }

    @Override
    protected int getMaxReturnedResults(String indexName) {
        return null != this.m_config.getMaximallyReturnedResults() ? this.m_config.getMaximallyReturnedResults().intValue() : super.getMaxReturnedResults(indexName);
    }

    @Override
    protected String getQueryModifier() {
        String modifier = super.getQueryModifier();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(modifier)) {
            modifier = "{!type=edismax qf=\"content_" + this.getSearchLocale().toString() + " " + "Title" + "_prop" + " " + "Description" + "_dprop" + " " + "Description.html" + "_dprop" + "\"}%(query)";
        }
        return modifier;
    }

    @Override
    protected Boolean getSearchForEmptyQuery() {
        if (this.m_configObject.has("searchforemptyquery")) {
            return super.getSearchForEmptyQuery();
        }
        return Boolean.TRUE;
    }

    @Override
    protected List<I_CmsSearchConfigurationSortOption> getSortOptions() {
        if (this.m_configObject.has("sortoptions")) {
            return super.getSortOptions();
        }
        LinkedList<I_CmsSearchConfigurationSortOption> options = new LinkedList<I_CmsSearchConfigurationSortOption>();
        SortOption currentOption = SortOption.valueOf(this.m_config.getSortOrder());
        if (this.m_sortOrder != null) {
            currentOption = this.m_sortOrder;
        }
        Locale locale = this.getSearchLocale();
        options.add(currentOption.getOption(locale));
        SortOption[] sortOptions = SortOption.values();
        for (int i = 0; i < sortOptions.length; ++i) {
            SortOption option = sortOptions[i];
            if (Objects.equals((Object)currentOption, (Object)option)) continue;
            options.add(option.getOption(locale));
        }
        return options;
    }

    String getBlacklistFilter() {
        if (this.m_ignoreBlacklist) {
            return "";
        }
        String result = "";
        List<CmsUUID> blacklist = this.m_config.getBlacklist();
        ArrayList blacklistStrings = Lists.newArrayList();
        for (CmsUUID id : blacklist) {
            blacklistStrings.add("\"" + id.toString() + "\"");
        }
        if (!blacklistStrings.isEmpty()) {
            result = "&fq=" + CmsEncoder.encode("-id:(" + CmsStringUtil.listAsString(blacklistStrings, " OR ") + ")");
        }
        return result;
    }

    String getCategoryFilterPart() {
        String result = "";
        if (!this.m_config.getCategories().isEmpty()) {
            ArrayList categoryVals = Lists.newArrayList();
            for (String path : this.m_config.getCategories()) {
                try {
                    path = CmsCategoryService.getInstance().getCategory(this.m_cms, this.m_cms.getRequestContext().addSiteRoot(path)).getPath();
                    categoryVals.add("\"" + path + "\"");
                }
                catch (CmsException e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (!categoryVals.isEmpty()) {
                String operator = " " + (Object)((Object)this.m_config.getCategoryMode()) + " ";
                String valueExpression = CmsStringUtil.listAsString(categoryVals, operator);
                result = "category_exact:(" + valueExpression + ")";
            }
        }
        return result;
    }

    String getCategoryFolderFilter() {
        String result = "";
        String defaultPart = this.getFolderFilterPart();
        String categoryFilterPart = this.getCategoryFilterPart();
        if (!categoryFilterPart.isEmpty()) {
            defaultPart = "((" + defaultPart + ") AND (" + categoryFilterPart + "))";
        }
        for (CmsListManager.ListConfigurationBean.ListCategoryFolderRestrictionBean restriction : this.m_config.getCategoryFolderRestrictions()) {
            String restrictionQuery = restriction.toString();
            if (restrictionQuery.isEmpty()) continue;
            restrictionQuery = "(" + restrictionQuery + " AND " + defaultPart + ")";
            if (!result.isEmpty()) {
                result = result + " OR ";
            }
            result = result + restrictionQuery;
        }
        if (result.isEmpty()) {
            result = defaultPart;
        }
        return "fq=" + CmsEncoder.encode(result);
    }

    String getDefaultReturnFields() {
        StringBuffer fields = new StringBuffer("");
        fields.append("path");
        fields.append(',');
        fields.append("instancedate").append("_dt");
        fields.append(',');
        fields.append("instancedateend").append("_dt");
        fields.append(',');
        fields.append("instancedatecurrenttill").append("_dt");
        fields.append(',');
        fields.append("instancedate").append('_').append(this.getSearchLocale().toString()).append("_dt");
        fields.append(',');
        fields.append("instancedateend").append('_').append(this.getSearchLocale().toString()).append("_dt");
        fields.append(',');
        fields.append("instancedatecurrenttill").append('_').append(this.getSearchLocale().toString()).append("_dt");
        fields.append(',');
        fields.append("id");
        fields.append(',');
        fields.append("solr_id");
        fields.append(',');
        fields.append("disptitle").append('_').append(this.getSearchLocale().toString()).append("_sort");
        fields.append(',');
        fields.append("link");
        fields.append(',');
        fields.append("geocoords_loc");
        return fields.toString();
    }

    String getFilterQuery() {
        I_CmsListDateRestriction dateRestriction;
        String result = this.m_config.getFilterQuery();
        if (result == null) {
            result = "";
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(result) && !result.startsWith("&")) {
            result = "&" + result;
        }
        if (!result.contains("fl=")) {
            result = result + "&fl=" + CmsEncoder.encode(this.getDefaultReturnFields());
        }
        if ((dateRestriction = this.m_config.getDateRestriction()) != null) {
            result = result + "&fq=" + CmsEncoder.encode("instancedatecurrenttill_" + this.getSearchLocale().toString() + "_dt:" + dateRestriction.getRange());
        }
        result = result + "&fq=con_locales:" + this.getSearchLocale().toString();
        return result;
    }

    String getFolderFilterPart() {
        String result = "";
        ArrayList parentFolderVals = Lists.newArrayList();
        if (!this.m_config.getFolders().isEmpty()) {
            for (String value : this.m_config.getFolders()) {
                parentFolderVals.add("\"" + value + "\"");
            }
        }
        result = parentFolderVals.isEmpty() ? "parent-folders:(\"/\")" : "parent-folders:(" + CmsStringUtil.listAsString(parentFolderVals, " OR ") + ")";
        return result;
    }

    String getGeoFilterQuery() {
        String result = "";
        CmsListManager.ListConfigurationBean.ListGeoFilterBean geoFilterBean = this.m_config.getGeoFilter();
        if (geoFilterBean != null) {
            String fq = CmsSolrQueryUtil.composeGeoFilterQuery("geocoords_loc", geoFilterBean.getCoordinates(), geoFilterBean.getRadius(), "km");
            result = "&fq=" + fq;
        }
        return result;
    }

    String getResourceTypeFilter() {
        String result = "";
        ArrayList typeVals = Lists.newArrayList();
        if (!this.m_config.getDisplayTypes().isEmpty()) {
            for (String displayType : this.m_config.getDisplayTypes()) {
                if (displayType.contains(":")) {
                    displayType = displayType.substring(0, displayType.indexOf(":"));
                }
                typeVals.add("\"" + displayType + "\"");
            }
        }
        if (!typeVals.isEmpty()) {
            result = "&fq=" + CmsEncoder.encode("type:(" + CmsStringUtil.listAsString(typeVals, " OR ") + ")");
        }
        return result;
    }

    private Map<String, I_CmsSearchConfigurationFacetField> getDefaultFieldFacets(boolean categoryConjunction) {
        HashMap<String, CmsSearchConfigurationFacetField> fieldFacets = new HashMap<String, CmsSearchConfigurationFacetField>();
        fieldFacets.put("category_exact", new CmsSearchConfigurationFacetField("category_exact", null, 1, 200, null, "Category", I_CmsSearchConfigurationFacet.SortOrder.index, null, categoryConjunction, null, Boolean.TRUE, null));
        fieldFacets.put("parent-folders", new CmsSearchConfigurationFacetField("parent-folders", null, 1, 200, null, "Folders", I_CmsSearchConfigurationFacet.SortOrder.index, null, Boolean.FALSE, null, Boolean.TRUE, null));
        return Collections.unmodifiableMap(fieldFacets);
    }

    private Boolean getIgnoreReleaseAndExpiration() {
        return this.m_config.isShowExpired();
    }

    public static enum SortOption {
        DATE_ASC,
        DATE_DESC,
        TITLE_ASC,
        TITLE_DESC,
        ORDER_ASC,
        ORDER_DESC;


        public I_CmsSearchConfigurationSortOption getOption(Locale l) {
            switch (this) {
                case DATE_ASC: {
                    return new CmsSearchConfigurationSortOption("date.asc", "date_asc", this.getSortDateField(l) + " asc");
                }
                case DATE_DESC: {
                    return new CmsSearchConfigurationSortOption("date.desc", "date_desc", this.getSortDateField(l) + " desc");
                }
                case TITLE_ASC: {
                    return new CmsSearchConfigurationSortOption("title.asc", "title_asc", this.getSortTitleField(l) + " asc");
                }
                case TITLE_DESC: {
                    return new CmsSearchConfigurationSortOption("title.desc", "title_desc", this.getSortTitleField(l) + " desc");
                }
                case ORDER_ASC: {
                    return new CmsSearchConfigurationSortOption("order.asc", "order_asc", this.getSortOrderField(l) + " asc");
                }
                case ORDER_DESC: {
                    return new CmsSearchConfigurationSortOption("order.desc", "order_desc", this.getSortOrderField(l) + " desc");
                }
            }
            throw new IllegalArgumentException();
        }

        protected String getSortDateField(Locale l) {
            return "instancedate" + (null != l ? "_" + l.toString() : "") + "_dt";
        }

        protected String getSortOrderField(Locale l) {
            return "disporder" + (null != l ? "_" + l.toString() : "") + "_i";
        }

        protected String getSortTitleField(Locale l) {
            return "disptitle" + (null != l ? "_" + l.toString() : "") + "_sort";
        }
    }
}

