/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.controller;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationGeoFilter;
import org.opencms.jsp.search.controller.I_CmsSearchControllerGeoFilter;
import org.opencms.jsp.search.state.CmsSearchStateGeoFilter;
import org.opencms.jsp.search.state.I_CmsSearchStateGeoFilter;
import org.opencms.main.CmsLog;
import org.opencms.search.solr.CmsSolrQuery;
import org.opencms.util.CmsGeoUtil;

public class CmsSearchControllerGeoFilter
implements I_CmsSearchControllerGeoFilter {
    private static final Log LOG = CmsLog.getLog(CmsSearchControllerGeoFilter.class);
    private final I_CmsSearchConfigurationGeoFilter m_config;
    private final I_CmsSearchStateGeoFilter m_state;

    public CmsSearchControllerGeoFilter(I_CmsSearchConfigurationGeoFilter config) {
        this.m_config = config;
        this.m_state = new CmsSearchStateGeoFilter();
    }

    @Override
    public void addParametersForCurrentState(Map<String, String[]> parameters) {
        if (this.m_state.hasGeoFilter()) {
            parameters.put(this.m_config.getCoordinatesParam(), new String[]{this.m_state.getCoordinates()});
            parameters.put(this.m_config.getRadiusParam(), new String[]{this.m_state.getRadius()});
            parameters.put(this.m_config.getUnitsParam(), new String[]{this.m_state.getUnits()});
        }
    }

    @Override
    public void addQueryParts(CmsSolrQuery query, CmsObject cms) {
        String units;
        String radius;
        String coordinates;
        String fieldName = this.m_config.getFieldName();
        if (this.m_state.hasGeoFilter()) {
            coordinates = this.m_state.getCoordinates();
            radius = this.m_state.getRadius();
            units = this.m_state.getUnits();
            query.setGeoFilterQuery(fieldName, coordinates, radius, units);
        }
        if (this.m_config.hasGeoFilter()) {
            coordinates = this.m_config.getCoordinates();
            radius = this.m_config.getRadius();
            units = this.m_config.getUnits();
            query.setGeoFilterQuery(fieldName, coordinates, radius, units);
        }
    }

    @Override
    public I_CmsSearchConfigurationGeoFilter getConfig() {
        return this.m_config;
    }

    @Override
    public I_CmsSearchStateGeoFilter getState() {
        return this.m_state;
    }

    @Override
    public void updateForQueryChange() {
    }

    @Override
    public void updateFromRequestParameters(Map<String, String[]> parameters, boolean isRepeated) {
        if (parameters.containsKey(this.m_config.getCoordinatesParam())) {
            String[] coordinates = parameters.get(this.m_config.getCoordinatesParam());
            if (coordinates != null && coordinates.length > 0 && CmsGeoUtil.validateCoordinates(coordinates[0])) {
                this.m_state.setCoordinates(coordinates[0]);
            } else {
                this.m_state.setCoordinates(null);
            }
        }
        if (parameters.containsKey(this.m_config.getRadiusParam())) {
            String[] radius = parameters.get(this.m_config.getRadiusParam());
            if (radius != null && radius.length > 0 && CmsGeoUtil.validateRadius(radius[0])) {
                this.m_state.setRadius(radius[0]);
            } else {
                this.m_state.setRadius(null);
            }
        }
        if (parameters.containsKey(this.m_config.getUnitsParam())) {
            String[] units = parameters.get(this.m_config.getUnitsParam());
            if (units != null && units.length > 0 && CmsGeoUtil.validateUnits(units[0])) {
                this.m_state.setUnits(units[0]);
            } else {
                this.m_state.setUnits(null);
            }
        }
    }
}

