/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.controller;

import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationPagination;
import org.opencms.jsp.search.controller.I_CmsSearchControllerPagination;
import org.opencms.jsp.search.state.CmsSearchStatePagination;
import org.opencms.jsp.search.state.I_CmsSearchStatePagination;
import org.opencms.search.solr.CmsSolrQuery;

public class CmsSearchControllerPagination
implements I_CmsSearchControllerPagination {
    private static final int DEFAULT_PAGE = 1;
    private final I_CmsSearchConfigurationPagination m_config;
    private final I_CmsSearchStatePagination m_state;

    public CmsSearchControllerPagination(I_CmsSearchConfigurationPagination config) {
        this.m_config = config;
        this.m_state = new CmsSearchStatePagination();
    }

    @Override
    public void addParametersForCurrentState(Map<String, String[]> parameters) {
        if (this.m_state.getCurrentPage() != 1) {
            parameters.put(this.m_config.getPageParam(), new String[]{Integer.toString(this.m_state.getCurrentPage())});
        }
    }

    @Override
    public void addQueryParts(CmsSolrQuery query, CmsObject cms) {
        query.setRows(this.getCurrentPageSize());
        int start = this.getCurrentPageStart();
        query.setStart(start);
    }

    @Override
    public I_CmsSearchConfigurationPagination getConfig() {
        return this.m_config;
    }

    @Override
    public int getCurrentPageSize() {
        return this.getConfig().getSizeOfPage(this.getState().getCurrentPage());
    }

    @Override
    public int getCurrentPageStart() {
        return this.m_config.getStartOfPage(this.m_state.getCurrentPage());
    }

    @Override
    public I_CmsSearchStatePagination getState() {
        return this.m_state;
    }

    @Override
    public void updateForQueryChange() {
        this.m_state.setIgnorePage(true);
    }

    @Override
    public void updateFromRequestParameters(Map<String, String[]> parameters, boolean isReloaded) {
        String[] page;
        if (!this.m_state.getIgnorePage() && parameters.containsKey(this.m_config.getPageParam()) && (page = parameters.get(this.m_config.getPageParam())).length > 0) {
            try {
                this.m_state.setCurrentPage(Integer.valueOf(page[0]));
                return;
            }
            catch (NumberFormatException e) {
                this.m_state.setCurrentPage(1);
            }
        }
        this.m_state.setCurrentPage(1);
    }
}

