/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.result;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Transformer;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.RangeFacet;
import org.apache.solr.client.solrj.response.SpellCheckResponse;
import org.opencms.file.CmsObject;
import org.opencms.jsp.search.controller.I_CmsSearchControllerDidYouMean;
import org.opencms.jsp.search.controller.I_CmsSearchControllerFacetField;
import org.opencms.jsp.search.controller.I_CmsSearchControllerFacetQuery;
import org.opencms.jsp.search.controller.I_CmsSearchControllerFacetRange;
import org.opencms.jsp.search.controller.I_CmsSearchControllerMain;
import org.opencms.jsp.search.result.CmsSearchResourceBean;
import org.opencms.jsp.search.result.CmsSearchStateParameters;
import org.opencms.jsp.search.result.I_CmsSearchResourceBean;
import org.opencms.jsp.search.result.I_CmsSearchResultWrapper;
import org.opencms.jsp.search.result.I_CmsSearchStateParameters;
import org.opencms.search.CmsSearchException;
import org.opencms.search.CmsSearchResource;
import org.opencms.search.solr.CmsSolrQuery;
import org.opencms.search.solr.CmsSolrResultList;
import org.opencms.util.CmsCollectionsGenericWrapper;

public class CmsSearchResultWrapper
implements I_CmsSearchResultWrapper {
    final CmsSolrResultList m_solrResultList;
    private Collection<I_CmsSearchResourceBean> m_foundResources;
    private final Long m_start;
    private final int m_end;
    private final long m_numFound;
    private final Float m_maxScore;
    final I_CmsSearchControllerMain m_controller;
    private Map<String, FacetField> m_fieldFacetMap;
    private Map<String, RangeFacet> m_rangeFacetMap;
    private Map<String, List<String>> m_missingFieldFacetEntryMap;
    private Map<String, List<String>> m_missingRangeFacetEntryMap;
    private List<String> m_missingQueryFacetEntries;
    private Map<String, Integer> m_facetQuery;
    private final CmsObject m_cmsObject;
    private final CmsSearchException m_exception;
    private final CmsSolrQuery m_query;

    public CmsSearchResultWrapper(I_CmsSearchControllerMain controller, CmsSolrResultList resultList, CmsSolrQuery query, CmsObject cms, CmsSearchException exception) {
        this.m_controller = controller;
        this.m_solrResultList = resultList;
        this.m_cmsObject = cms;
        this.m_exception = exception;
        this.m_query = query;
        if (resultList != null) {
            List<RangeFacet> rangeFacets;
            this.convertSearchResults(resultList);
            long l = resultList.getStart() == null ? 1L : resultList.getStart() + 1L;
            this.m_start = l;
            this.m_end = resultList.getEnd();
            this.m_numFound = resultList.getNumFound();
            this.m_maxScore = resultList.getMaxScore();
            if (resultList.getFacetQuery() != null) {
                Map<String, Integer> originalMap = resultList.getFacetQuery();
                this.m_facetQuery = new HashMap<String, Integer>(originalMap.size());
                for (String q : resultList.getFacetQuery().keySet()) {
                    this.m_facetQuery.put(this.removeLocalParamPrefix(q), originalMap.get(q));
                }
            }
            if (null != (rangeFacets = resultList.getFacetRanges())) {
                this.m_rangeFacetMap = new HashMap<String, RangeFacet>(rangeFacets.size());
                for (RangeFacet facet : rangeFacets) {
                    this.m_rangeFacetMap.put(facet.getName(), facet);
                }
            }
        } else {
            this.m_start = null;
            this.m_end = 0;
            this.m_numFound = 0L;
            this.m_maxScore = null;
        }
        if (null == this.m_rangeFacetMap) {
            this.m_rangeFacetMap = new HashMap<String, RangeFacet>();
        }
    }

    @Override
    public I_CmsSearchControllerMain getController() {
        return this.m_controller;
    }

    @Override
    public String getDidYouMeanCollated() {
        String suggestion = null;
        I_CmsSearchControllerDidYouMean didYouMeanController = this.getController().getDidYouMean();
        if (null != didYouMeanController && didYouMeanController.getConfig().getCollate() && this.m_solrResultList != null && this.m_solrResultList.getSpellCheckResponse() != null) {
            suggestion = this.m_solrResultList.getSpellCheckResponse().getCollatedResult();
        }
        return suggestion;
    }

    @Override
    public SpellCheckResponse.Suggestion getDidYouMeanSuggestion() {
        I_CmsSearchControllerDidYouMean didYouMeanController = this.getController().getDidYouMean();
        SpellCheckResponse.Suggestion usedSuggestion = null;
        if (null != didYouMeanController && this.m_solrResultList != null && this.m_solrResultList.getSpellCheckResponse() != null) {
            List suggestionList = this.m_solrResultList.getSpellCheckResponse().getSuggestions();
            int queryLength = this.m_controller.getDidYouMean().getState().getQuery().length();
            int minDistance = queryLength + 1;
            for (SpellCheckResponse.Suggestion suggestion : suggestionList) {
                int currentDistance = Math.abs(queryLength - suggestion.getToken().length());
                if (currentDistance >= minDistance) continue;
                usedSuggestion = suggestion;
                minDistance = currentDistance;
            }
        }
        return usedSuggestion;
    }

    @Override
    public I_CmsSearchStateParameters getEmptyStateParameters() {
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        return new CmsSearchStateParameters(this, parameters);
    }

    @Override
    public int getEnd() {
        return this.m_end;
    }

    @Override
    public CmsSearchException getException() {
        return this.m_exception;
    }

    @Override
    public Map<String, Integer> getFacetQuery() {
        return this.m_facetQuery;
    }

    @Override
    public Map<String, FacetField> getFieldFacet() {
        if (this.m_fieldFacetMap == null) {
            this.m_fieldFacetMap = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(Object fieldName) {
                    return CmsSearchResultWrapper.this.m_solrResultList == null ? null : CmsSearchResultWrapper.this.m_solrResultList.getFacetField(fieldName.toString());
                }
            });
        }
        return this.m_fieldFacetMap;
    }

    @Override
    public Collection<FacetField> getFieldFacets() {
        return this.m_solrResultList == null ? null : this.m_solrResultList.getFacetFields();
    }

    @Override
    public CmsSolrQuery getFinalQuery() {
        return this.m_query;
    }

    @Override
    public Map<String, Map<String, List<String>>> getHighlighting() {
        return this.m_solrResultList == null ? null : this.m_solrResultList.getHighLighting();
    }

    @Override
    public Float getMaxScore() {
        return this.m_maxScore;
    }

    @Override
    public Map<String, List<String>> getMissingSelectedFieldFacetEntries() {
        if (this.m_missingFieldFacetEntryMap == null) {
            this.m_missingFieldFacetEntryMap = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(Object fieldName) {
                    FacetField facetResult = CmsSearchResultWrapper.this.m_solrResultList == null ? null : CmsSearchResultWrapper.this.m_solrResultList.getFacetField(fieldName.toString());
                    I_CmsSearchControllerFacetField facetController = CmsSearchResultWrapper.this.m_controller.getFieldFacets().getFieldFacetController().get(fieldName.toString());
                    List<Object> result = new ArrayList();
                    if (null != facetController) {
                        List<String> checkedEntries = facetController.getState().getCheckedEntries();
                        if (null != facetResult) {
                            ArrayList<String> returnedValues = new ArrayList<String>(facetResult.getValues().size());
                            for (FacetField.Count value : facetResult.getValues()) {
                                returnedValues.add(value.getName());
                            }
                            for (String checked : checkedEntries) {
                                if (returnedValues.contains(checked)) continue;
                                result.add(checked);
                            }
                        } else {
                            result = checkedEntries;
                        }
                    }
                    return result;
                }
            });
        }
        return this.m_missingFieldFacetEntryMap;
    }

    @Override
    public List<String> getMissingSelectedQueryFacetEntries() {
        if (null == this.m_missingQueryFacetEntries) {
            Set<String> returnedValues = this.getFacetQuery().keySet();
            I_CmsSearchControllerFacetQuery facetController = this.m_controller.getQueryFacet();
            this.m_missingQueryFacetEntries = new ArrayList<String>();
            if (null != facetController) {
                List<String> checkedEntries = facetController.getState().getCheckedEntries();
                if (null != returnedValues) {
                    for (String checked : checkedEntries) {
                        if (returnedValues.contains(checked)) continue;
                        this.m_missingQueryFacetEntries.add(checked);
                    }
                } else {
                    this.m_missingQueryFacetEntries = checkedEntries;
                }
            }
        }
        return this.m_missingQueryFacetEntries;
    }

    @Override
    public Map<String, List<String>> getMissingSelectedRangeFacetEntries() {
        if (this.m_missingRangeFacetEntryMap == null) {
            this.m_missingRangeFacetEntryMap = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(Object fieldName) {
                    RangeFacet facetResult = (RangeFacet)CmsSearchResultWrapper.this.m_rangeFacetMap.get(fieldName);
                    I_CmsSearchControllerFacetRange facetController = CmsSearchResultWrapper.this.m_controller.getRangeFacets().getRangeFacetController().get(fieldName.toString());
                    List<Object> result = new ArrayList();
                    if (null != facetController) {
                        List<String> checkedEntries = facetController.getState().getCheckedEntries();
                        if (null != facetResult) {
                            ArrayList<String> returnedValues = new ArrayList<String>(facetResult.getCounts().size());
                            for (Object value : facetResult.getCounts()) {
                                returnedValues.add(((RangeFacet.Count)value).getValue());
                            }
                            for (String checked : checkedEntries) {
                                if (returnedValues.contains(checked)) continue;
                                result.add(checked);
                            }
                        } else {
                            result = checkedEntries;
                        }
                    }
                    return result;
                }
            });
        }
        return this.m_missingRangeFacetEntryMap;
    }

    @Override
    public long getNumFound() {
        return this.m_numFound;
    }

    @Override
    public long getNumMaxReturned() {
        long maxReturnedResults = Integer.valueOf(this.m_controller.getCommon().getConfig().getMaxReturnedResults()).longValue();
        return maxReturnedResults >= 0L && maxReturnedResults > this.getNumFound() ? this.getNumFound() : maxReturnedResults;
    }

    @Override
    public int getNumPages() {
        return this.m_solrResultList == null ? 1 : this.m_controller.getPagination().getConfig().getNumPages(this.getNumMaxReturned());
    }

    @Override
    public int getPageNavFirst() {
        int page = this.m_controller.getPagination().getState().getCurrentPage() - (this.m_controller.getPagination().getConfig().getPageNavLength() - 1) / 2;
        return page < 1 ? 1 : page;
    }

    @Override
    public int getPageNavLast() {
        int page = this.m_controller.getPagination().getState().getCurrentPage() + this.m_controller.getPagination().getConfig().getPageNavLength() / 2;
        return page > this.getNumPages() ? this.getNumPages() : page;
    }

    @Override
    public Map<String, RangeFacet> getRangeFacet() {
        return this.m_rangeFacetMap;
    }

    @Override
    public Collection<RangeFacet> getRangeFacets() {
        return this.m_rangeFacetMap.values();
    }

    @Override
    public Collection<I_CmsSearchResourceBean> getSearchResults() {
        return this.m_foundResources;
    }

    @Override
    public Long getStart() {
        return this.m_start;
    }

    @Override
    public CmsSearchStateParameters getStateParameters() {
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        this.m_controller.addParametersForCurrentState(parameters);
        return new CmsSearchStateParameters(this, parameters);
    }

    protected void convertSearchResults(Collection<CmsSearchResource> searchResults) {
        this.m_foundResources = new ArrayList<I_CmsSearchResourceBean>();
        for (CmsSearchResource searchResult : searchResults) {
            this.m_foundResources.add(new CmsSearchResourceBean(searchResult, this.m_cmsObject));
        }
    }

    private String removeLocalParamPrefix(String q) {
        int index = q.indexOf(125);
        if (index >= 0) {
            return q.substring(index + 1);
        }
        return q;
    }
}

