/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.userdata;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.jsp.userdata.CmsUserDataRequestType;
import org.opencms.main.CmsLog;

public class CmsUserDataRequestInfo {
    public static final String A_AUTH = "auth";
    public static final String A_CONTENT = "content";
    public static final String A_EMAIL = "email";
    public static final String A_EXPIRATION = "exp";
    public static final String A_ID = "id";
    public static final String A_TYPE = "type";
    public static final String A_USERIDS = "userids";
    private static final String A_HTML = "html";
    private static final String A_USER = "user";
    private static final Log LOG = CmsLog.getLog(CmsUserDataRequestInfo.class);
    private JSONObject m_json = new JSONObject();

    public CmsUserDataRequestInfo() {
        this.setId(RandomStringUtils.randomAlphanumeric((int)20).toLowerCase());
        this.setAuth(RandomStringUtils.randomAlphanumeric((int)20).toLowerCase());
    }

    public CmsUserDataRequestInfo(String data) throws JSONException {
        this.m_json = new JSONObject(data);
    }

    public boolean checkAuthCode(String auth) {
        String storedAuth = this.getAuthCode();
        return storedAuth != null && storedAuth.equals(auth);
    }

    public String getAuthCode() {
        return this.m_json.optString(A_AUTH);
    }

    public String getEmail() {
        return this.m_json.optString(A_EMAIL);
    }

    public long getExpiration() {
        return this.m_json.optLong(A_EXPIRATION, -1L);
    }

    public String getId() {
        return this.m_json.optString(A_ID);
    }

    public String getInfoHtml() {
        return this.m_json.optString(A_HTML);
    }

    public CmsUserDataRequestType getType() {
        String strType = this.m_json.optString(A_TYPE);
        if (strType == null) {
            return null;
        }
        return CmsUserDataRequestType.valueOf(strType);
    }

    public String getUserName() {
        return this.m_json.optString(A_USER);
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.getExpiration();
    }

    public void setAuth(String auth) {
        this.setString(A_AUTH, auth);
    }

    public void setEmail(String email) {
        this.setString(A_EMAIL, email);
    }

    public void setExpiration(long expiration) {
        try {
            this.m_json.put(A_EXPIRATION, expiration);
        }
        catch (JSONException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void setId(String id) {
        this.setString(A_ID, id);
    }

    public void setInfoHtml(String infoHtml) {
        this.setString(A_HTML, infoHtml);
    }

    public void setType(CmsUserDataRequestType type) {
        this.setString(A_TYPE, type.toString());
    }

    public void setUser(String user) {
        this.setString(A_USER, user);
    }

    public String toJson() {
        return this.m_json.toString();
    }

    public String toString() {
        return this.toJson();
    }

    private void setString(String key, String value) {
        try {
            this.m_json.put(key, value);
        }
        catch (JSONException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

