/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.userdata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.digester3.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.mail.EmailException;
import org.dom4j.Element;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsUserSearchParameters;
import org.opencms.jsp.userdata.CmsUserDataRequestConfig;
import org.opencms.jsp.userdata.CmsUserDataRequestException;
import org.opencms.jsp.userdata.CmsUserDataRequestInfo;
import org.opencms.jsp.userdata.CmsUserDataRequestStore;
import org.opencms.jsp.userdata.CmsUserDataRequestType;
import org.opencms.jsp.userdata.I_CmsUserDataDomain;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.mail.CmsHtmlMail;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public class CmsUserDataRequestManager {
    public static final String FUNCTION_NAME = "userdatarequest";
    public static final String N_USERDATA = "userdata";
    public static final String N_USERDATA_DOMAIN = "userdata-domain";
    private static final Log LOG = CmsLog.getLog(CmsUserDataRequestManager.class);
    private CmsUserDataRequestStore m_requestStore = new CmsUserDataRequestStore();
    private CmsObject m_adminCms;
    private List<I_CmsUserDataDomain> m_domains = new ArrayList<I_CmsUserDataDomain>();

    public static void addDigesterRules(Digester digester, String basePath) {
        digester.addObjectCreate(basePath, CmsUserDataRequestManager.class);
        String domainPath = basePath + "/" + N_USERDATA_DOMAIN;
        digester.addObjectCreate(domainPath, null, "class");
        digester.addSetNext(domainPath, "addUserDataDomain");
    }

    public static List<CmsUser> getUsersByEmail(CmsObject cms, String email) throws CmsException {
        CmsUserSearchParameters params = new CmsUserSearchParameters();
        params.setPaging(9999, 1);
        params.setFilterEmail(email);
        params.setSorting(CmsUserSearchParameters.SortKey.email, true);
        List<CmsUser> users = OpenCms.getOrgUnitManager().searchUsers(cms, params);
        return users;
    }

    public void addUserDataDomain(I_CmsUserDataDomain domain) {
        this.checkNotInitialized();
        this.m_domains.add(domain);
    }

    public void appendToXml(Element element) {
        Element root = element.addElement(N_USERDATA);
        for (I_CmsUserDataDomain domain : this.m_domains) {
            String clsName = domain.getClass().getName();
            Element domainElem = root.addElement(N_USERDATA_DOMAIN);
            domainElem.addAttribute("class", clsName);
            CmsParameterConfiguration config = domain.getConfiguration();
            config.appendToXml(domainElem);
        }
    }

    public void checkNotInitialized() {
        if (this.m_adminCms != null) {
            throw new IllegalStateException("CmsUserDataRequestManager already initialized.");
        }
    }

    public CmsUserDataRequestStore getRequestStore() {
        return this.m_requestStore;
    }

    public void initialize(CmsObject cms) {
        this.checkNotInitialized();
        this.m_adminCms = cms;
        for (I_CmsUserDataDomain domain : this.m_domains) {
            domain.initialize(cms);
        }
        this.m_requestStore.initialize(cms);
    }

    public Optional<CmsUserDataRequestConfig> loadConfig(CmsObject cms, String path) {
        LOG.debug((Object)("loading user data request config for path " + path));
        if (path == null) {
            LOG.info((Object)"path is null");
            return Optional.empty();
        }
        try {
            CmsResource resource = cms.readResource(path);
            CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, cms.readFile(resource));
            CmsUserDataRequestConfig result = new CmsUserDataRequestConfig(cms, content, cms.getRequestContext().getLocale());
            return Optional.of(result);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    public void startUserDataRequest(CmsObject cms, CmsUserDataRequestConfig config, CmsUser user) throws AddressException, EmailException {
        Document doc = Jsoup.parseBodyFragment((String)"");
        org.jsoup.nodes.Element root = doc.body().appendElement("div");
        CmsUserDataRequestInfo info = new CmsUserDataRequestInfo();
        info.setUser(user.getName());
        info.setType(CmsUserDataRequestType.singleUser);
        info.setEmail(user.getEmail());
        info.setExpiration(System.currentTimeMillis() + config.getRequestLifetime());
        for (I_CmsUserDataDomain userDomain : this.m_domains) {
            if (!userDomain.matchesUser(cms, CmsUserDataRequestType.singleUser, user)) continue;
            userDomain.appendInfoHtml(cms, CmsUserDataRequestType.singleUser, Collections.singletonList(user), root);
        }
        info.setInfoHtml(root.toString());
        this.m_requestStore.save(info);
        this.sendMail(cms, config, user.getEmail(), info.getId());
    }

    public void startUserDataRequest(CmsObject cms, CmsUserDataRequestConfig config, String email) throws CmsUserDataRequestException, EmailException, AddressException {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(email)) {
            throw new IllegalArgumentException("Can not use empty email address for user data request by email.");
        }
        try {
            List<CmsUser> users = CmsUserDataRequestManager.getUsersByEmail(this.m_adminCms, email);
            Document doc = Jsoup.parseBodyFragment((String)"");
            org.jsoup.nodes.Element root = doc.body().appendElement("div");
            boolean foundDomain = false;
            for (I_CmsUserDataDomain userDomain : this.m_domains) {
                ArrayList<CmsUser> usersForDomain = new ArrayList<CmsUser>();
                for (CmsUser user : users) {
                    if (!userDomain.matchesUser(cms, CmsUserDataRequestType.email, user)) continue;
                    usersForDomain.add(user);
                    foundDomain = true;
                }
                if (usersForDomain.isEmpty()) continue;
                userDomain.appendInfoHtml(cms, CmsUserDataRequestType.email, usersForDomain, root);
            }
            if (!foundDomain) {
                throw new CmsUserDataRequestException("no users found with the given email address.");
            }
            CmsUserDataRequestInfo info = new CmsUserDataRequestInfo();
            info.setType(CmsUserDataRequestType.email);
            info.setEmail(email);
            info.setInfoHtml(root.toString());
            info.setExpiration(System.currentTimeMillis() + config.getRequestLifetime());
            this.m_requestStore.save(info);
            this.sendMail(cms, config, email, info.getId());
        }
        catch (CmsException e) {
            throw new CmsUserDataRequestException(e);
        }
    }

    public String toString() {
        String collectorsStr = this.m_domains.stream().map(domain -> domain.toString()).collect(Collectors.joining(", "));
        return this.getClass().getName() + "[" + collectorsStr + "]";
    }

    private void sendMail(CmsObject cms, CmsUserDataRequestConfig config, String email, String id) throws EmailException, AddressException {
        CmsHtmlMail mail = new CmsHtmlMail();
        mail.setCharset("UTF-8");
        mail.setSubject(config.getMailSubject());
        mail.setTo(Arrays.asList(InternetAddress.parse((String)email)));
        String link = CmsJspStandardContextBean.getFunctionDetailLink(cms, "function@", FUNCTION_NAME, true) + "?" + "udrid" + "=" + id + "&" + "action" + "=" + "view";
        mail.setHtmlMsg(config.getMailText() + "<a href=\"" + link + "\">" + link + "</a>");
        mail.send();
    }
}

