/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import com.google.common.collect.Multimap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsADEManager;
import org.opencms.ade.configuration.CmsFunctionReference;
import org.opencms.ade.configuration.plugins.CmsTemplatePlugin;
import org.opencms.ade.configuration.plugins.CmsTemplatePluginFinder;
import org.opencms.ade.containerpage.CmsContainerpageService;
import org.opencms.ade.containerpage.CmsDetailOnlyContainerUtil;
import org.opencms.ade.containerpage.CmsModelGroupHelper;
import org.opencms.ade.containerpage.shared.CmsFormatterConfig;
import org.opencms.ade.containerpage.shared.CmsInheritanceInfo;
import org.opencms.ade.detailpage.CmsDetailPageInfo;
import org.opencms.ade.detailpage.CmsDetailPageResourceHandler;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.history.CmsHistoryResourceHandler;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.flex.CmsFlexController;
import org.opencms.flex.CmsFlexRequest;
import org.opencms.i18n.CmsLocaleGroupService;
import org.opencms.jsp.CmsJspBean;
import org.opencms.jsp.CmsJspResourceWrapper;
import org.opencms.jsp.CmsJspTagContainer;
import org.opencms.jsp.CmsJspTagEditable;
import org.opencms.jsp.Messages;
import org.opencms.jsp.jsonpart.CmsJsonPartFilter;
import org.opencms.jsp.util.A_CmsJspCustomContextBean;
import org.opencms.jsp.util.A_CmsJspValueWrapper;
import org.opencms.jsp.util.CmsDynamicFunctionBeanWrapper;
import org.opencms.jsp.util.CmsDynamicFunctionFormatWrapper;
import org.opencms.jsp.util.CmsJspCategoryAccessBean;
import org.opencms.jsp.util.CmsJspContentAccessBean;
import org.opencms.jsp.util.CmsJspContentAccessValueWrapper;
import org.opencms.jsp.util.CmsJspElFunctions;
import org.opencms.jsp.util.CmsJspElementSettingValueWrapper;
import org.opencms.jsp.util.CmsJspObjectValueWrapper;
import org.opencms.jsp.util.CmsJspSitemapConfigWrapper;
import org.opencms.jsp.util.CmsJspVfsAccessBean;
import org.opencms.jsp.util.CmsTemplatePluginWrapper;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.CmsSystemInfo;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsCategory;
import org.opencms.relations.CmsCategoryService;
import org.opencms.search.galleries.CmsGalleryNameMacroResolver;
import org.opencms.site.CmsSite;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsADESessionCache;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsDynamicFunctionBean;
import org.opencms.xml.containerpage.CmsDynamicFunctionParser;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.containerpage.CmsMetaMapping;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.templatemapper.CmsTemplateMapper;
import org.opencms.xml.types.I_CmsXmlContentValue;

public final class CmsJspStandardContextBean {
    public static final String ATTRIBUTE_CMS_OBJECT = "__cmsObject";
    public static final String ATTRIBUTE_NAME = "cms";
    protected static final Log LOG = CmsLog.getLog(CmsJspStandardContextBean.class);
    protected CmsObject m_cms;
    protected CmsADEConfigData m_config;
    Map<String, MetaMapping> m_metaMappings;
    ServletRequest m_request;
    private Map<String, CmsJspCategoryAccessBean> m_allSubCategories;
    private Map<String, CmsCategory> m_categories;
    private CmsContainerBean m_container;
    private CmsResource m_detailContentResource;
    private CmsResource m_detailFunctionPage;
    private CmsContainerPageBean m_detailOnlyPage;
    private boolean m_edited;
    private CmsContainerElementBean m_element;
    private Map<String, CmsContainerElementBean> m_elementInstances;
    private Map<String, CmsDynamicFunctionBeanWrapper> m_function;
    private Map<String, String> m_functionDetailPage;
    private boolean m_isDragMode;
    private Boolean m_isEditMode;
    private Map<String, String> m_localeTitles;
    private CmsContainerPageBean m_page;
    private CmsJspResourceWrapper m_pageResource;
    private Map<String, CmsContainerBean> m_parentContainers;
    private Map<String, List<CmsCategory>> m_pathCategories;
    private Map<String, CmsJspCategoryAccessBean> m_resourceCategories;
    private Map<String, String> m_sitePaths;
    private Map<String, List<CmsTemplatePluginWrapper>> m_templatePlugins;
    private Map<String, String> m_typeDetailPage;
    private CmsJspVfsAccessBean m_vfsBean;

    private CmsJspStandardContextBean() {
    }

    private CmsJspStandardContextBean(ServletRequest req) {
        CmsFlexController controller = CmsFlexController.getController(req);
        this.m_request = req;
        CmsObject cms = controller != null ? controller.getCmsObject() : (CmsObject)req.getAttribute(ATTRIBUTE_CMS_OBJECT);
        if (cms == null) {
            throw new CmsRuntimeException(Messages.get().container("ERR_MISSING_CMS_CONTROLLER_1", CmsJspBean.class.getName()));
        }
        this.updateCmsObject(cms);
        this.m_detailContentResource = CmsDetailPageResourceHandler.getDetailResource(req);
        this.m_detailFunctionPage = CmsDetailPageResourceHandler.getDetailFunctionPage(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFunctionDetailLink(CmsObject cms, String prefix, String functionName, boolean fullLink) {
        String type = prefix + functionName;
        CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(cms, cms.addSiteRoot(cms.getRequestContext().getUri()));
        List<CmsDetailPageInfo> detailPages = config.getDetailPagesForType(type);
        CmsDetailPageInfo detailPage = null;
        boolean usingDefault = false;
        if (detailPages == null || detailPages.size() == 0) {
            detailPage = config.getDefaultDetailPage();
            usingDefault = true;
        } else {
            detailPage = detailPages.get(0);
        }
        if (detailPage == null) {
            return "[No detail page configured for type =" + type + "=]";
        }
        CmsUUID id = detailPage.getId();
        CmsResource r = cms.readResource(id);
        boolean originalForceAbsoluteLinks = cms.getRequestContext().isForceAbsoluteLinks();
        try {
            cms.getRequestContext().setForceAbsoluteLinks(fullLink || originalForceAbsoluteLinks);
            String link = OpenCms.getLinkManager().substituteLink(cms, r);
            if (usingDefault) {
                link = CmsStringUtil.joinPaths(link, functionName);
            }
            String string = link;
            cms.getRequestContext().setForceAbsoluteLinks(originalForceAbsoluteLinks);
            return string;
        }
        catch (Throwable throwable) {
            try {
                cms.getRequestContext().setForceAbsoluteLinks(originalForceAbsoluteLinks);
                throw throwable;
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                return "[Error reading detail page for type =" + type + "=]";
            }
        }
    }

    public static CmsJspStandardContextBean getInstance(ServletRequest req) {
        CmsJspStandardContextBean result;
        Object attribute = req.getAttribute(ATTRIBUTE_NAME);
        if (attribute != null && attribute instanceof CmsJspStandardContextBean) {
            result = (CmsJspStandardContextBean)attribute;
        } else {
            result = new CmsJspStandardContextBean(req);
            req.setAttribute(ATTRIBUTE_NAME, (Object)result);
        }
        return result;
    }

    public CmsJspStandardContextBean createCopy() {
        CmsJspStandardContextBean result = new CmsJspStandardContextBean();
        result.m_container = this.m_container;
        if (this.m_detailContentResource != null) {
            result.m_detailContentResource = this.m_detailContentResource.getCopy();
        }
        result.m_element = this.m_element;
        result.setPage(this.m_page);
        return result;
    }

    public String decrypt(String text) {
        try {
            return OpenCms.getTextEncryptions().get("default").decrypt(text);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String elementCachingHash() {
        String result = "";
        if (this.m_element != null) {
            result = this.m_element.editorHash();
            if (this.m_container != null) {
                result = result + "w:" + this.m_container.getWidth() + "cName:" + this.m_container.getName() + "cType:" + this.m_container.getType();
            }
        }
        return result;
    }

    public String encrypt(String text) {
        try {
            return OpenCms.getTextEncryptions().get("default").encrypt(text);
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<Locale> getAvailableLocales() {
        return OpenCms.getLocaleManager().getAvailableLocales(this.m_cms, this.getRequestContext().getUri());
    }

    public Object getBean(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (A_CmsJspCustomContextBean.class.isAssignableFrom(clazz)) {
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                Object instance = constructor.newInstance(new Object[0]);
                Method setContextMethod = clazz.getMethod("setContext", CmsJspStandardContextBean.class);
                setContextMethod.invoke(instance, this);
                return instance;
            }
            throw new Exception();
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().container("ERR_NO_CUSTOM_BEAN_1", className));
            return null;
        }
    }

    public String getBinaryUploadFolder(CmsJspContentAccessBean content) {
        String keyToFind = "binary.upload.target";
        String baseValue = null;
        if (content != null) {
            List<CmsJspContentAccessValueWrapper> folderEntries;
            for (CmsJspContentAccessValueWrapper wrapper : content.getValueList().get("Parameter")) {
                String paramKey = wrapper.getValue().get("Key").getToString();
                String paramValue = wrapper.getValue().get("Value").getToString();
                if (!paramKey.equals(keyToFind)) continue;
                LOG.debug((Object)("Found upload folder in configuration: " + paramValue));
                baseValue = paramValue;
                break;
            }
            if (baseValue == null && (folderEntries = content.getValueList().get("SearchFolder")).size() == 1) {
                CmsJspResourceWrapper resource = folderEntries.get(0).getToResource();
                List<String> galleryTypes = Arrays.asList("downloadgallery", "imagegallery");
                if (resource != null && null != this.findAncestor(this.m_cms, resource, ancestor -> galleryTypes.stream().anyMatch(type -> OpenCms.getResourceManager().matchResourceType((String)type, ancestor.getTypeId())))) {
                    baseValue = this.m_cms.getSitePath(resource);
                    LOG.debug((Object)("Using single download gallery from search folder configuration as upload folder: " + baseValue));
                }
            }
        }
        if (baseValue == null && (baseValue = this.m_config.getAttribute(keyToFind, null)) != null) {
            LOG.debug((Object)("Found upload folder in sitemap configuration: " + baseValue));
        }
        CmsMacroResolver resolver = new CmsMacroResolver();
        resolver.setCmsObject(this.getCmsObject());
        resolver.addMacro("subsitepath", CmsFileUtil.removeTrailingSeparator(this.getSubSitePath()));
        resolver.addMacro("sitepath", "/");
        String result = resolver.resolveMacros(baseValue);
        LOG.debug((Object)("Final value for upload folder : " + result));
        return result;
    }

    public CmsContainerBean getContainer() {
        return this.m_container;
    }

    public CmsObject getControllerCms() {
        return CmsFlexController.getController(this.m_request).getCmsObject();
    }

    public CmsJspResourceWrapper getDetailContent() {
        return CmsJspResourceWrapper.wrap(this.m_cms, this.m_detailContentResource);
    }

    public CmsUUID getDetailContentId() {
        return this.m_detailContentResource == null ? null : this.m_detailContentResource.getStructureId();
    }

    public String getDetailContentSitePath() {
        return this.m_cms == null || this.m_detailContentResource == null ? null : this.m_cms.getSitePath(this.m_detailContentResource);
    }

    public CmsJspResourceWrapper getDetailFunctionPage() {
        return CmsJspResourceWrapper.wrap(this.m_cms, this.m_detailFunctionPage);
    }

    public CmsContainerPageBean getDetailOnlyPage() {
        if (null == this.m_detailOnlyPage && null != this.m_detailContentResource) {
            String pageRootPath = this.m_cms.getRequestContext().addSiteRoot(this.m_cms.getRequestContext().getUri());
            this.m_detailOnlyPage = CmsDetailOnlyContainerUtil.getDetailOnlyPage(this.m_cms, this.m_request, pageRootPath, false);
        }
        return this.m_detailOnlyPage;
    }

    public CmsContainerElementWrapper getElement() {
        return this.m_element != null ? new CmsContainerElementWrapper(this.m_element) : null;
    }

    public Map<String, List<CmsContainerElementWrapper>> getElementBeansInContainers() {
        return CmsCollectionsGenericWrapper.createLazyMap(obj -> {
            if (obj instanceof String) {
                ArrayList<CmsContainerElementWrapper> containerElements = new ArrayList<CmsContainerElementWrapper>();
                for (CmsContainerBean container : this.getPage().getContainers().values()) {
                    if (!container.getName().endsWith("-" + obj)) continue;
                    for (CmsContainerElementBean element : container.getElements()) {
                        try {
                            element.initResource(this.m_cms);
                            containerElements.add(new CmsContainerElementWrapper(element));
                        }
                        catch (Exception e) {
                            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                }
                return containerElements;
            }
            return null;
        });
    }

    public Map<String, List<CmsJspResourceWrapper>> getElementsInContainer() {
        return CmsCollectionsGenericWrapper.createLazyMap(obj -> {
            if (obj instanceof String) {
                ArrayList<CmsJspResourceWrapper> elements = new ArrayList<CmsJspResourceWrapper>();
                CmsContainerBean container = this.getPage().getContainers().get(obj);
                if (container != null) {
                    for (CmsContainerElementBean element : container.getElements()) {
                        try {
                            element.initResource(this.m_cms);
                            elements.add(CmsJspResourceWrapper.wrap(this.m_cms, element.getResource()));
                        }
                        catch (Exception e) {
                            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                }
                return elements;
            }
            return null;
        });
    }

    public Map<String, List<CmsJspResourceWrapper>> getElementsInContainers() {
        return CmsCollectionsGenericWrapper.createLazyMap(obj -> {
            if (obj instanceof String) {
                ArrayList<CmsJspResourceWrapper> elements = new ArrayList<CmsJspResourceWrapper>();
                for (CmsContainerBean container : this.getPage().getContainers().values()) {
                    if (!container.getName().endsWith("-" + obj)) continue;
                    for (CmsContainerElementBean element : container.getElements()) {
                        try {
                            element.initResource(this.m_cms);
                            elements.add(CmsJspResourceWrapper.wrap(this.m_cms, element.getResource()));
                        }
                        catch (Exception e) {
                            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                }
                return elements;
            }
            return null;
        });
    }

    public String getEnableReload() {
        return this.getReloadMarker();
    }

    public Map<String, CmsDynamicFunctionBeanWrapper> getFunction() {
        if (this.m_function == null) {
            Transformer transformer = new Transformer(){

                public Object transform(Object input) {
                    try {
                        CmsDynamicFunctionBean dynamicFunction = CmsJspStandardContextBean.this.readDynamicFunctionBean((String)input);
                        CmsDynamicFunctionBeanWrapper wrapper = new CmsDynamicFunctionBeanWrapper(CmsJspStandardContextBean.this.m_cms, dynamicFunction);
                        return wrapper;
                    }
                    catch (CmsException e) {
                        LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                        return new CmsDynamicFunctionBeanWrapper(CmsJspStandardContextBean.this.m_cms, null);
                    }
                }
            };
            this.m_function = CmsCollectionsGenericWrapper.createLazyMap(transformer);
        }
        return this.m_function;
    }

    @Deprecated
    public Map<String, String> getFunctionDetail() {
        return this.getFunctionDetailPage();
    }

    public Map<String, String> getFunctionDetailPage() {
        if (this.m_functionDetailPage == null) {
            this.m_functionDetailPage = CmsCollectionsGenericWrapper.createLazyMap(new CmsDetailLookupTransformer("function@"));
        }
        return this.m_functionDetailPage;
    }

    public Map<CmsJspContentAccessBean, CmsDynamicFunctionFormatWrapper> getFunctionFormatFromContent() {
        Transformer transformer = new Transformer(){

            public Object transform(Object contentAccess) {
                CmsXmlContent content = (CmsXmlContent)((CmsJspContentAccessBean)contentAccess).getRawContent();
                CmsDynamicFunctionParser parser = new CmsDynamicFunctionParser();
                CmsDynamicFunctionBean functionBean = null;
                try {
                    functionBean = parser.parseFunctionBean(CmsJspStandardContextBean.this.m_cms, content);
                }
                catch (CmsException e) {
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                    return new CmsDynamicFunctionFormatWrapper(CmsJspStandardContextBean.this.m_cms, null);
                }
                String type = CmsJspStandardContextBean.this.getContainer().getType();
                String width = CmsJspStandardContextBean.this.getContainer().getWidth();
                int widthNum = -1;
                try {
                    widthNum = Integer.parseInt(width);
                }
                catch (NumberFormatException e) {
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                CmsDynamicFunctionBean.Format format = functionBean.getFormatForContainer(CmsJspStandardContextBean.this.m_cms, type, widthNum);
                CmsDynamicFunctionFormatWrapper wrapper = new CmsDynamicFunctionFormatWrapper(CmsJspStandardContextBean.this.m_cms, format);
                return wrapper;
            }
        };
        return CmsCollectionsGenericWrapper.createLazyMap(transformer);
    }

    public boolean getIsDetailPage() {
        CmsJspResourceWrapper page = this.getPageResource();
        return OpenCms.getADEManager().isDetailPage(this.m_cms, page);
    }

    public boolean getIsEditMode() {
        if (this.m_isEditMode == null) {
            this.m_isEditMode = CmsJspTagEditable.isEditableRequest(this.m_request);
        }
        return this.m_isEditMode;
    }

    public boolean getIsJSONRequest() {
        return CmsJsonPartFilter.isJsonRequest(this.m_request);
    }

    public boolean getIsOnlineProject() {
        return this.m_cms.getRequestContext().getCurrentProject().isOnlineProject();
    }

    public Locale getLocale() {
        return this.getRequestContext().getLocale();
    }

    public Map<String, CmsJspResourceWrapper> getLocaleResource() {
        Map<String, CmsJspResourceWrapper> result = this.getPageResource().getLocaleResource();
        List<Locale> locales = CmsLocaleGroupService.getPossibleLocales(this.m_cms, this.getPageResource());
        for (Locale locale : locales) {
            if (result.containsKey(locale.toString())) continue;
            result.put(locale.toString(), null);
        }
        return result;
    }

    public Locale getMainLocale() {
        return this.getPageResource().getMainLocale();
    }

    public Map<String, String> getMeta() {
        this.initMetaMappings();
        return CmsCollectionsGenericWrapper.createLazyMap(new MetaLookupTranformer());
    }

    public CmsContainerPageBean getPage() {
        block3: {
            if (null == this.m_page) {
                try {
                    this.initPage();
                }
                catch (CmsException e) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn((Object)e, (Throwable)e);
                }
            }
        }
        return this.m_page;
    }

    public CmsContainerPageBean getPage(Object page, Object locale) {
        CmsResource pageResource = null;
        CmsContainerPageBean result = null;
        if (this.m_cms != null) {
            try {
                pageResource = CmsJspElFunctions.convertRawResource(this.m_cms, page);
                Locale l = CmsJspElFunctions.convertLocale(locale);
                result = this.getPage(pageResource);
                if (result != null) {
                    CmsADEConfigData adeConfig = OpenCms.getADEManager().lookupConfiguration(this.m_cms, pageResource.getRootPath());
                    for (CmsContainerBean container : result.getContainers().values()) {
                        for (CmsContainerElementBean element : container.getElements()) {
                            boolean isGroupContainer = element.isGroupContainer(this.m_cms);
                            boolean isInheritedContainer = element.isInheritedContainer(this.m_cms);
                            I_CmsFormatterBean formatterConfig = null;
                            if (isGroupContainer || isInheritedContainer) continue;
                            element.initResource(this.m_cms);
                            formatterConfig = CmsJspTagContainer.getFormatterConfigurationForElement(this.m_cms, element, adeConfig, container.getName(), "", 0);
                            if (formatterConfig == null) continue;
                            element.initSettings(this.m_cms, adeConfig, formatterConfig, l, this.m_request, null);
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public CmsJspResourceWrapper getPageResource() {
        try {
            if (this.m_pageResource == null) {
                this.m_pageResource = CmsJspResourceWrapper.wrap(this.m_cms, (CmsResource)((Object)CmsHistoryResourceHandler.getHistoryResource(this.m_request)));
                if (this.m_pageResource == null) {
                    this.m_pageResource = CmsJspResourceWrapper.wrap(this.m_cms, this.m_cms.readResource(this.m_cms.getRequestContext().getUri(), CmsResourceFilter.ignoreExpirationOffline(this.m_cms)));
                }
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return this.m_pageResource;
    }

    public CmsContainerBean getParentContainer() {
        CmsContainerBean result = null;
        if (this.getContainer() != null && this.getContainer().getParentInstanceId() != null) {
            result = this.m_parentContainers.get(this.getContainer().getParentInstanceId());
        }
        return result;
    }

    public Map<String, CmsContainerBean> getParentContainers() {
        if (this.m_parentContainers == null) {
            this.initPageData();
        }
        return Collections.unmodifiableMap(this.m_parentContainers);
    }

    public CmsContainerElementBean getParentElement() {
        return this.getParentElement(this.getElement());
    }

    public Set<String> getPluginGroups() {
        return this.getPlugins().keySet();
    }

    public Map<String, List<CmsTemplatePluginWrapper>> getPlugins() {
        if (this.m_templatePlugins == null) {
            Multimap<String, CmsTemplatePlugin> templatePluginsMultimap = new CmsTemplatePluginFinder(this).getTemplatePlugins();
            HashMap<String, List<CmsTemplatePluginWrapper>> templatePlugins = new HashMap<String, List<CmsTemplatePluginWrapper>>();
            for (String key : templatePluginsMultimap.keySet()) {
                ArrayList<CmsTemplatePluginWrapper> wrappers = new ArrayList<CmsTemplatePluginWrapper>();
                for (CmsTemplatePlugin plugin : templatePluginsMultimap.get((Object)key)) {
                    wrappers.add(new CmsTemplatePluginWrapper(this.m_cms, plugin));
                }
                templatePlugins.put(key, Collections.unmodifiableList(wrappers));
            }
            this.m_templatePlugins = templatePlugins;
        }
        return this.m_templatePlugins;
    }

    public Map<String, String> getPreviewFormatter() {
        Transformer transformer = new Transformer(){

            public Object transform(Object uri) {
                try {
                    String rootPath = CmsJspStandardContextBean.this.m_cms.getRequestContext().addSiteRoot((String)uri);
                    CmsResource resource = CmsJspStandardContextBean.this.m_cms.readResource((String)uri);
                    CmsADEManager adeManager = OpenCms.getADEManager();
                    CmsADEConfigData configData = adeManager.lookupConfiguration(CmsJspStandardContextBean.this.m_cms, rootPath);
                    CmsFormatterConfiguration formatterConfig = configData.getFormatters(CmsJspStandardContextBean.this.m_cms, resource);
                    if (formatterConfig == null) {
                        return "";
                    }
                    I_CmsFormatterBean previewFormatter = formatterConfig.getPreviewFormatter();
                    if (previewFormatter == null) {
                        return "";
                    }
                    CmsUUID structureId = previewFormatter.getJspStructureId();
                    CmsJspStandardContextBean.this.m_cms.readResource(structureId);
                    CmsResource formatterResource = CmsJspStandardContextBean.this.m_cms.readResource(structureId);
                    String formatterSitePath = CmsJspStandardContextBean.this.m_cms.getRequestContext().removeSiteRoot(formatterResource.getRootPath());
                    return formatterSitePath;
                }
                catch (CmsException e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                    return "";
                }
            }
        };
        return CmsCollectionsGenericWrapper.createLazyMap(transformer);
    }

    public Map<String, CmsJspCategoryAccessBean> getReadAllSubCategories() {
        if (null == this.m_allSubCategories) {
            this.m_allSubCategories = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(Object categoryPath) {
                    try {
                        List<CmsCategory> categories = CmsCategoryService.getInstance().readCategories(CmsJspStandardContextBean.this.m_cms, (String)categoryPath, true, CmsJspStandardContextBean.this.m_cms.getRequestContext().getUri());
                        CmsJspCategoryAccessBean result = new CmsJspCategoryAccessBean(CmsJspStandardContextBean.this.m_cms, categories, (String)categoryPath);
                        return result;
                    }
                    catch (CmsException e) {
                        LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                        return null;
                    }
                }
            });
        }
        return this.m_allSubCategories;
    }

    public CmsJspCategoryAccessBean getReadCategories() {
        return this.getReadResourceCategories().get(this.getRequestContext().getRootUri());
    }

    public Map<String, CmsCategory> getReadCategory() {
        if (null == this.m_categories) {
            this.m_categories = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(Object categoryPath) {
                    try {
                        CmsCategoryService catService = CmsCategoryService.getInstance();
                        return catService.localizeCategory(CmsJspStandardContextBean.this.m_cms, catService.readCategory(CmsJspStandardContextBean.this.m_cms, (String)categoryPath, CmsJspStandardContextBean.this.getRequestContext().getUri()), CmsJspStandardContextBean.this.m_cms.getRequestContext().getLocale());
                    }
                    catch (CmsException e) {
                        LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                        return null;
                    }
                }
            });
        }
        return this.m_categories;
    }

    public Map<String, List<CmsCategory>> getReadPathCategories() {
        if (null == this.m_pathCategories) {
            this.m_pathCategories = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(Object categoryPath) {
                    ArrayList<CmsCategory> result = new ArrayList<CmsCategory>();
                    String path = (String)categoryPath;
                    if (null == path || path.length() <= 1) {
                        return result;
                    }
                    path = path.substring(0, path.length() - 1);
                    List<String> pathParts = Arrays.asList(path.split("/"));
                    String currentPath = "";
                    for (String part : pathParts) {
                        currentPath = currentPath + part + "/";
                        CmsCategory category = CmsJspStandardContextBean.this.getReadCategory().get(currentPath);
                        if (null == category) continue;
                        result.add(category);
                    }
                    return CmsCategoryService.getInstance().localizeCategories(CmsJspStandardContextBean.this.m_cms, result, CmsJspStandardContextBean.this.m_cms.getRequestContext().getLocale());
                }
            });
        }
        return this.m_pathCategories;
    }

    public Map<String, CmsJspCategoryAccessBean> getReadResourceCategories() {
        if (null == this.m_resourceCategories) {
            this.m_resourceCategories = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(Object resourceName) {
                    try {
                        CmsResource resource = CmsJspStandardContextBean.this.m_cms.readResource(CmsJspStandardContextBean.this.getRequestContext().removeSiteRoot((String)resourceName));
                        return new CmsJspCategoryAccessBean(CmsJspStandardContextBean.this.m_cms, resource);
                    }
                    catch (CmsException e) {
                        LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                        return null;
                    }
                }
            });
        }
        return this.m_resourceCategories;
    }

    public String getReloadMarker() {
        if (this.m_cms.getRequestContext().getCurrentProject().isOnlineProject()) {
            return "";
        }
        return "<!--FORMATTER_RELOAD_g3jf9o0n-->";
    }

    public ServletRequest getRequest() {
        return this.m_request;
    }

    public CmsRequestContext getRequestContext() {
        return this.m_cms.getRequestContext();
    }

    public CmsSite getSite() {
        return OpenCms.getSiteManager().getSiteForSiteRoot(this.m_cms.getRequestContext().getSiteRoot());
    }

    public CmsJspSitemapConfigWrapper getSitemapConfig() {
        return new CmsJspSitemapConfigWrapper(this);
    }

    public Map<String, String> getSitePath() {
        if (this.m_sitePaths == null) {
            this.m_sitePaths = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(Object rootPath) {
                    if (rootPath instanceof String) {
                        return CmsJspStandardContextBean.this.getRequestContext().removeSiteRoot((String)rootPath);
                    }
                    return null;
                }
            });
        }
        return this.m_sitePaths;
    }

    public String getSubSitePath() {
        return this.m_cms.getRequestContext().removeSiteRoot(OpenCms.getADEManager().getSubSiteRoot(this.m_cms, this.m_cms.getRequestContext().getRootUri()));
    }

    public CmsSystemInfo getSystemInfo() {
        return OpenCms.getSystemInfo();
    }

    public TemplateBean getTemplate() {
        TemplateBean templateBean = (TemplateBean)this.getRequestAttribute("ATTR_TEMPLATE_BEAN");
        if (templateBean == null) {
            templateBean = new TemplateBean("", "");
        }
        return templateBean;
    }

    public String getTitle() {
        return this.getLocaleSpecificTitle(null);
    }

    public Map<String, String> getTitleLocale() {
        if (this.m_localeTitles == null) {
            this.m_localeTitles = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(Object inputLocale) {
                    Locale locale = null;
                    if (null != inputLocale) {
                        if (inputLocale instanceof Locale) {
                            locale = (Locale)inputLocale;
                        } else if (inputLocale instanceof String) {
                            try {
                                locale = LocaleUtils.toLocale((String)((String)inputLocale));
                            }
                            catch (IllegalArgumentException | NullPointerException runtimeException) {
                                // empty catch block
                            }
                        }
                    }
                    return CmsJspStandardContextBean.this.getLocaleSpecificTitle(locale);
                }
            });
        }
        return this.m_localeTitles;
    }

    public Map<String, String> getTypeDetailPage() {
        if (this.m_typeDetailPage == null) {
            this.m_typeDetailPage = CmsCollectionsGenericWrapper.createLazyMap(new CmsDetailLookupTransformer(""));
        }
        return this.m_typeDetailPage;
    }

    public CmsJspVfsAccessBean getVfs() {
        if (this.m_vfsBean == null) {
            this.m_vfsBean = CmsJspVfsAccessBean.create(this.m_cms);
        }
        return this.m_vfsBean;
    }

    public Locale getWorkplaceLocale() {
        return OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms);
    }

    public Map<Object, Object> getWrap() {
        return CmsCollectionsGenericWrapper.createLazyMap(obj -> {
            if (obj instanceof A_CmsJspValueWrapper || obj instanceof CmsJspResourceWrapper) {
                return obj;
            }
            if (obj instanceof CmsResource) {
                return CmsJspResourceWrapper.wrap(this.m_cms, (CmsResource)obj);
            }
            return CmsJspObjectValueWrapper.createWrapper(this.m_cms, obj);
        });
    }

    public void initPage() throws CmsException {
        if (this.m_page == null && this.m_cms != null) {
            String requestUri = this.m_cms.getRequestContext().getUri();
            CmsResource pageResource = (CmsResource)((Object)CmsHistoryResourceHandler.getHistoryResource(this.m_request));
            if (pageResource == null) {
                pageResource = this.m_cms.readResource(requestUri, CmsResourceFilter.ignoreExpirationOffline(this.m_cms));
            }
            this.m_config = OpenCms.getADEManager().lookupConfigurationWithCache(this.m_cms, pageResource.getRootPath());
            this.m_page = this.getPage(pageResource);
            this.m_page = CmsTemplateMapper.get(this.m_request).transformContainerpageBean(this.m_cms, this.m_page, pageResource.getRootPath());
        }
    }

    public boolean isDetailPageAvailable() {
        boolean result = false;
        if (this.m_cms != null && this.m_element != null && !this.m_element.isInMemoryOnly() && this.m_element.getResource() != null) {
            try {
                String detailPage = OpenCms.getADEManager().getDetailPageHandler().getDetailPage(this.m_cms, this.m_element.getResource().getRootPath(), this.m_cms.getRequestContext().getUri(), null);
                result = detailPage != null;
            }
            catch (Exception e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public boolean isDetailRequest() {
        return this.m_detailContentResource != null;
    }

    public boolean isDragMode() {
        return this.m_isDragMode;
    }

    public boolean isEdited() {
        return this.m_edited;
    }

    public boolean isModelGroupElement() {
        return this.m_element != null && !this.m_element.isInMemoryOnly() && this.isModelGroupPage() && this.m_element.isModelGroup();
    }

    public boolean isModelGroupPage() {
        CmsJspResourceWrapper page = this.getPageResource();
        return page != null && CmsContainerpageService.isEditingModelGroups(this.m_cms, page);
    }

    public void setContainer(CmsContainerBean container) {
        this.m_container = container;
    }

    public void setDetailOnlyPage(CmsContainerPageBean detailOnlyPage) {
        this.m_detailOnlyPage = detailOnlyPage;
        this.clearPageData();
    }

    public void setDragMode(boolean isDragMode) {
        this.m_isDragMode = isDragMode;
    }

    public void setEdited(boolean edited) {
        this.m_edited = edited;
    }

    public void setElement(CmsContainerElementBean element) {
        this.m_element = element;
    }

    public void setPage(CmsContainerPageBean page) {
        this.m_page = page;
        this.clearPageData();
    }

    public void updateCmsObject(CmsObject cms) {
        try {
            this.m_cms = OpenCms.initCmsObject(cms);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            this.m_cms = cms;
        }
        try {
            this.m_config = OpenCms.getADEManager().lookupConfigurationWithCache(cms, cms.getRequestContext().getRootUri());
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void updateRequestData(CmsFlexRequest cmsFlexRequest) {
        CmsResource detailRes;
        this.m_detailContentResource = detailRes = CmsDetailPageResourceHandler.getDetailResource((ServletRequest)cmsFlexRequest);
        this.m_request = cmsFlexRequest;
    }

    protected CmsObject getCmsObject() {
        return this.m_cms;
    }

    protected I_CmsFormatterBean getElementFormatter(CmsContainerElementBean element) {
        I_CmsFormatterBean formatter;
        block9: {
            if (this.m_elementInstances == null) {
                this.initPageData();
            }
            formatter = null;
            CmsContainerBean container = this.m_parentContainers.get(element.getInstanceId());
            if (container == null) {
                container = this.getContainer();
            }
            if (container != null) {
                String formatterConfigId;
                I_CmsFormatterBean dynamicFmt;
                String containerName = container.getName();
                Map<String, String> settings = element.getSettings();
                if (settings != null && (dynamicFmt = this.m_config.findFormatter(formatterConfigId = settings.get(CmsFormatterConfig.getSettingsKeyForContainer(containerName)))) != null) {
                    formatter = dynamicFmt;
                }
                if (formatter == null) {
                    try {
                        CmsResource resource = this.m_cms.readResource(this.m_cms.getRequestContext().getUri());
                        CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(this.m_cms, resource.getRootPath());
                        CmsFormatterConfiguration formatters = config.getFormatters(this.m_cms, resource);
                        int width = -2;
                        try {
                            width = Integer.parseInt(container.getWidth());
                        }
                        catch (Exception e) {
                            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                        formatter = formatters.getDefaultSchemaFormatter(container.getType(), width);
                    }
                    catch (CmsException e1) {
                        if (!LOG.isWarnEnabled()) break block9;
                        LOG.warn((Object)e1.getLocalizedMessage(), (Throwable)e1);
                    }
                }
            }
        }
        return formatter;
    }

    protected String getLocaleSpecificTitle(Locale locale) {
        String result = null;
        try {
            CmsJspResourceWrapper res;
            CmsFile file;
            CmsXmlContent content;
            if (this.isDetailRequest() && (result = (content = CmsXmlContentFactory.unmarshal(this.m_cms, file = this.m_cms.readFile(res = this.getDetailContent()))).getHandler().getTitleMapping(this.m_cms, content, this.m_cms.getRequestContext().getLocale())) == null) {
                result = this.m_cms.readPropertyObject(res, "Title", false, locale).getValue();
            }
            if (result == null) {
                result = this.m_cms.readPropertyObject(this.m_cms.getRequestContext().getUri(), "Title", true, locale).getValue();
            }
        }
        catch (CmsException e) {
            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(result)) {
            result = "";
        }
        return result;
    }

    protected CmsContainerElementBean getParentElement(CmsContainerElementBean element) {
        if (this.m_elementInstances == null) {
            this.initPageData();
        }
        CmsContainerElementBean parent = null;
        CmsContainerBean cont = this.m_parentContainers.get(element.getInstanceId());
        if (cont != null && cont.isNestedContainer()) {
            parent = this.m_elementInstances.get(cont.getParentInstanceId());
        }
        return parent;
    }

    protected CmsADEConfigData getSitemapConfigInternal() {
        return this.m_config;
    }

    protected CmsDynamicFunctionBean readDynamicFunctionBean(String configuredName) throws CmsException {
        CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(this.m_cms, this.m_cms.addSiteRoot(this.m_cms.getRequestContext().getUri()));
        CmsFunctionReference functionRef = config.getFunctionReference(configuredName);
        if (functionRef == null) {
            return null;
        }
        CmsDynamicFunctionParser parser = new CmsDynamicFunctionParser();
        CmsResource functionResource = this.m_cms.readResource(functionRef.getStructureId());
        CmsDynamicFunctionBean result = parser.parseFunctionBean(this.m_cms, functionResource);
        return result;
    }

    private void addMappingsForFormatter(I_CmsFormatterBean formatterBean, CmsUUID elementId, CmsMacroResolver resolver, boolean isDetailContent) {
        if (formatterBean != null && formatterBean.getMetaMappings() != null) {
            for (CmsMetaMapping map : formatterBean.getMetaMappings()) {
                String key = map.getKey();
                key = resolver.resolveMacros(key);
                if (!isDetailContent && this.m_metaMappings.containsKey(key) && this.m_metaMappings.get((Object)key).m_order > map.getOrder()) continue;
                MetaMapping mapping = new MetaMapping();
                mapping.m_key = key;
                mapping.m_elementXPath = map.getElement();
                mapping.m_defaultValue = resolver.resolveMacros(map.getDefaultValue());
                mapping.m_order = map.getOrder();
                mapping.m_contentId = elementId;
                this.m_metaMappings.put(key, mapping);
            }
        }
    }

    private void clearPageData() {
        this.m_elementInstances = null;
        this.m_parentContainers = null;
    }

    private CmsResource findAncestor(CmsObject cms, CmsResource resource, Predicate<CmsResource> predicate) {
        try {
            CmsObject rootCms = OpenCms.initCmsObject(cms);
            rootCms.getRequestContext().setSiteRoot("");
            CmsResource ancestor = resource;
            while (ancestor != null) {
                if (predicate.test(ancestor)) {
                    return ancestor;
                }
                String parentFolder = CmsResource.getParentFolder(ancestor.getRootPath());
                if (parentFolder != null) {
                    try {
                        ancestor = rootCms.readResource(parentFolder, CmsResourceFilter.IGNORE_EXPIRATION);
                        continue;
                    }
                    catch (CmsException e) {
                        LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                break;
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return null;
    }

    private CmsContainerPageBean getPage(CmsResource pageResource) throws CmsException {
        CmsContainerPageBean result = null;
        if (pageResource != null && CmsResourceTypeXmlContainerPage.isContainerPage(pageResource)) {
            CmsXmlContainerPage xmlContainerPage = CmsXmlContainerPageFactory.unmarshal(this.m_cms, pageResource, this.m_request);
            result = xmlContainerPage.getContainerPage(this.m_cms);
            CmsModelGroupHelper modelHelper = new CmsModelGroupHelper(this.m_cms, OpenCms.getADEManager().lookupConfiguration(this.m_cms, pageResource.getRootPath()), CmsJspTagEditable.isEditableRequest(this.m_request) && this.m_request instanceof HttpServletRequest ? CmsADESessionCache.getCache((HttpServletRequest)this.m_request, this.m_cms) : null, CmsContainerpageService.isEditingModelGroups(this.m_cms, pageResource));
            result = modelHelper.readModelGroups(xmlContainerPage.getContainerPage(this.m_cms));
        }
        return result;
    }

    private <A> A getRequestAttribute(String name) {
        Object attribute = this.m_request.getAttribute(name);
        return (A)(attribute != null ? attribute : null);
    }

    private void initMetaMappings() {
        block8: {
            if (this.m_metaMappings == null) {
                this.m_metaMappings = new HashMap<String, MetaMapping>();
                try {
                    this.initPage();
                    CmsMacroResolver resolver = new CmsMacroResolver();
                    resolver.setKeepEmptyMacros(true);
                    resolver.setCmsObject(this.m_cms);
                    resolver.setMessages(OpenCms.getWorkplaceManager().getMessages(this.getLocale()));
                    CmsResourceFilter filter = this.getIsEditMode() ? CmsResourceFilter.IGNORE_EXPIRATION : CmsResourceFilter.DEFAULT;
                    for (CmsContainerBean container : this.m_page.getContainers().values()) {
                        for (CmsContainerElementBean element : container.getElements()) {
                            String settingsKey = CmsFormatterConfig.getSettingsKeyForContainer(container.getName());
                            String formatterConfigId = element.getSettings() != null ? element.getSettings().get(settingsKey) : null;
                            I_CmsFormatterBean formatterBean = null;
                            formatterBean = this.m_config.findFormatter(formatterConfigId);
                            if (formatterBean == null || !formatterBean.useMetaMappingsForNormalElements() || !this.m_cms.existsResource(element.getId(), filter)) continue;
                            this.addMappingsForFormatter(formatterBean, element.getId(), resolver, false);
                        }
                    }
                    if (this.getDetailContentId() == null) break block8;
                    try {
                        CmsResource detailContent = this.m_cms.readResource(this.getDetailContentId(), CmsResourceFilter.ignoreExpirationOffline(this.m_cms));
                        CmsFormatterConfiguration config = OpenCms.getADEManager().lookupConfiguration(this.m_cms, this.m_cms.getRequestContext().getRootUri()).getFormatters(this.m_cms, detailContent);
                        for (I_CmsFormatterBean formatter : config.getDetailFormatters()) {
                            this.addMappingsForFormatter(formatter, this.getDetailContentId(), resolver, true);
                        }
                    }
                    catch (CmsException e) {
                        LOG.error((Object)Messages.get().getBundle().key("ERR_READING_REQUIRED_RESOURCE_1", this.getDetailContentId()), (Throwable)e);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    private void initPageData() {
        this.m_elementInstances = new HashMap<String, CmsContainerElementBean>();
        this.m_parentContainers = new HashMap<String, CmsContainerBean>();
        if (this.m_page != null) {
            for (CmsContainerBean container : this.m_page.getContainers().values()) {
                for (CmsContainerElementBean element : container.getElements()) {
                    this.m_elementInstances.put(element.getInstanceId(), element);
                    this.m_parentContainers.put(element.getInstanceId(), container);
                    try {
                        if (!element.isGroupContainer(this.m_cms) && !element.isInheritedContainer(this.m_cms)) continue;
                        List<CmsContainerElementBean> children = element.isGroupContainer(this.m_cms) ? CmsJspTagContainer.getGroupContainerElements(this.m_cms, element, this.m_request, container.getType()) : CmsJspTagContainer.getInheritedContainerElements(this.m_cms, element);
                        for (CmsContainerElementBean childElement : children) {
                            this.m_elementInstances.put(childElement.getInstanceId(), childElement);
                            this.m_parentContainers.put(childElement.getInstanceId(), container);
                        }
                    }
                    catch (CmsException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
            if (this.m_detailOnlyPage != null) {
                for (CmsContainerBean container : this.m_detailOnlyPage.getContainers().values()) {
                    for (CmsContainerElementBean element : container.getElements()) {
                        this.m_elementInstances.put(element.getInstanceId(), element);
                        this.m_parentContainers.put(element.getInstanceId(), container);
                    }
                }
            }
        }
    }

    class MetaMapping {
        CmsUUID m_contentId;
        String m_defaultValue;
        String m_elementXPath;
        String m_key;
        int m_order;

        MetaMapping() {
        }
    }

    class MetaLookupTranformer
    implements Transformer {
        MetaLookupTranformer() {
        }

        public Object transform(Object arg0) {
            String result = null;
            if (CmsJspStandardContextBean.this.m_metaMappings != null && CmsJspStandardContextBean.this.m_metaMappings.containsKey(arg0)) {
                MetaMapping mapping = CmsJspStandardContextBean.this.m_metaMappings.get(arg0);
                CmsGalleryNameMacroResolver resolver = null;
                try {
                    I_CmsXmlContentValue val;
                    CmsResourceFilter filter = CmsJspStandardContextBean.this.getIsEditMode() ? CmsResourceFilter.IGNORE_EXPIRATION : CmsResourceFilter.DEFAULT;
                    CmsResource res = CmsJspStandardContextBean.this.m_cms.readResource(mapping.m_contentId, filter);
                    CmsXmlContent content = CmsXmlContentFactory.unmarshal(CmsJspStandardContextBean.this.m_cms, res, CmsJspStandardContextBean.this.m_request);
                    resolver = new CmsGalleryNameMacroResolver(CmsJspStandardContextBean.this.m_cms, content, CmsJspStandardContextBean.this.getLocale());
                    if (content.hasLocale(CmsJspStandardContextBean.this.getLocale()) && (val = content.getValue(mapping.m_elementXPath, CmsJspStandardContextBean.this.getLocale())) != null) {
                        result = val.getStringValue(CmsJspStandardContextBean.this.m_cms);
                    }
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                if (result == null) {
                    result = mapping.m_defaultValue;
                }
                if (resolver != null && result != null) {
                    result = resolver.resolveMacros(result);
                }
            }
            return result;
        }
    }

    public static class TemplateBean {
        private boolean m_forced;
        private String m_name;
        private CmsResource m_resource;
        private String m_uri;

        public TemplateBean(String name, CmsResource resource) {
            this.m_resource = resource;
            this.m_name = name;
        }

        public TemplateBean(String name, String uri) {
            this.m_name = name;
            this.m_uri = uri;
        }

        public String getName() {
            return this.m_name;
        }

        public CmsResource getResource() {
            return this.m_resource;
        }

        public String getUri() {
            if (this.m_resource != null) {
                return this.m_resource.getRootPath();
            }
            return this.m_uri;
        }

        public boolean isForced() {
            return this.m_forced;
        }

        public void setForced(boolean forced) {
            this.m_forced = forced;
        }
    }

    public class SettingsTransformer
    implements Transformer {
        private I_CmsFormatterBean m_formatter;
        private Map<String, CmsXmlContentProperty> m_formatterSettingsConfig;
        private CmsContainerElementBean m_transformElement;

        SettingsTransformer(CmsContainerElementBean element) {
            this.m_transformElement = element;
            this.m_formatter = CmsJspStandardContextBean.this.getElementFormatter(element);
        }

        public Object transform(Object settingName) {
            boolean exists;
            if (this.m_formatter != null) {
                if (this.m_formatterSettingsConfig == null) {
                    this.m_formatterSettingsConfig = OpenCms.getADEManager().getFormatterSettings(CmsJspStandardContextBean.this.m_cms, CmsJspStandardContextBean.this.m_config, this.m_formatter, this.m_transformElement.getResource(), CmsJspStandardContextBean.this.getLocale(), CmsJspStandardContextBean.this.m_request);
                }
                exists = this.m_formatterSettingsConfig.get(settingName) != null;
            } else {
                exists = this.m_transformElement.getSettings().get(settingName) != null;
            }
            return new CmsJspElementSettingValueWrapper(CmsJspStandardContextBean.this, this.m_transformElement.getSettings().get(settingName), exists);
        }
    }

    public class CmsDetailLookupTransformer
    implements Transformer {
        private String m_prefix;

        public CmsDetailLookupTransformer(String prefix) {
            this.m_prefix = prefix;
        }

        public Object transform(Object input) {
            String prefix = this.m_prefix;
            CmsObject cms = CmsJspStandardContextBean.this.m_cms;
            String inputStr = String.valueOf(input);
            return CmsJspStandardContextBean.getFunctionDetailLink(cms, prefix, inputStr, false);
        }
    }

    public class CmsContainerElementWrapper
    extends CmsContainerElementBean {
        private CmsContainerElementWrapper m_parent;
        private String m_resourceTypeName;
        private CmsContainerElementBean m_wrappedElement;
        private Map<String, CmsJspElementSettingValueWrapper> m_wrappedSettings;

        protected CmsContainerElementWrapper(CmsContainerElementBean element) {
            this.m_wrappedElement = element;
        }

        @Override
        public CmsContainerElementBean clone() {
            return this.m_wrappedElement.clone();
        }

        @Override
        public String editorHash() {
            return this.m_wrappedElement.editorHash();
        }

        @Override
        public boolean equals(Object obj) {
            return this.m_wrappedElement.equals(obj);
        }

        @Override
        public CmsUUID getFormatterId() {
            return this.m_wrappedElement.getFormatterId();
        }

        @Override
        public CmsUUID getId() {
            return this.m_wrappedElement.getId();
        }

        @Override
        public Map<String, String> getIndividualSettings() {
            return this.m_wrappedElement.getIndividualSettings();
        }

        @Override
        public CmsInheritanceInfo getInheritanceInfo() {
            return this.m_wrappedElement.getInheritanceInfo();
        }

        @Override
        public String getInstanceId() {
            return this.m_wrappedElement.getInstanceId();
        }

        public CmsContainerElementWrapper getParent() {
            if (this.m_parent == null) {
                CmsContainerElementBean parent = CmsJspStandardContextBean.this.getParentElement(this.m_wrappedElement);
                this.m_parent = parent != null ? new CmsContainerElementWrapper(CmsJspStandardContextBean.this.getParentElement(this.m_wrappedElement)) : null;
            }
            return this.m_parent;
        }

        @Override
        public CmsResource getResource() {
            return this.m_wrappedElement.getResource();
        }

        public String getResourceTypeName() {
            if (this.m_resourceTypeName == null) {
                this.m_resourceTypeName = "";
                try {
                    this.m_resourceTypeName = OpenCms.getResourceManager().getResourceType(this.m_wrappedElement.getResource()).getTypeName();
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            return this.m_resourceTypeName;
        }

        public Map<String, CmsJspElementSettingValueWrapper> getSetting() {
            if (this.m_wrappedSettings == null) {
                this.m_wrappedSettings = CmsCollectionsGenericWrapper.createLazyMap(new SettingsTransformer(this.m_wrappedElement));
            }
            return this.m_wrappedSettings;
        }

        @Override
        public Map<String, String> getSettings() {
            return this.m_wrappedElement.getSettings();
        }

        @Override
        public String getSitePath() {
            return this.m_wrappedElement.getSitePath();
        }

        @Override
        public int hashCode() {
            return this.m_wrappedElement.hashCode();
        }

        @Override
        public void initResource(CmsObject cms) throws CmsException {
            this.m_wrappedElement.initResource(cms);
        }

        @Override
        public void initSettings(CmsObject cms, CmsADEConfigData config, I_CmsFormatterBean formatterBean, Locale locale, ServletRequest request, Map<String, String> settingPresets) {
            this.m_wrappedElement.initSettings(cms, config, formatterBean, locale, request, settingPresets);
        }

        @Override
        public boolean isCreateNew() {
            return this.m_wrappedElement.isCreateNew();
        }

        @Override
        public boolean isGroupContainer(CmsObject cms) throws CmsException {
            return this.m_wrappedElement.isGroupContainer(cms);
        }

        @Override
        public boolean isHistoryContent() {
            return this.m_wrappedElement.isHistoryContent();
        }

        @Override
        public boolean isInheritedContainer(CmsObject cms) throws CmsException {
            return this.m_wrappedElement.isInheritedContainer(cms);
        }

        @Override
        public boolean isInMemoryOnly() {
            return this.m_wrappedElement.isInMemoryOnly();
        }

        @Override
        public boolean isReleasedAndNotExpired() {
            return this.m_wrappedElement.isReleasedAndNotExpired();
        }

        @Override
        public boolean isTemporaryContent() {
            return this.m_wrappedElement.isTemporaryContent();
        }

        @Override
        public void removeInstanceId() {
            this.m_wrappedElement.removeInstanceId();
        }

        @Override
        public void setFormatterId(CmsUUID formatterId) {
            this.m_wrappedElement.setFormatterId(formatterId);
        }

        @Override
        public void setHistoryFile(CmsFile file) {
            this.m_wrappedElement.setHistoryFile(file);
        }

        @Override
        public void setInheritanceInfo(CmsInheritanceInfo inheritanceInfo) {
            this.m_wrappedElement.setInheritanceInfo(inheritanceInfo);
        }

        @Override
        public void setTemporaryFile(CmsFile elementFile) {
            this.m_wrappedElement.setTemporaryFile(elementFile);
        }

        @Override
        public String toString() {
            return this.m_wrappedElement.toString();
        }
    }
}

