/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.flex.CmsFlexController;
import org.opencms.flex.CmsFlexRequest;
import org.opencms.flex.CmsFlexResponse;
import org.opencms.i18n.CmsAcceptLanguageHeaderParser;
import org.opencms.i18n.CmsMessages;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.jsp.util.Messages;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.site.CmsSite;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;

public class CmsJspStatusBean
extends CmsJspActionElement {
    public static final String ERROR_MESSAGE = "javax.servlet.error.message";
    public static final String ERROR_REQUEST_URI = "javax.servlet.error.request_uri";
    public static final String ERROR_SERVLET_NAME = "javax.servlet.error.servlet_name";
    public static final String ERROR_STATUS_CODE = "javax.servlet.error.status_code";
    public static final String UNKKNOWN_STATUS_CODE = "unknown";
    public static final String VFS_FOLDER_HANDLER = "/system/handler/";
    private static final Log LOG = CmsLog.getLog(CmsJspStatusBean.class);
    private String m_errorMessage;
    private Throwable m_exception;
    private Locale m_locale;
    private Object[] m_localizeParameters;
    private CmsMessages m_messages;
    private String m_requestUri;
    private String m_servletName;
    private String m_siteRoot;
    private Integer m_statusCode;
    private String m_statusCodeMessage;
    private String m_templateUri;

    public CmsJspStatusBean() {
    }

    public CmsJspStatusBean(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        super(context, req, res);
        this.initMembers(req, null);
    }

    public CmsJspStatusBean(PageContext context, HttpServletRequest req, HttpServletResponse res, Throwable t) {
        super(context, req, res);
        this.initMembers(req, t);
    }

    @Deprecated
    public boolean forwardToErrorPage(String rootPath) {
        try {
            CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(rootPath);
            CmsObject clone = OpenCms.initCmsObject(this.getCmsObject());
            if (site != null) {
                clone.getRequestContext().setSiteRoot(site.getSiteRoot());
            }
            String relPath = clone.getRequestContext().removeSiteRoot(rootPath);
            clone.getRequestContext().setUri(relPath);
            CmsFlexController ori = CmsFlexController.getController((ServletRequest)this.getRequest());
            CmsFlexController controller = new CmsFlexController(clone, clone.readResource(relPath), ori.getCmsCache(), this.getRequest(), this.getResponse(), false, false);
            CmsFlexController.setController((ServletRequest)this.getRequest(), controller);
            CmsFlexRequest f_req = new CmsFlexRequest(this.getRequest(), controller);
            CmsFlexResponse f_res = new CmsFlexResponse(this.getResponse(), controller, false, false);
            controller.push(f_req, f_res);
            CmsRequestUtil.forwardRequest(OpenCms.getStaticExportManager().getVfsPrefix() + relPath, this.getRequest(), this.getResponse());
        }
        catch (Throwable e) {
            LOG.error((Object)e.getMessage(), e);
            return false;
        }
        return true;
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    public Throwable getException() {
        return this.m_exception;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public String getPageContent(String element) {
        String contentFolder = this.property("template-elements", "search", "");
        if (CmsStringUtil.isEmpty(contentFolder)) {
            contentFolder = "/system/handler/contents/";
        }
        String fileName = "content" + this.getStatusCodeMessage() + ".html";
        if (!this.getCmsObject().existsResource(contentFolder + fileName)) {
            fileName = "contentunknown.html";
        }
        return this.getContent(contentFolder + fileName, element, this.getLocale());
    }

    public String getRequestResourceName() {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getRequestUri())) {
            return CmsLinkManager.removeOpenCmsContext(this.getRequestUri());
        }
        return this.getRequestUri();
    }

    public String getRequestUri() {
        return this.m_requestUri;
    }

    public String getResourceUri(String resourceName) {
        return CmsWorkplace.getResourceUri(resourceName);
    }

    public String getServletName() {
        return this.m_servletName;
    }

    public String getSiteRoot() {
        return this.m_siteRoot;
    }

    public Integer getStatusCode() {
        return this.m_statusCode;
    }

    public String getStatusCodeMessage() {
        return this.m_statusCodeMessage;
    }

    public String getTemplateUri() {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_templateUri)) {
            this.m_templateUri = "/";
        }
        return this.m_templateUri;
    }

    public void includeTemplatePart(String target, String element) throws JspException {
        this.includeTemplatePart(target, element, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void includeTemplatePart(String target, String element, Map<String, Object> parameterMap) throws JspException {
        String currentSiteRoot = this.getRequestContext().getSiteRoot();
        String currentUri = this.getRequestContext().getUri();
        try {
            this.getRequestContext().setSiteRoot(this.getSiteRoot());
            this.getRequestContext().setUri(this.getTemplateUri());
            this.include(target, element, parameterMap);
        }
        finally {
            this.getRequestContext().setSiteRoot(currentSiteRoot);
            this.getRequestContext().setUri(currentUri);
        }
    }

    public String key(String keyName) {
        return this.key(keyName, null);
    }

    public String key(String keyName, String defaultKeyName) {
        String value = this.getMessages().key(keyName, this.getLocalizeParameters());
        if (value.startsWith("???") && CmsStringUtil.isNotEmpty(defaultKeyName)) {
            value = this.getMessages().key(defaultKeyName, this.getLocalizeParameters());
        }
        return CmsStringUtil.escapeHtml(value);
    }

    public String keyStatus(String keyName) {
        keyName = keyName + "_";
        return this.key(keyName + this.getStatusCodeMessage(), keyName + UNKKNOWN_STATUS_CODE);
    }

    public void logException() {
        if (this.m_exception != null) {
            LOG.error((Object)this.m_exception.getMessage(), this.m_exception);
        }
    }

    public void setTemplateUri(String templateUri) {
        this.m_templateUri = templateUri;
    }

    public boolean showException() {
        return OpenCms.getRoleManager().hasRole(this.getCmsObject(), CmsRole.DEVELOPER);
    }

    protected Object[] getLocalizeParameters() {
        if (this.m_localizeParameters == null) {
            this.m_localizeParameters = new Object[]{this.getStatusCodeMessage(), this.getRequestUri(), this.getErrorMessage(), this.getServletName(), new Date(this.getRequestContext().getRequestTime())};
        }
        return this.m_localizeParameters;
    }

    protected CmsMessages getMessages() {
        if (this.m_messages == null) {
            this.m_messages = new CmsMessages(Messages.get().getBundleName(), this.getLocale().toString());
        }
        return this.m_messages;
    }

    protected void initMembers(HttpServletRequest req, Throwable t) {
        this.m_servletName = (String)req.getAttribute(ERROR_SERVLET_NAME);
        this.m_errorMessage = (String)req.getAttribute(ERROR_MESSAGE);
        this.m_requestUri = (String)req.getAttribute(ERROR_REQUEST_URI);
        this.m_statusCode = (Integer)req.getAttribute(ERROR_STATUS_CODE);
        if (this.m_statusCode == null || this.m_requestUri == null) {
            String jkUri = (String)req.getAttribute("REDIRECT_URL");
            String jkStatusCode = (String)req.getAttribute("REDIRECT_STATUS");
            String jkServletName = (String)req.getAttribute("REDIRECT_SERVLET_NAME");
            try {
                if (!"none".equals(jkStatusCode) && !"none".equals(jkUri)) {
                    this.m_servletName = jkServletName;
                    this.m_requestUri = jkUri;
                    this.m_statusCode = new Integer(jkStatusCode);
                }
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.m_statusCodeMessage = this.m_statusCode != null ? String.valueOf(this.m_statusCode) : UNKKNOWN_STATUS_CODE;
        this.m_exception = t;
        CmsAcceptLanguageHeaderParser parser = new CmsAcceptLanguageHeaderParser(req, OpenCms.getWorkplaceManager().getDefaultLocale());
        List<Locale> acceptedLocales = parser.getAcceptedLocales();
        List<Locale> workplaceLocales = OpenCms.getWorkplaceManager().getLocales();
        this.m_locale = OpenCms.getLocaleManager().getFirstMatchingLocale(acceptedLocales, workplaceLocales);
        if (this.m_locale == null) {
            this.m_locale = OpenCms.getWorkplaceManager().getDefaultLocale();
        }
        this.getCmsObject().getRequestContext().setLocale(this.m_locale);
        this.m_siteRoot = OpenCms.getSiteManager().matchRequest(req).getSiteRoot();
    }

    protected void setErrorMessage(String errorMessage) {
        this.m_errorMessage = errorMessage;
    }

    protected void setException(Throwable exception) {
        this.m_exception = exception;
    }

    protected void setLocale(Locale locale) {
        this.m_locale = locale;
        this.getCmsObject().getRequestContext().setLocale(this.m_locale);
    }

    protected void setLocalizeParameters(Object[] localizeParameters) {
        this.m_localizeParameters = localizeParameters;
    }

    protected void setMessages(CmsMessages messages) {
        this.m_messages = messages;
    }

    protected void setRequestUri(String requestUri) {
        this.m_requestUri = requestUri;
    }

    protected void setServletName(String servletName) {
        this.m_servletName = servletName;
    }

    protected void setSiteRoot(String siteRoot) {
        this.m_siteRoot = siteRoot;
    }

    protected void setStatusCode(Integer statusCode) {
        this.m_statusCode = statusCode;
    }

    protected void setStatusCodeMessage(String statusCodeMessage) {
        this.m_statusCodeMessage = statusCodeMessage;
    }
}

