/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspTagEditable;
import org.opencms.jsp.util.CmsJspContentAccessBean;
import org.opencms.jsp.util.CmsJspObjectValueWrapper;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.jsp.util.CmsMacroFormatterResolver;
import org.opencms.jsp.util.CmsObjectFunctionTransformer;
import org.opencms.jsp.util.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsHtmlValidator;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsFlexFormatterBean;
import org.opencms.xml.containerpage.CmsMacroFormatterBean;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.DateRenderer;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.compiler.CompiledST;
import org.stringtemplate.v4.compiler.FormalArgument;

public class CmsStringTemplateRenderer {
    public static final String ERROR_DISPLAY = "<div class='oc-fomatter-error'>\n<div class='oc-formatter-error-head'>%1$s</div>\n<div class='oc-formatter-error-body'>\n<div class='oc-formatter-error-source'>%2$s</div>\n<div class='oc-formatter-error-message'>%3$s</div>\n</div>\n</div>";
    public static final String ERROR_DISPLAY_WITH_DETAILS = "<div class='oc-fomatter-error'>\n<div class='oc-formatter-error-head'>%1$s</div>\n<div class='oc-formatter-error-body'>\n<div class='oc-formatter-error-source'>%2$s</div>\n<div class='oc-formatter-error-message'>%3$s</div>\n<div class='oc-formatter-error-details'><pre>%4$s</pre></div>\n</div>\n</div>";
    public static final String KEY_FUNCTIONS = "fn";
    public static final String KEY_SETTINGS = "settings";
    private CmsObject m_cms;
    private PageContext m_context;
    private CmsJspStandardContextBean m_contextBean;
    private CmsContainerElementBean m_element;
    private HttpServletRequest m_request;

    public CmsStringTemplateRenderer(PageContext context, HttpServletRequest req) {
        this.m_context = context;
        this.m_request = req;
        CmsFlexController controller = CmsFlexController.getController((ServletRequest)req);
        if (controller == null) {
            this.handleMissingFlexController();
            return;
        }
        this.m_cms = controller.getCmsObject();
        this.m_contextBean = CmsJspStandardContextBean.getInstance((ServletRequest)this.m_request);
        this.m_element = this.m_contextBean.getElement();
    }

    public static String renderTemplate(CmsObject cms, String template, CmsJspContentAccessBean content, Map<String, Object> contextObjects) {
        STGroup group = new STGroup('%', '%');
        group.registerRenderer(Date.class, (AttributeRenderer)new DateRenderer());
        CompiledST cST = group.defineTemplate("main", template);
        cST.addArg(new FormalArgument("content"));
        if (contextObjects != null) {
            for (Map.Entry<String, Object> entry : contextObjects.entrySet()) {
                cST.addArg(new FormalArgument(entry.getKey()));
            }
        }
        ST st = group.getInstanceOf("main");
        st.add("content", (Object)content);
        if (contextObjects != null) {
            for (Map.Entry<String, Object> entry : contextObjects.entrySet()) {
                st.add(entry.getKey(), entry.getValue());
            }
        }
        return st.render(cms.getRequestContext().getLocale());
    }

    public static String renderTemplate(CmsObject cms, String template, CmsResource content, Map<String, Object> contextObjects) {
        return CmsStringTemplateRenderer.renderTemplate(cms, template, new CmsJspContentAccessBean(cms, content), contextObjects);
    }

    public static Map<String, CmsJspObjectValueWrapper> wrapSettings(CmsObject cms, Map<String, String> settings) {
        HashMap<String, CmsJspObjectValueWrapper> wrappedSettings = null;
        if (settings != null) {
            wrappedSettings = new HashMap<String, CmsJspObjectValueWrapper>(settings.size());
            for (Map.Entry<String, String> setting : settings.entrySet()) {
                wrappedSettings.put(setting.getKey(), CmsJspObjectValueWrapper.createWrapper(cms, setting.getValue()));
            }
        }
        return wrappedSettings;
    }

    public void render() throws IOException {
        block14: {
            CmsADEConfigData adeConfig = OpenCms.getADEManager().lookupConfigurationWithCache(this.m_cms, this.m_cms.getRequestContext().getRootUri());
            I_CmsFormatterBean formatterConfig = adeConfig.findFormatter(this.m_element.getFormatterId());
            if (formatterConfig instanceof CmsFlexFormatterBean) {
                CmsFlexFormatterBean config = (CmsFlexFormatterBean)formatterConfig;
                String template = config.getStringTemplate();
                if (this.m_element.isInMemoryOnly()) {
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(config.getPlaceholderStringTemplate())) {
                        template = config.getPlaceholderStringTemplate();
                    }
                    if (config.getDefaultContentStructureId() != null) {
                        try {
                            CmsResource defaultContent = this.m_cms.readResource(((CmsMacroFormatterBean)formatterConfig).getDefaultContentStructureId());
                            CmsFile defaultFile = this.m_cms.readFile(defaultContent);
                            this.m_element = new CmsContainerElementBean(defaultFile, this.m_element.getFormatterId(), this.m_element.getIndividualSettings(), true, this.m_element.editorHash(), this.m_element.isCreateNew());
                        }
                        catch (CmsException defaultContent) {
                            // empty catch block
                        }
                    }
                }
                try {
                    HashMap<String, Object> context = new HashMap<String, Object>();
                    context.put(KEY_SETTINGS, CmsStringTemplateRenderer.wrapSettings(this.m_cms, this.m_element.getSettings()));
                    context.put(KEY_FUNCTIONS, CmsCollectionsGenericWrapper.createLazyMap(new CmsObjectFunctionTransformer(this.m_cms)));
                    String output = CmsStringTemplateRenderer.renderTemplate(this.m_cms, template, this.m_element.getResource(), context);
                    if (CmsJspTagEditable.isEditableRequest((ServletRequest)this.m_request)) {
                        CmsHtmlValidator validator = new CmsHtmlValidator();
                        validator.validate(output);
                        if (!validator.isBalanced()) {
                            Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms);
                            String messages = "";
                            for (CmsMessageContainer message : validator.getMessages()) {
                                messages = messages + message.key(locale) + "\n";
                            }
                            output = String.format(ERROR_DISPLAY_WITH_DETAILS, Messages.get().getBundle(locale).key("GUI_FORMATTER_RENDERING_ERROR_0"), formatterConfig.getJspRootPath(), Messages.get().getBundle(locale).key("GUI_FORMATTER_RENDERING_NOT_WELL_FORMED_0"), messages);
                        } else if (validator.getRootElementCount() > 1) {
                            Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms);
                            output = String.format(ERROR_DISPLAY, Messages.get().getBundle(locale).key("GUI_FORMATTER_RENDERING_ERROR_0"), formatterConfig.getJspRootPath(), Messages.get().getBundle(locale).key("GUI_FORMATTER_RENDERING_MULTIPLE_ROOT_ELEMENTS_0"));
                        }
                    }
                    this.m_context.getOut().print(output);
                }
                catch (Throwable t) {
                    if (!CmsJspTagEditable.isEditableRequest((ServletRequest)this.m_request)) break block14;
                    String stackTrace = "";
                    for (StackTraceElement element : t.getStackTrace()) {
                        stackTrace = stackTrace + element.toString() + "\n";
                    }
                    Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms);
                    this.m_context.getOut().println(String.format(ERROR_DISPLAY_WITH_DETAILS, Messages.get().getBundle(locale).key("GUI_FORMATTER_RENDERING_ERROR_0"), formatterConfig.getJspRootPath(), t.getMessage(), stackTrace));
                }
            }
        }
    }

    private void handleMissingFlexController() {
        throw new CmsRuntimeException(org.opencms.jsp.Messages.get().container("ERR_MISSING_CMS_CONTROLLER_1", CmsMacroFormatterResolver.class.getName()));
    }
}

