/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.loader;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.Factory;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.loader.I_CmsFileNameGenerator;
import org.opencms.loader.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.PrintfFormat;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.xml.content.CmsNumberSuffixNameSequence;

public class CmsDefaultFileNameGenerator
implements I_CmsFileNameGenerator {
    private static final Log LOG = CmsLog.getLog(CmsDefaultFileNameGenerator.class);
    private static final String MACRO_NUMBER_DIGIT_SEPARATOR = ":";
    public static final String COPY_FILE_NAME_INSERT = "-copy";
    private CmsObject m_adminCms;

    public static boolean hasNumberMacro(String pattern) {
        return CmsDefaultFileNameGenerator.hasNumberMacro(pattern, "%(", ")") || CmsDefaultFileNameGenerator.hasNumberMacro(pattern, "${", "}");
    }

    public static String removeExtension(String path) {
        return path.replaceFirst("\\.[a-zA-Z]*$", "");
    }

    private static boolean hasNumberMacro(String pattern, String macroStart, String macroEnd) {
        String macro = "number";
        String macroPart = macroStart + macro + MACRO_NUMBER_DIGIT_SEPARATOR;
        int prefixIndex = pattern.indexOf(macroPart);
        if (prefixIndex >= 0) {
            char n = pattern.charAt(prefixIndex + macroPart.length());
            macro = macro + MACRO_NUMBER_DIGIT_SEPARATOR + n;
        }
        return pattern.contains(macroStart + macro + macroEnd);
    }

    @Override
    public String getCopyFileName(CmsObject cms, String parentFolder, String baseName) {
        String name = baseName;
        int dot = name.lastIndexOf(".");
        if (dot > 0) {
            if (!name.substring(0, dot).endsWith(COPY_FILE_NAME_INSERT)) {
                name = name.substring(0, dot) + COPY_FILE_NAME_INSERT + name.substring(dot);
            }
        } else if (!name.endsWith(COPY_FILE_NAME_INSERT)) {
            name = name + COPY_FILE_NAME_INSERT;
        }
        return this.getUniqueFileName(cms, parentFolder, name);
    }

    @Override
    public String getNewFileName(CmsObject cms, String namePattern, int defaultDigits) throws CmsException {
        return this.getNewFileName(cms, namePattern, defaultDigits, false);
    }

    @Override
    public String getNewFileName(CmsObject userCms, String namePattern, int defaultDigits, boolean explorerMode) throws CmsException {
        CmsObject cms = OpenCms.initCmsObject(this.m_adminCms);
        cms.getRequestContext().setSiteRoot(userCms.getRequestContext().getSiteRoot());
        cms.getRequestContext().setCurrentProject(userCms.getRequestContext().getCurrentProject());
        String checkPattern = cms.getRequestContext().removeSiteRoot(namePattern);
        String folderName = CmsResource.getFolderPath(checkPattern);
        List<CmsResource> resources = cms.readResources(folderName, CmsResourceFilter.ALL, false);
        CmsObject onlineCms = OpenCms.initCmsObject(cms);
        onlineCms.getRequestContext().setCurrentProject(cms.readProject(CmsProject.ONLINE_PROJECT_ID));
        HashSet<String> fileNames = new HashSet<String>();
        for (CmsResource res : resources) {
            fileNames.add(cms.getSitePath(res));
        }
        try {
            CmsResource offlineFolder = cms.readResource(folderName);
            CmsResource onlineFolder = onlineCms.readResource(offlineFolder.getStructureId());
            String onlinePath = onlineCms.getSitePath(onlineFolder);
            List<CmsResource> onlineContents = onlineCms.readResources(onlinePath, CmsResourceFilter.ALL, false);
            for (CmsResource res : onlineContents) {
                fileNames.add(cms.getSitePath(res));
            }
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return this.getNewFileNameFromList(fileNames, checkPattern, defaultDigits, explorerMode);
    }

    @Override
    public String getUniqueFileName(CmsObject cms, String parentFolder, String baseName) {
        Iterator<String> nameIterator = this.getUrlNameSequence(baseName);
        String result = nameIterator.next();
        CmsObject onlineCms = null;
        try {
            onlineCms = OpenCms.initCmsObject(cms);
            onlineCms.getRequestContext().setCurrentProject(cms.readProject(CmsProject.ONLINE_PROJECT_ID));
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        String path = CmsStringUtil.joinPaths(parentFolder, result);
        while (cms.existsResource(path, CmsResourceFilter.ALL) || onlineCms != null && onlineCms.existsResource(path, CmsResourceFilter.ALL)) {
            result = nameIterator.next();
            path = CmsStringUtil.joinPaths(parentFolder, result);
        }
        return result;
    }

    @Override
    public Iterator<String> getUrlNameSequence(String baseName) {
        String translatedTitle = OpenCms.getResourceManager().getFileTranslator().translateResource(baseName).replace("/", "-");
        return new CmsNumberSuffixNameSequence(translatedTitle);
    }

    @Override
    public void setAdminCms(CmsObject cms) {
        if (this.m_adminCms == null) {
            this.m_adminCms = cms;
        }
    }

    protected String getNewFileNameFromList(Set<String> fileNames, String checkPattern, int defaultDigits, final boolean explorerMode) {
        String checkTempFileName;
        String checkFileName;
        if (!CmsDefaultFileNameGenerator.hasNumberMacro(checkPattern)) {
            throw new IllegalArgumentException(Messages.get().getBundle().key("ERR_FILE_NAME_PATTERN_WITHOUT_NUMBER_MACRO_1", checkPattern));
        }
        CmsMacroResolver resolver = CmsMacroResolver.newInstance();
        HashSet<String> extensionlessNames = new HashSet<String>();
        for (String name : fileNames) {
            if (name.length() > 1) {
                name = CmsFileUtil.removeTrailingSeparator(name);
            }
            extensionlessNames.add(CmsDefaultFileNameGenerator.removeExtension(name));
        }
        String macro = "number";
        int useDigits = defaultDigits;
        String macroStart = "%(" + macro + MACRO_NUMBER_DIGIT_SEPARATOR;
        int prefixIndex = checkPattern.indexOf(macroStart);
        if (prefixIndex < 0) {
            macroStart = "${" + macro + MACRO_NUMBER_DIGIT_SEPARATOR;
            prefixIndex = checkPattern.indexOf(macroStart);
        }
        if (prefixIndex >= 0) {
            char n = checkPattern.charAt(prefixIndex + macroStart.length());
            macro = macro + ':' + n;
            useDigits = Character.getNumericValue(n);
        }
        CmsNumberFactory numberFactory = new CmsNumberFactory(useDigits){

            @Override
            public Object create() {
                if (explorerMode) {
                    if (this.m_number == 1) {
                        return "";
                    }
                    return "_" + this.m_numberFormat.sprintf(this.m_number - 1);
                }
                return super.create();
            }
        };
        resolver.addDynamicMacro(macro, numberFactory);
        HashSet<String> checked = new HashSet<String>();
        int j = 0;
        do {
            numberFactory.setNumber(++j);
            checkFileName = resolver.resolveMacros(checkPattern);
            if (checked.contains(checkFileName)) {
                throw new RuntimeException(Messages.get().getBundle().key("ERR_NO_FILE_NAME_AVAILABLE_FOR_PATTERN_1", checkPattern));
            }
            checked.add(checkFileName);
            checkTempFileName = CmsWorkplace.getTemporaryFileName(checkFileName);
        } while (extensionlessNames.contains(CmsDefaultFileNameGenerator.removeExtension(checkFileName)) || extensionlessNames.contains(CmsDefaultFileNameGenerator.removeExtension(checkTempFileName)));
        return checkFileName;
    }

    public class CmsNumberFactory
    implements Factory {
        protected int m_number;
        protected PrintfFormat m_numberFormat;

        public CmsNumberFactory(int digits) {
            this.m_numberFormat = new PrintfFormat("%0." + digits + "d");
            this.m_number = 0;
        }

        public Object create() {
            return this.m_numberFormat.sprintf(this.m_number);
        }

        public void setNumber(int number) {
            this.m_number = number;
        }
    }
}

