/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.loader;

import com.google.common.base.Splitter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.SocketException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.history.CmsHistoryResourceHandler;
import org.opencms.flex.CmsFlexCache;
import org.opencms.flex.CmsFlexController;
import org.opencms.flex.CmsFlexRequest;
import org.opencms.flex.CmsFlexResponse;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspTagEnableAde;
import org.opencms.jsp.jsonpart.CmsJsonPartFilter;
import org.opencms.jsp.util.CmsJspLinkMacroResolver;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.loader.CmsLoaderException;
import org.opencms.loader.I_CmsFlexCacheEnabledLoader;
import org.opencms.loader.I_CmsResourceLoader;
import org.opencms.loader.Messages;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.I_CmsEventListener;
import org.opencms.main.OpenCms;
import org.opencms.monitor.CmsMemoryMonitor;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationType;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.I_CmsRegexSubstitution;
import org.opencms.workplace.CmsWorkplaceManager;

public class CmsJspLoader
implements I_CmsResourceLoader,
I_CmsFlexCacheEnabledLoader,
I_CmsEventListener {
    public static final String CACHE_PROPERTY_BYPASS = "bypass";
    public static final String CACHE_PROPERTY_STREAM = "stream";
    public static final String DEFAULT_JSP_FOLDER = "/WEB-INF/jsp/";
    public static final String DIRECTIVE_END = "%>";
    public static final String DIRECTIVE_START = "<%@";
    public static final String JSP_EXTENSION = ".jsp";
    public static final String PARAM_CLIENT_CACHE_MAXAGE = "client.cache.maxage";
    public static final String PARAM_JSP_CACHE_SIZE = "jsp.cache.size";
    public static final String PARAM_JSP_ERRORPAGE_COMMITTED = "jsp.errorpage.committed";
    public static final String PARAM_JSP_FOLDER = "jsp.folder";
    public static final String PARAM_JSP_REPOSITORY = "jsp.repository";
    public static final int RESOURCE_LOADER_ID = 6;
    private static final Log LOG = CmsLog.getLog(CmsJspLoader.class);
    private static long m_clientCacheMaxAge;
    private static Map<String, ReentrantReadWriteLock> m_fileLocks;
    private static String m_jspRepository;
    private static String m_jspWebAppRepository;
    private CmsFlexCache m_cache;
    private CmsParameterConfiguration m_configuration;
    private boolean m_errorPagesAreNotCommitted;
    private Map<String, Boolean> m_offlineJsps;
    private Map<String, Boolean> m_onlineJsps;
    private Map<String, String> m_taglibs = new HashMap<String, String>();
    private ReentrantReadWriteLock m_purgeLock = new ReentrantReadWriteLock(true);

    public CmsJspLoader() {
        this.m_configuration = new CmsParameterConfiguration();
        OpenCms.addCmsEventListener(this, new int[]{5, 16, 17});
        m_fileLocks = CmsMemoryMonitor.createLRUCacheMap(10000);
        this.initCaches(1000);
    }

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
        this.m_configuration.add(paramName, paramValue);
        if (paramName.startsWith("taglib.")) {
            this.m_taglibs.put(paramName.replaceFirst("^taglib\\.", ""), paramValue.trim());
        }
    }

    @Override
    public void cmsEvent(CmsEvent event) {
        switch (event.getType()) {
            case 5: {
                this.m_offlineJsps.clear();
                this.m_onlineJsps.clear();
                return;
            }
            case 16: {
                this.m_offlineJsps.clear();
                return;
            }
            case 17: {
                this.m_onlineJsps.clear();
                return;
            }
        }
    }

    @Override
    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] dump(CmsObject cms, CmsResource file, String element, Locale locale, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        CmsFlexController controller = CmsFlexController.getController((ServletRequest)req);
        CmsFlexController oldController = null;
        if (controller != null) {
            oldController = controller;
        }
        byte[] result = null;
        try {
            controller = this.getController(cms, file, req, res, false, false);
            if (element != null) {
                String[] value = new String[]{element};
                Map<String, String[]> parameters = Collections.singletonMap("__element", value);
                controller.getCurrentRequest().addParameterMap(parameters);
            }
            Map<String, Object> attrs = controller.getCurrentRequest().addAttributeMap(CmsRequestUtil.getAtrributeMap((ServletRequest)req));
            result = this.dispatchJsp(controller);
            CmsJspStandardContextBean standardContext = (CmsJspStandardContextBean)attrs.get("cms");
            if (standardContext != null && req instanceof CmsFlexRequest) {
                standardContext.updateRequestData((CmsFlexRequest)req);
            }
            CmsFlexController.removeController((ServletRequest)req);
        }
        finally {
            if (oldController != null && controller != null) {
                oldController.updateDates(controller.getDateLastModified(), controller.getDateExpires());
                CmsFlexController.setController((ServletRequest)req, oldController);
            }
        }
        return result;
    }

    @Override
    public byte[] export(CmsObject cms, CmsResource resource, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        CmsFlexController controller = this.getController(cms, resource, req, res, false, true);
        byte[] result = this.dispatchJsp(controller);
        CmsFlexController.removeController((ServletRequest)req);
        return result;
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        return this.m_configuration;
    }

    public String getJspRepository() {
        return m_jspRepository;
    }

    @Override
    public int getLoaderId() {
        return 6;
    }

    public void getReferencingStrongLinks(CmsObject cms, CmsResource resource, Set<String> referencingPaths) throws CmsException {
        CmsRelationFilter filter = CmsRelationFilter.SOURCES.filterType(CmsRelationType.JSP_STRONG);
        for (CmsRelation relation : cms.getRelationsForResource(resource, filter)) {
            try {
                CmsResource source = relation.getSource(cms, CmsResourceFilter.DEFAULT);
                if (referencingPaths.contains(source.getRootPath())) continue;
                referencingPaths.add(source.getRootPath());
                this.getReferencingStrongLinks(cms, source, referencingPaths);
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public String getResourceLoaderInfo() {
        return Messages.get().getBundle().key("GUI_LOADER_JSP_DEFAULT_DESC_0");
    }

    @Override
    public void initConfiguration() {
        m_jspRepository = this.m_configuration.get(PARAM_JSP_REPOSITORY);
        if (m_jspRepository == null) {
            m_jspRepository = OpenCms.getSystemInfo().getWebApplicationRfsPath();
        }
        if (!(m_jspWebAppRepository = this.m_configuration.getString(PARAM_JSP_FOLDER, DEFAULT_JSP_FOLDER)).endsWith("/")) {
            m_jspWebAppRepository = m_jspWebAppRepository + "/";
        }
        m_jspRepository = CmsFileUtil.normalizePath(m_jspRepository + m_jspWebAppRepository);
        String maxAge = this.m_configuration.get(PARAM_CLIENT_CACHE_MAXAGE);
        m_clientCacheMaxAge = maxAge == null ? -1L : Long.parseLong(maxAge);
        this.m_errorPagesAreNotCommitted = this.m_configuration.getBoolean(PARAM_JSP_ERRORPAGE_COMMITTED, true);
        int cacheSize = this.m_configuration.getInteger(PARAM_JSP_CACHE_SIZE, -1);
        if (cacheSize > 0) {
            this.initCaches(cacheSize);
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_JSP_REPOSITORY_ABS_PATH_1", m_jspRepository));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_WEBAPP_PATH_1", m_jspWebAppRepository));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_JSP_REPOSITORY_ERR_PAGE_COMMOTED_1", (Object)this.m_errorPagesAreNotCommitted));
            if (m_clientCacheMaxAge > 0L) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_CLIENT_CACHE_MAX_AGE_1", maxAge));
            }
            if (cacheSize > 0) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_JSP_CACHE_SIZE_1", String.valueOf(cacheSize)));
            }
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_LOADER_INITIALIZED_1", this.getClass().getName()));
        }
    }

    @Override
    public boolean isStaticExportEnabled() {
        return true;
    }

    @Override
    public boolean isStaticExportProcessable() {
        return true;
    }

    @Override
    public boolean isUsableForTemplates() {
        return true;
    }

    @Override
    public boolean isUsingUriWhenLoadingTemplate() {
        return false;
    }

    @Override
    public void load(CmsObject cms, CmsResource file, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException, CmsException {
        CmsRequestContext context = cms.getRequestContext();
        if (CmsHistoryResourceHandler.isHistoryRequest((ServletRequest)req) && context.getUri().equals(context.removeSiteRoot(file.getRootPath()))) {
            this.showSource(cms, file, req, res);
        } else {
            boolean streaming = false;
            boolean bypass = false;
            String cacheProperty = cms.readPropertyObject(file, "cache", true).getValue();
            if (cacheProperty != null) {
                if (CACHE_PROPERTY_STREAM.equals(cacheProperty = cacheProperty.trim())) {
                    streaming = true;
                } else if (CACHE_PROPERTY_BYPASS.equals(cacheProperty)) {
                    streaming = true;
                    bypass = true;
                }
            }
            if (CmsJsonPartFilter.isJsonRequest((ServletRequest)req)) {
                streaming = true;
                bypass = true;
            }
            CmsFlexController controller = this.getController(cms, file, req, res, streaming, true);
            if (bypass || controller.isForwardMode()) {
                CmsJspStandardContextBean.getInstance((ServletRequest)controller.getCurrentRequest());
                controller.setForwardMode(true);
                String target = this.updateJsp(file, controller, new HashSet<String>());
                req.getRequestDispatcher(target).forward((ServletRequest)controller.getCurrentRequest(), (ServletResponse)res);
            } else {
                this.dispatchJsp(controller);
            }
            if (!controller.isForwardMode()) {
                CmsFlexController.removeController((ServletRequest)req);
            }
        }
    }

    @Deprecated
    public String processTaglibAttributes(String content) {
        Pattern directivePattern = Pattern.compile("(?sm)<%@\\s*page.*?%>");
        final Pattern taglibPattern = Pattern.compile("(?sm)taglibs\\s*=\\s*\"(.*?)\"");
        final Pattern commaPattern = Pattern.compile("(?sm)\\s*,\\s*");
        final LinkedHashSet<String> taglibs = new LinkedHashSet<String>();
        String marker = ":::TAGLIBS:::";
        I_CmsRegexSubstitution directiveSub = new I_CmsRegexSubstitution(){
            private boolean m_first = true;

            @Override
            public String substituteMatch(String string, Matcher matcher) {
                String match = string.substring(matcher.start(), matcher.end());
                I_CmsRegexSubstitution taglibSub = new I_CmsRegexSubstitution(){

                    @Override
                    public String substituteMatch(String string1, Matcher matcher1) {
                        String match1 = string1.substring(matcher1.start(1), matcher1.end(1));
                        for (String taglibKey : Splitter.on((Pattern)commaPattern).split((CharSequence)match1)) {
                            taglibs.add(taglibKey);
                        }
                        return "";
                    }
                };
                String result = CmsStringUtil.substitute(taglibPattern, match, taglibSub);
                if (this.m_first) {
                    result = result + ":::TAGLIBS:::";
                    this.m_first = false;
                }
                return result;
            }
        };
        String substituted = CmsStringUtil.substitute(directivePattern, content, directiveSub);
        substituted = substituted.replaceAll(":::TAGLIBS:::", this.generateTaglibInclusions(taglibs));
        substituted = substituted.replaceAll("(?sm)<%@\\s*page\\s*%>", "");
        return substituted;
    }

    public void removeFromCache(Set<String> rootPaths, boolean online) {
        Map<String, Boolean> cache = online ? this.m_onlineJsps : this.m_offlineJsps;
        for (String rootPath : rootPaths) {
            cache.remove(rootPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOfflineJspFromRepository(CmsResource resource) throws CmsLoaderException {
        String jspName = this.getJspRfsPath(resource, false);
        HashSet<String> pathSet = new HashSet<String>();
        pathSet.add(resource.getRootPath());
        ReentrantReadWriteLock lock = this.getFileLock(jspName);
        lock.writeLock().lock();
        try {
            this.removeFromCache(pathSet, false);
            File jspFile = new File(jspName);
            jspFile.delete();
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    @Override
    public void service(CmsObject cms, CmsResource resource, ServletRequest req, ServletResponse res) throws ServletException, IOException, CmsLoaderException {
        CmsFlexController controller = CmsFlexController.getController(req);
        String target = this.updateJsp(resource, controller, new HashSet<String>(8));
        controller.getCurrentResponse().setOnlyBuffering(true);
        CmsJspStandardContextBean.getInstance((ServletRequest)controller.getCurrentRequest());
        controller.getCurrentRequest().getRequestDispatcherToExternal(cms.getSitePath(resource), target).include(req, res);
    }

    @Override
    public void setFlexCache(CmsFlexCache cache) {
        this.m_cache = cache;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_FLEX_CACHE_0"));
        }
    }

    public void triggerPurge(final Runnable afterPurgeAction) {
        OpenCms.getExecutor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    CmsJspLoader.this.m_purgeLock.writeLock().lock();
                    for (ReentrantReadWriteLock lock : m_fileLocks.values()) {
                        lock.writeLock().lock();
                    }
                    CmsJspLoader.this.doPurge(afterPurgeAction);
                }
                catch (Exception e) {
                    LOG.error((Object)("Error while purging jsp repository: " + e.getLocalizedMessage()), (Throwable)e);
                }
                finally {
                    for (ReentrantReadWriteLock lock : m_fileLocks.values()) {
                        try {
                            lock.writeLock().unlock();
                        }
                        catch (Exception e) {
                            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    CmsJspLoader.this.m_purgeLock.writeLock().unlock();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public String updateJsp(CmsResource resource, CmsFlexController controller, Set<String> updatedFiles) throws IOException, ServletException, CmsLoaderException {
        boolean isHardInclude;
        String extension;
        String jspVfsName = resource.getRootPath();
        int loaderId = OpenCms.getResourceManager().getResourceType(resource.getTypeId()).getLoaderId();
        if (loaderId == 6 && !jspVfsName.endsWith(JSP_EXTENSION)) {
            extension = JSP_EXTENSION;
            isHardInclude = false;
        } else {
            extension = "";
            isHardInclude = loaderId != 6;
        }
        String jspTargetName = CmsFileUtil.getRepositoryName(m_jspWebAppRepository, jspVfsName + extension, controller.getCurrentRequest().isOnline());
        if (updatedFiles.contains(jspTargetName)) {
            return jspTargetName;
        }
        String jspPath = CmsFileUtil.getRepositoryName(m_jspRepository, jspVfsName + extension, controller.getCurrentRequest().isOnline());
        File d = new File(jspPath).getParentFile();
        if (d == null || d.exists() && (!d.isDirectory() || !d.canRead())) {
            CmsMessageContainer message = Messages.get().container("LOG_ACCESS_DENIED_1", jspPath);
            LOG.error((Object)message.key());
            throw new ServletException(message.key());
        }
        if (!d.exists()) {
            d.mkdirs();
        }
        ReentrantReadWriteLock readWriteLock = this.getFileLock(jspVfsName);
        try {
            File jspFile;
            block33: {
                readWriteLock.readLock().lock();
                jspFile = new File(jspPath);
                boolean mustUpdate = false;
                long jspModificationDate = 0L;
                if (!jspFile.exists()) {
                    boolean success;
                    mustUpdate = true;
                    File folder = jspFile.getParentFile();
                    if (!folder.exists() && !(success = folder.mkdirs())) {
                        LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("LOG_CREATE_FOLDER_FAILED_1", folder.getAbsolutePath()));
                    }
                } else {
                    jspModificationDate = jspFile.lastModified();
                    if (jspModificationDate < resource.getDateLastModified()) {
                        mustUpdate = true;
                    } else if (controller.getCurrentRequest().isDoRecompile()) {
                        mustUpdate = true;
                    } else {
                        if (controller.getCurrentRequest().isOnline()) {
                            mustUpdate = !this.m_onlineJsps.containsKey(jspVfsName);
                        } else {
                            boolean bl = mustUpdate = !this.m_offlineJsps.containsKey(jspVfsName);
                        }
                        if (mustUpdate) {
                            mustUpdate = this.updateStrongLinks(resource, controller, updatedFiles);
                        }
                    }
                }
                if (mustUpdate) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_WRITING_JSP_1", jspTargetName));
                    }
                    readWriteLock.readLock().unlock();
                    readWriteLock.writeLock().lock();
                    try {
                        String encoding;
                        byte[] contents;
                        if (jspFile.exists() && jspModificationDate != jspFile.lastModified()) break block33;
                        updatedFiles.add(jspTargetName);
                        try {
                            CmsObject cms = controller.getCmsObject();
                            contents = cms.readFile(resource).getContents();
                            encoding = cms.readPropertyObject(resource, "content-encoding", true).getValue();
                            encoding = encoding == null ? OpenCms.getSystemInfo().getDefaultEncoding() : CmsEncoder.lookupEncoding(encoding.trim(), encoding);
                        }
                        catch (CmsException e) {
                            controller.setThrowable(e, jspVfsName);
                            throw new ServletException(Messages.get().getBundle().key("ERR_LOADER_JSP_ACCESS_1", jspVfsName), (Throwable)e);
                        }
                        try {
                            contents = this.parseJsp(contents, encoding, controller, updatedFiles, isHardInclude);
                            if (LOG.isInfoEnabled()) {
                                LOG.info((Object)Messages.get().getBundle().key("LOG_JSP_PERMCHECK_4", new Object[]{jspFile.getAbsolutePath(), jspFile.exists(), jspFile.isFile(), jspFile.canWrite()}));
                            }
                            Class<CmsJspLoader> e = CmsJspLoader.class;
                            // MONITORENTER : org.opencms.loader.CmsJspLoader.class
                            FileOutputStream fs = new FileOutputStream(jspFile);
                            fs.write(contents);
                            fs.close();
                            jspFile.setLastModified((1L + resource.getDateLastModified() / 1000L) * 1000L);
                            // MONITOREXIT : e
                            if (controller.getCurrentRequest().isOnline()) {
                                this.m_onlineJsps.put(jspVfsName, Boolean.TRUE);
                            } else {
                                this.m_offlineJsps.put(jspVfsName, Boolean.TRUE);
                            }
                            if (LOG.isInfoEnabled()) {
                                LOG.info((Object)Messages.get().getBundle().key("LOG_UPDATED_JSP_2", jspTargetName, jspVfsName));
                            }
                        }
                        catch (FileNotFoundException e) {
                            throw new ServletException(Messages.get().getBundle().key("ERR_LOADER_JSP_WRITE_1", jspFile.getName()), (Throwable)e);
                        }
                    }
                    finally {
                        readWriteLock.readLock().lock();
                        readWriteLock.writeLock().unlock();
                    }
                }
            }
            controller.updateDates(jspFile.lastModified(), Long.MAX_VALUE);
            return jspTargetName;
        }
        finally {
            readWriteLock.readLock().unlock();
        }
    }

    public void updateJspFromRequest(String servletPath, CmsFlexRequest request) {
        block11: {
            String jspUri = servletPath;
            String pathInfo = request.getPathInfo();
            if (pathInfo != null) {
                jspUri = jspUri + pathInfo;
            }
            if (jspUri == null || !jspUri.startsWith(m_jspWebAppRepository)) {
                return;
            }
            if ((jspUri = jspUri.substring(m_jspWebAppRepository.length())).startsWith("online")) {
                jspUri = jspUri.substring("online".length());
            } else if (jspUri.startsWith("offline")) {
                jspUri = jspUri.substring("offline".length());
            } else {
                return;
            }
            CmsFlexController controller = CmsFlexController.getController((ServletRequest)request);
            try {
                CmsResource includeResource;
                try {
                    includeResource = this.readJspResource(controller, jspUri);
                }
                catch (CmsVfsResourceNotFoundException e) {
                    if (jspUri.endsWith(JSP_EXTENSION)) {
                        jspUri = jspUri.substring(0, jspUri.length() - JSP_EXTENSION.length());
                    }
                    includeResource = this.readJspResource(controller, jspUri);
                }
                this.updateJsp(includeResource, controller, new HashSet<String>(8));
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block11;
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    protected byte[] dispatchJsp(CmsFlexController controller) throws ServletException, IOException {
        CmsFlexRequest f_req = controller.getCurrentRequest();
        CmsFlexResponse f_res = controller.getCurrentResponse();
        try {
            f_req.getRequestDispatcher(controller.getCmsObject().getSitePath(controller.getCmsResource())).include((ServletRequest)f_req, (ServletResponse)f_res);
        }
        catch (SocketException e) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_IGNORING_EXC_1", e.getClass().getName()), (Throwable)e);
        }
        byte[] result = null;
        HttpServletResponse res = controller.getTopResponse();
        if (!controller.isStreaming() && !f_res.isSuspended()) {
            try {
                if (!res.isCommitted() || this.m_errorPagesAreNotCommitted) {
                    boolean isWorkplaceUser = CmsWorkplaceManager.isWorkplaceUser((HttpServletRequest)f_req);
                    if (controller.isTop() && !isWorkplaceUser && CmsFlexController.isNotModifiedSince((HttpServletRequest)f_req, controller.getDateLastModified())) {
                        if (f_req.getParameterMap().size() == 0) {
                            CmsFlexController.setDateExpiresHeader(res, controller.getDateExpires(), m_clientCacheMaxAge);
                        }
                        res.setStatus(304);
                        return null;
                    }
                    result = f_res.getWriterBytes();
                    HttpServletRequest req = controller.getTopRequest();
                    if (req.getHeader("OpenCms-Export") != null) {
                        req.setAttribute("OpenCms-Export", (Object)new Long(controller.getDateLastModified()));
                    } else if (controller.isTop()) {
                        res.setContentLength(result.length);
                        Integer errorCode = (Integer)req.getAttribute("org.opencms.util.CmsErrorCode");
                        if (errorCode == null) {
                            if (isWorkplaceUser) {
                                res.setDateHeader("Last-Modified", System.currentTimeMillis());
                                CmsRequestUtil.setNoCacheHeaders(res);
                            } else {
                                CmsFlexController.setDateLastModifiedHeader(res, controller.getDateLastModified());
                                if (f_req.getParameterMap().size() == 0 && controller.getDateLastModified() > -1L) {
                                    CmsFlexController.setDateExpiresHeader(res, controller.getDateExpires(), m_clientCacheMaxAge);
                                }
                            }
                            res.setStatus(200);
                        } else {
                            res.setStatus(errorCode.intValue());
                        }
                        CmsFlexResponse.processHeaders(f_res.getHeaders(), res);
                        res.getOutputStream().write(result);
                        res.getOutputStream().flush();
                    }
                }
            }
            catch (IllegalStateException e) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_IGNORING_EXC_1", e.getClass().getName()), (Throwable)e);
            }
            catch (SocketException e) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_IGNORING_EXC_1", e.getClass().getName()), (Throwable)e);
            }
        }
        return result;
    }

    protected void doPurge(Runnable afterPurgeAction) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)org.opencms.flex.Messages.get().getBundle().key("LOG_FLEXCACHE_WILL_PURGE_JSP_REPOSITORY_0"));
        }
        File d = new File(this.getJspRepository() + "online" + File.separator);
        CmsFileUtil.purgeDirectory(d);
        d = new File(this.getJspRepository() + "offline" + File.separator);
        CmsFileUtil.purgeDirectory(d);
        if (afterPurgeAction != null) {
            afterPurgeAction.run();
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)org.opencms.flex.Messages.get().getBundle().key("LOG_FLEXCACHE_PURGED_JSP_REPOSITORY_0"));
        }
    }

    protected String generateTaglibInclusions(Collection<String> taglibs) {
        StringBuffer buffer = new StringBuffer();
        for (String taglib : taglibs) {
            String uri = this.m_taglibs.get(taglib);
            if (uri == null) continue;
            buffer.append("<%@ taglib prefix=\"" + taglib + "\" uri=\"" + uri + "\" %>");
        }
        return buffer.toString();
    }

    protected CmsFlexController getController(CmsObject cms, CmsResource resource, HttpServletRequest req, HttpServletResponse res, boolean streaming, boolean top) {
        CmsFlexController controller = null;
        if (top) {
            controller = CmsFlexController.getController((ServletRequest)req);
        }
        if (controller == null) {
            if (!cms.getRequestContext().getCurrentProject().isOnlineProject() && (CmsHistoryResourceHandler.isHistoryRequest((ServletRequest)req) || CmsJspTagEnableAde.isDirectEditDisabled((ServletRequest)req))) {
                cms.getRequestContext().setAttribute("__disableDirectEdit", Boolean.TRUE);
            }
            controller = new CmsFlexController(cms, resource, this.m_cache, req, res, streaming, top);
            CmsFlexController.setController((ServletRequest)req, controller);
            CmsFlexRequest f_req = new CmsFlexRequest(req, controller);
            CmsFlexResponse f_res = new CmsFlexResponse(res, controller, streaming, true);
            controller.push(f_req, f_res);
        } else if (controller.isForwardMode()) {
            controller = new CmsFlexController(cms, controller);
            CmsFlexController.setController((ServletRequest)req, controller);
        }
        return controller;
    }

    protected void initCaches(int cacheSize) {
        this.m_offlineJsps = CmsMemoryMonitor.createLRUCacheMap(cacheSize);
        this.m_onlineJsps = CmsMemoryMonitor.createLRUCacheMap(cacheSize);
    }

    protected byte[] parseJsp(byte[] byteContent, String encoding, CmsFlexController controller, Set<String> updatedFiles, boolean isHardInclude) {
        String content;
        try {
            content = new String(byteContent, encoding);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_UNSUPPORTED_ENC_1", controller.getCurrentRequest().getElementUri()), (Throwable)e);
            try {
                encoding = OpenCms.getSystemInfo().getDefaultEncoding();
                content = new String(byteContent, encoding);
            }
            catch (UnsupportedEncodingException e2) {
                content = new String(byteContent);
            }
        }
        content = this.parseJspLinkMacros(content, controller);
        content = this.parseJspCmsTag(content, controller, updatedFiles);
        content = this.parseJspIncludes(content, controller, updatedFiles);
        content = this.parseJspEncoding(content, encoding, isHardInclude);
        content = this.processTaglibAttributes(content);
        try {
            return content.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            return content.getBytes();
        }
    }

    protected String parseJspCmsTag(String content, CmsFlexController controller, Set<String> updatedFiles) {
        int i1 = content.indexOf(DIRECTIVE_START);
        if (i1 < 0) {
            return content;
        }
        StringBuffer buf = new StringBuffer(content.length());
        int p0 = 0;
        int i2 = 0;
        int slen = DIRECTIVE_START.length();
        int elen = DIRECTIVE_END.length();
        while (i1 >= 0) {
            i2 = content.indexOf(DIRECTIVE_END, i1 + slen);
            if (i2 < 0) {
                return content;
            }
            if (i2 <= i1) continue;
            String directive = content.substring(i1 + slen, i2);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DIRECTIVE_DETECTED_3", DIRECTIVE_START, directive, DIRECTIVE_END));
            }
            int t1 = 0;
            int t2 = 0;
            int t3 = 0;
            int t4 = 0;
            int t5 = 0;
            while (directive.charAt(t1) == ' ') {
                ++t1;
            }
            String argument = null;
            if (directive.startsWith("cms", t1)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_X_DIRECTIVE_DETECTED_1", "cms"));
                }
                t2 = directive.indexOf("file", t1 + 3);
                t5 = 4;
            }
            if (t2 > 0) {
                String sub = directive.substring(t2 + t5);
                char c1 = sub.charAt(t3);
                while (c1 == ' ' || c1 == '=' || c1 == '\"') {
                    c1 = sub.charAt(++t3);
                }
                t4 = t3;
                while (c1 != '\"') {
                    c1 = sub.charAt(++t4);
                }
                if (t4 > t3) {
                    argument = sub.substring(t3, t4);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DIRECTIVE_ARG_1", argument));
                }
            }
            if (argument != null) {
                String jspname = this.updateJsp(argument, controller, updatedFiles);
                if (jspname != null) {
                    directive = jspname;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_DIRECTIVE_CHANGED_3", DIRECTIVE_START, directive, DIRECTIVE_END));
                    }
                }
                buf.append(content.substring(p0, i1));
                buf.append(directive);
                p0 = i2 + elen;
                i1 = content.indexOf(DIRECTIVE_START, p0);
                continue;
            }
            buf.append(content.substring(p0, i1 + slen));
            buf.append(directive);
            p0 = i2;
            i1 = content.indexOf(DIRECTIVE_START, p0);
        }
        if (i2 > 0) {
            buf.append(content.substring(p0, content.length()));
            content = buf.toString();
        }
        return content;
    }

    protected String parseJspEncoding(String content, String encoding, boolean isHardInclude) {
        int i1 = content.indexOf(DIRECTIVE_START);
        if (i1 < 0 && isHardInclude) {
            return content;
        }
        StringBuffer buf = new StringBuffer(content.length() + 64);
        int p0 = 0;
        int i2 = 0;
        int slen = DIRECTIVE_START.length();
        boolean found = false;
        if (i1 < 0) {
            buf.append(content);
        }
        while (i1 >= 0) {
            i2 = content.indexOf(DIRECTIVE_END, i1 + slen);
            if (i2 < 0) {
                return content;
            }
            if (i2 <= i1) continue;
            String directive = content.substring(i1 + slen, i2);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DIRECTIVE_DETECTED_3", DIRECTIVE_START, directive, DIRECTIVE_END));
            }
            int t1 = 0;
            int t2 = 0;
            int t3 = 0;
            int t4 = 0;
            int t5 = 0;
            while (directive.charAt(t1) == ' ') {
                ++t1;
            }
            String argument = null;
            if (directive.startsWith("page", t1)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_X_DIRECTIVE_DETECTED_1", "page"));
                }
                t2 = directive.indexOf("pageEncoding", t1 + 4);
                t5 = 12;
                if (t2 > 0) {
                    found = true;
                }
            }
            if (t2 > 0) {
                String sub = directive.substring(t2 + t5);
                char c1 = sub.charAt(t3);
                while (c1 == ' ' || c1 == '=' || c1 == '\"') {
                    c1 = sub.charAt(++t3);
                }
                t4 = t3;
                while (c1 != '\"') {
                    c1 = sub.charAt(++t4);
                }
                if (t4 > t3) {
                    argument = sub.substring(t3, t4);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DIRECTIVE_ARG_1", argument));
                }
            }
            if (argument != null) {
                String pre = directive.substring(0, t2 + t3 + t5);
                String suf = directive.substring(t2 + t3 + t5 + argument.length());
                directive = pre + encoding + suf;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DIRECTIVE_CHANGED_3", DIRECTIVE_START, directive, DIRECTIVE_END));
                }
            }
            buf.append(content.substring(p0, i1 + slen));
            buf.append(directive);
            p0 = i2;
            i1 = content.indexOf(DIRECTIVE_START, p0);
        }
        if (i2 > 0) {
            buf.append(content.substring(p0, content.length()));
        }
        if (found) {
            content = buf.toString();
        } else if (!isHardInclude) {
            StringBuffer buf2 = new StringBuffer(buf.length() + 32);
            buf2.append("<%@ page pageEncoding=\"");
            buf2.append(encoding);
            buf2.append("\" %>");
            buf2.append(buf);
            content = buf2.toString();
        }
        return content;
    }

    protected String parseJspIncludes(String content, CmsFlexController controller, Set<String> updatedFiles) {
        int i1 = content.indexOf(DIRECTIVE_START);
        if (i1 < 0) {
            return content;
        }
        StringBuffer buf = new StringBuffer(content.length());
        int p0 = 0;
        int i2 = 0;
        int slen = DIRECTIVE_START.length();
        while (i1 >= 0) {
            i2 = content.indexOf(DIRECTIVE_END, i1 + slen);
            if (i2 < 0) {
                return content;
            }
            if (i2 <= i1) continue;
            String directive = content.substring(i1 + slen, i2);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DIRECTIVE_DETECTED_3", DIRECTIVE_START, directive, DIRECTIVE_END));
            }
            int t1 = 0;
            int t2 = 0;
            int t3 = 0;
            int t4 = 0;
            int t5 = 0;
            while (directive.charAt(t1) == ' ') {
                ++t1;
            }
            String argument = null;
            if (directive.startsWith("include", t1)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_X_DIRECTIVE_DETECTED_1", "include"));
                }
                t2 = directive.indexOf("file", t1 + 7);
                t5 = 6;
            } else if (directive.startsWith("page", t1)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_X_DIRECTIVE_DETECTED_1", "page"));
                }
                t2 = directive.indexOf("errorPage", t1 + 4);
                t5 = 11;
            }
            if (t2 > 0) {
                String sub = directive.substring(t2 + t5);
                char c1 = sub.charAt(t3);
                while (c1 == ' ' || c1 == '=' || c1 == '\"') {
                    c1 = sub.charAt(++t3);
                }
                t4 = t3;
                while (c1 != '\"') {
                    c1 = sub.charAt(++t4);
                }
                if (t4 > t3) {
                    argument = sub.substring(t3, t4);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DIRECTIVE_ARG_1", argument));
                }
            }
            if (argument != null) {
                String pre = directive.substring(0, t2 + t3 + t5);
                String suf = directive.substring(t2 + t3 + t5 + argument.length());
                String jspname = this.updateJsp(argument, controller, updatedFiles);
                if (jspname != null) {
                    directive = pre + jspname + suf;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_DIRECTIVE_CHANGED_3", DIRECTIVE_START, directive, DIRECTIVE_END));
                    }
                }
            }
            buf.append(content.substring(p0, i1 + slen));
            buf.append(directive);
            p0 = i2;
            i1 = content.indexOf(DIRECTIVE_START, p0);
        }
        if (i2 > 0) {
            buf.append(content.substring(p0, content.length()));
            content = buf.toString();
        }
        return content;
    }

    protected String parseJspLinkMacros(String content, CmsFlexController controller) {
        CmsJspLinkMacroResolver macroResolver = new CmsJspLinkMacroResolver(controller.getCmsObject(), null, true);
        return macroResolver.resolveMacros(content);
    }

    protected CmsResource readJspResource(CmsFlexController controller, String jspName) throws CmsException {
        CmsObject cms = OpenCms.initCmsObject(controller.getCmsObject());
        cms.getRequestContext().setSiteRoot("");
        return cms.readResource(jspName);
    }

    protected void showSource(CmsObject cms, CmsResource file, HttpServletRequest req, HttpServletResponse res) throws CmsException, IOException {
        CmsResource historyResource = (CmsResource)((Object)CmsHistoryResourceHandler.getHistoryResource((ServletRequest)req));
        if (historyResource == null) {
            historyResource = file;
        }
        CmsFile historyFile = cms.readFile(historyResource);
        String content = new String(historyFile.getContents());
        res.setContentLength(content.length());
        res.setContentType("text/plain");
        PrintWriter out = res.getWriter();
        ((Writer)out).write(content);
        ((Writer)out).close();
    }

    protected String updateJsp(String vfsName, CmsFlexController controller, Set<String> updatedFiles) {
        String jspRfsName;
        block6: {
            String jspVfsName = CmsLinkManager.getAbsoluteUri(vfsName, controller.getCurrentRequest().getElementRootPath());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_UPDATE_JSP_1", jspVfsName));
            }
            try {
                CmsResource includeResource;
                try {
                    includeResource = this.readJspResource(controller, jspVfsName);
                }
                catch (CmsVfsResourceNotFoundException e) {
                    includeResource = this.readJspResource(controller, controller.getCmsObject().getRequestContext().addSiteRoot(jspVfsName));
                }
                jspRfsName = this.updateJsp(includeResource, controller, updatedFiles);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_NAME_REAL_FS_1", jspRfsName));
                }
            }
            catch (Exception e) {
                jspRfsName = null;
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ERR_UPDATE_1", jspVfsName), (Throwable)e);
            }
        }
        return jspRfsName;
    }

    protected boolean updateStrongLinks(CmsResource resource, CmsFlexController controller, Set<String> updatedFiles) throws CmsLoaderException, IOException, ServletException {
        Iterator<CmsRelation> it;
        int numberOfUpdates = updatedFiles.size();
        CmsObject cms = controller.getCmsObject();
        CmsRelationFilter filter = CmsRelationFilter.TARGETS.filterType(CmsRelationType.JSP_STRONG);
        try {
            it = cms.getRelationsForResource(resource, filter).iterator();
        }
        catch (CmsException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return false;
        }
        while (it.hasNext()) {
            CmsRelation relation = it.next();
            CmsResource target = null;
            try {
                target = relation.getTarget(cms, CmsResourceFilter.DEFAULT);
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                continue;
            }
            if (resource.equals(target)) continue;
            this.updateJsp(target, controller, updatedFiles);
        }
        return numberOfUpdates < updatedFiles.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReentrantReadWriteLock getFileLock(String jspVfsName) {
        ReentrantReadWriteLock lock = m_fileLocks.get(jspVfsName);
        if (lock == null) {
            this.m_purgeLock.readLock().lock();
            Map<String, ReentrantReadWriteLock> map = m_fileLocks;
            synchronized (map) {
                if (!m_fileLocks.containsKey(jspVfsName)) {
                    m_fileLocks.put(jspVfsName, new ReentrantReadWriteLock(true));
                }
                lock = m_fileLocks.get(jspVfsName);
            }
            this.m_purgeLock.readLock().unlock();
        }
        return lock;
    }

    private String getJspRfsPath(CmsResource resource, boolean online) throws CmsLoaderException {
        String jspVfsName = resource.getRootPath();
        int loaderId = OpenCms.getResourceManager().getResourceType(resource.getTypeId()).getLoaderId();
        String extension = loaderId == 6 && !jspVfsName.endsWith(JSP_EXTENSION) ? JSP_EXTENSION : "";
        String jspPath = CmsFileUtil.getRepositoryName(m_jspRepository, jspVfsName + extension, online);
        return jspPath;
    }

    static {
        m_fileLocks = CmsMemoryMonitor.createLRUCacheMap(10000);
    }
}

