/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsEncoder;
import org.opencms.ui.components.CmsRichTextArea;

public class CmsBroadcast
implements Cloneable {
    public static long DISPLAY_AGAIN_TIME = 60000L;
    private String m_message;
    private CmsUser m_sender;
    private long m_sendTime;
    private ContentMode m_contentMode;
    private long m_lastDisplay;
    private boolean m_repeat;

    @Deprecated
    public CmsBroadcast(CmsUser sender, String message) {
        this(sender, message, System.currentTimeMillis(), 0L, false);
    }

    @Deprecated
    public CmsBroadcast(CmsUser sender, String message, boolean repeat) {
        this(sender, message, System.currentTimeMillis(), 0L, repeat);
    }

    public CmsBroadcast(CmsUser sender, String message, boolean repeat, ContentMode mode) {
        this(sender, message, System.currentTimeMillis(), 0L, repeat, mode);
    }

    public CmsBroadcast(CmsUser sender, String message, ContentMode mode) {
        this(sender, message, System.currentTimeMillis(), 0L, false, mode);
    }

    @Deprecated
    public CmsBroadcast(CmsUser sender, String message, long sendTime, long lastDisplay, boolean repeat) {
        this(sender, message, sendTime, lastDisplay, repeat, ContentMode.plain);
    }

    @Deprecated
    public CmsBroadcast(CmsUser sender, String message, long sendTime, long lastDisplay, boolean repeat, ContentMode mode) {
        this.m_sender = sender;
        this.m_message = message;
        this.m_sendTime = sendTime;
        this.m_lastDisplay = lastDisplay;
        this.m_repeat = repeat;
        this.m_contentMode = mode;
    }

    public ContentMode getContentMode() {
        return this.m_contentMode;
    }

    public long getLastDisplay() {
        return this.m_lastDisplay;
    }

    public String getMessage() {
        String result;
        switch (this.m_contentMode) {
            case html: {
                result = this.m_message;
                break;
            }
            default: {
                result = this.htmlForPlain(this.m_message);
            }
        }
        result = CmsRichTextArea.cleanHtml(result, true);
        return result;
    }

    public String getRawMessage() {
        return this.m_message;
    }

    public long getSendTime() {
        return this.m_sendTime;
    }

    public CmsUser getUser() {
        return this.m_sender;
    }

    public boolean isRepeat() {
        return this.m_repeat;
    }

    public CmsBroadcast withLastDisplay(long lastDisplay) {
        try {
            CmsBroadcast result = (CmsBroadcast)this.clone();
            result.m_lastDisplay = lastDisplay;
            return result;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private String htmlForPlain(String message) {
        String result = CmsEncoder.escapeXml(message);
        result = result.replace("\n", "<br>");
        return result;
    }

    public static enum ContentMode {
        plain,
        html;

    }
}

