/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;

public class CmsDuplicateRemovingLogBuffer {
    private Set<Entry> m_entries = new LinkedHashSet<Entry>();

    public void add(String channel, String level, String message) {
        this.m_entries.add(new Entry(channel, level, message));
    }

    public void flush() {
        for (Entry entry : this.m_entries) {
            String level = entry.getLevel();
            Log log = CmsLog.getLog(entry.getChannel());
            if ("warn".equalsIgnoreCase(level)) {
                log.warn((Object)entry.getMessage());
                continue;
            }
            if ("error".equalsIgnoreCase(level)) {
                log.error((Object)entry.getMessage());
                continue;
            }
            if ("info".equalsIgnoreCase(level)) {
                log.info((Object)entry.getMessage());
                continue;
            }
            if ("debug".equalsIgnoreCase(level)) {
                log.debug((Object)entry.getMessage());
                continue;
            }
            log.info((Object)entry.getMessage());
        }
        this.m_entries.clear();
    }

    public static class Entry {
        private String m_channel;
        private String m_level;
        private String m_message;

        public Entry(String channel, String level, String message) {
            this.m_channel = channel;
            this.m_level = level;
            this.m_message = message;
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }

        public String getChannel() {
            return this.m_channel;
        }

        public String getLevel() {
            return this.m_level;
        }

        public String getMessage() {
            return this.m_message;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }
    }
}

