/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.util.Loader;

public final class CmsLog {
    public static final String FILE_LOG = "opencms.log";
    public static final String FOLDER_LOGS = "logs" + File.separatorChar;
    public static final String PROPERTY_LOGFOLDER = "opencms.logfolder";
    public static final String PROPERTY_LOGFILE = "opencms.logfile";
    public static Log INIT;
    private static String m_logFileRfsFolder;
    private static String m_logFileRfsPath;
    private static CopyOnWriteArraySet<String> NON_MANAGEABLE_CHANNELS;

    private CmsLog() {
    }

    public static String eval(Log log, Callable<String> stringProvider) {
        try {
            return stringProvider.call();
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return "<ERROR>";
        }
    }

    public static Log getLog(Object obj) {
        if (obj instanceof String) {
            return LogFactory.getLog((String)((String)obj));
        }
        if (obj instanceof Class) {
            return LogFactory.getLog((Class)((Class)obj));
        }
        return LogFactory.getLog(obj.getClass());
    }

    public static boolean isManageable(String channel) {
        return !NON_MANAGEABLE_CHANNELS.contains(channel);
    }

    public static void makeChannelNonManageable(String channel) {
        NON_MANAGEABLE_CHANNELS.add(channel);
    }

    public static String[] render(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            throwable.printStackTrace(pw);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        pw.flush();
        LineNumberReader reader = new LineNumberReader(new StringReader(sw.toString()));
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line = reader.readLine();
            while (line != null) {
                lines.add(line);
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            if (ex instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            lines.add(ex.toString());
        }
        return lines.toArray(new String[0]);
    }

    protected static String getLogFileRfsPath() {
        return m_logFileRfsPath;
    }

    protected static String getLogFileRfsFolder() {
        return m_logFileRfsFolder;
    }

    static {
        NON_MANAGEABLE_CHANNELS = new CopyOnWriteArraySet();
        try {
            URL log4j2Url = Loader.getResource((String)"log4j2.xml", null);
            if (log4j2Url != null) {
                File log4jProps = new File(URLDecoder.decode(log4j2Url.getPath(), Charset.defaultCharset().name()));
                String path = log4jProps.getAbsolutePath();
                boolean setLogFile = Boolean.parseBoolean(System.getProperty("opencms.set.logfile", "true"));
                if (setLogFile) {
                    String propertyLogfolder = System.getProperty(PROPERTY_LOGFOLDER);
                    String propertyLogfile = System.getProperty(PROPERTY_LOGFILE);
                    String webInfPath = log4jProps.getParent();
                    webInfPath = webInfPath.substring(0, webInfPath.lastIndexOf(File.separatorChar) + 1);
                    String logFilePath = propertyLogfile != null ? propertyLogfile : webInfPath + FOLDER_LOGS + FILE_LOG;
                    String logFolderPath = propertyLogfolder != null ? propertyLogfolder : webInfPath + FOLDER_LOGS;
                    m_logFileRfsPath = new File(logFilePath).getAbsolutePath();
                    m_logFileRfsFolder = new File(logFolderPath).getAbsolutePath() + File.separatorChar;
                    if (propertyLogfile == null) {
                        System.setProperty(PROPERTY_LOGFILE, m_logFileRfsPath);
                    }
                    if (propertyLogfolder == null) {
                        System.setProperty(PROPERTY_LOGFOLDER, m_logFileRfsFolder);
                    }
                    ConfigurationSource source = ConfigurationSource.fromUri((URI)log4j2Url.toURI());
                    Configurator.initialize(null, (ConfigurationSource)source);
                }
                INIT = LogFactory.getLog((String)"org.opencms.init");
                INIT.info((Object)(". Log4j config file    : " + path));
                INIT.debug((Object)(". m_logFileRfsPath    : " + m_logFileRfsPath));
                INIT.debug((Object)(". m_logFileRfsFolder  : " + m_logFileRfsFolder));
            } else {
                System.err.println("'log4j2.xml' not found. (Default location: WEB-INF/classes/log4j2.xml)");
            }
        }
        catch (SecurityException e) {
            e.printStackTrace(System.err);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

