/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.configuration.I_CmsConfigurationParameterHandler;
import org.opencms.configuration.I_CmsNeedsAdminCmsObject;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsResourceInitException;
import org.opencms.main.I_CmsResourceInit;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsLink;
import org.opencms.relations.I_CmsCustomLinkRenderer;
import org.opencms.security.CmsPermissionViolationException;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.xml2json.I_CmsApiAuthorizationHandler;

public class CmsProtectedStaticFileHandler
implements I_CmsResourceInit,
I_CmsConfigurationParameterHandler,
I_CmsNeedsAdminCmsObject,
I_CmsCustomLinkRenderer {
    public static final String PARAM_LINKREWRITE_ID = "linkrewrite.id";
    public static final String PARAM_AUTHORIZATION = "authorization";
    public static final String PARAM_PATHFILTER = "pathfilter";
    public static final String PARAM_TYPEFILTER = "typefilter";
    public static final String PREFIX = "/staticresource";
    private static final Log LOG = CmsLog.getLog(CmsProtectedStaticFileHandler.class);
    public static final String PARAM_LINKREWRITE_PREFIX = "linkrewrite.prefix";
    private CmsObject m_adminCms;
    private CmsParameterConfiguration m_config = new CmsParameterConfiguration();
    private Pattern m_pathFilter;
    private Pattern m_typeFilter;
    private String m_linkRewritePrefix;

    public static String mergeLinkPrefix(String prefix, String path, String query) {
        try {
            URI baseUri = new URI(prefix);
            URI correctedUri = new URI(baseUri.getScheme(), baseUri.getAuthority(), CmsStringUtil.joinPaths(baseUri.getPath(), PREFIX, path), query, null);
            return correctedUri.toASCIIString();
        }
        catch (URISyntaxException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    private static CmsObject authorize(CmsObject adminCms, CmsObject defaultCms, HttpServletRequest request, String authChain) {
        if (authChain == null) {
            return defaultCms;
        }
        for (String token : authChain.split(",")) {
            if ("default".equals(token = token.trim())) {
                LOG.info((Object)"Using default CmsObject");
                return defaultCms;
            }
            if ("guest".equals(token)) {
                try {
                    return OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserGuest());
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    return null;
                }
            }
            I_CmsApiAuthorizationHandler handler = OpenCms.getApiAuthorization(token);
            if (handler == null) {
                LOG.error((Object)("Could not find API authorization handler " + token));
                return null;
            }
            try {
                CmsObject cms = handler.initCmsObject(adminCms, request);
                if (cms == null) continue;
                LOG.info((Object)("Succeeded with authorization handler: " + token));
                return cms;
            }
            catch (CmsException e) {
                LOG.error((Object)("Error evaluating authorization handler " + token));
                return null;
            }
        }
        LOG.info((Object)"Authentication unsusccessful");
        return null;
    }

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
        this.m_config.add(paramName, paramValue);
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        return this.m_config;
    }

    @Override
    public String getLink(CmsObject cms, CmsLink link) {
        try {
            CmsObject adminCms = OpenCms.initCmsObject(this.m_adminCms);
            adminCms.getRequestContext().setCurrentProject(cms.getRequestContext().getCurrentProject());
            link.checkConsistency(adminCms);
            if (this.checkResourceAccessible(link.getResource())) {
                return CmsProtectedStaticFileHandler.mergeLinkPrefix(this.m_linkRewritePrefix, link.getResource().getRootPath(), link.getQuery());
            }
            return null;
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String getLink(CmsObject cms, CmsResource resource) {
        if (this.checkResourceAccessible(resource)) {
            return CmsProtectedStaticFileHandler.mergeLinkPrefix(this.m_linkRewritePrefix, resource.getRootPath(), null);
        }
        return null;
    }

    @Override
    public void initConfiguration() {
        this.m_config = CmsParameterConfiguration.unmodifiableVersion(this.m_config);
        this.m_pathFilter = Pattern.compile(this.m_config.getString(PARAM_PATHFILTER, ".*"));
        this.m_typeFilter = Pattern.compile(this.m_config.getString(PARAM_TYPEFILTER, "image|text|binary"));
        String linkRewriteId = this.m_config.getString(PARAM_LINKREWRITE_ID, null);
        if (linkRewriteId != null) {
            OpenCms.setRuntimeProperty(linkRewriteId, this);
        }
        this.m_linkRewritePrefix = this.m_config.getString(PARAM_LINKREWRITE_PREFIX, null);
    }

    @Override
    public CmsResource initResource(CmsResource origRes, CmsObject cms, HttpServletRequest req, HttpServletResponse res) throws CmsResourceInitException {
        String uri = cms.getRequestContext().getUri();
        if (origRes != null) {
            return origRes;
        }
        if (res == null) {
            return origRes;
        }
        if (!CmsStringUtil.isPrefixPath(PREFIX, uri)) {
            return null;
        }
        String path = uri.substring(PREFIX.length());
        if (path.isEmpty()) {
            path = "/";
        } else if (path.length() > 1) {
            path = CmsFileUtil.removeTrailingSeparator(path);
        }
        String authorizationParam = this.m_config.get(PARAM_AUTHORIZATION);
        CmsObject origCms = cms;
        cms = CmsProtectedStaticFileHandler.authorize(this.m_adminCms, origCms, req, authorizationParam);
        if (cms != null && cms != origCms) {
            origCms.getRequestContext().setAttribute("resourceinit.alternativeCmsObject", cms);
            cms.getRequestContext().setSiteRoot(origCms.getRequestContext().getSiteRoot());
            cms.getRequestContext().setUri(origCms.getRequestContext().getUri());
        }
        int status = 200;
        try {
            CmsObject rootCms = OpenCms.initCmsObject(cms);
            rootCms.getRequestContext().setSiteRoot("");
            if (this.m_pathFilter.matcher(path).matches()) {
                CmsResource resource = rootCms.readResource(path, CmsResourceFilter.IGNORE_EXPIRATION);
                if (!this.checkResourceAccessible(resource)) {
                    status = 403;
                } else {
                    return resource;
                }
            }
            status = 404;
        }
        catch (CmsPermissionViolationException e) {
            status = OpenCms.getDefaultUsers().isUserGuest(cms.getRequestContext().getCurrentUser().getName()) ? 401 : 403;
        }
        catch (CmsVfsResourceNotFoundException e) {
            status = 404;
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            status = 500;
        }
        try {
            res.sendError(status);
        }
        catch (IOException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        CmsResourceInitException ex = new CmsResourceInitException(CmsProtectedStaticFileHandler.class);
        ex.setClearErrors(true);
        throw ex;
    }

    @Override
    public void setAdminCmsObject(CmsObject adminCms) {
        this.m_adminCms = adminCms;
    }

    private boolean checkResourceAccessible(CmsResource res) {
        return res != null && this.m_pathFilter.matcher(res.getRootPath()).matches() && this.checkType(res.getTypeId());
    }

    private boolean checkType(int typeId) {
        try {
            I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(typeId);
            return this.m_typeFilter.matcher(type.getTypeName()).matches();
        }
        catch (Exception e) {
            LOG.error((Object)("Missing type with id: " + typeId));
            return false;
        }
    }
}

