/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMessages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsServletContainerSettings;
import org.opencms.main.CmsShellCommandException;
import org.opencms.main.CmsShellCommands;
import org.opencms.main.I_CmsShellCommands;
import org.opencms.main.Messages;
import org.opencms.main.OpenCms;
import org.opencms.main.OpenCmsCore;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsDataTypeUtil;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.benchmark.CmsBenchmarkTable;
import org.opencms.util.benchmark.CmsFileBenchmarkReceiver;

public class CmsShell {
    public static final String SHELL_PARAM_ADDITIONAL_COMMANDS = "-additional=";
    public static final String SHELL_PARAM_BASE = "-base=";
    public static final String SHELL_PARAM_DEFAULT_WEB_APP = "-defaultWebApp=";
    public static final String SHELL_PARAM_ERROR_CODE = "-errorCode=";
    public static final String SHELL_PARAM_JLAN = "-jlan";
    public static final String SHELL_PARAM_SCRIPT = "-script=";
    public static final String SHELL_PARAM_SERVLET_MAPPING = "-servletMapping=";
    public static final ThreadLocal<ArrayList<CmsShell>> SHELL_STACK = ThreadLocal.withInitial(() -> new ArrayList());
    private static boolean JLAN_DISABLED;
    private CmsBenchmarkTable m_benchmarkTable;
    protected CmsObject m_cms;
    protected PrintStream m_err;
    protected int m_errorCode = -1;
    protected PrintStream m_out;
    private I_CmsShellCommands m_additionalShellCommands;
    private List<CmsCommandObject> m_commandObjects;
    private boolean m_echo;
    private boolean m_exitCalled;
    private boolean m_hasReportError;
    private boolean m_interactive;
    private CmsMessages m_messages;
    private OpenCmsCore m_opencms;
    private String m_prompt;
    private CmsUserSettings m_settings;
    private I_CmsShellCommands m_shellCommands;

    public CmsShell(CmsObject cms, String prompt, I_CmsShellCommands additionalShellCommands, PrintStream out, PrintStream err) {
        this.setPrompt(prompt);
        try {
            this.m_opencms = null;
            Locale locale = this.getLocale();
            this.m_messages = Messages.get().getBundle(locale);
            this.m_cms = cms;
            this.initShell(additionalShellCommands, out, err);
        }
        catch (Throwable t) {
            t.printStackTrace(this.m_err);
        }
    }

    public CmsShell(String webInfPath, String servletMapping, String defaultWebAppName, String prompt, I_CmsShellCommands additionalShellCommands) {
        this(webInfPath, servletMapping, defaultWebAppName, prompt, additionalShellCommands, System.out, System.err, false);
    }

    public CmsShell(String webInfPath, String servletMapping, String defaultWebAppName, String prompt, I_CmsShellCommands additionalShellCommands, PrintStream out, PrintStream err, boolean interactive) {
        this.setPrompt(prompt);
        this.setInteractive(interactive);
        if (CmsStringUtil.isEmpty(servletMapping)) {
            servletMapping = "/opencms/*";
        }
        if (CmsStringUtil.isEmpty(defaultWebAppName)) {
            defaultWebAppName = "ROOT";
        }
        try {
            this.m_opencms = OpenCmsCore.getInstance();
            Locale locale = this.getLocale();
            this.m_messages = Messages.get().getBundle(locale);
            if (CmsStringUtil.isEmpty(webInfPath)) {
                out.println(this.m_messages.key("GUI_SHELL_NO_HOME_FOLDER_SPECIFIED_0"));
                out.println();
                webInfPath = CmsFileUtil.searchWebInfFolder(System.getProperty("user.dir"));
                if (CmsStringUtil.isEmpty(webInfPath)) {
                    err.println(this.m_messages.key("GUI_SHELL_HR_0"));
                    err.println(this.m_messages.key("GUI_SHELL_NO_HOME_FOLDER_FOUND_0"));
                    err.println();
                    err.println(this.m_messages.key("GUI_SHELL_START_DIR_LINE1_0"));
                    err.println(this.m_messages.key("GUI_SHELL_START_DIR_LINE2_0"));
                    err.println(this.m_messages.key("GUI_SHELL_HR_0"));
                    return;
                }
            }
            out.println(Messages.get().getBundle(locale).key("GUI_SHELL_WEB_INF_PATH_1", webInfPath));
            CmsServletContainerSettings settings = new CmsServletContainerSettings(webInfPath, defaultWebAppName, servletMapping, null, null);
            this.m_opencms.getSystemInfo().init(settings);
            String propertyPath = this.m_opencms.getSystemInfo().getConfigurationFileRfsPath();
            out.println(this.m_messages.key("GUI_SHELL_CONFIG_FILE_1", propertyPath));
            out.println();
            CmsParameterConfiguration configuration = new CmsParameterConfiguration(propertyPath);
            this.m_opencms = this.m_opencms.upgradeRunlevel(configuration);
            this.m_cms = this.m_opencms.initCmsObject(this.m_opencms.getDefaultUsers().getUserGuest());
            this.initShell(additionalShellCommands, out, err);
        }
        catch (Throwable t) {
            t.printStackTrace(err);
        }
    }

    public static CmsShell getTopShell() {
        ArrayList<CmsShell> shells = SHELL_STACK.get();
        if (shells.isEmpty()) {
            return null;
        }
        return shells.get(shells.size() - 1);
    }

    public static boolean isJlanDisabled() {
        return JLAN_DISABLED;
    }

    public static void main(String[] args) {
        JLAN_DISABLED = true;
        boolean wrongUsage = false;
        String webInfPath = null;
        String script = null;
        String servletMapping = null;
        String defaultWebApp = null;
        String additional = null;
        int errorCode = -1;
        if (args.length > 4) {
            wrongUsage = true;
        } else {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.startsWith(SHELL_PARAM_BASE)) {
                    webInfPath = arg.substring(SHELL_PARAM_BASE.length());
                    continue;
                }
                if (arg.startsWith(SHELL_PARAM_SCRIPT)) {
                    script = arg.substring(SHELL_PARAM_SCRIPT.length());
                    continue;
                }
                if (arg.startsWith(SHELL_PARAM_SERVLET_MAPPING)) {
                    servletMapping = arg.substring(SHELL_PARAM_SERVLET_MAPPING.length());
                    continue;
                }
                if (arg.startsWith(SHELL_PARAM_DEFAULT_WEB_APP)) {
                    defaultWebApp = arg.substring(SHELL_PARAM_DEFAULT_WEB_APP.length());
                    continue;
                }
                if (arg.startsWith(SHELL_PARAM_ADDITIONAL_COMMANDS)) {
                    additional = arg.substring(SHELL_PARAM_ADDITIONAL_COMMANDS.length());
                    continue;
                }
                if (arg.startsWith(SHELL_PARAM_ERROR_CODE)) {
                    errorCode = Integer.valueOf(arg.substring(SHELL_PARAM_ERROR_CODE.length()));
                    continue;
                }
                if (arg.startsWith(SHELL_PARAM_JLAN)) {
                    JLAN_DISABLED = false;
                    continue;
                }
                System.out.println(Messages.get().getBundle().key("GUI_SHELL_WRONG_USAGE_0"));
                wrongUsage = true;
            }
        }
        if (wrongUsage) {
            System.out.println(Messages.get().getBundle().key("GUI_SHELL_USAGE_1", CmsShell.class.getName()));
        } else {
            I_CmsShellCommands additionalCommands = null;
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(additional)) {
                try {
                    Class<?> commandClass = Class.forName(additional);
                    additionalCommands = (I_CmsShellCommands)commandClass.newInstance();
                }
                catch (Exception e) {
                    System.out.println(Messages.get().getBundle().key("GUI_SHELL_ERR_ADDITIONAL_COMMANDS_1", additional));
                    e.printStackTrace();
                    return;
                }
            }
            boolean interactive = true;
            FileInputStream stream = null;
            if (script != null) {
                try {
                    stream = new FileInputStream(script);
                }
                catch (IOException exc) {
                    System.out.println(Messages.get().getBundle().key("GUI_SHELL_ERR_SCRIPTFILE_1", script));
                }
            }
            if (stream == null) {
                stream = new FileInputStream(FileDescriptor.in);
                interactive = true;
            }
            CmsShell shell = new CmsShell(webInfPath, servletMapping, defaultWebApp, "${user}@${project}:${siteroot}|${uri}>", additionalCommands, System.out, System.err, interactive);
            shell.m_errorCode = errorCode;
            shell.execute(stream);
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void popShell() {
        ArrayList<CmsShell> shells = SHELL_STACK.get();
        if (shells.size() > 0) {
            shells.remove(shells.size() - 1);
        }
    }

    public static void pushShell(CmsShell shell) {
        SHELL_STACK.get().add(shell);
    }

    public static void setReportError() {
        CmsShell instance = CmsShell.getTopShell();
        if (instance != null) {
            instance.m_hasReportError = true;
        }
    }

    public void execute(InputStream inputStream) {
        this.execute(new InputStreamReader(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Reader reader) {
        try {
            CmsShell.pushShell(this);
            LineNumberReader lnr = new LineNumberReader(reader);
            while (!this.m_exitCalled) {
                String line = lnr.readLine();
                if ((this.m_interactive || this.m_echo) && line != null | this.m_interactive) {
                    this.printPrompt();
                }
                if (line == null) {
                    if (this.m_interactive) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Throwable throwable) {}
                    }
                    break;
                }
                if (line.trim().startsWith("#")) {
                    this.m_out.println(line);
                    continue;
                }
                if (line.indexOf(27) != -1) {
                    this.m_out.println(this.m_messages.key("GUI_SHELL_ESCAPE_SEQUENCES_NOT_SUPPORTED_0"));
                    continue;
                }
                StringReader lineReader = new StringReader(line);
                StreamTokenizer st = new StreamTokenizer(lineReader);
                st.eolIsSignificant(true);
                st.wordChars(42, 42);
                ArrayList<String> parameters = new ArrayList<String>();
                while (st.nextToken() != -1) {
                    if (st.ttype == -2) {
                        parameters.add(Integer.toString(new Double(st.nval).intValue()));
                        continue;
                    }
                    if (null == st.sval) continue;
                    parameters.add(st.sval);
                }
                lineReader.close();
                if (parameters.size() == 0) {
                    if (!this.m_echo) continue;
                    this.m_out.println();
                    continue;
                }
                String command = (String)parameters.get(0);
                List<String> arguments = parameters.subList(1, parameters.size());
                this.executeCommand(command, arguments);
            }
        }
        catch (Throwable t) {
            if (!(t instanceof CmsShellCommandException)) {
                t.printStackTrace(this.m_err);
            }
            if (this.m_errorCode != -1) {
                System.exit(this.m_errorCode);
            }
        }
        finally {
            CmsShell.popShell();
        }
    }

    public void execute(String commands) {
        this.execute(new StringReader(commands));
    }

    public void executeCommand(String command, List<String> parameters) {
        if (null == command) {
            return;
        }
        if (this.m_echo) {
            this.m_out.print(command);
            for (int i = 0; i < parameters.size(); ++i) {
                this.m_out.print(" '");
                this.m_out.print(parameters.get(i));
                this.m_out.print("'");
            }
            this.m_out.println();
        }
        boolean executed = false;
        Iterator<CmsCommandObject> i = this.m_commandObjects.iterator();
        while (!executed && i.hasNext()) {
            CmsCommandObject cmdObj = i.next();
            executed = cmdObj.executeMethod(command, parameters);
        }
        if (!executed) {
            this.m_out.println();
            StringBuffer commandMsg = new StringBuffer(command).append("(");
            for (int j = 0; j < parameters.size(); ++j) {
                commandMsg.append("value");
                if (j >= parameters.size() - 1) continue;
                commandMsg.append(", ");
            }
            commandMsg.append(")");
            this.m_out.println(this.m_messages.key("GUI_SHELL_METHOD_NOT_FOUND_1", commandMsg.toString()));
            this.m_out.println(this.m_messages.key("GUI_SHELL_HR_0"));
            ((CmsShellCommands)this.m_shellCommands).help();
        }
    }

    public void exit() {
        if (this.m_exitCalled) {
            return;
        }
        this.m_exitCalled = true;
        try {
            if (this.m_additionalShellCommands != null) {
                this.m_additionalShellCommands.shellExit();
            } else if (null != this.m_shellCommands) {
                this.m_shellCommands.shellExit();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (this.m_opencms != null) {
            try {
                this.m_opencms.shutDown();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public CmsBenchmarkTable getBenchmarkTable() {
        if (this.m_benchmarkTable == null) {
            this.m_benchmarkTable = new CmsBenchmarkTable(new CmsFileBenchmarkReceiver());
        }
        return this.m_benchmarkTable;
    }

    public PrintStream getErr() {
        return this.m_err;
    }

    public int getErrorCode() {
        return this.m_errorCode;
    }

    public Locale getLocale() {
        if (this.getSettings() == null) {
            return CmsLocaleManager.getDefaultLocale();
        }
        return this.getSettings().getLocale();
    }

    public CmsMessages getMessages() {
        return this.m_messages;
    }

    public PrintStream getOut() {
        return this.m_out;
    }

    public String getPrompt() {
        String prompt = this.m_prompt;
        try {
            prompt = CmsStringUtil.substitute(prompt, "${user}", this.m_cms.getRequestContext().getCurrentUser().getName());
            prompt = CmsStringUtil.substitute(prompt, "${siteroot}", this.m_cms.getRequestContext().getSiteRoot());
            prompt = CmsStringUtil.substitute(prompt, "${project}", this.m_cms.getRequestContext().getCurrentProject().getName());
            prompt = CmsStringUtil.substitute(prompt, "${uri}", this.m_cms.getRequestContext().getUri());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return prompt;
    }

    public CmsUserSettings getSettings() {
        return this.m_settings;
    }

    public boolean hasEcho() {
        return this.m_echo;
    }

    public boolean hasReportError() {
        return this.m_hasReportError;
    }

    public void initShell(I_CmsShellCommands additionalShellCommands, PrintStream out, PrintStream err) {
        this.m_out = out;
        this.m_err = err;
        this.m_settings = this.initSettings();
        this.m_shellCommands = new CmsShellCommands();
        this.m_shellCommands.initShellCmsObject(this.m_cms, this);
        if (additionalShellCommands != null) {
            this.m_additionalShellCommands = additionalShellCommands;
            this.m_additionalShellCommands.initShellCmsObject(this.m_cms, this);
            this.m_additionalShellCommands.shellStart();
        } else {
            this.m_shellCommands.shellStart();
        }
        this.m_commandObjects = new ArrayList<CmsCommandObject>();
        if (this.m_additionalShellCommands != null) {
            this.m_commandObjects.add(new CmsCommandObject(this.m_additionalShellCommands));
        }
        this.m_commandObjects.add(new CmsCommandObject(this.m_shellCommands));
        this.m_commandObjects.add(new CmsCommandObject(this.m_cms.getRequestContext()));
        this.m_commandObjects.add(new CmsCommandObject(this.m_cms));
    }

    public boolean isExitCalled() {
        return this.m_exitCalled;
    }

    public boolean isInteractive() {
        return this.m_interactive;
    }

    public void printPrompt() {
        String prompt = this.getPrompt();
        this.m_out.print(prompt);
        this.m_out.flush();
    }

    public void setInteractive(boolean interactive) {
        this.m_interactive = interactive;
    }

    public void setLocale(Locale locale) throws CmsException {
        CmsUserSettings settings = this.getSettings();
        if (settings != null) {
            settings.setLocale(locale);
            settings.save(this.m_cms);
            this.m_messages = Messages.get().getBundle(locale);
        }
    }

    @Deprecated
    public void start(FileInputStream inputStream) {
        this.setInteractive(true);
        this.execute(inputStream);
    }

    public boolean validateUser(String userName, String password, CmsRole requiredRole) {
        boolean result = false;
        try {
            CmsUser user = this.m_cms.readUser(userName, password);
            result = OpenCms.getRoleManager().hasRole(this.m_cms, user.getName(), requiredRole);
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        return result;
    }

    protected void help(String searchString) {
        boolean foundSomething = false;
        this.m_out.println();
        for (CmsCommandObject cmdObj : this.m_commandObjects) {
            String commandList = cmdObj.getMethodHelp(searchString);
            if (CmsStringUtil.isEmpty(commandList)) continue;
            this.m_out.println(this.m_messages.key("GUI_SHELL_AVAILABLE_METHODS_1", cmdObj.getObject().getClass().getName()));
            this.m_out.println(commandList);
            foundSomething = true;
        }
        if (!foundSomething) {
            this.m_out.println(this.m_messages.key("GUI_SHELL_MATCH_SEARCHSTRING_1", searchString));
        }
    }

    protected CmsUserSettings initSettings() {
        this.m_settings = new CmsUserSettings(this.m_cms);
        return this.m_settings;
    }

    protected void setEcho(boolean echo) {
        this.m_echo = echo;
    }

    protected void setPrompt(String prompt) {
        this.m_prompt = prompt;
    }

    private class CmsCommandObject {
        private Map<String, List<Method>> m_methods;
        private Object m_object;

        protected CmsCommandObject(Object object) {
            this.m_object = object;
            this.initShellMethods();
        }

        protected boolean executeMethod(String command, List<String> parameters) {
            block21: {
                Class<?>[] clazz;
                CmsShell.this.m_hasReportError = false;
                String lookup = this.buildMethodLookup(command, parameters.size());
                List<Method> possibleMethods = this.m_methods.get(lookup);
                if (possibleMethods == null) {
                    return false;
                }
                Method onlyStringMethod = null;
                Method foundMethod = null;
                Object[] params = null;
                for (Method method : possibleMethods) {
                    clazz = method.getParameterTypes();
                    boolean onlyString = true;
                    for (int j = 0; j < clazz.length; ++j) {
                        if (clazz[j].equals(String.class)) continue;
                        onlyString = false;
                        break;
                    }
                    if (!onlyString) continue;
                    onlyStringMethod = method;
                    break;
                }
                for (Method method : possibleMethods) {
                    if (method == onlyStringMethod) continue;
                    clazz = method.getParameterTypes();
                    Object[] converted = new Object[clazz.length];
                    boolean match = true;
                    for (int j = 0; j < clazz.length; ++j) {
                        String value = parameters.get(j);
                        try {
                            converted[j] = CmsDataTypeUtil.parse(value, clazz[j]);
                            continue;
                        }
                        catch (Throwable t) {
                            match = false;
                            break;
                        }
                    }
                    if (!match) continue;
                    params = converted;
                    foundMethod = method;
                    break;
                }
                if (foundMethod == null && onlyStringMethod != null) {
                    params = parameters.toArray();
                    foundMethod = onlyStringMethod;
                }
                if (params == null || foundMethod == null) {
                    return false;
                }
                try {
                    Object result = foundMethod.invoke(this.m_object, params);
                    if (result != null) {
                        if (result instanceof Collection) {
                            Collection c = (Collection)result;
                            CmsShell.this.m_out.println(c.getClass().getName() + " (size: " + c.size() + ")");
                            int count = 0;
                            if (result instanceof Map) {
                                Map m = (Map)result;
                                for (Map.Entry entry : m.entrySet()) {
                                    CmsShell.this.m_out.println(count++ + ": " + entry.getKey() + "= " + entry.getValue());
                                }
                            } else {
                                Iterator j = c.iterator();
                                while (j.hasNext()) {
                                    CmsShell.this.m_out.println(count++ + ": " + j.next());
                                }
                            }
                        } else {
                            CmsShell.this.m_out.println(result.toString());
                        }
                    }
                }
                catch (InvocationTargetException ite) {
                    CmsShell.this.m_out.println(Messages.get().getBundle(CmsShell.this.getLocale()).key("GUI_SHELL_EXEC_METHOD_1", new Object[]{foundMethod.getName()}));
                    ite.getTargetException().printStackTrace(CmsShell.this.m_out);
                    if (CmsShell.this.m_errorCode != -1) {
                        throw new CmsShellCommandException(ite.getCause());
                    }
                }
                catch (Throwable t) {
                    CmsShell.this.m_out.println(Messages.get().getBundle(CmsShell.this.getLocale()).key("GUI_SHELL_EXEC_METHOD_1", new Object[]{foundMethod.getName()}));
                    t.printStackTrace(CmsShell.this.m_out);
                    if (CmsShell.this.m_errorCode == -1) break block21;
                    throw new CmsShellCommandException(t);
                }
            }
            if (CmsShell.this.m_hasReportError && CmsShell.this.m_errorCode != -1) {
                throw new CmsShellCommandException(true);
            }
            return true;
        }

        protected String getMethodHelp(String searchString) {
            StringBuffer buf = new StringBuffer(512);
            Iterator<String> i = this.m_methods.keySet().iterator();
            while (i.hasNext()) {
                List<Method> l = this.m_methods.get(i.next());
                for (Method method : l) {
                    if (searchString != null && method.getName().toLowerCase().indexOf(searchString.toLowerCase()) <= -1) continue;
                    buf.append("* ");
                    buf.append(method.getName());
                    buf.append("(");
                    Class<?>[] params = method.getParameterTypes();
                    for (int k = 0; k < params.length; ++k) {
                        String par = params[k].getName();
                        par = par.substring(par.lastIndexOf(46) + 1);
                        if (k != 0) {
                            buf.append(", ");
                        }
                        buf.append(par);
                    }
                    buf.append(")\n");
                }
            }
            return buf.toString();
        }

        protected Object getObject() {
            return this.m_object;
        }

        private String buildMethodLookup(String methodName, int paramCount) {
            StringBuffer buf = new StringBuffer(32);
            buf.append(methodName.toLowerCase());
            buf.append(" [");
            buf.append(paramCount);
            buf.append("]");
            return buf.toString();
        }

        private void initShellMethods() {
            TreeMap<String, List<Method>> result = new TreeMap<String, List<Method>>();
            Method[] methods = this.m_object.getClass().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (methods[i].getDeclaringClass() != this.m_object.getClass() || methods[i].getModifiers() != 1) continue;
                boolean onlyPrimitive = true;
                Class<?>[] clazz = methods[i].getParameterTypes();
                for (int j = 0; j < clazz.length; ++j) {
                    if (CmsDataTypeUtil.isParseable(clazz[j])) continue;
                    onlyPrimitive = false;
                    break;
                }
                if (!onlyPrimitive) continue;
                String lookup = this.buildMethodLookup(methods[i].getName(), methods[i].getParameterTypes().length);
                ArrayList<Method> l = result.containsKey(lookup) ? (ArrayList<Method>)result.get(lookup) : new ArrayList<Method>(1);
                l.add(methods[i]);
                result.put(lookup, l);
            }
            this.m_methods = result;
        }
    }
}

