/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gwt.user.client.rpc.core.java.util.LinkedHashMap_CustomFieldSerializer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.logging.Log;
import org.apache.logging.log4j.CloseableThreadContext;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.opencms.ade.configuration.CmsADEManager;
import org.opencms.ade.containerpage.CmsContainerpageService;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.configuration.CmsConfigurationManager;
import org.opencms.configuration.CmsImportExportConfiguration;
import org.opencms.configuration.CmsModuleConfiguration;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.configuration.CmsSchedulerConfiguration;
import org.opencms.configuration.CmsSearchConfiguration;
import org.opencms.configuration.CmsSitesConfiguration;
import org.opencms.configuration.CmsSystemConfiguration;
import org.opencms.configuration.CmsVariablesConfiguration;
import org.opencms.configuration.CmsVfsConfiguration;
import org.opencms.configuration.CmsWorkplaceConfiguration;
import org.opencms.configuration.I_CmsNeedsAdminCmsObject;
import org.opencms.crypto.I_CmsTextEncryption;
import org.opencms.db.CmsAliasManager;
import org.opencms.db.CmsDbEntryNotFoundException;
import org.opencms.db.CmsDefaultUsers;
import org.opencms.db.CmsExportPoint;
import org.opencms.db.CmsLoginManager;
import org.opencms.db.CmsSecurityManager;
import org.opencms.db.CmsSqlManager;
import org.opencms.db.CmsSubscriptionManager;
import org.opencms.db.timing.CmsDefaultProfilingHandler;
import org.opencms.db.timing.CmsThreadStatsTreeProfilingHandler;
import org.opencms.db.timing.I_CmsProfilingHandler;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.flex.CmsFlexCache;
import org.opencms.flex.CmsFlexCacheConfiguration;
import org.opencms.flex.CmsFlexController;
import org.opencms.gwt.CmsGwtService;
import org.opencms.gwt.CmsGwtServiceContext;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsI18nInfo;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.i18n.CmsSingleTreeLocaleHandler;
import org.opencms.i18n.CmsVfsBundleManager;
import org.opencms.importexport.CmsImportExportManager;
import org.opencms.json.JSONObject;
import org.opencms.jsp.jsonpart.CmsJsonPartFilter;
import org.opencms.jsp.userdata.CmsUserDataRequestManager;
import org.opencms.letsencrypt.CmsLetsEncryptConfiguration;
import org.opencms.loader.CmsResourceManager;
import org.opencms.loader.CmsTemplateContextManager;
import org.opencms.loader.I_CmsFlexCacheEnabledLoader;
import org.opencms.loader.I_CmsResourceLoader;
import org.opencms.lock.CmsLockManager;
import org.opencms.main.CmsContextInfo;
import org.opencms.main.CmsEventManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsHttpAuthenticationSettings;
import org.opencms.main.CmsInitException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsResourceInitException;
import org.opencms.main.CmsServletContainerSettings;
import org.opencms.main.CmsSessionInfo;
import org.opencms.main.CmsSessionManager;
import org.opencms.main.CmsSystemInfo;
import org.opencms.main.CmsThreadStore;
import org.opencms.main.CmsUIServlet;
import org.opencms.main.I_CmsRequestHandler;
import org.opencms.main.I_CmsResourceInit;
import org.opencms.main.I_CmsSessionStorageProvider;
import org.opencms.main.I_CmsStartStopHandler;
import org.opencms.main.Messages;
import org.opencms.main.OpenCms;
import org.opencms.main.OpenCmsServlet;
import org.opencms.module.CmsModuleManager;
import org.opencms.monitor.CmsMemoryMonitor;
import org.opencms.monitor.CmsMemoryMonitorConfiguration;
import org.opencms.mx.CmsDiagnosticsMXBean;
import org.opencms.publish.CmsPublishEngine;
import org.opencms.publish.CmsPublishManager;
import org.opencms.repository.CmsRepositoryManager;
import org.opencms.rmi.CmsRemoteShellServer;
import org.opencms.scheduler.CmsScheduleManager;
import org.opencms.search.CmsSearchManager;
import org.opencms.security.CmsOrgUnitManager;
import org.opencms.security.CmsPersistentLoginTokenHandler;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleManager;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.security.CmsSecurityException;
import org.opencms.security.I_CmsAuthorizationHandler;
import org.opencms.security.I_CmsCredentialsResolver;
import org.opencms.security.I_CmsPasswordHandler;
import org.opencms.security.I_CmsValidationHandler;
import org.opencms.site.CmsSite;
import org.opencms.site.CmsSiteManagerImpl;
import org.opencms.site.CmsSiteMatcher;
import org.opencms.staticexport.CmsDefaultLinkSubstitutionHandler;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.staticexport.CmsStaticExportManager;
import org.opencms.ugc.CmsUgcSessionFactory;
import org.opencms.ui.apps.CmsWorkplaceAppManager;
import org.opencms.ui.dialogs.CmsPublishScheduledDialog;
import org.opencms.ui.error.CmsErrorUI;
import org.opencms.ui.login.CmsLoginHelper;
import org.opencms.ui.login.CmsLoginUI;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsTaskWatcher;
import org.opencms.util.CmsUUID;
import org.opencms.workflow.CmsDefaultWorkflowManager;
import org.opencms.workflow.I_CmsWorkflowManager;
import org.opencms.workplace.CmsWorkplaceManager;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.xml.CmsXmlContentTypeManager;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.xml2json.I_CmsApiAuthorizationHandler;

public final class OpenCmsCore {
    public static final String PARAM_FORCE_ABSOLUTE_LINKS = "__forceAbsoluteLinks";
    static final Log LOG = CmsLog.getLog(OpenCmsCore.class);
    private static final Object LOCK = new Object();
    private static CmsMessageContainer m_errorCondition;
    private static OpenCmsCore m_instance;
    private CmsADEManager m_adeManager;
    private CmsAliasManager m_aliasManager;
    private Map<String, I_CmsApiAuthorizationHandler> m_apiAuthorizations;
    private I_CmsAuthorizationHandler m_authorizationHandler;
    private CmsObject m_configAdminCms;
    private CmsConfigurationManager m_configurationManager;
    private I_CmsCredentialsResolver m_credentialsResolver;
    private List<String> m_defaultFiles;
    private CmsDefaultUsers m_defaultUsers;
    private CmsEventManager m_eventManager;
    private ScheduledThreadPoolExecutor m_executor;
    private Set<CmsExportPoint> m_exportPoints;
    private CmsFlexCache m_flexCache;
    private Map<String, CmsGwtServiceContext> m_gwtServiceContexts;
    private CmsImportExportManager m_importExportManager;
    private CmsLetsEncryptConfiguration m_letsEncryptConfig;
    private CmsLinkManager m_linkManager;
    private CmsLocaleManager m_localeManager;
    private CmsLoginManager m_loginManager;
    private CmsMemoryMonitor m_memoryMonitor;
    private CmsModuleManager m_moduleManager;
    private CmsOrgUnitManager m_orgUnitManager;
    private I_CmsPasswordHandler m_passwordHandler;
    private CmsPublishEngine m_publishEngine;
    private CmsPublishManager m_publishManager;
    private CmsRemoteShellServer m_remoteShellServer;
    private CmsRepositoryManager m_repositoryManager;
    private Map<String, I_CmsRequestHandler> m_requestHandlers;
    private List<I_CmsResourceInit> m_resourceInitHandlers;
    private CmsResourceManager m_resourceManager;
    private CmsRoleManager m_roleManager;
    private int m_runLevel;
    private Map<Object, Object> m_runtimeProperties;
    private CmsScheduleManager m_scheduleManager;
    private CmsSearchManager m_searchManager;
    private CmsSecurityManager m_securityManager;
    private CmsSessionManager m_sessionManager;
    private CmsSiteManagerImpl m_siteManager;
    private List<I_CmsStartStopHandler> m_startStopHandlers = new ArrayList<I_CmsStartStopHandler>();
    private CmsStaticExportManager m_staticExportManager;
    private CmsSubscriptionManager m_subscriptionManager;
    private CmsSystemInfo m_systemInfo;
    private CmsTemplateContextManager m_templateContextManager;
    private LinkedHashMap m_textEncryptions;
    private CmsThreadStore m_threadStore;
    private CmsUserDataRequestManager m_userDataRequestManager;
    private I_CmsValidationHandler m_validationHandler;
    private CmsVfsBundleManager m_vfsBundleManager;
    private I_CmsWorkflowManager m_workflowManager;
    private CmsWorkplaceAppManager m_workplaceAppManager;
    private CmsWorkplaceManager m_workplaceManager;
    private CmsXmlContentTypeManager m_xmlContentTypeManager;

    private OpenCmsCore() throws CmsInitException {
        if (m_instance != null && m_instance.getRunLevel() > 0) {
            throw new CmsInitException(Messages.get().container("ERR_ALREADY_INITIALIZED_0"));
        }
        this.initMembers();
        m_instance = this;
        this.setRunLevel(1);
    }

    public static String getPathInfo(HttpServletRequest req) {
        int pos;
        String requestErrorPageAttribute;
        String path = req.getPathInfo();
        if (path == null && (requestErrorPageAttribute = OpenCms.getSystemInfo().getServletContainerSettings().getRequestErrorPageAttribute()) != null && (path = (String)req.getAttribute(requestErrorPageAttribute)) != null && (pos = path.indexOf("/", 1)) > 0) {
            path = path.substring(pos);
        }
        if (path == null) {
            path = "/";
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static OpenCmsCore getInstance() {
        if (m_errorCondition != null) {
            throw new CmsInitException(m_errorCondition, false);
        }
        if (m_instance != null) {
            return m_instance;
        }
        Object object = LOCK;
        synchronized (object) {
            if (m_instance == null) {
                try {
                    m_instance = new OpenCmsCore();
                }
                catch (CmsInitException e) {
                    LOG.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return m_instance;
    }

    protected static void setErrorCondition(CmsMessageContainer errorCondition) {
        if (m_instance != null && m_instance.getRunLevel() < 3) {
            if (!"ERR_CRITICAL_INIT_WIZARD_0".equals(errorCondition.getKey())) {
                m_errorCondition = errorCondition;
                System.err.println(Messages.get().getBundle().key("LOG_INIT_FAILURE_MESSAGE_1", errorCondition.key()));
            }
            LOG.error((Object)errorCondition.key(), (Throwable)new CmsException(errorCondition));
            m_instance = null;
        } else if (m_instance != null) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_INIT_INVALID_ERROR_2", new Integer(m_instance.getRunLevel()), errorCondition.key()));
        }
    }

    public String getFlexCacheKeyDump() {
        if (this.m_flexCache != null) {
            StringBuffer buffer = new StringBuffer();
            this.m_flexCache.dumpKeys(buffer);
            return buffer.toString();
        }
        return null;
    }

    public CmsLetsEncryptConfiguration getLetsEncryptConfig() {
        return this.m_letsEncryptConfig;
    }

    public void invokeBuiltinService(String remainingPath, HttpServletRequest req, HttpServletResponse res) throws ServletException {
        try {
            CmsObject cms = this.initCmsObject(req, res);
            if ("/unlockPage".equals(remainingPath)) {
                CmsContainerpageService.unlockPage(cms, req, res);
            } else if ("/updateSession".equals(remainingPath)) {
                boolean isHeartbeatRequest = true;
                OpenCms.getSessionManager().updateSessionInfo(cms, req, isHeartbeatRequest);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected void addRequestHandler(I_CmsRequestHandler handler) {
        if (handler == null) {
            return;
        }
        String[] names = handler.getHandlerNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (this.m_requestHandlers.get(name) != null) {
                CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_DUPLICATE_REQUEST_HANDLER_1", name));
                continue;
            }
            this.m_requestHandlers.put(name, handler);
            if (!CmsLog.INIT.isInfoEnabled()) continue;
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADDED_REQUEST_HANDLER_2", name, handler.getClass().getName()));
        }
    }

    protected CmsADEManager getADEManager() {
        if (!this.m_adeManager.isInitialized()) {
            this.m_adeManager.initialize();
        }
        return this.m_adeManager;
    }

    protected CmsAliasManager getAliasManager() {
        return this.m_aliasManager;
    }

    protected I_CmsApiAuthorizationHandler getApiAuthorization(String name) {
        return this.m_apiAuthorizations.get(name);
    }

    protected I_CmsAuthorizationHandler getAuthorizationHandler() {
        return this.m_authorizationHandler;
    }

    protected CmsConfigurationManager getConfigurationManager() {
        return this.m_configurationManager;
    }

    protected I_CmsCredentialsResolver getCredentialsResolver() {
        if (this.m_credentialsResolver == null) {
            CmsSystemConfiguration systemConfig = (CmsSystemConfiguration)this.m_configurationManager.getConfiguration(CmsSystemConfiguration.class);
            return systemConfig.getCredentialsResolver();
        }
        return this.m_credentialsResolver;
    }

    protected List<String> getDbPoolNames() {
        return new ArrayList<String>(this.m_configurationManager.getConfiguration().getList("db.pools"));
    }

    protected List<String> getDefaultFiles() {
        return this.m_defaultFiles;
    }

    protected CmsDefaultUsers getDefaultUsers() {
        return this.m_defaultUsers;
    }

    protected CmsEventManager getEventManager() {
        return this.m_eventManager;
    }

    protected ScheduledThreadPoolExecutor getExecutor() {
        return this.m_executor;
    }

    protected Set<CmsExportPoint> getExportPoints() {
        return this.m_exportPoints;
    }

    protected CmsFlexCache getFlexCache() {
        return this.m_flexCache;
    }

    protected CmsImportExportManager getImportExportManager() {
        return this.m_importExportManager;
    }

    protected CmsLinkManager getLinkManager() {
        return this.m_linkManager;
    }

    protected CmsLocaleManager getLocaleManager() {
        return this.m_localeManager;
    }

    protected CmsLockManager getLockManager() {
        return this.m_securityManager.getLockManager();
    }

    protected CmsLoginManager getLoginManager() {
        return this.m_loginManager;
    }

    protected CmsMemoryMonitor getMemoryMonitor() {
        return this.m_memoryMonitor;
    }

    protected CmsModuleManager getModuleManager() {
        return this.m_moduleManager;
    }

    protected CmsOrgUnitManager getOrgUnitManager() {
        return this.m_orgUnitManager;
    }

    protected I_CmsPasswordHandler getPasswordHandler() {
        return this.m_passwordHandler;
    }

    protected CmsPublishManager getPublishManager() {
        return this.m_publishManager;
    }

    protected CmsRepositoryManager getRepositoryManager() {
        return this.m_repositoryManager;
    }

    protected I_CmsRequestHandler getRequestHandler(String name) {
        return this.m_requestHandlers.get(name);
    }

    protected CmsResourceManager getResourceManager() {
        return this.m_resourceManager;
    }

    protected CmsRoleManager getRoleManager() {
        return this.m_roleManager;
    }

    protected int getRunLevel() {
        return this.m_runLevel;
    }

    protected Object getRuntimeProperty(Object key) {
        return this.m_runtimeProperties.get(key);
    }

    protected CmsScheduleManager getScheduleManager() {
        return this.m_scheduleManager;
    }

    protected CmsSearchManager getSearchManager() {
        return this.m_searchManager;
    }

    protected CmsSecurityManager getSecurityManager() {
        return this.m_securityManager;
    }

    protected CmsSessionManager getSessionManager() {
        return this.m_sessionManager;
    }

    protected CmsSiteManagerImpl getSiteManager() {
        return this.m_siteManager;
    }

    protected CmsSqlManager getSqlManager() {
        return this.m_securityManager.getSqlManager();
    }

    protected CmsStaticExportManager getStaticExportManager() {
        return this.m_staticExportManager;
    }

    protected CmsSubscriptionManager getSubscriptionManager() {
        return this.m_subscriptionManager;
    }

    protected CmsSystemInfo getSystemInfo() {
        return this.m_systemInfo;
    }

    protected CmsTemplateContextManager getTemplateContextManager() {
        return this.m_templateContextManager;
    }

    protected Map<String, I_CmsTextEncryption> getTextEncryptions() {
        return this.m_textEncryptions;
    }

    protected CmsThreadStore getThreadStore() {
        return this.m_threadStore;
    }

    protected CmsUserDataRequestManager getUserDataRequestManager() {
        return this.m_userDataRequestManager;
    }

    protected I_CmsValidationHandler getValidationHandler() {
        return this.m_validationHandler;
    }

    protected I_CmsWorkflowManager getWorkflowManager() {
        return this.m_workflowManager;
    }

    protected CmsWorkplaceAppManager getWorkplaceAppManager() {
        return this.m_workplaceAppManager;
    }

    protected CmsWorkplaceManager getWorkplaceManager() {
        return this.m_workplaceManager;
    }

    protected CmsXmlContentTypeManager getXmlContentTypeManager() {
        if (this.m_xmlContentTypeManager != null) {
            return this.m_xmlContentTypeManager;
        }
        if (this.getRunLevel() == 1) {
            this.m_xmlContentTypeManager = CmsXmlContentTypeManager.createTypeManagerForTestCases();
        }
        return this.m_xmlContentTypeManager;
    }

    protected void initCmsContextForUI(HttpServletRequest req, HttpServletResponse res, CmsUIServlet servlet) throws IOException, CmsException {
        String originalEncoding = req.getCharacterEncoding();
        String referrer = req.getHeader("referer");
        boolean allowPrivilegedLogin = referrer == null || !referrer.contains("/system/login");
        CmsObject cms = this.initCmsObject(req, res, allowPrivilegedLogin);
        servlet.setCms(cms);
        if (originalEncoding != null) {
            req.setCharacterEncoding(originalEncoding);
        }
    }

    protected CmsObject initCmsObject(CmsObject cms) {
        CmsRequestContext requestContext = cms.getRequestContext();
        CmsRequestContext context = new CmsRequestContext(requestContext.getCurrentUser().clone(), (CmsProject)requestContext.getCurrentProject().clone(), requestContext.getUri(), requestContext.getRequestMatcher(), requestContext.getSiteRoot(), requestContext.isSecureRequest(), requestContext.getLocale(), requestContext.getEncoding(), requestContext.getRemoteAddress(), System.currentTimeMillis(), this.m_resourceManager.getFolderTranslator(), this.m_resourceManager.getFileTranslator(), requestContext.getOuFqn(), requestContext.isForceAbsoluteLinks());
        context.setDetailResource(requestContext.getDetailResource());
        CmsObject result = new CmsObject(this.m_securityManager, context);
        return result;
    }

    protected CmsObject initCmsObject(CmsObject adminCms, CmsContextInfo contextInfo) throws CmsRoleViolationException, CmsException {
        String userName = contextInfo.getUserName();
        if (!(adminCms != null && this.m_roleManager.hasRole(adminCms, CmsRole.ROOT_ADMIN) || userName.endsWith(this.getDefaultUsers().getUserGuest()) || userName.endsWith(this.getDefaultUsers().getUserExport()))) {
            CmsMessageContainer message = Messages.get().container("ERR_INVALID_INIT_USER_2", userName, adminCms != null ? adminCms.getRequestContext().getCurrentUser().getName() : "");
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)message.key());
            }
            throw new CmsRoleViolationException(message);
        }
        return this.initCmsObject(contextInfo);
    }

    protected CmsObject initCmsObject(HttpServletRequest req, HttpServletResponse res, boolean allowPrivilegedLogin) throws IOException, CmsException {
        CmsObject cms = this.initCmsObjectFromSession(req);
        if (cms != null) {
            return cms;
        }
        if (allowPrivilegedLogin) {
            I_CmsAuthorizationHandler.I_PrivilegedLoginAction loginAction = new I_CmsAuthorizationHandler.I_PrivilegedLoginAction(){
                private CmsObject m_adminCms;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public CmsObject doLogin(HttpServletRequest request, String principal) throws CmsException {
                    try {
                        CmsUser user = this.m_adminCms.readUser(principal);
                        if (!user.isEnabled()) {
                            throw new CmsException(Messages.get().container("ERR_INVALID_INIT_USER_2", user.getName(), "-"));
                        }
                        CmsContextInfo contextInfo = new CmsContextInfo(this.m_adminCms.getRequestContext());
                        contextInfo.setUserName(principal);
                        CmsObject newCms = OpenCmsCore.this.initCmsObject(this.m_adminCms, contextInfo);
                        if ((contextInfo.getRequestedUri().startsWith("/system/workplace/") || request.getRequestURI().startsWith(OpenCms.getSystemInfo().getWorkplaceContext())) && OpenCmsCore.this.getRoleManager().hasRole(newCms, CmsRole.ELEMENT_AUTHOR)) {
                            LOG.debug((Object)("Handling workplace login for user " + principal));
                            CmsWorkplaceSettings settings = CmsLoginHelper.initSiteAndProject(newCms);
                            request.getSession(true).setAttribute("__CmsWorkplace.WORKPLACE_SETTINGS", (Object)settings);
                            OpenCms.getSessionManager().updateSessionInfo(newCms, request);
                        }
                        this.m_adminCms.updateLastLoginDate(user);
                        OpenCms.fireCmsEvent(1, Collections.singletonMap("data", user));
                        CmsObject cmsObject = newCms;
                        return cmsObject;
                    }
                    finally {
                        this.m_adminCms = null;
                    }
                }

                @Override
                public CmsObject getCmsObject() {
                    return this.m_adminCms;
                }

                @Override
                public void setCmsObject(CmsObject adminCms) {
                    this.m_adminCms = adminCms;
                }
            };
            loginAction.setCmsObject(this.initCmsObject(req, res, OpenCms.getDefaultUsers().getUserAdmin(), null, null));
            cms = this.m_authorizationHandler.initCmsObject(req, loginAction);
            if (cms != null) {
                return cms;
            }
            this.m_authorizationHandler.requestAuthorization(req, res, this.getLoginFormURL(req, res));
        }
        cms = this.initCmsObject(req, this.m_securityManager.readUser(null, OpenCms.getDefaultUsers().getUserGuest()), this.getSiteManager().matchRequest(req).getSiteRoot(), CmsProject.ONLINE_PROJECT_ID, "");
        return cms;
    }

    protected CmsObject initCmsObject(String user) throws CmsException {
        return this.initCmsObject(null, new CmsContextInfo(user));
    }

    protected CmsObject initCmsObjectFromSession(HttpServletRequest req) throws CmsException {
        CmsSessionInfo sessionInfo;
        String url = req.getRequestURL().toString();
        String p = "[ " + url + " ] ";
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(p + "Trying to init cms object from session for request \"" + req.toString() + "\"."));
        }
        if ((sessionInfo = this.m_sessionManager.getSessionInfo(req)) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(p + "No session info found."));
            }
            return null;
        }
        if (!this.getSessionManager().hasValidClientToken(req)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Client token in session invalid.");
            }
            return null;
        }
        CmsSite site = this.getSiteManager().matchRequest(req);
        CmsUUID project = sessionInfo.getProject();
        String siteroot = sessionInfo.getSiteRoot();
        if (siteroot == null) {
            LOG.debug((Object)(p + "site root from session info was null, determining site root from current request's host"));
            siteroot = site.getSiteRoot();
        }
        CmsUser user = this.m_securityManager.readUser(null, sessionInfo.getUserId());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(p + "Initializing cms object with user \"" + user.getName() + "\"."));
            LOG.debug((Object)(p + "siteRoot = " + siteroot));
        }
        return this.initCmsObject(req, user, siteroot, project, sessionInfo.getOrganizationalUnitFqn());
    }

    protected synchronized void initConfiguration(CmsParameterConfiguration configuration) throws CmsInitException {
        CmsObject adminCms;
        CmsFlexCache flexCache;
        CmsVariablesConfiguration variablesConfiguration;
        CmsSystemConfiguration systemConfiguration;
        block43: {
            String serverInfo = configuration.getString("context.servlet.container", null);
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DOT_0"));
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DOT_0"));
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DOT_0"));
                CmsLog.INIT.info((Object)(". " + Messages.get().getBundle().key("GUI_SHELL_VERSION_1", OpenCms.getSystemInfo().getVersionNumber())));
                for (int i = 0; i < Messages.COPYRIGHT_BY_ALKACON.length; ++i) {
                    CmsLog.INIT.info((Object)(". " + Messages.COPYRIGHT_BY_ALKACON[i]));
                }
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_LINE_0"));
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_STARTUP_TIME_1", new Date(System.currentTimeMillis())));
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_OPENCMS_VERSION_1", OpenCms.getSystemInfo().getVersionNumber() + " [" + OpenCms.getSystemInfo().getVersionId() + "]"));
                if (serverInfo != null) {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SERVLET_CONTAINER_1", serverInfo));
                }
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_WEBAPP_NAME_1", this.getSystemInfo().getWebApplicationName()));
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SERVLET_PATH_1", this.getSystemInfo().getServletPath()));
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_OPENCMS_CONTEXT_1", this.getSystemInfo().getOpenCmsContext()));
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_WEBINF_PATH_1", this.getSystemInfo().getWebInfRfsPath()));
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_PROPERTY_FILE_1", this.getSystemInfo().getConfigurationFileRfsPath()));
                String logFileRfsPath = this.getSystemInfo().getLogFileRfsPath();
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_LOG_FILE_1", logFileRfsPath != null ? logFileRfsPath : "Managed by log4j"));
            }
            String systemEncoding = null;
            try {
                systemEncoding = System.getProperty("file.encoding");
            }
            catch (SecurityException se) {
                LOG.debug((Object)"Security manager preventing access to file.encoding system property.", (Throwable)se);
            }
            try {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            catch (Exception e) {
                CmsLog.INIT.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_FILE_ENCODING_1", systemEncoding));
            }
            String ethernetAddress = configuration.getString("server.ethernet.address", CmsStringUtil.getEthernetAddress());
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ETHERNET_ADDRESS_1", ethernetAddress));
            }
            CmsUUID.init(ethernetAddress);
            String serverName = configuration.getString("server.name", "OpenCmsServer");
            this.getSystemInfo().setServerName(serverName);
            try {
                if (CmsLog.INIT.isInfoEnabled()) {
                    String jdkinfo = System.getProperty("java.vm.name") + " ";
                    jdkinfo = jdkinfo + System.getProperty("java.vm.version") + " ";
                    jdkinfo = jdkinfo + System.getProperty("java.vm.info") + " ";
                    jdkinfo = jdkinfo + System.getProperty("java.vm.vendor") + " ";
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_JAVA_VM_1", jdkinfo));
                    String osinfo = System.getProperty("os.name") + " ";
                    osinfo = osinfo + System.getProperty("os.version") + " ";
                    osinfo = osinfo + System.getProperty("os.arch") + " ";
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_OPERATING_SYSTEM_1", osinfo));
                }
            }
            catch (Exception e) {
                throw new CmsInitException(Messages.get().container("ERR_CRITICAL_INIT_PROP_0"), (Throwable)e);
            }
            this.m_configurationManager = new CmsConfigurationManager(this.getSystemInfo().getConfigFolder());
            this.m_configurationManager.setConfiguration(configuration);
            try {
                this.m_configurationManager.loadXmlConfiguration();
            }
            catch (Exception e) {
                throw new CmsInitException(Messages.get().container("ERR_CRITICAL_INIT_XML_0"), (Throwable)e);
            }
            systemConfiguration = (CmsSystemConfiguration)this.m_configurationManager.getConfiguration(CmsSystemConfiguration.class);
            if (systemConfiguration.useSaxImplSystemProperties()) {
                CmsXmlUtils.initSystemProperties();
            }
            CmsMemoryMonitorConfiguration memoryMonitorConfiguration = systemConfiguration.getCmsMemoryMonitorConfiguration();
            try {
                this.m_memoryMonitor = CmsStringUtil.isNotEmptyOrWhitespaceOnly(memoryMonitorConfiguration.getClassName()) ? (CmsMemoryMonitor)Class.forName(memoryMonitorConfiguration.getClassName()).newInstance() : new CmsMemoryMonitor();
            }
            catch (Exception e) {
                throw new CmsInitException(Messages.get().container("ERR_CRITICAL_INIT_MEMORY_MONITOR_1", memoryMonitorConfiguration.getClassName()), (Throwable)e);
            }
            this.m_memoryMonitor.initialize(systemConfiguration);
            CmsEventManager configuredEventManager = systemConfiguration.getEventManager();
            configuredEventManager.initialize(this.m_eventManager);
            this.m_eventManager = configuredEventManager;
            String setEncoding = systemConfiguration.getDefaultContentEncoding();
            String defaultEncoding = CmsEncoder.lookupEncoding(setEncoding, null);
            if (defaultEncoding == null) {
                throw new CmsInitException(Messages.get().container("ERR_CRITICAL_INIT_ENCODING_1", setEncoding));
            }
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_OPENCMS_ENCODING_1", defaultEncoding));
            }
            this.getSystemInfo().setDefaultEncoding(defaultEncoding);
            this.getSystemInfo().setVersionHistorySettings(systemConfiguration.isHistoryEnabled(), systemConfiguration.getHistoryVersions(), systemConfiguration.getHistoryVersionsAfterDeletion());
            this.getSystemInfo().setMailSettings(systemConfiguration.getMailSettings());
            this.getSystemInfo().setHttpAuthenticationSettings(systemConfiguration.getHttpAuthenticationSettings());
            this.getSystemInfo().setRestrictDetailContents(systemConfiguration.isRestrictDetailContents());
            this.getSystemInfo().setNotificationTime(systemConfiguration.getNotificationTime());
            this.getSystemInfo().setNotificationProject(systemConfiguration.getNotificationProject());
            this.m_executor = new ScheduledThreadPoolExecutor(3, new ThreadFactoryBuilder().setNameFormat("OpenCmsCore-exec-%d").build());
            this.m_resourceInitHandlers = systemConfiguration.getResourceInitHandlers();
            for (I_CmsRequestHandler handler : systemConfiguration.getRequestHandlers()) {
                this.addRequestHandler(handler);
                if (!CmsLog.INIT.isInfoEnabled()) continue;
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_REQUEST_HANDLER_CLASS_1", handler.getClass().getName()));
            }
            this.m_defaultUsers = systemConfiguration.getCmsDefaultUsers();
            CmsSitesConfiguration sitesConfiguration = (CmsSitesConfiguration)this.m_configurationManager.getConfiguration(CmsSitesConfiguration.class);
            this.m_siteManager = sitesConfiguration.getSiteManager();
            CmsSchedulerConfiguration schedulerConfiguration = (CmsSchedulerConfiguration)this.m_configurationManager.getConfiguration(CmsSchedulerConfiguration.class);
            this.m_scheduleManager = schedulerConfiguration.getScheduleManager();
            variablesConfiguration = (CmsVariablesConfiguration)this.m_configurationManager.getConfiguration(CmsVariablesConfiguration.class);
            CmsVfsConfiguration vfsConfiguation = (CmsVfsConfiguration)this.m_configurationManager.getConfiguration(CmsVfsConfiguration.class);
            this.m_resourceManager = vfsConfiguation.getResourceManager();
            this.m_xmlContentTypeManager = vfsConfiguation.getXmlContentTypeManager();
            this.m_defaultFiles = vfsConfiguation.getDefaultFiles();
            this.m_resourceManager.setTranslators(vfsConfiguation.getFolderTranslator(), vfsConfiguation.getFileTranslator(), vfsConfiguation.getXsdTranslator());
            flexCache = null;
            try {
                if (CmsLog.INIT.isInfoEnabled()) {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_FLEX_CACHE_STARTING_0"));
                }
                CmsFlexCacheConfiguration flexCacheConfiguration = systemConfiguration.getCmsFlexCacheConfiguration();
                this.getSystemInfo().setDeviceSelector(flexCacheConfiguration.getDeviceSelector());
                this.m_flexCache = flexCache = new CmsFlexCache(flexCacheConfiguration);
                if (CmsLog.INIT.isInfoEnabled()) {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_FLEX_CACHE_FINISHED_0"));
                }
            }
            catch (Exception e) {
                if (!CmsLog.INIT.isWarnEnabled()) break block43;
                CmsLog.INIT.warn((Object)Messages.get().getBundle().key("INIT_FLEX_CACHE_ERROR_1", e.getMessage()));
            }
        }
        if (flexCache != null) {
            for (I_CmsResourceLoader o : this.m_resourceManager.getLoaders()) {
                if (!(o instanceof I_CmsFlexCacheEnabledLoader)) continue;
                ((I_CmsFlexCacheEnabledLoader)((Object)o)).setFlexCache(flexCache);
            }
        }
        CmsImportExportConfiguration importExportConfiguration = (CmsImportExportConfiguration)this.m_configurationManager.getConfiguration(CmsImportExportConfiguration.class);
        this.m_importExportManager = importExportConfiguration.getImportExportManager();
        this.m_staticExportManager = importExportConfiguration.getStaticExportManager();
        this.m_repositoryManager = importExportConfiguration.getRepositoryManager();
        CmsSearchConfiguration searchConfiguration = (CmsSearchConfiguration)this.m_configurationManager.getConfiguration(CmsSearchConfiguration.class);
        this.m_searchManager = searchConfiguration.getSearchManager();
        CmsWorkplaceConfiguration workplaceConfiguration = (CmsWorkplaceConfiguration)this.m_configurationManager.getConfiguration(CmsWorkplaceConfiguration.class);
        this.m_workplaceManager = workplaceConfiguration.getWorkplaceManager();
        this.addExportPoints(this.m_workplaceManager.getExportPoints());
        this.addExportPoints(this.m_staticExportManager.getExportPoints());
        CmsModuleConfiguration moduleConfiguration = (CmsModuleConfiguration)this.m_configurationManager.getConfiguration(CmsModuleConfiguration.class);
        this.m_moduleManager = moduleConfiguration.getModuleManager();
        this.m_passwordHandler = systemConfiguration.getPasswordHandler();
        this.m_validationHandler = systemConfiguration.getValidationHandler();
        this.m_authorizationHandler = systemConfiguration.getAuthorizationHandler();
        this.m_loginManager = systemConfiguration.getLoginManager();
        try {
            this.m_loginManager.setLoginMessage(null, variablesConfiguration.getLoginMessage());
            this.m_loginManager.setBeforeLoginMessage(null, variablesConfiguration.getBeforeLoginMessage());
        }
        catch (CmsRoleViolationException e1) {
            CmsLog.INIT.error((Object)e1.getLocalizedMessage(), (Throwable)e1);
        }
        this.m_publishEngine = new CmsPublishEngine(systemConfiguration.getRuntimeInfoFactory());
        this.m_credentialsResolver = systemConfiguration.getCredentialsResolver();
        this.m_securityManager = CmsSecurityManager.newInstance(this.m_configurationManager, systemConfiguration.getRuntimeInfoFactory(), this.m_publishEngine);
        this.m_publishManager = systemConfiguration.getPublishManager();
        this.m_subscriptionManager = systemConfiguration.getSubscriptionManager();
        this.m_roleManager = new CmsRoleManager(this.m_securityManager);
        this.m_orgUnitManager = new CmsOrgUnitManager(this.m_securityManager);
        this.m_threadStore = new CmsThreadStore(this.m_securityManager);
        this.m_linkManager = new CmsLinkManager(this.m_staticExportManager.getLinkSubstitutionHandler());
        this.m_aliasManager = new CmsAliasManager(this.m_securityManager);
        this.m_runtimeProperties.putAll(systemConfiguration.getRuntimeProperties());
        I_CmsSessionStorageProvider sessionStorageProvider = systemConfiguration.getSessionStorageProvider();
        try {
            adminCms = this.initCmsObject(null, null, this.getDefaultUsers().getUserAdmin(), (String)null, (String)null);
        }
        catch (CmsException e) {
            throw new CmsInitException(Messages.get().container("ERR_CRITICAL_INIT_ADMINCMS_0"), (Throwable)e);
        }
        this.m_configAdminCms = adminCms;
        this.m_repositoryManager.initializeCms(adminCms);
        try {
            if (flexCache != null) {
                flexCache.initializeCms(this.initCmsObject(adminCms));
            }
            this.m_configurationManager.setAdminCms(adminCms);
            this.m_scheduleManager.initialize(this.initCmsObject(adminCms));
            this.m_localeManager = systemConfiguration.getLocaleManager();
            this.m_localeManager.initialize(this.initCmsObject(adminCms));
            this.m_siteManager.initialize(this.initCmsObject(adminCms));
            this.m_staticExportManager.initialize(this.initCmsObject(adminCms));
            this.m_xmlContentTypeManager.initialize(this.initCmsObject(adminCms));
            this.m_orgUnitManager.initialize(this.initCmsObject(adminCms));
            this.m_moduleManager.initialize(this.initCmsObject(adminCms), this.m_configurationManager);
            this.m_resourceManager.initialize(this.initCmsObject(adminCms));
            this.m_publishManager.setPublishEngine(this.m_publishEngine);
            this.m_publishManager.setSecurityManager(this.m_securityManager);
            this.m_publishManager.setPublishListRemoveMode(systemConfiguration.getPublishListRemoveMode());
            this.m_publishManager.initialize(this.initCmsObject(adminCms));
            this.m_searchManager.initialize(this.initCmsObject(adminCms));
            this.m_vfsBundleManager = new CmsVfsBundleManager(adminCms);
            this.m_workplaceManager.initialize(this.initCmsObject(adminCms));
            this.m_sessionManager.initialize(sessionStorageProvider, this.initCmsObject(adminCms));
            this.m_sessionManager.setUserSessionMode(systemConfiguration.getUserSessionMode(true));
            this.m_subscriptionManager.setSecurityManager(this.m_securityManager);
            this.m_subscriptionManager.initialize(adminCms);
            CmsUgcSessionFactory.setAdminCms(adminCms);
            CmsFormatterConfiguration.initialize(adminCms);
            CmsPersistentLoginTokenHandler.setAdminCms(this.initCmsObject(adminCms));
            CmsLoginUI.setAdminCmsObject(this.initCmsObject(adminCms));
            this.m_adeManager = new CmsADEManager(this.initCmsObject(adminCms), this.m_memoryMonitor, systemConfiguration);
            this.m_workplaceAppManager = new CmsWorkplaceAppManager(this.initCmsObject(adminCms));
            this.m_workplaceAppManager.loadApps();
            this.m_workplaceAppManager.initWorkplaceCssUris(this.m_moduleManager);
            this.m_templateContextManager = new CmsTemplateContextManager(this.initCmsObject(adminCms));
            this.m_workflowManager = systemConfiguration.getWorkflowManager();
            this.m_letsEncryptConfig = systemConfiguration.getLetsEncryptConfig();
            this.m_userDataRequestManager = systemConfiguration.getUserDataRequestManager();
            if (this.m_userDataRequestManager != null) {
                this.m_userDataRequestManager.initialize(this.initCmsObject(adminCms));
            }
            if (this.m_workflowManager == null) {
                this.m_workflowManager = new CmsDefaultWorkflowManager();
                this.m_workflowManager.setParameters(new HashMap<String, String>());
            }
            this.m_remoteShellServer = CmsRemoteShellServer.initialize(systemConfiguration);
            CmsPublishScheduledDialog.setAdminCms(this.initCmsObject(adminCms));
            this.m_workflowManager.initialize(this.initCmsObject(adminCms));
            this.m_apiAuthorizations = systemConfiguration.getApiAuthorizations();
            for (I_CmsApiAuthorizationHandler apiAuthorization : this.m_apiAuthorizations.values()) {
                apiAuthorization.initialize(this.initCmsObject(adminCms));
            }
            for (I_CmsResourceInit resourceInit : this.m_resourceInitHandlers) {
                if (!(resourceInit instanceof I_CmsNeedsAdminCmsObject)) continue;
                ((I_CmsNeedsAdminCmsObject)((Object)resourceInit)).setAdminCmsObject(adminCms);
            }
            for (I_CmsRequestHandler requestHandler : this.m_requestHandlers.values()) {
                if (!(requestHandler instanceof I_CmsNeedsAdminCmsObject)) continue;
                ((I_CmsNeedsAdminCmsObject)((Object)requestHandler)).setAdminCmsObject(adminCms);
            }
            this.m_textEncryptions = new LinkedHashMap();
            for (I_CmsTextEncryption encryption : systemConfiguration.getTextEncryptions().values()) {
                encryption.initialize(OpenCms.initCmsObject(adminCms));
                this.m_textEncryptions.put(encryption.getName(), encryption);
            }
        }
        catch (CmsException e) {
            throw new CmsInitException(Messages.get().container("ERR_CRITICAL_INIT_MANAGERS_0"), (Throwable)e);
        }
        try {
            Iterator<Object> e = new StringTemplate();
        }
        catch (Exception e) {
            CmsLog.INIT.error((Object)("Problem with initializing stringtemplate class: " + e.getLocalizedMessage()), (Throwable)e);
        }
        try {
            this.getEventManager().fireEvent(5);
        }
        catch (Exception e) {
            CmsLog.INIT.error((Object)("Problem with clearing caches after initialization: " + e.getLocalizedMessage()), (Throwable)e);
        }
        CmsTaskWatcher.initialize();
    }

    protected synchronized void initContext(ServletContext context) throws CmsInitException {
        CmsParameterConfiguration configuration;
        this.m_gwtServiceContexts = new HashMap<String, CmsGwtServiceContext>();
        CmsServletContainerSettings servletContainerSettings = new CmsServletContainerSettings(context);
        this.getSystemInfo().init(servletContainerSettings);
        try {
            configuration = new CmsParameterConfiguration(this.getSystemInfo().getConfigurationFileRfsPath());
        }
        catch (Exception e) {
            throw new CmsInitException(Messages.get().container("ERR_CRITICAL_INIT_PROPFILE_1", this.getSystemInfo().getConfigurationFileRfsPath()), (Throwable)e);
        }
        String throwException = configuration.getString("servlet.exception.enabled", "auto");
        if (!throwException.equals("auto")) {
            boolean throwExc = Boolean.valueOf(throwException);
            this.getSystemInfo().getServletContainerSettings().setServletThrowsException(throwExc);
        }
        if (configuration.getBoolean("wizard.enabled", true)) {
            throw new CmsInitException(Messages.get().container("ERR_CRITICAL_INIT_WIZARD_0"));
        }
        configuration.add("context.servlet.container", context.getServerInfo());
        System.err.println(Messages.get().getBundle().key("LOG_STARTUP_CONSOLE_NOTE_2", OpenCms.getSystemInfo().getVersionNumber(), this.getSystemInfo().getWebApplicationName()));
        for (int i = 0; i < Messages.COPYRIGHT_BY_ALKACON.length; ++i) {
            System.err.println(Messages.COPYRIGHT_BY_ALKACON[i]);
        }
        System.err.println();
        this.initConfiguration(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initMembers() {
        Object object = LOCK;
        synchronized (object) {
            this.m_resourceInitHandlers = new ArrayList<I_CmsResourceInit>();
            this.m_requestHandlers = new HashMap<String, I_CmsRequestHandler>();
            this.m_systemInfo = new CmsSystemInfo();
            this.m_exportPoints = Collections.emptySet();
            this.m_defaultUsers = new CmsDefaultUsers();
            this.m_localeManager = new CmsLocaleManager(Locale.ENGLISH);
            this.m_sessionManager = new CmsSessionManager();
            this.m_runtimeProperties = new Hashtable<Object, Object>();
            this.m_eventManager = new CmsEventManager();
            this.m_linkManager = new CmsLinkManager(new CmsDefaultLinkSubstitutionHandler());
        }
    }

    protected CmsResource initResource(CmsObject cms, String resourceName, HttpServletRequest req, HttpServletResponse res) throws CmsException {
        CmsResource resource;
        CmsException tmpException = null;
        boolean handledSecure = false;
        try {
            resource = cms.readDefaultFile(resourceName, CmsResourceFilter.ignoreExpirationOffline(cms));
        }
        catch (CmsException e) {
            tmpException = e;
            resource = null;
        }
        if (resource != null) {
            cms.getRequestContext().setUri(cms.getSitePath(resource));
            if (resource.isInternalOrInInternalFolder()) {
                throw new CmsException(Messages.get().container("ERR_READ_INTERNAL_RESOURCE_1", cms.getRequestContext().getUri()));
            }
            if ((resource = this.handleSecureResource(cms, req, res, resource, resourceName)) == null) {
                handledSecure = true;
            }
        }
        boolean clearErrors = false;
        for (I_CmsResourceInit handler : this.m_resourceInitHandlers) {
            try {
                resource = handler.initResource(resource, cms, req, res);
            }
            catch (CmsResourceInitException e) {
                if (!e.isClearErrors()) break;
                tmpException = null;
                clearErrors = true;
                break;
            }
            catch (CmsSecurityException e) {
                tmpException = e;
                break;
            }
        }
        if (resource == null) {
            if (tmpException != null) {
                throw tmpException;
            }
            if (!clearErrors) {
                throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_PATH_NOT_FOUND_1", resourceName));
            }
        } else if (!handledSecure && cms.getRequestContext().getDetailContentId() != null) {
            resource = this.handleSecureResource(cms, req, res, resource, resourceName);
            handledSecure = true;
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initServlet(OpenCmsServlet servlet) {
        Object object = LOCK;
        synchronized (object) {
            this.addRequestHandler(servlet);
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SYSTEM_RUNNING_1", CmsStringUtil.formatRuntime(this.getSystemInfo().getRuntime())));
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_LINE_0"));
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DOT_0"));
            }
        }
    }

    protected void invokeGwtService(String serviceName, HttpServletRequest req, HttpServletResponse res, ServletConfig servletConfig) {
        CmsObject cms = null;
        try {
            cms = this.initCmsObject(req, res);
            CmsGwtService rpcService = this.getGwtService(serviceName, servletConfig);
            rpcService.checkPermissions(cms);
            String rpcContextStr = req.getHeader("X-OcmsRpcContext");
            if (rpcContextStr == null) {
                rpcContextStr = "{}";
            }
            JSONObject rpcContext = new JSONObject(rpcContextStr);
            String pageIdStr = rpcContext.optString("pageId");
            CmsResource page = null;
            if (CmsUUID.isValidUUID(pageIdStr)) {
                try {
                    page = cms.readResource(new CmsUUID(pageIdStr), CmsResourceFilter.IGNORE_EXPIRATION);
                }
                catch (Exception e) {
                    LOG.error((Object)("Page id " + pageIdStr + " is unreadable: " + e.getLocalizedMessage()), (Throwable)e);
                }
            }
            if (page != null) {
                cms.getRequestContext().setUri(cms.getSitePath(page));
                cms.getRequestContext().setAttribute(CmsRequestContext.ATTRIBUTE_ADE_CONTEXT_PATH, page.getRootPath());
            }
            rpcService.setCms(cms);
            Object lock = req.getSession();
            if (lock == null) {
                lock = new Object();
            }
            rpcService.service((ServletRequest)req, (ServletResponse)res);
            this.m_sessionManager.updateSessionInfo(cms, req, rpcService.isBroadcastCall());
        }
        catch (CmsRoleViolationException rv) {
            LOG.debug((Object)rv.getLocalizedMessage(), (Throwable)rv);
            int status = 401;
            res.setStatus(status);
            try {
                res.sendError(status, rv.toString());
            }
            catch (IOException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        catch (Throwable t) {
            LOG.error((Object)t.getLocalizedMessage(), t);
            int status = 500;
            res.setStatus(status);
            try {
                res.sendError(status, t.toString());
            }
            catch (IOException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    protected void setRuntimeProperty(Object key, Object value) {
        this.m_runtimeProperties.put(key, value);
    }

    protected void showResource(HttpServletRequest req, HttpServletResponse res) {
        CmsObject cms = null;
        try {
            cms = this.initCmsObject(req, res);
            HashMap<String, String> logInfo = new HashMap<String, String>();
            logInfo.put("cms_siteroot", cms.getRequestContext().getSiteRoot());
            logInfo.put("cms_project", cms.getRequestContext().getCurrentProject().getName());
            try (CloseableThreadContext.Instance threadContext = CloseableThreadContext.putAll(logInfo);){
                CmsSiteMatcher currentSiteMatcher;
                List<CmsSiteMatcher> currentSiteAliase;
                LOG.info((Object)("Updating log context: " + logInfo));
                String uri = cms.getRequestContext().getUri();
                if (cms.getRequestContext().getCurrentProject().isOnlineProject()) {
                    if (uri.startsWith("/sites/")) {
                        throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_PATH_NOT_FOUND_1", uri));
                    }
                    if (OpenCms.getStaticExportManager().isExportLink(cms, uri)) {
                        String url = this.m_linkManager.getOnlineLink(cms, uri);
                        res.sendRedirect(url);
                        return;
                    }
                }
                if ((currentSiteAliase = this.m_siteManager.getCurrentSite(cms).getAliases()).contains((currentSiteMatcher = cms.getRequestContext().getRequestMatcher()).forDifferentScheme("http")) || currentSiteAliase.contains(currentSiteMatcher.forDifferentScheme("https"))) {
                    int pos = currentSiteAliase.indexOf(currentSiteMatcher.forDifferentScheme("http"));
                    if (pos == -1) {
                        pos = currentSiteAliase.indexOf(currentSiteMatcher.forDifferentScheme("https"));
                    }
                    if (currentSiteAliase.get(pos).isRedirect()) {
                        res.sendRedirect(this.m_siteManager.getCurrentSite(cms).getUrl() + req.getContextPath() + req.getPathInfo());
                        return;
                    }
                }
                CmsResource resource = this.initResource(cms, cms.getRequestContext().getUri(), req, res);
                Object alternativeCmsObject = cms.getRequestContext().removeAttribute("resourceinit.alternativeCmsObject");
                CmsObject cmsForLoad = cms;
                if (alternativeCmsObject instanceof CmsObject) {
                    cmsForLoad = (CmsObject)alternativeCmsObject;
                }
                if (resource != null) {
                    boolean forceAbsoluteLinks = this.checkForceAbsoluteLinks(req, cms, resource);
                    cms.getRequestContext().setForceAbsoluteLinks(forceAbsoluteLinks);
                    this.m_resourceManager.loadResource(cmsForLoad, resource, req, res);
                    if (cmsForLoad == cms) {
                        this.m_sessionManager.updateSessionInfo(cms, req);
                    }
                }
            }
        }
        catch (Throwable t) {
            this.errorHandling(cms, req, res, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutDown() {
        Object object = LOCK;
        synchronized (object) {
            if (this.getRunLevel() > 0) {
                System.err.println(Messages.get().getBundle().key("LOG_SHUTDOWN_CONSOLE_NOTE_2", this.getSystemInfo().getVersionNumber(), this.getSystemInfo().getWebApplicationName()));
                if (CmsLog.INIT.isInfoEnabled()) {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DOT_0"));
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DOT_0"));
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_LINE_0"));
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SHUTDOWN_START_1", this.getSystemInfo().getVersionNumber() + " [" + this.getSystemInfo().getVersionId() + "]"));
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_CURRENT_RUNLEVEL_1", new Integer(this.getRunLevel())));
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SHUTDOWN_TIME_1", new Date(System.currentTimeMillis())));
                }
                this.setRunLevel(0);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_SHUTDOWN_TRACE_0"), (Throwable)new Exception());
                }
                for (I_CmsStartStopHandler handler : this.m_startStopHandlers) {
                    try {
                        handler.shutdown();
                    }
                    catch (Throwable e) {
                        CmsLog.INIT.error((Object)e.getLocalizedMessage(), e);
                    }
                }
                try {
                    if (null != this.m_publishEngine) {
                        this.m_publishEngine.shutDown();
                    }
                }
                catch (Throwable e) {
                    CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_ERROR_PUBLISH_SHUTDOWN_1", e.getMessage()), e);
                }
                try {
                    if (this.m_searchManager != null) {
                        this.m_searchManager.shutDown();
                    }
                }
                catch (Throwable e) {
                    CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_ERROR_SEARCH_MANAGER_SHUTDOWN_1", e.getMessage()), e);
                }
                try {
                    if (this.m_remoteShellServer != null) {
                        this.m_remoteShellServer.shutDown();
                    }
                }
                catch (Throwable e) {
                    CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_ERROR_REMOTESHELL_SHUTDOWN_1", e.getMessage()), e);
                }
                try {
                    if (this.m_vfsBundleManager != null) {
                        this.m_vfsBundleManager.shutDown();
                    }
                }
                catch (Throwable e) {
                    CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_ERROR_VFSBUNDLE_MANAGER_SHUTDOWN_1", e.getMessage()), e);
                }
                try {
                    if (this.m_staticExportManager != null) {
                        this.m_staticExportManager.shutDown();
                    }
                }
                catch (Throwable e) {
                    CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_ERROR_EXPORT_SHUTDOWN_1", e.getMessage()), e);
                }
                try {
                    if (this.m_moduleManager != null) {
                        this.m_moduleManager.shutDown();
                    }
                }
                catch (Throwable e) {
                    CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_ERROR_MODULE_SHUTDOWN_1", e.getMessage()), e);
                }
                try {
                    if (this.m_executor != null) {
                        this.m_executor.shutdownNow();
                        this.m_executor.awaitTermination(30L, TimeUnit.SECONDS);
                    }
                }
                catch (Throwable e) {
                    CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_ERROR_MODULE_SHUTDOWN_1", e.getMessage()), e);
                }
                try {
                    if (this.m_scheduleManager != null) {
                        this.m_scheduleManager.shutDown();
                    }
                }
                catch (Throwable e) {
                    CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_ERROR_SCHEDULE_SHUTDOWN_1", e.getMessage()), e);
                }
                try {
                    if (this.m_resourceManager != null) {
                        this.m_resourceManager.shutDown();
                    }
                }
                catch (Throwable e) {
                    CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_ERROR_RESOURCE_SHUTDOWN_1", e.getMessage()), e);
                }
                try {
                    if (this.m_repositoryManager != null) {
                        this.m_repositoryManager.shutDown();
                    }
                }
                catch (Throwable e) {
                    CmsLog.INIT.error((Object)e.getLocalizedMessage(), e);
                }
                try {
                    if (this.m_threadStore != null) {
                        this.m_threadStore.shutDown();
                    }
                }
                catch (Throwable e) {
                    CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_ERROR_THREAD_SHUTDOWN_1", e.getMessage()), e);
                }
                try {
                    if (this.m_securityManager != null) {
                        this.m_securityManager.destroy();
                    }
                }
                catch (Throwable e) {
                    CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_ERROR_SECURITY_SHUTDOWN_1", e.getMessage()), e);
                }
                try {
                    if (this.m_sessionManager != null) {
                        this.m_sessionManager.shutdown();
                    }
                }
                catch (Throwable e) {
                    CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_ERROR_SESSION_MANAGER_SHUTDOWN_1", e.getMessage()), e);
                }
                try {
                    if (this.m_memoryMonitor != null) {
                        this.m_memoryMonitor.shutdown();
                    }
                }
                catch (Throwable e) {
                    CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_ERROR_MEMORY_MONITOR_SHUTDOWN_1", e.getMessage()), e);
                }
                try {
                    if (this.m_adeManager != null) {
                        this.m_adeManager.shutdown();
                    }
                }
                catch (Throwable e) {
                    CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_ERROR_ADE_MANAGER_SHUTDOWN_1", e.getMessage()), e);
                }
                String runtime = CmsStringUtil.formatRuntime(this.getSystemInfo().getRuntime());
                if (CmsLog.INIT.isInfoEnabled()) {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_OPENCMS_STOPPED_1", runtime));
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_LINE_0"));
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DOT_0"));
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DOT_0"));
                }
                System.err.println(Messages.get().getBundle().key("LOG_CONSOLE_TOTAL_RUNTIME_1", runtime));
            }
            m_instance = null;
        }
    }

    protected CmsObject updateContext(HttpServletRequest request, CmsObject cms) throws CmsException {
        boolean isWorkplace;
        String siteRoot = null;
        boolean bl = isWorkplace = cms.getRequestContext().getUri().startsWith("/system/workplace/") || request.getRequestURI().startsWith(OpenCms.getSystemInfo().getWorkplaceContext());
        if (isWorkplace && this.getRoleManager().hasRole(cms, CmsRole.ELEMENT_AUTHOR)) {
            siteRoot = cms.getRequestContext().getSiteRoot();
        } else {
            CmsSite site = OpenCms.getSiteManager().matchRequest(request);
            siteRoot = site.getSiteRoot();
        }
        return this.initCmsObject(request, cms.getRequestContext().getCurrentUser(), siteRoot, cms.getRequestContext().getCurrentProject().getUuid(), cms.getRequestContext().getOuFqn());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OpenCmsCore upgradeRunlevel(CmsParameterConfiguration configuration) throws CmsInitException {
        Object object = LOCK;
        synchronized (object) {
            if (m_instance != null && this.getRunLevel() >= 2) {
                return m_instance;
            }
            if (this.getRunLevel() != 1) {
                CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_WRONG_INIT_SEQUENCE_2", new Integer(3), new Integer(this.getRunLevel())));
                return m_instance;
            }
            this.setRunLevel(2);
            m_instance.initConfiguration(configuration);
            this.setRunLevel(3);
            this.afterUpgradeRunlevel();
            return m_instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OpenCmsCore upgradeRunlevel(ServletContext context) throws CmsInitException {
        Object object = LOCK;
        synchronized (object) {
            if (m_instance != null && this.getRunLevel() >= 4) {
                return m_instance;
            }
            if (this.getRunLevel() != 1) {
                CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_WRONG_INIT_SEQUENCE_2", new Integer(4), new Integer(this.getRunLevel())));
                return m_instance;
            }
            this.setRunLevel(2);
            m_instance.initContext(context);
            this.setRunLevel(4);
            this.afterUpgradeRunlevel();
            return m_instance;
        }
    }

    protected void writeConfiguration(Class<?> clazz) {
        try {
            this.m_configurationManager.writeConfiguration(clazz);
        }
        catch (IOException e) {
            CmsLog.getLog(CmsConfigurationManager.class).error((Object)Messages.get().getBundle().key("LOG_ERROR_WRITING_CONFIG_1", clazz.getName()), (Throwable)e);
        }
        catch (CmsConfigurationException e) {
            CmsLog.getLog(CmsConfigurationManager.class).error((Object)Messages.get().getBundle().key("LOG_ERROR_WRITING_CONFIG_1", clazz.getName()), (Throwable)e);
        }
    }

    private void addExportPoints(Set<CmsExportPoint> exportPoints) {
        HashSet<CmsExportPoint> newSet = new HashSet<CmsExportPoint>(this.m_exportPoints.size() + exportPoints.size());
        newSet.addAll(exportPoints);
        newSet.addAll(this.m_exportPoints);
        this.m_exportPoints = Collections.unmodifiableSet(newSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterUpgradeRunlevel() {
        block32: {
            block30: {
                String adeInitData;
                block29: {
                    try {
                        OpenCmsCore.m_instance.m_securityManager.readLocks();
                    }
                    catch (CmsException e) {
                        if (!LOG.isErrorEnabled()) break block29;
                        LOG.error((Object)org.opencms.lock.Messages.get().getBundle().key("ERR_READ_LOCKS_0"), (Throwable)e);
                    }
                }
                if (OpenCms.getRunLevel() != 4) break block32;
                Iterator<I_CmsStartStopHandler> stats = new CmsThreadStatsTreeProfilingHandler();
                try {
                    CmsDefaultProfilingHandler.INSTANCE.addHandler((I_CmsProfilingHandler)((Object)stats));
                    this.m_adeManager.initialize();
                    CmsDefaultProfilingHandler.INSTANCE.removeHandler((I_CmsProfilingHandler)((Object)stats));
                    if (!((CmsThreadStatsTreeProfilingHandler)((Object)stats)).hasData()) break block30;
                    adeInitData = ((CmsThreadStatsTreeProfilingHandler)((Object)stats)).dump();
                }
                catch (Throwable throwable) {
                    CmsDefaultProfilingHandler.INSTANCE.removeHandler((I_CmsProfilingHandler)((Object)stats));
                    if (((CmsThreadStatsTreeProfilingHandler)((Object)stats)).hasData()) {
                        String adeInitData2 = ((CmsThreadStatsTreeProfilingHandler)((Object)stats)).dump();
                        String prefix = String.format("%010X", System.currentTimeMillis() / 1000L);
                        String path = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf("logs/" + prefix + "_startup-ade-driver-report.xml");
                        try (FileOutputStream out = new FileOutputStream(path);){
                            out.write(adeInitData2.getBytes("UTF-8"));
                        }
                        catch (Exception e) {
                            LOG.error((Object)("Could not write ADE init profiling data to file, writing to log instead: " + e.getLocalizedMessage()), (Throwable)e);
                            LOG.error((Object)adeInitData2);
                        }
                    }
                    throw throwable;
                }
                String prefix = String.format("%010X", System.currentTimeMillis() / 1000L);
                String path = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf("logs/" + prefix + "_startup-ade-driver-report.xml");
                try (FileOutputStream out = new FileOutputStream(path);){
                    out.write(adeInitData.getBytes("UTF-8"));
                }
                catch (Exception e) {
                    LOG.error((Object)("Could not write ADE init profiling data to file, writing to log instead: " + e.getLocalizedMessage()), (Throwable)e);
                    LOG.error((Object)adeInitData);
                }
            }
            try {
                CmsObject adminCms = this.initCmsObject(null, null, this.getDefaultUsers().getUserAdmin(), (String)null, (String)null);
                OpenCms.getSearchManager().initSpellcheckIndex(adminCms);
            }
            catch (CmsException e) {
                throw new CmsInitException(Messages.get().container("ERR_CRITICAL_INIT_ADMINCMS_0"), (Throwable)e);
            }
        }
        this.m_publishManager.startPublishing();
        for (I_CmsStartStopHandler handler : ServiceLoader.load(I_CmsStartStopHandler.class)) {
            this.m_startStopHandlers.add(handler);
        }
        for (I_CmsStartStopHandler handler : this.m_startStopHandlers) {
            try {
                handler.startup(this.m_configAdminCms);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        try {
            CmsDiagnosticsMXBean.register();
        }
        catch (Throwable e) {
            CmsLog.INIT.error((Object)e.getLocalizedMessage(), e);
        }
        try {
            Field field = LinkedHashMap_CustomFieldSerializer.class.getDeclaredField("reflectionHasFailed");
            field.setAccessible(true);
            ((AtomicBoolean)field.get(null)).set(true);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            CmsLog.INIT.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private boolean checkForceAbsoluteLinks(HttpServletRequest req, CmsObject cms, CmsResource resource) {
        try {
            boolean forceAbsoluteLinks = Boolean.parseBoolean(req.getParameter(PARAM_FORCE_ABSOLUTE_LINKS));
            if (forceAbsoluteLinks) {
                CmsProperty enableForceAbsoluteProp = cms.readPropertyObject(resource, "links.forceabsolute.enabled", true);
                return Boolean.parseBoolean(enableForceAbsoluteProp.getValue());
            }
            return false;
        }
        catch (Exception e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    private void errorHandling(CmsObject cms, HttpServletRequest req, HttpServletResponse res, Throwable t) {
        CmsFlexController.removeController((ServletRequest)req);
        req.removeAttribute("cms");
        boolean canWrite = !res.isCommitted() && !res.containsHeader("Location");
        int status = -1;
        boolean isGuest = true;
        if (t instanceof ServletException) {
            ServletException s = (ServletException)t;
            if (s.getRootCause() != null) {
                t = s.getRootCause();
            }
            LOG.error((Object)(t.getLocalizedMessage() + " rendering URL " + req.getRequestURL()), t);
        } else if (t instanceof CmsSecurityException) {
            LOG.warn((Object)(t.getLocalizedMessage() + " rendering URL " + req.getRequestURL()), t);
            if (canWrite) {
                try {
                    this.m_authorizationHandler.requestAuthorization(req, res, this.getLoginFormURL(req, res));
                }
                catch (IOException ioe) {
                    LOG.debug((Object)"Error calling authorization handler.", (Throwable)ioe);
                }
                return;
            }
        } else if (t instanceof CmsDbEntryNotFoundException) {
            LOG.warn((Object)(t.getLocalizedMessage() + " rendering URL " + req.getRequestURL()), t);
            status = 503;
            isGuest = false;
        } else if (t instanceof CmsVfsResourceNotFoundException) {
            LOG.warn((Object)(t.getLocalizedMessage() + " rendering URL " + req.getRequestURL()), t);
            status = 404;
        } else if (t instanceof CmsException) {
            LOG.error((Object)(t.getLocalizedMessage() + " rendering URL " + req.getRequestURL()), t);
            if (t.getCause() != null) {
                t = t.getCause();
            }
        } else if (t.getClass().getName().equals("org.apache.catalina.connector.ClientAbortException")) {
            LOG.debug((Object)(t.getLocalizedMessage() + " rendering URL " + req.getRequestURL()), t);
        } else {
            LOG.error((Object)(t.getLocalizedMessage() + " rendering URL " + req.getRequestURL()), t);
        }
        if (status < 1) {
            status = 500;
        }
        res.setStatus(status);
        try {
            if (cms != null && cms.getRequestContext().getCurrentUser() != null) {
                isGuest = isGuest && (cms.getRequestContext().getCurrentUser().isGuestUser() || cms.userInGroup(cms.getRequestContext().getCurrentUser().getName(), OpenCms.getDefaultUsers().getGroupGuests()));
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        if (canWrite) {
            res.setContentType("text/html");
            CmsRequestUtil.setNoCacheHeaders(res);
            if (!(status == 404 || isGuest || cms == null || CmsJsonPartFilter.isJsonRequest((ServletRequest)req) || cms.getRequestContext().getCurrentProject().isOnlineProject())) {
                try {
                    res.setStatus(200);
                    res.getWriter().print(CmsErrorUI.getBootstrapPage(cms, t, req));
                }
                catch (IOException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            } else {
                try {
                    res.sendError(status, t.toString());
                }
                catch (IOException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    private synchronized CmsGwtService getGwtService(String serviceName, ServletConfig servletConfig) throws Throwable {
        CmsGwtServiceContext context = this.m_gwtServiceContexts.get(serviceName);
        if (context == null) {
            context = new CmsGwtServiceContext(serviceName);
            this.m_gwtServiceContexts.put(serviceName, context);
        }
        CmsGwtService gwtService = (CmsGwtService)((Object)Class.forName(serviceName).newInstance());
        gwtService.init(servletConfig);
        gwtService.setContext(context);
        return gwtService;
    }

    private String getLoginFormURL(HttpServletRequest req, HttpServletResponse res) throws IOException {
        CmsProperty propertyLoginForm;
        String path;
        CmsObject adminCms;
        String loginFormURL;
        CmsHttpAuthenticationSettings httpAuthenticationSettings;
        block14: {
            httpAuthenticationSettings = OpenCms.getSystemInfo().getHttpAuthenticationSettings();
            loginFormURL = null;
            try {
                adminCms = this.initCmsObject(req, res, OpenCms.getDefaultUsers().getUserAdmin(), null, null);
            }
            catch (CmsException e) {
                throw new IOException(Messages.get().getBundle().key("ERR_INVALID_INIT_USER_2", OpenCms.getDefaultUsers().getUserAdmin(), null), e);
            }
            path = adminCms.getRequestContext().getUri();
            propertyLoginForm = null;
            try {
                propertyLoginForm = adminCms.readPropertyObject(path, "login-form", true);
            }
            catch (Throwable t) {
                if (t instanceof CmsVfsResourceNotFoundException) {
                    CmsResource alternativeResource = null;
                    try {
                        alternativeResource = this.initResource(adminCms, path, req, null);
                        if (alternativeResource != null) {
                            propertyLoginForm = adminCms.readPropertyObject(adminCms.getSitePath(alternativeResource), "login-form", true);
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                if (propertyLoginForm != null || !LOG.isWarnEnabled()) break block14;
                LOG.warn((Object)Messages.get().getBundle().key("LOG_ERROR_READING_AUTH_PROP_2", "login-form", path), t);
            }
        }
        String params = null;
        if (propertyLoginForm != null && propertyLoginForm != CmsProperty.getNullProperty() && CmsStringUtil.isNotEmpty(propertyLoginForm.getValue())) {
            loginFormURL = propertyLoginForm.getValue();
            params = "__loginform=true";
        } else if (!httpAuthenticationSettings.useBrowserBasedHttpAuthentication() && CmsStringUtil.isNotEmpty(httpAuthenticationSettings.getFormBasedHttpAuthenticationUri())) {
            loginFormURL = httpAuthenticationSettings.getFormBasedHttpAuthenticationUri();
        }
        String callbackURL = CmsRequestUtil.encodeParamsWithUri(path, req);
        if (loginFormURL != null) {
            if (!loginFormURL.startsWith("http")) {
                loginFormURL = this.m_linkManager.substituteLink(adminCms, loginFormURL, null, true);
            } else {
                callbackURL = this.m_linkManager.getServerLink(adminCms, path);
                callbackURL = CmsRequestUtil.encodeParamsWithUri(callbackURL, req);
            }
        }
        return this.m_authorizationHandler.getLoginFormURL(loginFormURL, params, callbackURL);
    }

    private CmsResource handleSecureResource(CmsObject cms, HttpServletRequest req, HttpServletResponse res, CmsResource resource, String resourceName) throws CmsException, CmsVfsResourceNotFoundException {
        if (cms.getRequestContext().getCurrentProject().isOnlineProject() && res != null) {
            boolean secure = false;
            try {
                secure = Boolean.valueOf(cms.readPropertyObject(cms.getSitePath(resource), "secure", true).getValue());
            }
            catch (CmsVfsResourceNotFoundException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            if (secure) {
                CmsResource resource1 = resource;
                CmsSite site = OpenCms.getSiteManager().getCurrentSite(cms);
                String secureUrl = null;
                try {
                    secureUrl = site.getSecureUrl();
                }
                catch (Exception e) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_SECURE_SITE_NOT_CONFIGURED_1", resourceName), (Throwable)e);
                    throw new CmsException(Messages.get().container("ERR_SECURE_SITE_NOT_CONFIGURED_1", resourceName), (Throwable)e);
                }
                boolean usingSec = true;
                if (req != null) {
                    usingSec = req.getRequestURL().toString().toUpperCase().startsWith(secureUrl.toUpperCase());
                }
                if (site.isExclusiveUrl() && !usingSec) {
                    resource1 = null;
                    if (site.isExclusiveError()) {
                        throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_REQUEST_SECURE_RESOURCE_0"));
                    }
                    String target = OpenCms.getLinkManager().getOnlineLink(cms, resourceName);
                    if (!target.toLowerCase().startsWith(secureUrl.toLowerCase())) {
                        Optional<String> targetWithReplacedHost = CmsStringUtil.replacePrefix(target, site.getSiteMatcher().getUrl(), secureUrl, true);
                        if (targetWithReplacedHost.isPresent()) {
                            target = (String)targetWithReplacedHost.get();
                        }
                        if (!target.toLowerCase().startsWith(secureUrl.toLowerCase())) {
                            LOG.warn((Object)("Failed to generate secure URL for " + target + ", site = " + site));
                        }
                    }
                    try {
                        if (site.usesPermanentRedirects()) {
                            res.setStatus(301);
                            res.setHeader("Location", target);
                        } else {
                            res.sendRedirect(target);
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error sending secure resource redirect.", (Throwable)e);
                    }
                }
                resource = resource1;
            }
        }
        return resource;
    }

    private CmsObject initCmsObject(CmsContextInfo contextInfo) throws CmsException {
        CmsProject project;
        CmsUser user = contextInfo.getUser();
        if (user == null) {
            user = this.m_securityManager.readUser(null, contextInfo.getUserName());
        }
        if ((project = contextInfo.getProject()) == null) {
            project = this.m_securityManager.readProject(contextInfo.getProjectName());
        }
        CmsRequestContext context = new CmsRequestContext(user, project, contextInfo.getRequestedUri(), contextInfo.getRequestMatcher(), contextInfo.getSiteRoot(), contextInfo.isSecureRequest(), contextInfo.getLocale(), contextInfo.getEncoding(), contextInfo.getRemoteAddr(), contextInfo.getRequestTime(), this.m_resourceManager.getFolderTranslator(), this.m_resourceManager.getFileTranslator(), contextInfo.getOuFqn(), contextInfo.isForceAbsoluteLinks());
        context.setDetailResource(contextInfo.getDetailResource());
        return new CmsObject(this.m_securityManager, context);
    }

    private CmsObject initCmsObject(HttpServletRequest request, CmsUser user, String siteRoot, CmsUUID projectId, String ouFqn) throws CmsException {
        Locale locale;
        CmsI18nInfo i18nInfo;
        CmsSiteMatcher requestMatcher;
        String remoteAddr;
        CmsProject project = null;
        try {
            project = this.m_securityManager.readProject(projectId);
        }
        catch (CmsDbEntryNotFoundException e) {
            project = this.m_securityManager.readProject(CmsProject.ONLINE_PROJECT_ID);
            LOG.debug((Object)("Project '" + projectId + "' was not found, switch to online project."), (Throwable)e);
        }
        String requestedResource = null;
        Long requestTimeAttr = null;
        boolean isSecureRequest = false;
        if (request != null) {
            HttpSession session;
            requestedResource = OpenCmsCore.getPathInfo(request);
            remoteAddr = request.getHeader("x-forwarded-for");
            if (remoteAddr == null) {
                remoteAddr = request.getRemoteAddr();
            }
            if ((session = request.getSession(false)) != null) {
                requestTimeAttr = (Long)session.getAttribute("__org.opencms.main.CmsContextInfo#m_requestTime");
            }
            isSecureRequest = OpenCms.getSiteManager().usesSecureSite(request);
            requestMatcher = new CmsSiteMatcher(request.getRequestURL().toString());
        } else {
            remoteAddr = "127.0.0.1";
            requestMatcher = OpenCms.getSiteManager().getWorkplaceSiteMatcher();
        }
        if (requestedResource == null) {
            requestedResource = "/";
        }
        long requestTime = requestTimeAttr == null ? System.currentTimeMillis() : requestTimeAttr;
        if (this.m_localeManager.isInitialized()) {
            if (request != null && (requestedResource.endsWith(".gwt") || this.isWorkplaceServletRequest(request))) {
                i18nInfo = new CmsI18nInfo(CmsLocaleManager.getDefaultLocale(), request.getCharacterEncoding());
            } else {
                String resourceName = requestedResource.startsWith("/system/") ? requestedResource : (OpenCms.getSiteManager().startsWithShared(requestedResource) ? requestedResource : siteRoot.concat(requestedResource));
                i18nInfo = this.m_localeManager.getI18nInfo(request, user, project, resourceName);
            }
        } else {
            i18nInfo = new CmsI18nInfo(Locale.ENGLISH, this.getSystemInfo().getDefaultEncoding());
        }
        requestedResource = CmsEncoder.decode(requestedResource);
        CmsSite site = OpenCms.getSiteManager().getSiteForSiteRoot(siteRoot);
        if (site != null && CmsSite.LocalizationMode.singleTree.equals((Object)site.getLocalizationMode()) && (locale = CmsSingleTreeLocaleHandler.getLocaleFromPath(requestedResource)) != null) {
            requestedResource = requestedResource.substring(requestedResource.indexOf(locale.toString()) + locale.toString().length());
        }
        CmsContextInfo contextInfo = new CmsContextInfo(user, project, requestedResource, requestMatcher, siteRoot, isSecureRequest, i18nInfo.getLocale(), i18nInfo.getEncoding(), remoteAddr, requestTime, ouFqn, false);
        return this.initCmsObject(contextInfo);
    }

    private CmsObject initCmsObject(HttpServletRequest req, HttpServletResponse res) throws IOException, CmsException {
        return this.initCmsObject(req, res, true);
    }

    private CmsObject initCmsObject(HttpServletRequest req, HttpServletResponse res, String user, String password, String ouFqn) throws CmsException {
        String siteroot = null;
        if (req != null) {
            siteroot = OpenCms.getSiteManager().matchRequest(req).getSiteRoot();
        }
        if (user == null) {
            user = this.getDefaultUsers().getUserGuest();
        }
        if (siteroot == null) {
            siteroot = "/";
        }
        CmsObject cms = this.initCmsObject(req, this.m_securityManager.readUser(null, user), siteroot, CmsProject.ONLINE_PROJECT_ID, ouFqn);
        if (password != null && !this.getDefaultUsers().isUserGuest(user)) {
            cms.loginUser(user, password, "127.0.0.1");
        }
        return cms;
    }

    private boolean isWorkplaceServletRequest(HttpServletRequest req) {
        String servletPath = req.getServletPath();
        return servletPath != null && servletPath.startsWith("/workplace");
    }

    private void setRunLevel(int level) {
        if (m_instance != null) {
            if (OpenCmsCore.m_instance.m_runLevel >= 1 && CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_RUNLEVEL_CHANGE_2", new Integer(OpenCmsCore.m_instance.m_runLevel), new Integer(level)));
            }
            OpenCmsCore.m_instance.m_runLevel = level;
        }
    }

    static {
        String keyEntityExpansionLimit = "jdk.xml.entityExpansionLimit";
        if (System.getProperty("jdk.xml.entityExpansionLimit") == null) {
            System.setProperty("jdk.xml.entityExpansionLimit", "64000");
        }
    }
}

