/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.main.OpenCmsCore;

public class OpenCmsProtectedExportFilter
implements Filter {
    private static final Log LOG = CmsLog.getLog(OpenCmsProtectedExportFilter.class);
    private String m_prefix;

    public void destroy() {
        this.m_prefix = null;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (OpenCms.getStaticExportManager().getProtectedExportPath() != null && req instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)req;
            String uri = request.getRequestURI();
            if (uri.startsWith(this.getPrefix())) {
                ((HttpServletResponse)res).sendError(403);
                return;
            }
            try {
                String rfsName;
                String rootPath;
                CmsObject cms = OpenCmsCore.getInstance().initCmsObject(request, (HttpServletResponse)res, false);
                if (cms.getRequestContext().getCurrentProject().isOnlineProject() && (rootPath = OpenCms.getLinkManager().getRootPath(cms, uri)) != null && (rfsName = OpenCms.getStaticExportManager().getProtectedExportName(rootPath)) != null) {
                    cms = OpenCms.initCmsObject(cms);
                    cms.getRequestContext().setSiteRoot("");
                    if (cms.existsResource(rootPath)) {
                        req.getRequestDispatcher(rfsName).forward((ServletRequest)request, res);
                        return;
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        chain.doFilter(req, res);
    }

    public void init(FilterConfig arg0) {
    }

    private String getPrefix() {
        if (this.m_prefix == null) {
            this.m_prefix = OpenCms.getSystemInfo().getContextPath() + "/" + OpenCms.getStaticExportManager().getProtectedExportPath() + "/";
        }
        return this.m_prefix;
    }
}

