/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.module;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.importexport.CmsImportParameters;
import org.opencms.importexport.CmsImportResourceDataReader;
import org.opencms.importexport.CmsImportVersion10;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsShell;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.module.CmsModuleImportData;
import org.opencms.module.CmsModuleImportExportHandler;
import org.opencms.module.CmsResourceImportData;
import org.opencms.module.Messages;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationType;
import org.opencms.relations.I_CmsLinkParseable;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsModuleUpdater {
    private static final Log LOG = CmsLog.getLog(CmsModuleUpdater.class);
    private Set<CmsUUID> m_importIds = new HashSet<CmsUUID>();
    private CmsModuleImportData m_moduleData;
    private I_CmsReport m_report;

    public CmsModuleUpdater(CmsModuleImportData moduleData, I_CmsReport report) {
        this.m_moduleData = moduleData;
        this.m_report = report;
    }

    public static boolean checkCompatibleModuleResources(CmsModule installedModule, CmsModule newModule) {
        if (!installedModule.hasOnlySystemAndSharedResources() || !newModule.hasOnlySystemAndSharedResources()) {
            String oldSite = installedModule.getSite();
            String newSite = newModule.getSite();
            if (oldSite == null || newSite == null || !CmsStringUtil.comparePaths(oldSite, newSite)) {
                return false;
            }
        }
        for (String oldModRes : installedModule.getResources()) {
            for (String newModRes : newModule.getResources()) {
                if (!CmsStringUtil.isProperPrefixPath(oldModRes, newModRes)) continue;
                return false;
            }
        }
        return true;
    }

    public static Optional<CmsModuleUpdater> create(CmsObject cms, String importFile, I_CmsReport report) throws CmsException {
        CmsModuleImportData moduleData = CmsModuleUpdater.readModuleData(cms, importFile, report);
        if (moduleData.checkUpdatable(cms)) {
            return Optional.of(new CmsModuleUpdater(moduleData, report));
        }
        return Optional.empty();
    }

    public static boolean needToUpdateResourceFields(CmsResource existingRes, CmsResource newRes, boolean reduced) {
        boolean result = false;
        result |= existingRes.getTypeId() != newRes.getTypeId();
        result |= CmsModuleUpdater.differentDates(existingRes.getDateCreated(), newRes.getDateCreated());
        result |= CmsModuleUpdater.differentDates(existingRes.getDateReleased(), newRes.getDateReleased());
        result |= CmsModuleUpdater.differentDates(existingRes.getDateExpired(), newRes.getDateExpired());
        result |= existingRes.getFlags() != newRes.getFlags();
        if (!reduced) {
            result |= !Objects.equal((Object)existingRes.getUserCreated(), (Object)newRes.getUserCreated());
            result |= !Objects.equal((Object)existingRes.getUserLastModified(), (Object)newRes.getUserLastModified());
            result |= existingRes.getDateLastModified() != newRes.getDateLastModified();
        }
        return result;
    }

    public static String normalizePath(String ... pathComponents) {
        return CmsFileUtil.removeTrailingSeparator(CmsStringUtil.joinPaths(pathComponents));
    }

    public static CmsModuleImportData readModuleData(CmsObject cms, String importFile, I_CmsReport report) throws CmsException {
        CmsModuleImportData result = new CmsModuleImportData();
        CmsModule module = CmsModuleImportExportHandler.readModuleFromImport(importFile);
        cms = OpenCms.initCmsObject(cms);
        String importSite = module.getImportSite();
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(importSite)) {
            cms.getRequestContext().setSiteRoot(importSite);
        } else {
            String siteToSet = cms.getRequestContext().getSiteRoot();
            if ("".equals(siteToSet)) {
                siteToSet = "/";
            }
            module.setSite(siteToSet);
        }
        result.setModule(module);
        result.setCms(cms);
        CmsImportResourceDataReader importer = new CmsImportResourceDataReader(result);
        CmsImportParameters params = new CmsImportParameters(importFile, "/", false);
        importer.importData(cms, report, params);
        return result;
    }

    static boolean differentDates(long d1, long d2) {
        return 1000L < Math.abs(d2 - d1);
    }

    private static Set<CmsResource> getAllResourcesInModule(CmsObject cms, CmsModule module) throws CmsException {
        HashSet<CmsResource> result = new HashSet<CmsResource>();
        for (CmsResource resource : CmsModule.calculateModuleResources(cms, module)) {
            result.add(resource);
            if (!resource.isFolder()) continue;
            result.addAll(cms.readResources(resource, CmsResourceFilter.ALL, true));
        }
        return result;
    }

    public void importRelations(CmsObject cms) throws CmsException {
        for (CmsResourceImportData resData : this.m_moduleData.getResourceData()) {
            CmsResource importResource;
            if (resData.getRelations().isEmpty() || (importResource = resData.getImportResource()) == null) continue;
            importResource = cms.readResource(importResource.getStructureId(), CmsResourceFilter.ALL);
            this.updateRelations(cms, importResource, resData.getRelations());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            CmsObject cms = this.m_moduleData.getCms();
            CmsModule module = this.m_moduleData.getModule();
            CmsModule oldModule = OpenCms.getModuleManager().getModule(module.getName());
            Map<CmsUUID, CmsUUID> conflictingIds = this.m_moduleData.getConflictingIds();
            if (!conflictingIds.isEmpty()) {
                this.deleteConflictingResources(cms, module, conflictingIds);
            }
            CmsProject importProject = this.createAndSetModuleImportProject(cms, module);
            CmsModuleImportExportHandler.reportBeginImport(this.m_report, module.getName());
            HashMap<CmsUUID, CmsResourceImportData> importResourcesById = new HashMap<CmsUUID, CmsResourceImportData>();
            for (CmsResourceImportData resData : this.m_moduleData.getResourceData()) {
                importResourcesById.put(resData.getResource().getStructureId(), resData);
            }
            Set<CmsResource> oldModuleResources = CmsModuleUpdater.getAllResourcesInModule(cms, oldModule);
            ArrayList<CmsResource> toDelete = new ArrayList<CmsResource>();
            Set immutables = OpenCms.getImportExportManager().getImmutableResources().stream().flatMap(path -> Arrays.asList(CmsFileUtil.removeTrailingSeparator(path), CmsFileUtil.addTrailingSeparator(path)).stream()).collect(Collectors.toSet());
            for (CmsResource oldRes : oldModuleResources) {
                CmsResourceImportData newRes;
                if (immutables.contains(oldRes.getRootPath()) || (newRes = (CmsResourceImportData)importResourcesById.get(oldRes.getStructureId())) != null) continue;
                toDelete.add(oldRes);
            }
            int index = 0;
            for (CmsResourceImportData resData1 : this.m_moduleData.getResourceData()) {
                this.processImportResource(cms, resData1, ++index);
            }
            this.processDeletions(cms, toDelete);
            this.parseLinks(cms);
            this.importRelations(cms);
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(module.getImportScript())) {
                this.runImportScript(cms, module);
            }
            OpenCms.getModuleManager().updateModule(cms, module);
            module.setCheckpointTime(System.currentTimeMillis());
            if (module.getResourceTypes() != Collections.EMPTY_LIST) {
                OpenCms.getResourceManager().initialize(cms);
            }
            if (module.getExplorerTypes() != Collections.EMPTY_LIST) {
                OpenCms.getWorkplaceManager().addExplorerTypeSettings(module);
            }
            for (CmsResourceImportData resData : this.m_moduleData.getResourceData()) {
                if (!this.m_importIds.contains(resData.getResource().getStructureId()) || OpenCms.getResourceManager().matchResourceType(resData.getTypeName(), resData.getResource().getTypeId()) || !OpenCms.getResourceManager().hasResourceType(resData.getTypeName())) continue;
                try {
                    CmsResource res = cms.readResource(resData.getResource().getStructureId());
                    cms.chtype(res, OpenCms.getResourceManager().getResourceType(resData.getTypeName()));
                }
                catch (Exception e) {
                    this.m_report.println(e);
                }
            }
            cms.unlockProject(importProject.getUuid());
            OpenCms.getPublishManager().publishProject(cms, this.m_report);
            OpenCms.getPublishManager().waitWhileRunning();
            CmsModuleImportExportHandler.reportEndImport(this.m_report);
        }
        catch (Exception e) {
            this.m_report.println(e);
        }
        finally {
            this.cleanUp();
        }
    }

    public boolean updateAcls(CmsObject cms, CmsResourceImportData resData, CmsResource resource) throws CmsException {
        boolean changed = false;
        Map<CmsUUID, CmsAccessControlEntry> importAces = this.buildAceMap(resData.getAccessControlEntries());
        String path = cms.getSitePath(resource);
        List<CmsAccessControlEntry> existingAcl = cms.getAccessControlEntries(path, false);
        Map<CmsUUID, CmsAccessControlEntry> existingAces = this.buildAceMap(existingAcl);
        HashSet<CmsUUID> keys = new HashSet<CmsUUID>(existingAces.keySet());
        keys.addAll(importAces.keySet());
        for (CmsUUID key : keys) {
            CmsAccessControlEntry existingEntry = existingAces.get(key);
            CmsAccessControlEntry newEntry = importAces.get(key);
            if (existingEntry != null && newEntry != null && existingEntry.withNulledResource().equals(newEntry.withNulledResource())) continue;
            cms.importAccessControlEntries(resource, resData.getAccessControlEntries());
            changed = true;
            break;
        }
        return changed;
    }

    protected CmsProject createAndSetModuleImportProject(CmsObject cms, CmsModule module) throws CmsException {
        CmsProject importProject = cms.createProject(Messages.get().getBundle(cms.getRequestContext().getLocale()).key("GUI_IMPORT_MODULE_PROJECT_NAME_1", new Object[]{module.getName()}), Messages.get().getBundle(cms.getRequestContext().getLocale()).key("GUI_IMPORT_MODULE_PROJECT_DESC_1", new Object[]{module.getName()}), OpenCms.getDefaultUsers().getGroupAdministrators(), OpenCms.getDefaultUsers().getGroupAdministrators(), CmsProject.PROJECT_TYPE_TEMPORARY);
        cms.getRequestContext().setCurrentProject(importProject);
        cms.copyResourceToProject("/");
        return importProject;
    }

    protected void deleteConflictingResources(CmsObject cms, CmsModule module, Map<CmsUUID, CmsUUID> conflictingIds) throws CmsException, Exception {
        CmsProject conflictProject = cms.createProject("Deletion of conflicting resources for " + module.getName(), "Deletion of conflicting resources for " + module.getName(), OpenCms.getDefaultUsers().getGroupAdministrators(), OpenCms.getDefaultUsers().getGroupAdministrators(), CmsProject.PROJECT_TYPE_TEMPORARY);
        CmsObject deleteCms = OpenCms.initCmsObject(cms);
        deleteCms.getRequestContext().setCurrentProject(conflictProject);
        for (CmsUUID vfsId : conflictingIds.values()) {
            CmsResource toDelete = deleteCms.readResource(vfsId, CmsResourceFilter.ALL);
            this.lock(deleteCms, toDelete);
            deleteCms.deleteResource(toDelete, CmsResource.DELETE_PRESERVE_SIBLINGS);
        }
        OpenCms.getPublishManager().publishProject(deleteCms);
        OpenCms.getPublishManager().waitWhileRunning();
    }

    protected void parseLinks(CmsObject cms) throws CmsException {
        ArrayList<CmsResource> linkParseables = new ArrayList<CmsResource>();
        for (CmsResourceImportData resData : this.m_moduleData.getResourceData()) {
            CmsResource importRes = resData.getImportResource();
            if (importRes == null || !this.m_importIds.contains(importRes.getStructureId()) || !this.isLinkParsable(importRes)) continue;
            linkParseables.add(importRes);
        }
        this.m_report.println(org.opencms.importexport.Messages.get().container("RPT_START_PARSE_LINKS_0"), 2);
        CmsImportVersion10.parseLinks(cms, linkParseables, this.m_report);
        this.m_report.println(org.opencms.importexport.Messages.get().container("RPT_END_PARSE_LINKS_0"), 2);
    }

    protected void processDeletions(CmsObject cms, List<CmsResource> toDelete) throws CmsException {
        Collections.sort(toDelete, (a, b) -> b.getRootPath().compareTo(a.getRootPath()));
        for (CmsResource deleteRes : toDelete) {
            this.m_report.print(org.opencms.importexport.Messages.get().container("RPT_DELFOLDER_0"), 3);
            this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", deleteRes.getRootPath()));
            CmsLock lock = cms.getLock(deleteRes);
            if (lock.isUnlocked()) {
                this.lock(cms, deleteRes);
            }
            cms.deleteResource(deleteRes, CmsResource.DELETE_PRESERVE_SIBLINGS);
            this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
        }
    }

    protected void processImportResource(CmsObject cms, CmsResourceImportData resData, int index) {
        boolean changed = false;
        this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", "( " + index + " / " + this.m_moduleData.getResourceData().size() + " ) "), 3);
        this.m_report.print(org.opencms.importexport.Messages.get().container("RPT_IMPORTING_0"), 3);
        this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", resData.getPath()));
        this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
        try {
            CmsResource oldRes = null;
            try {
                oldRes = resData.hasStructureId() ? cms.readResource(resData.getResource().getStructureId(), CmsResourceFilter.IGNORE_EXPIRATION) : cms.readResource(resData.getPath(), CmsResourceFilter.IGNORE_EXPIRATION);
            }
            catch (CmsVfsResourceNotFoundException e) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            CmsResource currentRes = oldRes;
            if (oldRes != null) {
                String oldPath = cms.getSitePath(oldRes);
                String newPath = resData.getPath();
                if (!CmsStringUtil.comparePaths(oldPath, resData.getPath())) {
                    cms.moveResource(oldPath, newPath);
                    changed = true;
                    currentRes = cms.readResource(oldRes.getStructureId(), CmsResourceFilter.IGNORE_EXPIRATION);
                }
            }
            boolean needsImport = true;
            boolean reducedExport = !resData.hasDateLastModified();
            byte[] content = resData.getContent();
            if (oldRes != null) {
                if (!resData.hasStructureId()) {
                    needsImport = false;
                } else if (oldRes.getState().isUnchanged() && !CmsModuleUpdater.needToUpdateResourceFields(oldRes, resData.getResource(), reducedExport)) {
                    if (oldRes.isFile() && content != null) {
                        CmsFile file = cms.readFile(oldRes);
                        if (Arrays.equals(file.getContents(), content)) {
                            needsImport = false;
                        } else {
                            LOG.debug((Object)("Content mismatch for " + file.getRootPath()));
                        }
                    } else {
                        needsImport = false;
                    }
                }
            }
            if (needsImport || oldRes == null) {
                currentRes = cms.importResource(resData.getPath(), resData.getResource(), content, new ArrayList<CmsProperty>());
                changed = true;
                this.m_importIds.add(currentRes.getStructureId());
            } else {
                currentRes = cms.readResource(oldRes.getStructureId(), CmsResourceFilter.ALL);
                CmsLock lock = cms.getLock(currentRes);
                if (lock.isUnlocked()) {
                    this.lock(cms, currentRes);
                }
            }
            resData.setImportResource(currentRes);
            List<CmsProperty> propsToWrite = this.compareProperties(cms, resData, currentRes);
            if (!propsToWrite.isEmpty()) {
                cms.writePropertyObjects(currentRes, propsToWrite);
                changed = true;
            }
            if (changed |= this.updateAcls(cms, resData, currentRes)) {
                this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
            } else {
                this.m_report.println(org.opencms.report.Messages.get().container("RPT_SKIPPED_0"), 3);
            }
        }
        catch (Exception e) {
            this.m_report.println(e);
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected void runImportScript(CmsObject cms, CmsModule module) {
        LOG.info((Object)("Executing import script for module " + module.getName()));
        this.m_report.println(Messages.get().container("RPT_IMPORT_SCRIPT_HEADER_0"), 2);
        String importScript = "echo on\n" + module.getImportScript();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(buffer);
        CmsShell shell = new CmsShell(cms, "${user}@${project}:${siteroot}|${uri}>", null, out, out);
        shell.execute(importScript);
        String outputString = buffer.toString();
        LOG.info((Object)("Shell output for import script was: \n" + outputString));
        this.m_report.println(Messages.get().container("RPT_IMPORT_SCRIPT_OUTPUT_1", outputString));
    }

    Map<CmsUUID, CmsAccessControlEntry> buildAceMap(Collection<CmsAccessControlEntry> acl) {
        if (acl == null) {
            acl = new ArrayList<CmsAccessControlEntry>();
        }
        HashMap<CmsUUID, CmsAccessControlEntry> result = new HashMap<CmsUUID, CmsAccessControlEntry>();
        for (CmsAccessControlEntry ace : acl) {
            result.put(ace.getPrincipal(), ace);
        }
        return result;
    }

    private void cleanUp() {
        for (CmsResourceImportData resData : this.m_moduleData.getResourceData()) {
            resData.cleanUp();
        }
    }

    private List<CmsProperty> compareProperties(CmsObject cms, CmsResourceImportData resData, CmsResource existingResource) throws CmsException {
        if (existingResource == null) {
            return Collections.emptyList();
        }
        Map<String, CmsProperty> importProps = resData.getProperties();
        Map<String, CmsProperty> existingProps = CmsProperty.getPropertyMap(cms.readPropertyObjects(existingResource, false));
        HashMap<String, CmsProperty> propsToWrite = new HashMap<String, CmsProperty>();
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(existingProps.keySet());
        keys.addAll(importProps.keySet());
        for (String key : keys) {
            if (existingResource.isFile() && "image.size".equals(key)) continue;
            CmsProperty existingProp = existingProps.get(key);
            CmsProperty importProp = importProps.get(key);
            if (existingProp == null) {
                propsToWrite.put(key, importProp);
                continue;
            }
            if (importProp == null) {
                propsToWrite.put(key, new CmsProperty(key, "", ""));
                continue;
            }
            if (existingProp.isIdentical(importProp)) continue;
            propsToWrite.put(key, importProp);
        }
        return new ArrayList<CmsProperty>(propsToWrite.values());
    }

    private boolean isLinkParsable(CmsResource importRes) throws CmsException {
        int typeId = importRes.getTypeId();
        I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(typeId);
        return type instanceof I_CmsLinkParseable;
    }

    private void lock(CmsObject cms, CmsResource resource) throws CmsException {
        CmsLock lock = cms.getLock(resource);
        if (lock.isUnlocked()) {
            cms.lockResourceTemporary(resource);
        } else {
            cms.changeLock(resource);
        }
    }

    private boolean needToUpdateRelations(List<CmsRelation> noContentRelations, Set<CmsRelation> newRelations) {
        if (noContentRelations.size() != newRelations.size()) {
            return true;
        }
        for (CmsRelation relation : noContentRelations) {
            if (newRelations.contains(relation) || newRelations.contains(relation.withTargetId(null))) continue;
            return true;
        }
        return false;
    }

    private void updateRelations(CmsObject cms, CmsResource importResource, List<CmsImportVersion10.RelationData> relations) throws CmsException {
        HashMap<String, CmsRelationType> relTypes = new HashMap<String, CmsRelationType>();
        for (CmsRelationType relType : OpenCms.getResourceManager().getRelationTypes()) {
            relTypes.put(relType.getName(), relType);
        }
        HashSet existingRelations = Sets.newHashSet(cms.readRelations(CmsRelationFilter.relationsFromStructureId(importResource.getStructureId())));
        List<CmsRelation> noContentRelations = existingRelations.stream().filter(rel -> !rel.getType().isDefinedInContent()).collect(Collectors.toList());
        HashSet<CmsRelation> newRelations = new HashSet<CmsRelation>();
        for (CmsImportVersion10.RelationData rel2 : relations) {
            if (rel2.getType().isDefinedInContent()) continue;
            newRelations.add(new CmsRelation(importResource.getStructureId(), importResource.getRootPath(), rel2.getTargetId(), rel2.getTarget(), rel2.getType()));
        }
        if (this.needToUpdateRelations(noContentRelations, newRelations)) {
            CmsRelationFilter relFilter = CmsRelationFilter.TARGETS.filterNotDefinedInContent();
            try {
                cms.deleteRelationsFromResource(importResource, relFilter);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                this.m_report.println(e);
            }
            for (CmsRelation newRel : newRelations) {
                try {
                    CmsResource targetResource;
                    if (newRel.getTargetId() != null) {
                        targetResource = cms.readResource(newRel.getTargetId(), CmsResourceFilter.IGNORE_EXPIRATION);
                    } else {
                        try (AutoCloseable ac = cms.tempChangeSiteRoot("");){
                            targetResource = cms.readResource(newRel.getTargetPath(), CmsResourceFilter.IGNORE_EXPIRATION);
                        }
                    }
                    if (targetResource == null) continue;
                    cms.addRelationToResource(importResource, targetResource, newRel.getType().getName());
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    this.m_report.println(e);
                }
            }
        }
    }
}

