/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.mx;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.opencms.main.OpenCmsServlet;
import org.opencms.mx.I_CmsDiagnosticsMXBean;

public class CmsDiagnosticsMXBean
implements I_CmsDiagnosticsMXBean {
    public static final CmsDiagnosticsMXBean INSTANCE = new CmsDiagnosticsMXBean();

    public static void register() throws Exception {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName mxbeanName = new ObjectName("org.opencms.mx:type=CmsDiagnosticsMXBean");
        mbs.registerMBean(INSTANCE, mxbeanName);
    }

    @Override
    public String listActiveRequests() {
        ArrayList<OpenCmsServlet.RequestInfo> infos = new ArrayList<OpenCmsServlet.RequestInfo>(OpenCmsServlet.activeRequests.values());
        long now = System.currentTimeMillis();
        infos.sort((a, b) -> Long.compare(a.getStartTime(), b.getStartTime()));
        StringBuilder result = new StringBuilder();
        for (OpenCmsServlet.RequestInfo info : infos) {
            String line = "(#" + info.getThreadId() + ") " + info.getUri() + " " + (now - info.getStartTime());
            result.append(line);
            result.append("\n");
        }
        return result.toString();
    }
}

