/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.pdftools.dtds;

import java.io.IOException;
import java.net.URL;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XhtmlEntityResolver
implements EntityResolver {
    static final String XHTML_PREFIX = "http://www.w3.org/TR/xhtml1/DTD/";
    private final EntityResolver m_next;

    public XhtmlEntityResolver() {
        this(null);
    }

    public XhtmlEntityResolver(EntityResolver next) {
        this.m_next = next;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (systemId.startsWith(XHTML_PREFIX)) {
            String name = systemId.substring(XHTML_PREFIX.length());
            URL resource = this.getClass().getResource(name);
            if (resource != null) {
                InputSource inputSource = new InputSource(resource.toExternalForm());
                inputSource.setPublicId(publicId);
                return inputSource;
            }
        }
        if (systemId.startsWith("file:") || systemId.startsWith("jar:")) {
            return null;
        }
        if (this.m_next != null) {
            return this.m_next.resolveEntity(publicId, systemId);
        }
        return null;
    }
}

