/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.relations;

import com.google.common.base.Objects;
import java.util.Comparator;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.main.CmsException;
import org.opencms.relations.CmsRelationType;
import org.opencms.util.CmsUUID;

public class CmsRelation {
    public static final Comparator<CmsRelation> COMPARATOR = new Comparator<CmsRelation>(){

        @Override
        public int compare(CmsRelation r1, CmsRelation r2) {
            if (r1 == r2) {
                return 0;
            }
            String p1 = r1.getSourcePath() + r1.getTargetPath() + r1.getType().getId();
            String p2 = r2.getSourcePath() + r2.getTargetPath() + r2.getType().getId();
            return p1.compareTo(p2);
        }
    };
    private static final String UNDEF = "";
    private int m_hashCode;
    private final CmsUUID m_sourceId;
    private final String m_sourcePath;
    private final CmsUUID m_targetId;
    private final String m_targetPath;
    private final CmsRelationType m_type;

    public CmsRelation(CmsResource source, CmsResource target, CmsRelationType type) {
        this(source.getStructureId(), source.getRootPath(), target.getStructureId(), target.getRootPath(), type);
    }

    public CmsRelation(CmsUUID sourceId, String sourcePath, CmsUUID targetId, String targetPath, CmsRelationType type) {
        this.m_sourceId = sourceId != null ? sourceId : CmsUUID.getNullUUID();
        this.m_sourcePath = sourcePath != null ? sourcePath : UNDEF;
        this.m_targetId = targetId != null ? targetId : CmsUUID.getNullUUID();
        this.m_targetPath = targetPath != null ? targetPath : UNDEF;
        this.m_type = type != null ? type : CmsRelationType.XML_WEAK;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CmsRelation) {
            CmsRelation other = (CmsRelation)obj;
            return !(this.m_type != other.m_type || !Objects.equal((Object)this.m_sourcePath, (Object)other.m_sourcePath) && !Objects.equal((Object)this.m_sourceId, (Object)other.m_sourceId) || !Objects.equal((Object)this.m_targetPath, (Object)other.m_targetPath) && !Objects.equal((Object)this.m_targetId, (Object)other.m_targetId));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsResource getSource(CmsObject cms, CmsResourceFilter filter) throws CmsException {
        try {
            return cms.readResource(this.getSourceId(), filter);
        }
        catch (CmsVfsResourceNotFoundException e) {
            String storedSiteRoot = cms.getRequestContext().getSiteRoot();
            try {
                cms.getRequestContext().setSiteRoot(UNDEF);
                CmsResource cmsResource = cms.readResource(this.getSourcePath(), filter);
                return cmsResource;
            }
            finally {
                cms.getRequestContext().setSiteRoot(storedSiteRoot);
            }
        }
    }

    public CmsUUID getSourceId() {
        return this.m_sourceId;
    }

    public String getSourcePath() {
        return this.m_sourcePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsResource getTarget(CmsObject cms, CmsResourceFilter filter) throws CmsException {
        try {
            return cms.readResource(this.getTargetId(), filter);
        }
        catch (CmsVfsResourceNotFoundException e) {
            String storedSiteRoot = cms.getRequestContext().getSiteRoot();
            try {
                cms.getRequestContext().setSiteRoot(UNDEF);
                CmsResource cmsResource = cms.readResource(this.getTargetPath(), filter);
                return cmsResource;
            }
            finally {
                cms.getRequestContext().setSiteRoot(storedSiteRoot);
            }
        }
    }

    public CmsUUID getTargetId() {
        return this.m_targetId;
    }

    public String getTargetPath() {
        return this.m_targetPath;
    }

    public CmsRelationType getType() {
        return this.m_type;
    }

    public int hashCode() {
        if (this.m_hashCode == 0) {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.m_sourceId == null ? 0 : this.m_sourceId.hashCode());
            result = 31 * result + (this.m_sourcePath == null ? 0 : this.m_sourcePath.hashCode());
            result = 31 * result + (this.m_targetId == null ? 0 : this.m_targetId.hashCode());
            result = 31 * result + (this.m_targetPath == null ? 0 : this.m_targetPath.hashCode());
            this.m_hashCode = result = 31 * result + (this.m_type == null ? 0 : this.m_type.hashCode());
        }
        return this.m_hashCode;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("CmsRelation [");
        str.append("source id: ").append(this.m_sourceId).append(", ");
        str.append("source path: ").append(this.m_sourcePath).append(", ");
        str.append("target id: ").append(this.m_targetId).append(", ");
        str.append("target path: ").append(this.m_targetPath).append(", ");
        str.append("type: ").append(this.m_type);
        str.append("]");
        return str.toString();
    }

    public CmsRelation withTargetId(CmsUUID id) {
        return new CmsRelation(this.m_sourceId, this.m_sourcePath, id, this.m_targetPath, this.m_type);
    }
}

