/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.report.wrapper;

import java.util.Arrays;
import java.util.Collection;
import org.opencms.i18n.I_CmsMessageBundle;
import org.opencms.report.I_CmsReport;
import org.opencms.report.wrapper.DefaultReportMessages;

public class CmsReportWrapper {
    private Collection<I_CmsReport> m_reports;
    private I_CmsMessageBundle m_messages;

    public CmsReportWrapper(I_CmsMessageBundle messages, Collection<I_CmsReport> reports) {
        this.m_messages = messages;
        this.m_reports = reports;
    }

    public CmsReportWrapper(I_CmsMessageBundle messages, I_CmsReport ... report) {
        this.m_messages = messages;
        this.m_reports = Arrays.asList(report);
    }

    public void reportAddWarning(Object warning) {
        for (I_CmsReport r : this.m_reports) {
            r.addWarning(warning);
        }
    }

    public void reportDefault(String message, Object ... params) {
        for (I_CmsReport r : this.m_reports) {
            r.println(this.m_messages.container(message, params));
        }
    }

    public void reportDefaultNoBreak(String message, Object ... params) {
        for (I_CmsReport r : this.m_reports) {
            r.print(this.m_messages.container(message, params));
        }
    }

    public void reportFailed(boolean withDots) {
        for (I_CmsReport r : this.m_reports) {
            r.println(DefaultReportMessages.get().container(withDots ? "REPORT_FAILED_0" : "REPORT_FAILED_NO_DOTS_0"), 5);
        }
    }

    public void reportFailed(String message, Object ... params) {
        for (I_CmsReport r : this.m_reports) {
            if (null != message) {
                r.print(this.m_messages.container(message, params), 5);
            }
            r.println(DefaultReportMessages.get().container("REPORT_FAILED_0"), 5);
        }
    }

    public void reportHeadline(String message, Object ... params) {
        for (I_CmsReport r : this.m_reports) {
            r.println(this.m_messages.container(message, params), 2);
        }
    }

    public void reportHeadlineNoBreak(String message, Object ... params) {
        for (I_CmsReport r : this.m_reports) {
            r.print(this.m_messages.container(message, params), 2);
        }
    }

    public void reportNewline() {
        for (I_CmsReport r : this.m_reports) {
            r.println();
        }
    }

    public void reportNote(String message, Object ... params) {
        for (I_CmsReport r : this.m_reports) {
            r.println(this.m_messages.container(message, params), 3);
        }
    }

    public void reportNoteNoBreak(String message, Object ... params) {
        for (I_CmsReport r : this.m_reports) {
            r.print(this.m_messages.container(message, params), 3);
        }
    }

    public void reportOk(boolean withDots) {
        for (I_CmsReport r : this.m_reports) {
            r.println(DefaultReportMessages.get().container(withDots ? "REPORT_OK_0" : "REPORT_OK_NO_DOTS_0"), 4);
        }
    }

    public void reportOk(String message, Object ... params) {
        for (I_CmsReport r : this.m_reports) {
            if (null != message) {
                r.print(this.m_messages.container(message, params), 4);
            }
            r.println(DefaultReportMessages.get().container("REPORT_OK_0"), 4);
        }
    }

    public void reportSkipped(boolean withDots) {
        for (I_CmsReport r : this.m_reports) {
            r.println(DefaultReportMessages.get().container(withDots ? "REPORT_SKIPPED_0" : "REPORT_SKIPPED_NO_DOTS_0"), 1);
        }
    }

    public void reportSkipped(String message, Object ... params) {
        for (I_CmsReport r : this.m_reports) {
            if (null != message) {
                r.print(this.m_messages.container(message, params), 1);
            }
            r.println(DefaultReportMessages.get().container("REPORT_SKIPPED_0"), 1);
        }
    }

    public void reportWarning(String message, Object ... params) {
        for (I_CmsReport r : this.m_reports) {
            r.println(this.m_messages.container(message, params), 1);
        }
    }

    public void reportWarningNoBreak(String message, Object ... params) {
        for (I_CmsReport r : this.m_reports) {
            r.println(this.m_messages.container(message, params), 1);
        }
    }
}

