/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.rmi;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.opencms.rmi.CmsShellCommandResult;
import org.opencms.rmi.I_CmsRemoteShell;
import org.opencms.rmi.I_CmsRemoteShellProvider;

public class CmsRemoteShellClient {
    public static final String PARAM_ADDITIONAL = "additional";
    public static final String PARAM_REGISTRY_PORT = "registryPort";
    public static final String PARAM_REGISTRY_HOST = "registryHost";
    public static final String PARAM_SCRIPT = "script";
    private String m_additionalCommands;
    private boolean m_echo;
    private int m_errorCode;
    private boolean m_exitCalled;
    private boolean m_hasError;
    private InputStream m_input;
    private boolean m_interactive;
    private PrintStream m_out;
    private String m_prompt;
    private int m_registryPort;
    private String m_registryHost;
    private I_CmsRemoteShell m_remoteShell;

    public CmsRemoteShellClient(String[] args) throws IOException {
        Map<String, String> params = this.parseArgs(args);
        String script = params.get(PARAM_SCRIPT);
        if (script == null) {
            this.m_interactive = true;
            this.m_input = System.in;
        } else {
            this.m_input = new FileInputStream(script);
        }
        this.m_additionalCommands = params.get(PARAM_ADDITIONAL);
        String port = params.get(PARAM_REGISTRY_PORT);
        this.m_registryPort = 1101;
        if (port != null) {
            try {
                this.m_registryPort = Integer.parseInt(port);
                if (this.m_registryPort < 0) {
                    System.out.println("Invalid port: " + port);
                    System.exit(1);
                }
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid port: " + port);
                System.exit(1);
            }
        }
        this.m_registryHost = params.get(PARAM_REGISTRY_HOST);
    }

    public static void main(String[] args) throws Exception {
        CmsRemoteShellClient client = new CmsRemoteShellClient(args);
        client.run();
    }

    public Map<String, String> parseArgs(String[] args) {
        HashMap<String, String> result = new HashMap<String, String>();
        HashSet<String> allowedKeys = new HashSet<String>(Arrays.asList(PARAM_ADDITIONAL, PARAM_SCRIPT, PARAM_REGISTRY_PORT, PARAM_REGISTRY_HOST));
        for (String arg : args) {
            if (arg.startsWith("-")) {
                int eqPos = arg.indexOf("=");
                if (eqPos >= 0) {
                    String key = arg.substring(1, eqPos);
                    if (!allowedKeys.contains(key)) {
                        this.wrongUsage();
                    }
                    String val = arg.substring(eqPos + 1);
                    result.put(key, val);
                    continue;
                }
                this.wrongUsage();
                continue;
            }
            this.wrongUsage();
        }
        return result;
    }

    public void run() throws Exception {
        block8: {
            Registry registry = LocateRegistry.getRegistry(this.m_registryHost, this.m_registryPort);
            I_CmsRemoteShellProvider provider = (I_CmsRemoteShellProvider)registry.lookup("RemoteShellProvider");
            this.m_remoteShell = provider.createShell(this.m_additionalCommands);
            this.m_prompt = this.m_remoteShell.getPrompt();
            this.m_out = new PrintStream(System.out);
            try {
                LineNumberReader lnr = new LineNumberReader(new InputStreamReader(this.m_input, "UTF-8"));
                while (!this.exitCalled()) {
                    String line;
                    if (this.m_interactive || this.isEcho()) {
                        this.printPrompt();
                    }
                    if ((line = lnr.readLine()) == null) break;
                    if (line.trim().startsWith("#")) {
                        this.m_out.println(line);
                        continue;
                    }
                    StringReader lineReader = new StringReader(line);
                    StreamTokenizer st = new StreamTokenizer(lineReader);
                    st.eolIsSignificant(true);
                    st.wordChars(42, 42);
                    ArrayList<String> parameters = new ArrayList<String>();
                    while (st.nextToken() != -1) {
                        if (st.ttype == -2) {
                            parameters.add(Integer.toString(Double.valueOf(st.nval).intValue()));
                            continue;
                        }
                        parameters.add(st.sval);
                    }
                    lineReader.close();
                    if (parameters.size() == 0) {
                        if (!this.isEcho()) continue;
                        this.m_out.println();
                        continue;
                    }
                    String command = (String)parameters.get(0);
                    ArrayList<String> arguments = new ArrayList<String>(parameters.subList(1, parameters.size()));
                    this.executeCommand(command, arguments);
                }
                this.exit(0);
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (this.m_errorCode == -1) break block8;
                this.exit(this.m_errorCode);
            }
        }
    }

    private void executeCommand(String command, List<String> arguments) {
        try {
            CmsShellCommandResult result = this.m_remoteShell.executeCommand(command, arguments);
            this.m_out.print(result.getOutput());
            this.updateState(result);
            if (this.m_exitCalled) {
                this.exit(0);
            } else if (this.m_hasError && this.m_errorCode != -1) {
                this.exit(this.m_errorCode);
            }
        }
        catch (RemoteException r) {
            r.printStackTrace(System.err);
            this.exit(1);
        }
    }

    private void exit(int errorCode) {
        try {
            this.m_remoteShell.end();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(errorCode);
    }

    private boolean exitCalled() {
        return this.m_exitCalled;
    }

    private boolean isEcho() {
        return this.m_echo;
    }

    private void printPrompt() {
        System.out.print(this.m_prompt);
    }

    private void updateState(CmsShellCommandResult result) {
        this.m_errorCode = result.getErrorCode();
        this.m_prompt = result.getPrompt();
        this.m_exitCalled = result.isExitCalled();
        this.m_hasError = result.hasError();
        this.m_echo = result.hasEcho();
    }

    private void wrongUsage() {
        String usage = "Usage: java -cp $PATH_TO_OPENCMS_JAR org.opencms.rmi.CmsRemoteShellClient\n    -script=[path to script] (optional) \n    -registryPort=[port of RMI registry] (optional, default is 1101)\n    -registryHost=[host of RMI registry] (optional, defaults to java.net.InetAddress.getLocalHost().getHostAddress())\n    -additional=[additional commands class name] (optional)";
        System.out.println(usage);
        System.exit(1);
    }
}

